/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSHTMLInputElement_h
#define JSHTMLInputElement_h

#include "HTMLInputElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLElement.h"
#include <runtime/JSObject.h>

namespace WebCore {

class JSHTMLInputElement : public JSHTMLElement {
public:
    typedef JSHTMLElement Base;
    static JSHTMLInputElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLInputElement> impl)
    {
        JSHTMLInputElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLInputElement>(globalObject->vm().heap)) JSHTMLInputElement(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom attributes
    JSC::JSValue selectionStart(JSC::ExecState*) const;
    void setSelectionStart(JSC::ExecState*, JSC::JSValue);
    JSC::JSValue selectionEnd(JSC::ExecState*) const;
    void setSelectionEnd(JSC::ExecState*, JSC::JSValue);
    JSC::JSValue selectionDirection(JSC::ExecState*) const;
    void setSelectionDirection(JSC::ExecState*, JSC::JSValue);

    // Custom functions
    JSC::JSValue setSelectionRange(JSC::ExecState*);
protected:
    JSHTMLInputElement(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<HTMLInputElement>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};


class JSHTMLInputElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSHTMLInputElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLInputElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLInputElementPrototype>(vm.heap)) JSHTMLInputElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSHTMLInputElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSHTMLInputElementConstructor : public DOMConstructorObject {
private:
    JSHTMLInputElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLInputElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLInputElementConstructor* ptr = new (NotNull, JSC::allocateCell<JSHTMLInputElementConstructor>(*exec->heap())) JSHTMLInputElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepUp(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepDown(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionCheckValidity(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetCustomValidity(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSelect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetRangeText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetSelectionRange(JSC::ExecState*);
// Attributes

JSC::JSValue jsHTMLInputElementAccept(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementAccept(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementAlt(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementAlt(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementAutocomplete(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementAutocomplete(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementAutofocus(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementAutofocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementDefaultChecked(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementDefaultChecked(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementChecked(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementChecked(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementDirName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementDirName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementDisabled(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementDisabled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementForm(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLInputElementFiles(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFiles(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementFormAction(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFormAction(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementFormEnctype(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFormEnctype(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementFormMethod(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFormMethod(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementFormNoValidate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFormNoValidate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementFormTarget(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementFormTarget(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementHeight(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementIndeterminate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementIndeterminate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(DATALIST_ELEMENT)
JSC::JSValue jsHTMLInputElementList(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
JSC::JSValue jsHTMLInputElementMax(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementMax(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementMaxLength(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementMaxLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementMin(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementMin(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementMultiple(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementMultiple(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementPattern(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementPattern(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementPlaceholder(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementPlaceholder(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementReadOnly(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementReadOnly(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementRequired(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementRequired(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementSize(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementSize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementSrc(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementSrc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementStep(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementStep(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementType(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementType(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementDefaultValue(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementDefaultValue(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementValue(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementValue(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementValueAsDate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementValueAsDate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementValueAsNumber(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementValueAsNumber(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementWidth(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementWillValidate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLInputElementValidity(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLInputElementValidationMessage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLInputElementLabels(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLInputElementSelectionStart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementSelectionStart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementSelectionEnd(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementSelectionEnd(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementSelectionDirection(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementSelectionDirection(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementAlign(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementAlign(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(DIRECTORY_UPLOAD)
JSC::JSValue jsHTMLInputElementWebkitdirectory(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementWebkitdirectory(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsHTMLInputElementUseMap(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementUseMap(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLInputElementIncremental(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementIncremental(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(INPUT_SPEECH)
JSC::JSValue jsHTMLInputElementWebkitSpeech(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementWebkitSpeech(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INPUT_SPEECH)
JSC::JSValue jsHTMLInputElementWebkitGrammar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementWebkitGrammar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INPUT_SPEECH)
JSC::JSValue jsHTMLInputElementOnwebkitspeechchange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementOnwebkitspeechchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MEDIA_CAPTURE)
JSC::JSValue jsHTMLInputElementCapture(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLInputElementCapture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsHTMLInputElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif
