/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSKeyboardEvent_h
#define JSKeyboardEvent_h

#include "JSDOMBinding.h"
#include "JSUIEvent.h"
#include "KeyboardEvent.h"
#include <runtime/JSObject.h>

namespace WebCore {

class JSDictionary;

class JSKeyboardEvent : public JSUIEvent {
public:
    typedef JSUIEvent Base;
    static JSKeyboardEvent* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<KeyboardEvent> impl)
    {
        JSKeyboardEvent* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEvent>(globalObject->vm().heap)) JSKeyboardEvent(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
protected:
    JSKeyboardEvent(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<KeyboardEvent>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};


class JSKeyboardEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSKeyboardEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyboardEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEventPrototype>(vm.heap)) JSKeyboardEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSKeyboardEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSKeyboardEventConstructor : public DOMConstructorObject {
private:
    JSKeyboardEventConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSKeyboardEventConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSKeyboardEventConstructor* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEventConstructor>(*exec->heap())) JSKeyboardEventConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSKeyboardEvent(JSC::ExecState*);
#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
    static JSC::ConstructType getConstructData(JSC::JSCell*, JSC::ConstructData&);
#endif // ENABLE(DOM4_EVENTS_CONSTRUCTOR)
};

bool fillKeyboardEventInit(KeyboardEventInit&, JSDictionary&);

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsKeyboardEventKeyIdentifier(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventLocation(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventKeyLocation(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventCtrlKey(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventShiftKey(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventAltKey(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventMetaKey(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventAltGraphKey(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
// Constants

JSC::JSValue jsKeyboardEventDOM_KEY_LOCATION_STANDARD(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventDOM_KEY_LOCATION_LEFT(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventDOM_KEY_LOCATION_RIGHT(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsKeyboardEventDOM_KEY_LOCATION_NUMPAD(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif
