/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEDisplacementMapElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEDisplacementMapElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEDisplacementMapElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementIn1), (intptr_t)0, NoIntrinsic },
    { "in2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementIn2), (intptr_t)0, NoIntrinsic },
    { "scale", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementScale), (intptr_t)0, NoIntrinsic },
    { "xChannelSelector", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementXChannelSelector), (intptr_t)0, NoIntrinsic },
    { "yChannelSelector", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementYChannelSelector), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDisplacementMapElementTable = { 36, 31, JSSVGFEDisplacementMapElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEDisplacementMapElementConstructorTableValues[] =
{
    { "SVG_CHANNEL_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_R", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_R), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_G", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_G), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_B", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_B), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_A", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_A), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDisplacementMapElementConstructorTable = { 16, 15, JSSVGFEDisplacementMapElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEDisplacementMapElementConstructor::s_info = { "SVGFEDisplacementMapElementConstructor", &Base::s_info, &JSSVGFEDisplacementMapElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEDisplacementMapElementConstructor) };

JSSVGFEDisplacementMapElementConstructor::JSSVGFEDisplacementMapElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEDisplacementMapElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEDisplacementMapElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEDisplacementMapElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEDisplacementMapElementConstructor, JSDOMWrapper>(exec, &JSSVGFEDisplacementMapElementConstructorTable, jsCast<JSSVGFEDisplacementMapElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEDisplacementMapElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEDisplacementMapElementConstructor, JSDOMWrapper>(exec, &JSSVGFEDisplacementMapElementConstructorTable, jsCast<JSSVGFEDisplacementMapElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEDisplacementMapElementPrototypeTableValues[] =
{
    { "SVG_CHANNEL_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_R", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_R), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_G", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_G), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_B", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_B), (intptr_t)0, NoIntrinsic },
    { "SVG_CHANNEL_A", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEDisplacementMapElementSVG_CHANNEL_A), (intptr_t)0, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEDisplacementMapElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEDisplacementMapElementPrototypeTable = { 16, 15, JSSVGFEDisplacementMapElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEDisplacementMapElementPrototype::s_info = { "SVGFEDisplacementMapElementPrototype", &Base::s_info, &JSSVGFEDisplacementMapElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEDisplacementMapElementPrototype) };

JSObject* JSSVGFEDisplacementMapElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEDisplacementMapElement>(exec, globalObject);
}

bool JSSVGFEDisplacementMapElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEDisplacementMapElementPrototype* thisObject = jsCast<JSSVGFEDisplacementMapElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGFEDisplacementMapElementPrototype, JSObject>(exec, &JSSVGFEDisplacementMapElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFEDisplacementMapElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEDisplacementMapElementPrototype* thisObject = jsCast<JSSVGFEDisplacementMapElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGFEDisplacementMapElementPrototype, JSObject>(exec, &JSSVGFEDisplacementMapElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFEDisplacementMapElement::s_info = { "SVGFEDisplacementMapElement", &Base::s_info, &JSSVGFEDisplacementMapElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEDisplacementMapElement) };

JSSVGFEDisplacementMapElement::JSSVGFEDisplacementMapElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEDisplacementMapElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEDisplacementMapElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEDisplacementMapElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEDisplacementMapElementPrototype::create(exec->globalData(), globalObject, JSSVGFEDisplacementMapElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEDisplacementMapElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEDisplacementMapElement* thisObject = jsCast<JSSVGFEDisplacementMapElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEDisplacementMapElement, Base>(exec, &JSSVGFEDisplacementMapElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEDisplacementMapElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEDisplacementMapElement* thisObject = jsCast<JSSVGFEDisplacementMapElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEDisplacementMapElement, Base>(exec, &JSSVGFEDisplacementMapElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEDisplacementMapElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementIn2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementScale(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->scaleAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementXChannelSelector(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->xChannelSelectorAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementYChannelSelector(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->yChannelSelectorAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEDisplacementMapElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFEDisplacementMapElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEDisplacementMapElement* domObject = jsCast<JSSVGFEDisplacementMapElement*>(asObject(slotBase));
    return JSSVGFEDisplacementMapElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEDisplacementMapElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEDisplacementMapElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEDisplacementMapElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEDisplacementMapElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEDisplacementMapElement* castedThis = jsCast<JSSVGFEDisplacementMapElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEDisplacementMapElement::s_info);
    SVGFEDisplacementMapElement* impl = static_cast<SVGFEDisplacementMapElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGFEDisplacementMapElementSVG_CHANNEL_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFEDisplacementMapElementSVG_CHANNEL_R(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFEDisplacementMapElementSVG_CHANNEL_G(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGFEDisplacementMapElementSVG_CHANNEL_B(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGFEDisplacementMapElementSVG_CHANNEL_A(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
