/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeFilter.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "NodeFilter.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNodeFilterTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeFilterTable = { 2, 1, JSNodeFilterTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNodeFilterConstructorTableValues[] =
{
    { "FILTER_ACCEPT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_ACCEPT), (intptr_t)0, NoIntrinsic },
    { "FILTER_REJECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_REJECT), (intptr_t)0, NoIntrinsic },
    { "FILTER_SKIP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_SKIP), (intptr_t)0, NoIntrinsic },
    { "SHOW_ALL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ALL), (intptr_t)0, NoIntrinsic },
    { "SHOW_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_ATTRIBUTE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ATTRIBUTE), (intptr_t)0, NoIntrinsic },
    { "SHOW_TEXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_TEXT), (intptr_t)0, NoIntrinsic },
    { "SHOW_CDATA_SECTION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_CDATA_SECTION), (intptr_t)0, NoIntrinsic },
    { "SHOW_ENTITY_REFERENCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ENTITY_REFERENCE), (intptr_t)0, NoIntrinsic },
    { "SHOW_ENTITY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ENTITY), (intptr_t)0, NoIntrinsic },
    { "SHOW_PROCESSING_INSTRUCTION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_PROCESSING_INSTRUCTION), (intptr_t)0, NoIntrinsic },
    { "SHOW_COMMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_COMMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT_TYPE), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT_FRAGMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT_FRAGMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_NOTATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_NOTATION), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeFilterConstructorTable = { 34, 31, JSNodeFilterConstructorTableValues, 0 };

COMPILE_ASSERT(1 == NodeFilter::FILTER_ACCEPT, NodeFilterEnumFILTER_ACCEPTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == NodeFilter::FILTER_REJECT, NodeFilterEnumFILTER_REJECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == NodeFilter::FILTER_SKIP, NodeFilterEnumFILTER_SKIPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0xFFFFFFFF == NodeFilter::SHOW_ALL, NodeFilterEnumSHOW_ALLIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000001 == NodeFilter::SHOW_ELEMENT, NodeFilterEnumSHOW_ELEMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000002 == NodeFilter::SHOW_ATTRIBUTE, NodeFilterEnumSHOW_ATTRIBUTEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000004 == NodeFilter::SHOW_TEXT, NodeFilterEnumSHOW_TEXTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000008 == NodeFilter::SHOW_CDATA_SECTION, NodeFilterEnumSHOW_CDATA_SECTIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000010 == NodeFilter::SHOW_ENTITY_REFERENCE, NodeFilterEnumSHOW_ENTITY_REFERENCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000020 == NodeFilter::SHOW_ENTITY, NodeFilterEnumSHOW_ENTITYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000040 == NodeFilter::SHOW_PROCESSING_INSTRUCTION, NodeFilterEnumSHOW_PROCESSING_INSTRUCTIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000080 == NodeFilter::SHOW_COMMENT, NodeFilterEnumSHOW_COMMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000100 == NodeFilter::SHOW_DOCUMENT, NodeFilterEnumSHOW_DOCUMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000200 == NodeFilter::SHOW_DOCUMENT_TYPE, NodeFilterEnumSHOW_DOCUMENT_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000400 == NodeFilter::SHOW_DOCUMENT_FRAGMENT, NodeFilterEnumSHOW_DOCUMENT_FRAGMENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x00000800 == NodeFilter::SHOW_NOTATION, NodeFilterEnumSHOW_NOTATIONIsWrongUseDoNotCheckConstants);

const ClassInfo JSNodeFilterConstructor::s_info = { "NodeFilterConstructor", &Base::s_info, &JSNodeFilterConstructorTable, 0, CREATE_METHOD_TABLE(JSNodeFilterConstructor) };

JSNodeFilterConstructor::JSNodeFilterConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNodeFilterConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSNodeFilterPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSNodeFilterConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeFilterConstructor, JSDOMWrapper>(exec, &JSNodeFilterConstructorTable, jsCast<JSNodeFilterConstructor*>(cell), propertyName, slot);
}

bool JSNodeFilterConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNodeFilterConstructor, JSDOMWrapper>(exec, &JSNodeFilterConstructorTable, jsCast<JSNodeFilterConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSNodeFilterPrototypeTableValues[] =
{
    { "FILTER_ACCEPT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_ACCEPT), (intptr_t)0, NoIntrinsic },
    { "FILTER_REJECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_REJECT), (intptr_t)0, NoIntrinsic },
    { "FILTER_SKIP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterFILTER_SKIP), (intptr_t)0, NoIntrinsic },
    { "SHOW_ALL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ALL), (intptr_t)0, NoIntrinsic },
    { "SHOW_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_ATTRIBUTE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ATTRIBUTE), (intptr_t)0, NoIntrinsic },
    { "SHOW_TEXT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_TEXT), (intptr_t)0, NoIntrinsic },
    { "SHOW_CDATA_SECTION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_CDATA_SECTION), (intptr_t)0, NoIntrinsic },
    { "SHOW_ENTITY_REFERENCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ENTITY_REFERENCE), (intptr_t)0, NoIntrinsic },
    { "SHOW_ENTITY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_ENTITY), (intptr_t)0, NoIntrinsic },
    { "SHOW_PROCESSING_INSTRUCTION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_PROCESSING_INSTRUCTION), (intptr_t)0, NoIntrinsic },
    { "SHOW_COMMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_COMMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT_TYPE), (intptr_t)0, NoIntrinsic },
    { "SHOW_DOCUMENT_FRAGMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_DOCUMENT_FRAGMENT), (intptr_t)0, NoIntrinsic },
    { "SHOW_NOTATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeFilterSHOW_NOTATION), (intptr_t)0, NoIntrinsic },
    { "acceptNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNodeFilterPrototypeFunctionAcceptNode), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeFilterPrototypeTable = { 66, 63, JSNodeFilterPrototypeTableValues, 0 };
const ClassInfo JSNodeFilterPrototype::s_info = { "NodeFilterPrototype", &Base::s_info, &JSNodeFilterPrototypeTable, 0, CREATE_METHOD_TABLE(JSNodeFilterPrototype) };

JSObject* JSNodeFilterPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNodeFilter>(exec, globalObject);
}

bool JSNodeFilterPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNodeFilterPrototype* thisObject = jsCast<JSNodeFilterPrototype*>(cell);
    return getStaticPropertySlot<JSNodeFilterPrototype, JSObject>(exec, &JSNodeFilterPrototypeTable, thisObject, propertyName, slot);
}

bool JSNodeFilterPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNodeFilterPrototype* thisObject = jsCast<JSNodeFilterPrototype*>(object);
    return getStaticPropertyDescriptor<JSNodeFilterPrototype, JSObject>(exec, &JSNodeFilterPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNodeFilter::s_info = { "NodeFilter", &Base::s_info, &JSNodeFilterTable, 0 , CREATE_METHOD_TABLE(JSNodeFilter) };

JSNodeFilter::JSNodeFilter(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NodeFilter> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNodeFilter::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNodeFilter::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNodeFilterPrototype::create(exec->globalData(), globalObject, JSNodeFilterPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSNodeFilter::destroy(JSC::JSCell* cell)
{
    JSNodeFilter* thisObject = static_cast<JSNodeFilter*>(cell);
    thisObject->JSNodeFilter::~JSNodeFilter();
}

JSNodeFilter::~JSNodeFilter()
{
    releaseImplIfNotNull();
}

bool JSNodeFilter::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNodeFilter* thisObject = jsCast<JSNodeFilter*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSNodeFilter, Base>(exec, &JSNodeFilterTable, thisObject, propertyName, slot);
}

bool JSNodeFilter::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNodeFilter* thisObject = jsCast<JSNodeFilter*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSNodeFilter, Base>(exec, &JSNodeFilterTable, thisObject, propertyName, descriptor);
}

JSValue jsNodeFilterConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNodeFilter* domObject = jsCast<JSNodeFilter*>(asObject(slotBase));
    return JSNodeFilter::getConstructor(exec, domObject->globalObject());
}

JSValue JSNodeFilter::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeFilterConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNodeFilterPrototypeFunctionAcceptNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNodeFilter::s_info))
        return throwVMTypeError(exec);
    JSNodeFilter* castedThis = jsCast<JSNodeFilter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNodeFilter::s_info);
    NodeFilter* impl = static_cast<NodeFilter*>(castedThis->impl());
    Node* n(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->acceptNode(exec, n));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsNodeFilterFILTER_ACCEPT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsNodeFilterFILTER_REJECT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsNodeFilterFILTER_SKIP(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsNodeFilterSHOW_ALL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0xFFFFFFFF));
}

JSValue jsNodeFilterSHOW_ELEMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000001));
}

JSValue jsNodeFilterSHOW_ATTRIBUTE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000002));
}

JSValue jsNodeFilterSHOW_TEXT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000004));
}

JSValue jsNodeFilterSHOW_CDATA_SECTION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000008));
}

JSValue jsNodeFilterSHOW_ENTITY_REFERENCE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000010));
}

JSValue jsNodeFilterSHOW_ENTITY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000020));
}

JSValue jsNodeFilterSHOW_PROCESSING_INSTRUCTION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000040));
}

JSValue jsNodeFilterSHOW_COMMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000080));
}

JSValue jsNodeFilterSHOW_DOCUMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000100));
}

JSValue jsNodeFilterSHOW_DOCUMENT_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000200));
}

JSValue jsNodeFilterSHOW_DOCUMENT_FRAGMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000400));
}

JSValue jsNodeFilterSHOW_NOTATION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00000800));
}

static inline bool isObservable(JSNodeFilter* jsNodeFilter)
{
    if (jsNodeFilter->hasCustomProperties())
        return true;
    return false;
}

bool JSNodeFilterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNodeFilter* jsNodeFilter = jsCast<JSNodeFilter*>(handle.get().asCell());
    if (!isObservable(jsNodeFilter))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSNodeFilterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNodeFilter* jsNodeFilter = jsCast<JSNodeFilter*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNodeFilter->impl(), jsNodeFilter);
    jsNodeFilter->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NodeFilter* impl)
{
    return wrap<JSNodeFilter>(exec, globalObject, impl);
}


}
