from helper import unittest, PillowTestCase, hopper

from PIL import Image, MspImagePlugin

import os

TEST_FILE = "Tests/images/hopper.msp"
EXTRA_DIR = "Tests/images/picins"
YA_EXTRA_DIR = "Tests/images/msp"


class TestFileMsp(PillowTestCase):

    def test_sanity(self):
        file = self.tempfile("temp.msp")

        hopper("1").save(file)

        im = Image.open(file)
        im.load()
        self.assertEqual(im.mode, "1")
        self.assertEqual(im.size, (128, 128))
        self.assertEqual(im.format, "MSP")

    def test_invalid_file(self):
        invalid_file = "Tests/images/flower.jpg"

        self.assertRaises(SyntaxError,
                          lambda: MspImagePlugin.MspImageFile(invalid_file))

    def test_bad_checksum(self):
        # Arrange
        # This was created by forcing Pillow to save with checksum=0
        bad_checksum = "Tests/images/hopper_bad_checksum.msp"

        # Act / Assert
        self.assertRaises(SyntaxError,
                          lambda: MspImagePlugin.MspImageFile(bad_checksum))

    def test_open_windows_v1(self):
        # Arrange
        # Act
        im = Image.open(TEST_FILE)

        # Assert
        self.assert_image_equal(im, hopper("1"))
        self.assertIsInstance(im, MspImagePlugin.MspImageFile)

    def _assert_file_image_equal(self, source_path, target_path):
        with Image.open(source_path) as im:
            target = Image.open(target_path)
            self.assert_image_equal(im, target)

    @unittest.skipIf(not os.path.exists(EXTRA_DIR),
                     "Extra image files not installed")
    def test_open_windows_v2(self):

        files = (os.path.join(EXTRA_DIR, f) for f in os.listdir(EXTRA_DIR)
                 if os.path.splitext(f)[1] == '.msp')
        for path in files:
            self._assert_file_image_equal(path,
                                          path.replace('.msp','.png'))

    @unittest.skipIf(not os.path.exists(YA_EXTRA_DIR),
                     "Even More Extra image files not installed")
    def test_msp_v2(self):
        for f in os.listdir(YA_EXTRA_DIR):
            if not '.MSP' in f: continue
            path = os.path.join(YA_EXTRA_DIR, f)
            self._assert_file_image_equal(path,
                                          path.replace('.MSP','.png'))


    def test_cannot_save_wrong_mode(self):
        # Arrange
        im = hopper()
        filename = self.tempfile("temp.msp")

        # Act/Assert
        self.assertRaises(IOError, lambda: im.save(filename))


if __name__ == '__main__':
    unittest.main()
