/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.34 from the
 * contents of GdkEvent.xs. Do not edit this file, edit GdkEvent.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/GdkEvent.xs"
/*
 * Copyright (c) 2003-2006 by the gtk2-perl team (see the file AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301  USA.
 *
 * $Id$
 */

#include "gtk2perl.h"

/*

since the GdkEvent is a union, it behaves like a polymorphic structure.
gdk provides a couple of functions to return some common values regardless
of the type of event, but we need to provide access to pretty much all
of the members.

thus, i've created a bit of hierarchy within the GdkEvent itself.  specialized
event types inherit evreything else from Gtk2::Gdk::Event, but add their
own methods to provide access to the struct members.

by the way, we do everything as opaque types and methods instead of creating
a hash like gtk-perl in order to avoid the performance hit of always creating
a hash that maybe 20% of client code will ever actually use.

*/



static const char *
gdk_event_get_package (GType gtype,
                       GdkEvent * event)
{
	PERL_UNUSED_VAR (gtype);

	switch (event->type) {
	    case GDK_NOTHING:
	    case GDK_DELETE:
	    case GDK_DESTROY:
	    case GDK_MAP:
	    case GDK_UNMAP:
		return "Gtk2::Gdk::Event";
	    case GDK_EXPOSE:
#if GTK_CHECK_VERSION (2, 14, 0)
	    case GDK_DAMAGE:
#endif
		return "Gtk2::Gdk::Event::Expose";
	    case GDK_MOTION_NOTIFY:
		return "Gtk2::Gdk::Event::Motion";
	    case GDK_BUTTON_PRESS:
	    case GDK_2BUTTON_PRESS:
	    case GDK_3BUTTON_PRESS:
	    case GDK_BUTTON_RELEASE:
		return "Gtk2::Gdk::Event::Button";
	    case GDK_KEY_PRESS:
	    case GDK_KEY_RELEASE:
		return "Gtk2::Gdk::Event::Key";
	    case GDK_ENTER_NOTIFY:
	    case GDK_LEAVE_NOTIFY:
		return "Gtk2::Gdk::Event::Crossing";
	    case GDK_FOCUS_CHANGE:
		return "Gtk2::Gdk::Event::Focus";
	    case GDK_CONFIGURE:
		return "Gtk2::Gdk::Event::Configure";
	    case GDK_PROPERTY_NOTIFY:
		return "Gtk2::Gdk::Event::Property";
	    case GDK_SELECTION_CLEAR:
	    case GDK_SELECTION_REQUEST:
	    case GDK_SELECTION_NOTIFY:
		return "Gtk2::Gdk::Event::Selection";
	    case GDK_PROXIMITY_IN:
	    case GDK_PROXIMITY_OUT:
		return "Gtk2::Gdk::Event::Proximity";
	    case GDK_DRAG_ENTER:
	    case GDK_DRAG_LEAVE:
	    case GDK_DRAG_MOTION:
	    case GDK_DRAG_STATUS:
	    case GDK_DROP_START:
	    case GDK_DROP_FINISHED:
		return "Gtk2::Gdk::Event::DND";
	    case GDK_CLIENT_EVENT:
		return "Gtk2::Gdk::Event::Client";
	    case GDK_VISIBILITY_NOTIFY:
		return "Gtk2::Gdk::Event::Visibility";
	    case GDK_NO_EXPOSE:
		return "Gtk2::Gdk::Event::NoExpose";
	    case GDK_SCROLL:
		return "Gtk2::Gdk::Event::Scroll";
	    case GDK_WINDOW_STATE:
		return "Gtk2::Gdk::Event::WindowState";
	    case GDK_SETTING:
		return "Gtk2::Gdk::Event::Setting";
#if GTK_CHECK_VERSION (2, 6, 0)
	    case GDK_OWNER_CHANGE:
		return "Gtk2::Gdk::Event::OwnerChange";
#endif
#if GTK_CHECK_VERSION (2, 8, 0)
	    case GDK_GRAB_BROKEN:
		return "Gtk2::Gdk::Event::GrabBroken";
#endif
	    default:
		{
		GEnumClass * class = g_type_class_ref (GDK_TYPE_EVENT_TYPE);
		GEnumValue * value = g_enum_get_value (class, event->type);
		if (value)
			warn ("Unhandled event type %s (%d) in event->type",
			      value->value_name, event->type);
		else
			warn ("Unknown value %d in event->type", event->type);
		g_type_class_unref (class);
		}
		return "Gtk2::Gdk::Event"; /* limp along */
	}
}

static void
gtk2perl_gdk_event_set_state (GdkEvent * event,
                              GdkModifierType newstate)
{
	if (event) {
		switch (event->type) {
		    case GDK_MOTION_NOTIFY:
			event->motion.state = newstate;
			break;
		    case GDK_BUTTON_PRESS:
		    case GDK_2BUTTON_PRESS:
		    case GDK_3BUTTON_PRESS:
		    case GDK_BUTTON_RELEASE:
			event->button.state = newstate;
			break;
		    case GDK_SCROLL:
			event->scroll.state = newstate;
			break;
		    case GDK_KEY_PRESS:
		    case GDK_KEY_RELEASE:
			event->key.state = newstate;
			break;
		    case GDK_ENTER_NOTIFY:
		    case GDK_LEAVE_NOTIFY:
			event->crossing.state = newstate;
			break;
		    case GDK_PROPERTY_NOTIFY:
			event->property.state = newstate;
			break;
		    case GDK_VISIBILITY_NOTIFY:
			/* visibility state is something else. */
		    case GDK_CLIENT_EVENT:
		    case GDK_NO_EXPOSE:
		    case GDK_CONFIGURE:
		    case GDK_FOCUS_CHANGE:
		    case GDK_SELECTION_CLEAR:
		    case GDK_SELECTION_REQUEST:
		    case GDK_SELECTION_NOTIFY:
		    case GDK_PROXIMITY_IN:
		    case GDK_PROXIMITY_OUT:
		    case GDK_DRAG_ENTER:
		    case GDK_DRAG_LEAVE:
		    case GDK_DRAG_MOTION:
		    case GDK_DRAG_STATUS:
		    case GDK_DROP_START:
		    case GDK_DROP_FINISHED:
		    case GDK_NOTHING:
		    case GDK_DELETE:
		    case GDK_DESTROY:
		    case GDK_EXPOSE:
		    case GDK_MAP:
		    case GDK_UNMAP:
		    case GDK_WINDOW_STATE:
		    case GDK_SETTING:
#if GTK_CHECK_VERSION (2, 6, 0)
		    case GDK_OWNER_CHANGE:
#endif
#if GTK_CHECK_VERSION (2, 8, 0)
		    case GDK_GRAB_BROKEN:
#endif
#if GTK_CHECK_VERSION (2, 14, 0)
		    case GDK_DAMAGE:
#endif
			/* no state field */
			break;
		}
	}
}

static void
gtk2perl_gdk_event_set_time (GdkEvent * event,
                             guint32 newtime)
{
	if (event) {
		switch (event->type) {
		     case GDK_MOTION_NOTIFY:
			event->motion.time = newtime;
			break;
		     case GDK_BUTTON_PRESS:
		     case GDK_2BUTTON_PRESS:
		     case GDK_3BUTTON_PRESS:
		     case GDK_BUTTON_RELEASE:
			event->button.time = newtime;
			break;
		     case GDK_SCROLL:
			event->scroll.time = newtime;
			break;
		     case GDK_KEY_PRESS:
		     case GDK_KEY_RELEASE:
			event->key.time = newtime;
			break;
		     case GDK_ENTER_NOTIFY:
		     case GDK_LEAVE_NOTIFY:
			event->crossing.time = newtime;
			break;
		     case GDK_PROPERTY_NOTIFY:
			event->property.time = newtime;
			break;
		     case GDK_SELECTION_CLEAR:
		     case GDK_SELECTION_REQUEST:
		     case GDK_SELECTION_NOTIFY:
			event->selection.time = newtime;
			break;
		     case GDK_PROXIMITY_IN:
		     case GDK_PROXIMITY_OUT:
			event->proximity.time = newtime;
			break;
		     case GDK_DRAG_ENTER:
		     case GDK_DRAG_LEAVE:
		     case GDK_DRAG_MOTION:
		     case GDK_DRAG_STATUS:
		     case GDK_DROP_START:
		     case GDK_DROP_FINISHED:
			event->dnd.time = newtime;
			break;
#if GTK_CHECK_VERSION (2, 6, 0)
		     case GDK_OWNER_CHANGE:
			event->owner_change.time = newtime;
#endif
		     case GDK_CLIENT_EVENT:
		     case GDK_VISIBILITY_NOTIFY:
		     case GDK_NO_EXPOSE:
		     case GDK_CONFIGURE:
		     case GDK_FOCUS_CHANGE:
		     case GDK_NOTHING:
		     case GDK_DELETE:
		     case GDK_DESTROY:
		     case GDK_EXPOSE:
		     case GDK_MAP:
		     case GDK_UNMAP:
		     case GDK_WINDOW_STATE:
		     case GDK_SETTING:
#if GTK_CHECK_VERSION (2, 8, 0)
		     case GDK_GRAB_BROKEN:
#endif
#if GTK_CHECK_VERSION (2, 14, 0)
		    case GDK_DAMAGE:
#endif
			/* no time */
			break;
		}
	}
}

/* initialized in the boot section. */
static GPerlBoxedWrapperClass   gdk_event_wrapper_class;
static GPerlBoxedWrapperClass * default_wrapper_class;

static SV *
gdk_event_wrap (GType gtype,
                const char * package,
                GdkEvent * event,
		gboolean own)
{
	HV * stash;
	SV * sv;

	sv = default_wrapper_class->wrap (gtype, package, event, own);

	/* we don't really care about the registered package, override it. */
	package = gdk_event_get_package (gtype, event);
	stash = gv_stashpv (package, TRUE);
	return sv_bless (sv, stash);
}

static GdkEvent *
gdk_event_unwrap (GType gtype, const char * package, SV * sv)
{
	GdkEvent * event = default_wrapper_class->unwrap (gtype, package, sv);

	/* we don't really care about the registered package, override it. */
	package = gdk_event_get_package (gtype, event);

	if (!sv_derived_from (sv, package))
		croak ("%s is not of type %s",
		       gperl_format_variable_for_output (sv),
		       package);

	return event;
}

#if !GTK_CHECK_VERSION (2, 2, 0)
# define gdk_event_new	gtk2perl_gdk_event_new
static GdkEvent *
gtk2perl_gdk_event_new (GdkEventType type)
{
	GdkEvent ev;
	memset (&ev, 0, sizeof (GdkEvent));
	ev.any.type = type;
	return gdk_event_copy (&ev);
}
#endif

static void
gtk2perl_event_func (GdkEvent *event, gpointer data)
{
	gperl_callback_invoke ((GPerlCallback *) data, NULL, event);
}

#line 338 "xs/GdkEvent.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 482 "xs/GdkEvent.c"

XS_EUPXS(XS_Gtk2__Gdk_events_pending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk_events_pending)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	gboolean	RETVAL;

	RETVAL = gdk_events_pending(/*void*/);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GdkEvent_own_ornull *	RETVAL;

	RETVAL = gdk_event_get(/*void*/);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkEvent_own_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
#line 415 "xs/GdkEvent.xs"
	PERL_UNUSED_VAR (ix);
#line 519 "xs/GdkEvent.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_graphics_expose); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_graphics_expose)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, window");
    {
	GdkWindow *	window = SvGdkWindow (ST(1))
;
	GdkEvent_own_ornull *	RETVAL;

	RETVAL = gdk_event_get_graphics_expose(window);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkEvent_own_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_put); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_put)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, event");
    {
	GdkEvent *	event = SvGdkEvent (ST(1))
;

	gdk_event_put(event);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Event_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, type");
    {
	GdkEventType	type = SvGdkEventType (ST(1))
;
	GdkEvent_own *	RETVAL;

	RETVAL = gdk_event_new(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkEvent_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_copy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkEvent_own *	RETVAL;

	RETVAL = gdk_event_copy(event);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkEvent_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_time)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "event, ...");
    {
	GdkEvent_ornull *	event = SvGdkEvent_ornull (ST(0))
;
	guint	RETVAL;
	dXSTARG;
#line 476 "xs/GdkEvent.xs"
	if (ix == 0 && items != 1)
		croak ("Usage:  Gtk2::Gdk::Event::get_time (event)");
	if (ix == 2 && items != 2)
		croak ("Usage:  Gtk2::Gdk::Event::set_time (event, newtime)");
	RETVAL = gdk_event_get_time (event);
	if (items == 2 || ix == 2) {
		/* set */
		gtk2perl_gdk_event_set_time (event, SvIV (ST (1)));
	}
#line 632 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_state)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "event, ...");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkModifierType	RETVAL;
#line 512 "xs/GdkEvent.xs"
	if (ix == 0 && items != 1)
		croak ("Usage:  Gtk2::Gdk::Event::get_state (event)");
	if (ix == 2 && items != 2)
		croak ("Usage:  Gtk2::Gdk::Event::set_state (event, newstate)");
	if (items == 2 || ix == 2) {
		/* set; return old value. */
		if (!gdk_event_get_state (event, &RETVAL)) {
			/* Use pass_unknown to prevent getting the rather
			 * unhelpful "invalid enum value" exception here for
			 * events added in newer gdks than that for which we
			 * were built.  If we're going to throw an exception,
			 * it should at least be somewhat meaningful. */
			SV * s = gperl_convert_back_enum_pass_unknown
					(GDK_TYPE_EVENT_TYPE, event->type);
			croak ("events of type %s have no state member",
			       SvPV_nolen (s));
		}
		gtk2perl_gdk_event_set_state (event,
		                              SvGdkModifierType (ST (1)));
	} else {
		/* just get */
		if (!gdk_event_get_state (event, &RETVAL))
			XSRETURN_UNDEF;
	}
#line 675 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkModifierType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_coords); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_coords)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
#line 554 "xs/GdkEvent.xs"
	gdouble x;
	gdouble y;
#line 702 "xs/GdkEvent.c"
#line 557 "xs/GdkEvent.xs"
	if (!gdk_event_get_coords (event, &x, &y))
		XSRETURN_EMPTY;
	PERL_UNUSED_VAR (ix);
	EXTEND (SP, 2);
	PUSHs (sv_2mortal (newSVnv (x)));
	PUSHs (sv_2mortal (newSVnv (y)));
#line 710 "xs/GdkEvent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_root_coords); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_root_coords)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
#line 589 "xs/GdkEvent.xs"
	gdouble x_root;
	gdouble y_root;
#line 732 "xs/GdkEvent.c"
#line 592 "xs/GdkEvent.xs"
	if (!gdk_event_get_root_coords (event, &x_root, &y_root))
		XSRETURN_EMPTY;
	switch (ix) {
		case 2: /* x */
			PUSHs (sv_2mortal (newSVnv (x_root)));
			break;
		case 3: /* y */
			PUSHs (sv_2mortal (newSVnv (y_root)));
			break;
		default:
			EXTEND (SP, 2);
			PUSHs (sv_2mortal (newSVnv (x_root)));
			PUSHs (sv_2mortal (newSVnv (y_root)));
	}
#line 748 "xs/GdkEvent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_axis); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_axis)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "event, axis_use");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkAxisUse	axis_use = SvGdkAxisUse (ST(1))
;
	gdouble	RETVAL;
	dXSTARG;
#line 616 "xs/GdkEvent.xs"
	PERL_UNUSED_VAR (ix);
	if (!gdk_event_get_axis (event, axis_use, &RETVAL))
		XSRETURN_UNDEF;
#line 773 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_handler_set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_handler_set)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "class, func, data=NULL");
    {
	SV *	func = ST(1)
;
	SV *	data;
#line 639 "xs/GdkEvent.xs"
	GPerlCallback *callback;
	GType params[1];
#line 793 "xs/GdkEvent.c"

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 642 "xs/GdkEvent.xs"
    	params[0] = GDK_TYPE_EVENT;
	if (gperl_sv_is_defined (func)) {
		callback = gperl_callback_new (func, data,
		                               G_N_ELEMENTS (params),
		                               params, 0);
		gdk_event_handler_set (gtk2perl_event_func,
		                       callback,
		                       (GDestroyNotify) gperl_callback_destroy);
	} else {
		/* reset to gtk+'s event handler. */
		gdk_event_handler_set ((GdkEventFunc) gtk_main_do_event,
				       NULL, NULL);
	}
#line 815 "xs/GdkEvent.c"
    }
    XSRETURN_EMPTY;
}

#if GTK_CHECK_VERSION (2,2,0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gtk2__Gdk__Event_set_screen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_set_screen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "event, screen");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkScreen *	screen = SvGdkScreen (ST(1))
;

	gdk_event_set_screen(event, screen);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Event_get_screen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_get_screen)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkScreen *	RETVAL;

	RETVAL = gdk_event_get_screen(event);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkScreen (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif /* have GdkScreen */

XS_EUPXS(XS_Gtk2__Gdk__Event_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_DESTROY)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 698 "xs/GdkEvent.xs"
	PERL_UNUSED_VAR (ix);
	default_wrapper_class->destroy (sv);
#line 879 "xs/GdkEvent.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Event_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkEventType	RETVAL;
#line 738 "xs/GdkEvent.xs"
	RETVAL = event->any.type;
#line 897 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkEventType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_window); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_window)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=NULL");
    {
	GdkWindow_ornull *	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkWindow_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkWindow_ornull (ST(1))
;
	}
#line 745 "xs/GdkEvent.xs"
	RETVAL = event->any.window;
	if (RETVAL) g_object_ref (event->any.window);

	if (items == 2 && newvalue != event->any.window)
	{
		if (event->any.window)
			g_object_unref (event->any.window);
		if (newvalue)
			g_object_ref (newvalue);
		event->any.window = newvalue;
	}
#line 939 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkWindow_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
#line 759 "xs/GdkEvent.xs"
	if (RETVAL) g_object_unref (RETVAL);
#line 948 "xs/GdkEvent.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event_send_event); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event_send_event)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	gint8	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gint8	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (gint8)SvIV(ST(1))
;
	}
#line 764 "xs/GdkEvent.xs"
	RETVAL = event->any.send_event;
	if (items == 2)
		event->any.send_event = newvalue;
#line 977 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_area); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_area)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventexpose, newvalue=NULL");
    {
	GdkRectangle *	RETVAL;
	GdkEvent *	eventexpose = SvGdkEvent (ST(0))
;
	GdkRectangle *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkRectangle (ST(1))
;
	}
#line 797 "xs/GdkEvent.xs"
	RETVAL = &(eventexpose->expose.area);
	if (items == 2)
	{
		eventexpose->expose.area.x = newvalue->x;
		eventexpose->expose.area.y = newvalue->y;
		eventexpose->expose.area.width = newvalue->width;
		eventexpose->expose.area.height = newvalue->height;
	}
#line 1011 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkRectangle (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_region); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_region)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventexpose, newvalue=NULL");
    {
	GdkRegion_own_ornull *	RETVAL;
	GdkEvent *	eventexpose = SvGdkEvent (ST(0))
;
	GdkRegion_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkRegion_ornull (ST(1))
;
	}
#line 811 "xs/GdkEvent.xs"
	RETVAL = NULL;
	if (eventexpose->expose.region)
		RETVAL = gdk_region_copy (eventexpose->expose.region);
	if (items == 2 && newvalue != eventexpose->expose.region)
	{
		if (eventexpose->expose.region)
			gdk_region_destroy (eventexpose->expose.region);
		if (newvalue)
			eventexpose->expose.region = gdk_region_copy (newvalue);
		else
			eventexpose->expose.region = NULL;
	}
#line 1054 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkRegion_own_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Expose_count)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventexpose, newvalue=0");
    {
	gint	RETVAL;
	dXSTARG;
	GdkEvent *	eventexpose = SvGdkEvent (ST(0))
;
	guint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint)SvUV(ST(1))
;
	}
#line 829 "xs/GdkEvent.xs"
	RETVAL = eventexpose->expose.count;
	if (items == 2)
		eventexpose->expose.count = newvalue;
#line 1089 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Visibility_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Visibility_state)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventvisibility, newvalue=0");
    {
	GdkVisibilityState	RETVAL;
	GdkEvent *	eventvisibility = SvGdkEvent (ST(0))
;
	GdkVisibilityState	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkVisibilityState (ST(1))
;
	}
#line 882 "xs/GdkEvent.xs"
	RETVAL = eventvisibility->visibility.state;
	if (items == 2)
		eventvisibility->visibility.state = newvalue;
#line 1118 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkVisibilityState (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_is_hint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_is_hint)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventmotion, newvalue=0");
    {
	guint	RETVAL;
	dXSTARG;
	GdkEvent *	eventmotion = SvGdkEvent (ST(0))
;
	guint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint)SvUV(ST(1))
;
	}
#line 920 "xs/GdkEvent.xs"
	RETVAL = eventmotion->motion.is_hint;
	if (items == 2)
		eventmotion->motion.is_hint = newvalue;
#line 1153 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_device)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventmotion, newvalue=NULL");
    {
	GdkDevice_ornull *	RETVAL;
	GdkEvent *	eventmotion = SvGdkEvent (ST(0))
;
	GdkDevice_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkDevice_ornull (ST(1))
;
	}
#line 929 "xs/GdkEvent.xs"
	RETVAL = eventmotion->motion.device;
	if (items == 2)
		eventmotion->motion.device = newvalue;
#line 1182 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkDevice_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_x)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 938 "xs/GdkEvent.xs"
	RETVAL = event->motion.x;
	if (items == 2)
		event->motion.x = newvalue;
#line 1217 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_y)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 947 "xs/GdkEvent.xs"
	RETVAL = event->motion.y;
	if (items == 2)
		event->motion.y = newvalue;
#line 1247 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_request_motions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Motion_request_motions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "event");
    {
	GdkEvent *	event = SvGdkEvent (ST(0))
;
#line 959 "xs/GdkEvent.xs"
	gdk_event_request_motions ((GdkEventMotion *) event);
#line 1268 "xs/GdkEvent.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gtk2__Gdk__Event__Button_button); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Button_button)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventbutton, newvalue=0");
    {
	guint	RETVAL;
	dXSTARG;
	GdkEvent *	eventbutton = SvGdkEvent (ST(0))
;
	guint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint)SvUV(ST(1))
;
	}
#line 995 "xs/GdkEvent.xs"
	RETVAL = eventbutton->button.button;
	if (items == 2)
		eventbutton->button.button = newvalue;
#line 1298 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Button_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Button_device)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventbutton, newvalue=NULL");
    {
	GdkDevice_ornull *	RETVAL;
	GdkEvent *	eventbutton = SvGdkEvent (ST(0))
;
	GdkDevice_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkDevice_ornull (ST(1))
;
	}
#line 1004 "xs/GdkEvent.xs"
	RETVAL = eventbutton->button.device;
	if (items == 2)
		eventbutton->button.device = newvalue;
#line 1327 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkDevice_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Button_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Button_x)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1013 "xs/GdkEvent.xs"
	RETVAL = event->button.x;
	if (items == 2)
		event->button.x = newvalue;
#line 1362 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Button_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Button_y)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1022 "xs/GdkEvent.xs"
	RETVAL = event->button.y;
	if (items == 2)
		event->button.y = newvalue;
#line 1392 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_direction); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_direction)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventscroll, newvalue=0");
    {
	GdkScrollDirection	RETVAL;
	GdkEvent *	eventscroll = SvGdkEvent (ST(0))
;
	GdkScrollDirection	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkScrollDirection (ST(1))
;
	}
#line 1059 "xs/GdkEvent.xs"
	RETVAL = eventscroll->scroll.direction;
	if (items == 2)
		eventscroll->scroll.direction = newvalue;
#line 1421 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkScrollDirection (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_device)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventscroll, newvalue=NULL");
    {
	GdkDevice_ornull *	RETVAL;
	GdkEvent *	eventscroll = SvGdkEvent (ST(0))
;
	GdkDevice_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkDevice_ornull (ST(1))
;
	}
#line 1068 "xs/GdkEvent.xs"
	RETVAL = eventscroll->scroll.device;
	if (items == 2)
		eventscroll->scroll.device = newvalue;
#line 1455 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkDevice_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_x)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1077 "xs/GdkEvent.xs"
	RETVAL = event->scroll.x;
	if (items == 2)
		event->scroll.x = newvalue;
#line 1490 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Scroll_y)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1086 "xs/GdkEvent.xs"
	RETVAL = event->scroll.y;
	if (items == 2)
		event->scroll.y = newvalue;
#line 1520 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Key_keyval); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Key_keyval)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventkey, newvalue=0");
    {
	guint	RETVAL;
	dXSTARG;
	GdkEvent *	eventkey = SvGdkEvent (ST(0))
;
	guint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint)SvUV(ST(1))
;
	}
#line 1123 "xs/GdkEvent.xs"
	RETVAL = eventkey->key.keyval;
	if (items == 2)
		eventkey->key.keyval = newvalue;
#line 1550 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Key_hardware_keycode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Key_hardware_keycode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventkey, newvalue=0");
    {
	guint16	RETVAL;
	dXSTARG;
	GdkEvent *	eventkey = SvGdkEvent (ST(0))
;
	guint16	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint16)SvUV(ST(1))
;
	}
#line 1132 "xs/GdkEvent.xs"
	RETVAL = eventkey->key.hardware_keycode;
	if (items == 2)
		eventkey->key.hardware_keycode = newvalue;
#line 1580 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Key_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Key_group)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventkey, newvalue=0");
    {
	guint8	RETVAL;
	dXSTARG;
	GdkEvent *	eventkey = SvGdkEvent (ST(0))
;
	guint8	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint8)SvUV(ST(1))
;
	}
#line 1141 "xs/GdkEvent.xs"
	RETVAL = eventkey->key.group;
	if (items == 2)
		eventkey->key.group = newvalue;
#line 1610 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_subwindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_subwindow)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=NULL");
    {
	GdkWindow_ornull *	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkWindow_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkWindow_ornull (ST(1))
;
	}
#line 1182 "xs/GdkEvent.xs"
	RETVAL = event->crossing.subwindow;
	if (RETVAL) g_object_ref (RETVAL);

	if (items == 2 && newvalue != event->crossing.subwindow)
	{
		if (event->crossing.subwindow)
			g_object_unref (event->crossing.subwindow);
		if (newvalue)
			g_object_ref (newvalue);
		event->crossing.subwindow = newvalue;
	}
#line 1647 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkWindow_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
#line 1196 "xs/GdkEvent.xs"
	if (RETVAL) g_object_unref (RETVAL);
#line 1656 "xs/GdkEvent.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_mode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_mode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventcrossing, newvalue=0");
    {
	GdkCrossingMode	RETVAL;
	GdkEvent *	eventcrossing = SvGdkEvent (ST(0))
;
	GdkCrossingMode	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkCrossingMode (ST(1))
;
	}
#line 1201 "xs/GdkEvent.xs"
	RETVAL = eventcrossing->crossing.mode;
	if (items == 2)
		eventcrossing->crossing.mode = newvalue;
#line 1684 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkCrossingMode (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_detail); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_detail)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventcrossing, newvalue=0");
    {
	GdkNotifyType	RETVAL;
	GdkEvent *	eventcrossing = SvGdkEvent (ST(0))
;
	GdkNotifyType	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkNotifyType (ST(1))
;
	}
#line 1210 "xs/GdkEvent.xs"
	RETVAL = eventcrossing->crossing.detail;
	if (items == 2)
		eventcrossing->crossing.detail = newvalue;
#line 1718 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkNotifyType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_focus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_focus)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventcrossing, newvalue=0");
    {
	gboolean	RETVAL;
	GdkEvent *	eventcrossing = SvGdkEvent (ST(0))
;
	gboolean	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (bool)SvTRUE(ST(1))
;
	}
#line 1219 "xs/GdkEvent.xs"
	RETVAL = eventcrossing->crossing.focus;
	if (items == 2)
		eventcrossing->crossing.focus = newvalue;
#line 1752 "xs/GdkEvent.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_x)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1228 "xs/GdkEvent.xs"
	RETVAL = event->crossing.x;
	if (items == 2)
		event->crossing.x = newvalue;
#line 1782 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Crossing_y)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0.0");
    {
	gdouble	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gdouble	newvalue;

	if (items < 2)
	    newvalue = 0.0;
	else {
	    newvalue = (double)SvNV(ST(1))
;
	}
#line 1237 "xs/GdkEvent.xs"
	RETVAL = event->crossing.y;
	if (items == 2)
		event->crossing.y = newvalue;
#line 1812 "xs/GdkEvent.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Focus_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Focus_in)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventfocus, newvalue=0");
    {
	gint16	RETVAL;
	dXSTARG;
	GdkEvent *	eventfocus = SvGdkEvent (ST(0))
;
	gint16	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (gint16)SvIV(ST(1))
;
	}
#line 1268 "xs/GdkEvent.xs"
	RETVAL = eventfocus->focus_change.in;
	if (items == 2)
		eventfocus->focus_change.in = newvalue;
#line 1842 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_width)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventconfigure, newvalue=0");
    {
	gint	RETVAL;
	dXSTARG;
	GdkEvent *	eventconfigure = SvGdkEvent (ST(0))
;
	gint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (gint)SvIV(ST(1))
;
	}
#line 1303 "xs/GdkEvent.xs"
	switch (ix) {
		case 0:
			RETVAL = eventconfigure->configure.width;
			break;
		case 1:
			RETVAL = eventconfigure->configure.height;
			break;
		default:
			RETVAL = 0;
			g_assert_not_reached ();
	}
	if (items == 2)
	{
		switch (ix) {
			case 0:
				eventconfigure->configure.width = newvalue;
				break;
			case 1:
				eventconfigure->configure.height = newvalue;
				break;
			default:
				g_assert_not_reached ();
		}
	}
#line 1894 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_x); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_x)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	gint	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (gint)SvIV(ST(1))
;
	}
#line 1333 "xs/GdkEvent.xs"
	RETVAL = event->configure.x;
	if (items == 2)
		event->configure.x = newvalue;
#line 1924 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Configure_y)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	gint	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (gint)SvIV(ST(1))
;
	}
#line 1342 "xs/GdkEvent.xs"
	RETVAL = event->configure.y;
	if (items == 2)
		event->configure.y = newvalue;
#line 1954 "xs/GdkEvent.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Property_atom); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Property_atom)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventproperty, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	eventproperty = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1375 "xs/GdkEvent.xs"
	RETVAL = eventproperty->property.atom;
	if (items == 2)
		eventproperty->property.atom = newvalue;
#line 1983 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Property_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Property_state)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventproperty, newvalue=0");
    {
	guint	RETVAL;
	dXSTARG;
	GdkEvent *	eventproperty = SvGdkEvent (ST(0))
;
	guint	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint)SvUV(ST(1))
;
	}
#line 1384 "xs/GdkEvent.xs"
	RETVAL = eventproperty->property.state;
	if (items == 2)
		eventproperty->property.state = newvalue;
#line 2018 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_selection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_selection)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventselection, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	eventselection = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1419 "xs/GdkEvent.xs"
	RETVAL = eventselection->selection.selection;
	if (items == 2)
		eventselection->selection.selection = newvalue;
#line 2047 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_target)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventselection, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	eventselection = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1428 "xs/GdkEvent.xs"
	RETVAL = eventselection->selection.target;
	if (items == 2)
		eventselection->selection.target = newvalue;
#line 2081 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_property); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_property)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventselection, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	eventselection = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1437 "xs/GdkEvent.xs"
	RETVAL = eventselection->selection.property;
	if (items == 2)
		eventselection->selection.property = newvalue;
#line 2115 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_requestor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Selection_requestor)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventselection, newvalue=0");
    {
	GdkNativeWindow	RETVAL;
	dXSTARG;
	GdkEvent *	eventselection = SvGdkEvent (ST(0))
;
	GdkNativeWindow	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (GdkNativeWindow)SvUV(ST(1))
;
	}
#line 1446 "xs/GdkEvent.xs"
	RETVAL = eventselection->selection.requestor;
	if (items == 2)
		eventselection->selection.requestor = newvalue;
#line 2150 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Proximity_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Proximity_device)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventproximity, newvalue=NULL");
    {
	GdkDevice_ornull *	RETVAL;
	GdkEvent *	eventproximity = SvGdkEvent (ST(0))
;
	GdkDevice_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkDevice_ornull (ST(1))
;
	}
#line 1481 "xs/GdkEvent.xs"
	RETVAL = eventproximity->motion.device;
	if (items == 2)
		eventproximity->motion.device = newvalue;
#line 2179 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkDevice_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Client_message_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Client_message_type)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventclient, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	eventclient = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1518 "xs/GdkEvent.xs"
	RETVAL = eventclient->client.message_type;
	if (items == 2)
		eventclient->client.message_type = newvalue;
#line 2213 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Client_data_format); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Client_data_format)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventclient, newvalue=0");
    {
	gushort	RETVAL;
	dXSTARG;
	GdkEvent *	eventclient = SvGdkEvent (ST(0))
;
	gushort	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (unsigned short)SvUV(ST(1))
;
	}
#line 1533 "xs/GdkEvent.xs"
	RETVAL = eventclient->client.data_format;
	if (items == 2)
		eventclient->client.data_format = newvalue;
#line 2248 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Client_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Client_data)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "eventclient, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1560 "xs/GdkEvent.xs"
	int i, first_index = 1;
#line 2266 "xs/GdkEvent.c"
	GdkEvent *	eventclient = SvGdkEvent (ST(0))
;
#line 1562 "xs/GdkEvent.xs"
	switch (eventclient->client.data_format) {
		case 8: {
			if (items == first_index + 1) {
				char *data = SvPV_nolen (ST (first_index));
				char old[20];

				for (i = 0; i < 20; i++) {
					old[i] = eventclient->client.data.b[i];
					eventclient->client.data.b[i] = data[i];
				}

				XPUSHs (sv_2mortal (newSVpv (old, 20)));
			} else {
				XPUSHs (sv_2mortal (newSVpv (eventclient->client.data.b, 20)));
			}

			break;
		}
		case 16: {
			if (items == first_index + 10) {
				short old[10];

				for (i = first_index; i < items; i++) {
					old[i - first_index] = eventclient->client.data.s[i - first_index];
					eventclient->client.data.s[i - first_index] = (gint16) SvIV (ST (i));
				}

				for (i = 0; i < 10; i++)
					XPUSHs (sv_2mortal (newSViv (old[i])));

			} else {
				for (i = 0; i < 10; i++)
					XPUSHs (sv_2mortal (newSViv (eventclient->client.data.s[i])));
			}

			break;
		}
		case 32: {
			if (items == first_index + 5) {
				long old[5];

				for (i = first_index; i < items; i++) {
					old[i - first_index] = eventclient->client.data.l[i - first_index];
					eventclient->client.data.l[i - first_index] = SvIV (ST (i));
				}

				for (i = 0; i < 5; i++)
					XPUSHs (sv_2mortal (newSViv (old[i])));

			} else {
				for (i = 0; i < 5; i++)
					XPUSHs (sv_2mortal (newSViv (eventclient->client.data.l[i])));
			}

			break;
		}
		default:
			croak ("Illegal format value %d used; should be either 8, 16 or 32", 
			       eventclient->client.data_format);
	}
#line 2330 "xs/GdkEvent.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Setting_action); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Setting_action)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventsetting, newvalue=0");
    {
	GdkSettingAction	RETVAL;
	GdkEvent *	eventsetting = SvGdkEvent (ST(0))
;
	GdkSettingAction	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkSettingAction (ST(1))
;
	}
#line 1649 "xs/GdkEvent.xs"
	RETVAL = eventsetting->setting.action;
	if (items == 2)
		eventsetting->setting.action = newvalue;
#line 2359 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkSettingAction (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__Setting_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__Setting_name)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventsetting, newvalue=NULL");
    {
	char_ornull *	RETVAL;
	GdkEvent *	eventsetting = SvGdkEvent (ST(0))
;
	char_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    if (gperl_sv_is_defined (ST(1))) {
		    newvalue = (char_ornull *)SvPV_nolen (ST(1));
	    } else {
		    newvalue = NULL;
	    }
;
	}
#line 1658 "xs/GdkEvent.xs"
	RETVAL = eventsetting->setting.name;
	if (items == 2)
	{
		if (eventsetting->setting.name)
			g_free (eventsetting->setting.name);

		if (newvalue)
			eventsetting->setting.name = g_strdup (newvalue);
		else
			eventsetting->setting.name = NULL;
	}
#line 2405 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL) {
		    sv_setpv ((SV*)RETVALSV, RETVAL);
	    } else {
		    SvSetSV (RETVALSV, &PL_sv_undef);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__WindowState_changed_mask); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__WindowState_changed_mask)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventwindowstate, newvalue=0");
    {
	GdkWindowState	RETVAL;
	GdkEvent *	eventwindowstate = SvGdkEvent (ST(0))
;
	GdkWindowState	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkWindowState (ST(1))
;
	}
#line 1698 "xs/GdkEvent.xs"
	RETVAL = eventwindowstate->window_state.changed_mask;
	if (items == 2)
		eventwindowstate->window_state.changed_mask = newvalue;
#line 2443 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkWindowState (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__WindowState_new_window_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__WindowState_new_window_state)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventwindowstate, newvalue=0");
    {
	GdkWindowState	RETVAL;
	GdkEvent *	eventwindowstate = SvGdkEvent (ST(0))
;
	GdkWindowState	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkWindowState (ST(1))
;
	}
#line 1707 "xs/GdkEvent.xs"
	RETVAL = eventwindowstate->window_state.new_window_state;
	if (items == 2)
		eventwindowstate->window_state.new_window_state = newvalue;
#line 2477 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkWindowState (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__DND_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__DND_context)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "eventdnd, newvalue=NULL");
    {
	GdkDragContext_ornull *	RETVAL;
	GdkEvent *	eventdnd = SvGdkEvent (ST(0))
;
	GdkDragContext_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkDragContext_ornull (ST(1))
;
	}
#line 1742 "xs/GdkEvent.xs"
	RETVAL = eventdnd->dnd.context;
	if (RETVAL) g_object_ref (RETVAL);

	if (items == 2 && newvalue != eventdnd->dnd.context)
	{
		if (eventdnd->dnd.context)
			g_object_unref (eventdnd->dnd.context);
		if (newvalue)
			g_object_ref (newvalue);
		eventdnd->dnd.context = newvalue;
	}
#line 2519 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkDragContext_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
#line 1756 "xs/GdkEvent.xs"
	if (RETVAL) g_object_unref (RETVAL);
#line 2528 "xs/GdkEvent.c"
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION (2, 6, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_owner); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_owner)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	GdkNativeWindow	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkNativeWindow	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (GdkNativeWindow)SvUV(ST(1))
;
	}
#line 1789 "xs/GdkEvent.xs"
	RETVAL = event->owner_change.owner;

	if (items == 2 && newvalue != RETVAL)
	{
		event->owner_change.owner = newvalue;
	}
#line 2563 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_reason); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_reason)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	GdkOwnerChange	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkOwnerChange	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkOwnerChange (ST(1))
;
	}
#line 1801 "xs/GdkEvent.xs"
	RETVAL = event->owner_change.reason;

	if (items == 2 && newvalue != RETVAL)
	{
		event->owner_change.reason = newvalue;
	}
#line 2595 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkOwnerChange (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_selection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_selection)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	GdkAtom	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkAtom	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = SvGdkAtom (ST(1))
;
	}
#line 1813 "xs/GdkEvent.xs"
	RETVAL = event->owner_change.selection;

	if (items == 2 && newvalue != RETVAL)
	{
		event->owner_change.selection = newvalue;
	}
#line 2632 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkAtom (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_selection_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__OwnerChange_selection_time)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	guint32	RETVAL;
	dXSTARG;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	guint32	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (guint32)SvUV(ST(1))
;
	}
#line 1825 "xs/GdkEvent.xs"
	RETVAL = event->owner_change.selection_time;

	if (items == 2 && newvalue != RETVAL)
	{
		event->owner_change.selection_time = newvalue;
	}
#line 2670 "xs/GdkEvent.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if GTK_CHECK_VERSION (2, 8, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_keyboard); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_keyboard)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	gboolean	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gboolean	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (bool)SvTRUE(ST(1))
;
	}
#line 1857 "xs/GdkEvent.xs"
	RETVAL = event->grab_broken.keyboard;

	if (items == 2 && newvalue != RETVAL)
		event->grab_broken.keyboard = newvalue;
#line 2704 "xs/GdkEvent.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_implicit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_implicit)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=0");
    {
	gboolean	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	gboolean	newvalue;

	if (items < 2)
	    newvalue = 0;
	else {
	    newvalue = (bool)SvTRUE(ST(1))
;
	}
#line 1867 "xs/GdkEvent.xs"
	RETVAL = event->grab_broken.implicit;

	if (items == 2 && newvalue != RETVAL)
		event->grab_broken.implicit = newvalue;
#line 2734 "xs/GdkEvent.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_grab_window); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Event__GrabBroken_grab_window)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "event, newvalue=NULL");
    {
	GdkWindow_ornull *	RETVAL;
	GdkEvent *	event = SvGdkEvent (ST(0))
;
	GdkWindow_ornull *	newvalue;

	if (items < 2)
	    newvalue = NULL;
	else {
	    newvalue = SvGdkWindow_ornull (ST(1))
;
	}
#line 1882 "xs/GdkEvent.xs"
	RETVAL = event->grab_broken.grab_window;

	/* GdkEventGrabBroken doesn't hold a ref on grab_window, so
	 * just plonk the new value in, unlike for any.window above.
         */
	if (items == 2 && newvalue != RETVAL)
		event->grab_broken.grab_window = newvalue;
#line 2767 "xs/GdkEvent.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkWindow_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gtk2__Gdk_set_show_events); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk_set_show_events)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, show_events");
    {
	gboolean	show_events = (bool)SvTRUE(ST(1))
;

	gdk_set_show_events(show_events);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk_get_show_events); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk_get_show_events)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	gboolean	RETVAL;

	RETVAL = gdk_get_show_events(/*void*/);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk_setting_get); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk_setting_get)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, name");
    {
	const gchar *	name;
#line 1925 "xs/GdkEvent.xs"
	GValue value = {0,};
#line 2822 "xs/GdkEvent.c"
	SV *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	name = (const gchar *)SvPV_nolen (ST(1))
;
#line 1927 "xs/GdkEvent.xs"
	g_value_init (&value, G_TYPE_INT);
	if (!gdk_setting_get (name, &value))
		XSRETURN_UNDEF;
	RETVAL = gperl_sv_from_value (&value);
	g_value_unset (&value);
#line 2835 "xs/GdkEvent.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gtk2__Gdk__Event); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gtk2__Gdk__Event)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Gtk2::Gdk::events_pending", XS_Gtk2__Gdk_events_pending);
        cv = newXS_deffile("Gtk2::Gdk::Event::get", XS_Gtk2__Gdk__Event_get);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::peek", XS_Gtk2__Gdk__Event_get);
        XSANY.any_i32 = 1;
        newXS_deffile("Gtk2::Gdk::Event::get_graphics_expose", XS_Gtk2__Gdk__Event_get_graphics_expose);
        newXS_deffile("Gtk2::Gdk::Event::put", XS_Gtk2__Gdk__Event_put);
        newXS_deffile("Gtk2::Gdk::Event::new", XS_Gtk2__Gdk__Event_new);
        newXS_deffile("Gtk2::Gdk::Event::copy", XS_Gtk2__Gdk__Event_copy);
        cv = newXS_deffile("Gtk2::Gdk::Event::get_time", XS_Gtk2__Gdk__Event_get_time);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::set_time", XS_Gtk2__Gdk__Event_get_time);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Gtk2::Gdk::Event::time", XS_Gtk2__Gdk__Event_get_time);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::get_state", XS_Gtk2__Gdk__Event_get_state);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::set_state", XS_Gtk2__Gdk__Event_get_state);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Gtk2::Gdk::Event::state", XS_Gtk2__Gdk__Event_get_state);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::coords", XS_Gtk2__Gdk__Event_get_coords);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::get_coords", XS_Gtk2__Gdk__Event_get_coords);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::get_root_coords", XS_Gtk2__Gdk__Event_get_root_coords);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::root_coords", XS_Gtk2__Gdk__Event_get_root_coords);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::x_root", XS_Gtk2__Gdk__Event_get_root_coords);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Gtk2::Gdk::Event::y_root", XS_Gtk2__Gdk__Event_get_root_coords);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Gtk2::Gdk::Event::axis", XS_Gtk2__Gdk__Event_get_axis);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::get_axis", XS_Gtk2__Gdk__Event_get_axis);
        XSANY.any_i32 = 0;
        newXS_deffile("Gtk2::Gdk::Event::handler_set", XS_Gtk2__Gdk__Event_handler_set);
#if XSubPPtmpAAAA
        newXS_deffile("Gtk2::Gdk::Event::set_screen", XS_Gtk2__Gdk__Event_set_screen);
        newXS_deffile("Gtk2::Gdk::Event::get_screen", XS_Gtk2__Gdk__Event_get_screen);
#endif
        cv = newXS_deffile("Gtk2::Gdk::Event::Button::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("Gtk2::Gdk::Event::Client::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 14;
        cv = newXS_deffile("Gtk2::Gdk::Event::Configure::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 10;
        cv = newXS_deffile("Gtk2::Gdk::Event::Crossing::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 8;
        cv = newXS_deffile("Gtk2::Gdk::Event::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Event::DND::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 17;
        cv = newXS_deffile("Gtk2::Gdk::Event::Expose::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::Focus::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 9;
        cv = newXS_deffile("Gtk2::Gdk::Event::GrabBroken::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 19;
        cv = newXS_deffile("Gtk2::Gdk::Event::Key::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 7;
        cv = newXS_deffile("Gtk2::Gdk::Event::Motion::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("Gtk2::Gdk::Event::NoExpose::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Gtk2::Gdk::Event::OwnerChange::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 18;
        cv = newXS_deffile("Gtk2::Gdk::Event::Property::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 11;
        cv = newXS_deffile("Gtk2::Gdk::Event::Proximity::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 13;
        cv = newXS_deffile("Gtk2::Gdk::Event::Scroll::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 6;
        cv = newXS_deffile("Gtk2::Gdk::Event::Selection::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 12;
        cv = newXS_deffile("Gtk2::Gdk::Event::Setting::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 15;
        cv = newXS_deffile("Gtk2::Gdk::Event::Visibility::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Gtk2::Gdk::Event::WindowState::DESTROY", XS_Gtk2__Gdk__Event_DESTROY);
        XSANY.any_i32 = 16;
        newXS_deffile("Gtk2::Gdk::Event::type", XS_Gtk2__Gdk__Event_type);
        newXS_deffile("Gtk2::Gdk::Event::window", XS_Gtk2__Gdk__Event_window);
        newXS_deffile("Gtk2::Gdk::Event::send_event", XS_Gtk2__Gdk__Event_send_event);
        newXS_deffile("Gtk2::Gdk::Event::Expose::area", XS_Gtk2__Gdk__Event__Expose_area);
        newXS_deffile("Gtk2::Gdk::Event::Expose::region", XS_Gtk2__Gdk__Event__Expose_region);
        newXS_deffile("Gtk2::Gdk::Event::Expose::count", XS_Gtk2__Gdk__Event__Expose_count);
        newXS_deffile("Gtk2::Gdk::Event::Visibility::state", XS_Gtk2__Gdk__Event__Visibility_state);
        newXS_deffile("Gtk2::Gdk::Event::Motion::is_hint", XS_Gtk2__Gdk__Event__Motion_is_hint);
        newXS_deffile("Gtk2::Gdk::Event::Motion::device", XS_Gtk2__Gdk__Event__Motion_device);
        newXS_deffile("Gtk2::Gdk::Event::Motion::x", XS_Gtk2__Gdk__Event__Motion_x);
        newXS_deffile("Gtk2::Gdk::Event::Motion::y", XS_Gtk2__Gdk__Event__Motion_y);
#if XSubPPtmpAAAB
        newXS_deffile("Gtk2::Gdk::Event::Motion::request_motions", XS_Gtk2__Gdk__Event__Motion_request_motions);
#endif
        newXS_deffile("Gtk2::Gdk::Event::Button::button", XS_Gtk2__Gdk__Event__Button_button);
        newXS_deffile("Gtk2::Gdk::Event::Button::device", XS_Gtk2__Gdk__Event__Button_device);
        newXS_deffile("Gtk2::Gdk::Event::Button::x", XS_Gtk2__Gdk__Event__Button_x);
        newXS_deffile("Gtk2::Gdk::Event::Button::y", XS_Gtk2__Gdk__Event__Button_y);
        newXS_deffile("Gtk2::Gdk::Event::Scroll::direction", XS_Gtk2__Gdk__Event__Scroll_direction);
        newXS_deffile("Gtk2::Gdk::Event::Scroll::device", XS_Gtk2__Gdk__Event__Scroll_device);
        newXS_deffile("Gtk2::Gdk::Event::Scroll::x", XS_Gtk2__Gdk__Event__Scroll_x);
        newXS_deffile("Gtk2::Gdk::Event::Scroll::y", XS_Gtk2__Gdk__Event__Scroll_y);
        newXS_deffile("Gtk2::Gdk::Event::Key::keyval", XS_Gtk2__Gdk__Event__Key_keyval);
        newXS_deffile("Gtk2::Gdk::Event::Key::hardware_keycode", XS_Gtk2__Gdk__Event__Key_hardware_keycode);
        newXS_deffile("Gtk2::Gdk::Event::Key::group", XS_Gtk2__Gdk__Event__Key_group);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::subwindow", XS_Gtk2__Gdk__Event__Crossing_subwindow);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::mode", XS_Gtk2__Gdk__Event__Crossing_mode);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::detail", XS_Gtk2__Gdk__Event__Crossing_detail);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::focus", XS_Gtk2__Gdk__Event__Crossing_focus);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::x", XS_Gtk2__Gdk__Event__Crossing_x);
        newXS_deffile("Gtk2::Gdk::Event::Crossing::y", XS_Gtk2__Gdk__Event__Crossing_y);
        newXS_deffile("Gtk2::Gdk::Event::Focus::in", XS_Gtk2__Gdk__Event__Focus_in);
        cv = newXS_deffile("Gtk2::Gdk::Event::Configure::height", XS_Gtk2__Gdk__Event__Configure_width);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Gtk2::Gdk::Event::Configure::width", XS_Gtk2__Gdk__Event__Configure_width);
        XSANY.any_i32 = 0;
        newXS_deffile("Gtk2::Gdk::Event::Configure::x", XS_Gtk2__Gdk__Event__Configure_x);
        newXS_deffile("Gtk2::Gdk::Event::Configure::y", XS_Gtk2__Gdk__Event__Configure_y);
        newXS_deffile("Gtk2::Gdk::Event::Property::atom", XS_Gtk2__Gdk__Event__Property_atom);
        newXS_deffile("Gtk2::Gdk::Event::Property::state", XS_Gtk2__Gdk__Event__Property_state);
        newXS_deffile("Gtk2::Gdk::Event::Selection::selection", XS_Gtk2__Gdk__Event__Selection_selection);
        newXS_deffile("Gtk2::Gdk::Event::Selection::target", XS_Gtk2__Gdk__Event__Selection_target);
        newXS_deffile("Gtk2::Gdk::Event::Selection::property", XS_Gtk2__Gdk__Event__Selection_property);
        newXS_deffile("Gtk2::Gdk::Event::Selection::requestor", XS_Gtk2__Gdk__Event__Selection_requestor);
        newXS_deffile("Gtk2::Gdk::Event::Proximity::device", XS_Gtk2__Gdk__Event__Proximity_device);
        newXS_deffile("Gtk2::Gdk::Event::Client::message_type", XS_Gtk2__Gdk__Event__Client_message_type);
        newXS_deffile("Gtk2::Gdk::Event::Client::data_format", XS_Gtk2__Gdk__Event__Client_data_format);
        newXS_deffile("Gtk2::Gdk::Event::Client::data", XS_Gtk2__Gdk__Event__Client_data);
        newXS_deffile("Gtk2::Gdk::Event::Setting::action", XS_Gtk2__Gdk__Event__Setting_action);
        newXS_deffile("Gtk2::Gdk::Event::Setting::name", XS_Gtk2__Gdk__Event__Setting_name);
        newXS_deffile("Gtk2::Gdk::Event::WindowState::changed_mask", XS_Gtk2__Gdk__Event__WindowState_changed_mask);
        newXS_deffile("Gtk2::Gdk::Event::WindowState::new_window_state", XS_Gtk2__Gdk__Event__WindowState_new_window_state);
        newXS_deffile("Gtk2::Gdk::Event::DND::context", XS_Gtk2__Gdk__Event__DND_context);
#if XSubPPtmpAAAC
        newXS_deffile("Gtk2::Gdk::Event::OwnerChange::owner", XS_Gtk2__Gdk__Event__OwnerChange_owner);
        newXS_deffile("Gtk2::Gdk::Event::OwnerChange::reason", XS_Gtk2__Gdk__Event__OwnerChange_reason);
        newXS_deffile("Gtk2::Gdk::Event::OwnerChange::selection", XS_Gtk2__Gdk__Event__OwnerChange_selection);
        newXS_deffile("Gtk2::Gdk::Event::OwnerChange::selection_time", XS_Gtk2__Gdk__Event__OwnerChange_selection_time);
#endif
#if XSubPPtmpAAAD
        newXS_deffile("Gtk2::Gdk::Event::GrabBroken::keyboard", XS_Gtk2__Gdk__Event__GrabBroken_keyboard);
        newXS_deffile("Gtk2::Gdk::Event::GrabBroken::implicit", XS_Gtk2__Gdk__Event__GrabBroken_implicit);
        newXS_deffile("Gtk2::Gdk::Event::GrabBroken::grab_window", XS_Gtk2__Gdk__Event__GrabBroken_grab_window);
#endif
        newXS_deffile("Gtk2::Gdk::set_show_events", XS_Gtk2__Gdk_set_show_events);
        newXS_deffile("Gtk2::Gdk::get_show_events", XS_Gtk2__Gdk_get_show_events);
        newXS_deffile("Gtk2::Gdk::setting_get", XS_Gtk2__Gdk_setting_get);

    /* Initialisation Section */

#line 388 "xs/GdkEvent.xs"
	/* GdkEvent is a polymorphic structure, whose actual package
	 * depends on the type member's value.  instead of trying to make
	 * a perl developer know about this, we'll bless it into the proper
	 * subclass by overriding the default wrapper behavior.
	 *
	 * note that we expressly wish to keep the GdkEvent as an opaque
	 * type in gtk2-perl for efficiency; converting an event to a
	 * hash is an expensive operation that is usually wasted (based on
	 * experience with gtk-perl).
	 */
	default_wrapper_class = gperl_default_boxed_wrapper_class ();
	gdk_event_wrapper_class = * default_wrapper_class;
	gdk_event_wrapper_class.wrap = (GPerlBoxedWrapFunc)gdk_event_wrap;
	gdk_event_wrapper_class.unwrap = (GPerlBoxedUnwrapFunc)gdk_event_unwrap;
	gperl_register_boxed (GDK_TYPE_EVENT, "Gtk2::Gdk::Event",
	                      &gdk_event_wrapper_class);

#if XSubPPtmpAAAA
#endif
#line 782 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Expose", "Gtk2::Gdk::Event");

#line 847 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::NoExpose", "Gtk2::Gdk::Event");

#line 868 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Visibility", "Gtk2::Gdk::Event");

#line 900 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Motion", "Gtk2::Gdk::Event");

#if XSubPPtmpAAAB
#endif
#line 975 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Button", "Gtk2::Gdk::Event");

#line 1040 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Scroll", "Gtk2::Gdk::Event");

#line 1104 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Key", "Gtk2::Gdk::Event");

#line 1160 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Crossing", "Gtk2::Gdk::Event");

#line 1255 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Focus", "Gtk2::Gdk::Event");

#line 1286 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Configure", "Gtk2::Gdk::Event");

#line 1360 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Property", "Gtk2::Gdk::Event");

#line 1402 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Selection", "Gtk2::Gdk::Event");

#line 1464 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Proximity", "Gtk2::Gdk::Event");

#line 1499 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Client", "Gtk2::Gdk::Event");

#line 1635 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::Setting", "Gtk2::Gdk::Event");

#line 1684 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::WindowState", "Gtk2::Gdk::Event");

#line 1725 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::DND", "Gtk2::Gdk::Event");

#if XSubPPtmpAAAC
#line 1772 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::OwnerChange", "Gtk2::Gdk::Event");

#endif
#if XSubPPtmpAAAD
#line 1852 "xs/GdkEvent.xs"
	gperl_set_isa ("Gtk2::Gdk::Event::GrabBroken", "Gtk2::Gdk::Event");

#endif
#line 3105 "xs/GdkEvent.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

