/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_OPTERON;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_OPTERON.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_OPTERON, sbdtobf16_k_OPTERON, sbf16tos_k_OPTERON, dbf16tod_k_OPTERON,

  samax_k_OPTERON,  samin_k_OPTERON,  smax_k_OPTERON,  smin_k_OPTERON,
  isamax_k_OPTERON, isamin_k_OPTERON, ismax_k_OPTERON, ismin_k_OPTERON,
  snrm2_k_OPTERON,  sasum_k_OPTERON, ssum_k_OPTERON, scopy_k_OPTERON, sbdot_k_OPTERON,
  dsdot_k_OPTERON,
  srot_k_OPTERON,   saxpy_k_OPTERON,  sscal_k_OPTERON, sswap_k_OPTERON,
  sbgemv_n_OPTERON, sbgemv_t_OPTERON, sger_k_OPTERON,
  ssymv_L_OPTERON, ssymv_U_OPTERON,

  sbgemm_kernel_OPTERON, sbgemm_beta_OPTERON,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_OPTERON, sbgemm_itcopy_OPTERON,
#else
  sbgemm_oncopy_OPTERON, sbgemm_otcopy_OPTERON,
#endif
  sbgemm_oncopy_OPTERON, sbgemm_otcopy_OPTERON,

  strsm_kernel_LN_OPTERON, strsm_kernel_LT_OPTERON, strsm_kernel_RN_OPTERON, strsm_kernel_RT_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_OPTERON, strsm_iunncopy_OPTERON, strsm_iutucopy_OPTERON, strsm_iutncopy_OPTERON,
  strsm_ilnucopy_OPTERON, strsm_ilnncopy_OPTERON, strsm_iltucopy_OPTERON, strsm_iltncopy_OPTERON,
#else
  strsm_ounucopy_OPTERON, strsm_ounncopy_OPTERON, strsm_outucopy_OPTERON, strsm_outncopy_OPTERON,
  strsm_olnucopy_OPTERON, strsm_olnncopy_OPTERON, strsm_oltucopy_OPTERON, strsm_oltncopy_OPTERON,
#endif
  strsm_ounucopy_OPTERON, strsm_ounncopy_OPTERON, strsm_outucopy_OPTERON, strsm_outncopy_OPTERON,
  strsm_olnucopy_OPTERON, strsm_olnncopy_OPTERON, strsm_oltucopy_OPTERON, strsm_oltncopy_OPTERON,
  strmm_kernel_RN_OPTERON, strmm_kernel_RT_OPTERON, strmm_kernel_LN_OPTERON, strmm_kernel_LT_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_OPTERON, strmm_iunncopy_OPTERON, strmm_iutucopy_OPTERON, strmm_iutncopy_OPTERON,
  strmm_ilnucopy_OPTERON, strmm_ilnncopy_OPTERON, strmm_iltucopy_OPTERON, strmm_iltncopy_OPTERON,
#else
  strmm_ounucopy_OPTERON, strmm_ounncopy_OPTERON, strmm_outucopy_OPTERON, strmm_outncopy_OPTERON,
  strmm_olnucopy_OPTERON, strmm_olnncopy_OPTERON, strmm_oltucopy_OPTERON, strmm_oltncopy_OPTERON,
#endif
  strmm_ounucopy_OPTERON, strmm_ounncopy_OPTERON, strmm_outucopy_OPTERON, strmm_outncopy_OPTERON,
  strmm_olnucopy_OPTERON, strmm_olnncopy_OPTERON, strmm_oltucopy_OPTERON, strmm_oltncopy_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_OPTERON, ssymm_iltcopy_OPTERON,
#else
  ssymm_outcopy_OPTERON, ssymm_oltcopy_OPTERON,
#endif
  ssymm_outcopy_OPTERON, ssymm_oltcopy_OPTERON,

#ifndef NO_LAPACK
  sneg_tcopy_OPTERON, slaswp_ncopy_OPTERON,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_OPTERON,
  sbgemm_small_kernel_nn_OPTERON, sbgemm_small_kernel_nt_OPTERON, sbgemm_small_kernel_tn_OPTERON, sbgemm_small_kernel_tt_OPTERON,
  sbgemm_small_kernel_b0_nn_OPTERON, sbgemm_small_kernel_b0_nt_OPTERON, sbgemm_small_kernel_b0_tn_OPTERON, sbgemm_small_kernel_b0_tt_OPTERON,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_OPTERON,  samin_k_OPTERON,  smax_k_OPTERON,  smin_k_OPTERON,
  isamax_k_OPTERON, isamin_k_OPTERON, ismax_k_OPTERON, ismin_k_OPTERON,
  snrm2_k_OPTERON,  sasum_k_OPTERON,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_OPTERON,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_OPTERON, sdot_k_OPTERON,
//  dsdot_k_OPTERON,
  srot_k_OPTERON,   saxpy_k_OPTERON,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_OPTERON,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_OPTERON,
  sgemv_n_OPTERON,  sgemv_t_OPTERON,
#endif
#if BUILD_SINGLE == 1  
  sger_k_OPTERON,
  ssymv_L_OPTERON, ssymv_U_OPTERON,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_OPTERON,
  sgemm_direct_performant_OPTERON,	
#endif

  sgemm_kernel_OPTERON, sgemm_beta_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_OPTERON, sgemm_itcopy_OPTERON,
#else
  sgemm_oncopy_OPTERON, sgemm_otcopy_OPTERON,
#endif
  sgemm_oncopy_OPTERON, sgemm_otcopy_OPTERON,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_OPTERON,
  sgemm_small_kernel_nn_OPTERON, sgemm_small_kernel_nt_OPTERON, sgemm_small_kernel_tn_OPTERON, sgemm_small_kernel_tt_OPTERON,
  sgemm_small_kernel_b0_nn_OPTERON, sgemm_small_kernel_b0_nt_OPTERON, sgemm_small_kernel_b0_tn_OPTERON, sgemm_small_kernel_b0_tt_OPTERON,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_OPTERON, strsm_kernel_LT_OPTERON, strsm_kernel_RN_OPTERON, strsm_kernel_RT_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_OPTERON, strsm_iunncopy_OPTERON, strsm_iutucopy_OPTERON, strsm_iutncopy_OPTERON,
  strsm_ilnucopy_OPTERON, strsm_ilnncopy_OPTERON, strsm_iltucopy_OPTERON, strsm_iltncopy_OPTERON,
#else
  strsm_ounucopy_OPTERON, strsm_ounncopy_OPTERON, strsm_outucopy_OPTERON, strsm_outncopy_OPTERON,
  strsm_olnucopy_OPTERON, strsm_olnncopy_OPTERON, strsm_oltucopy_OPTERON, strsm_oltncopy_OPTERON,
#endif
  strsm_ounucopy_OPTERON, strsm_ounncopy_OPTERON, strsm_outucopy_OPTERON, strsm_outncopy_OPTERON,
  strsm_olnucopy_OPTERON, strsm_olnncopy_OPTERON, strsm_oltucopy_OPTERON, strsm_oltncopy_OPTERON,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_OPTERON, strmm_kernel_RT_OPTERON, strmm_kernel_LN_OPTERON, strmm_kernel_LT_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_OPTERON, strmm_iunncopy_OPTERON, strmm_iutucopy_OPTERON, strmm_iutncopy_OPTERON,
  strmm_ilnucopy_OPTERON, strmm_ilnncopy_OPTERON, strmm_iltucopy_OPTERON, strmm_iltncopy_OPTERON,
#else
  strmm_ounucopy_OPTERON, strmm_ounncopy_OPTERON, strmm_outucopy_OPTERON, strmm_outncopy_OPTERON,
  strmm_olnucopy_OPTERON, strmm_olnncopy_OPTERON, strmm_oltucopy_OPTERON, strmm_oltncopy_OPTERON,
#endif
  strmm_ounucopy_OPTERON, strmm_ounncopy_OPTERON, strmm_outucopy_OPTERON, strmm_outncopy_OPTERON,
  strmm_olnucopy_OPTERON, strmm_olnncopy_OPTERON, strmm_oltucopy_OPTERON, strmm_oltncopy_OPTERON,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_OPTERON, ssymm_iltcopy_OPTERON,
#else
  ssymm_outcopy_OPTERON, ssymm_oltcopy_OPTERON,
#endif
  ssymm_outcopy_OPTERON, ssymm_oltcopy_OPTERON,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_OPTERON, slaswp_ncopy_OPTERON,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_OPTERON,  damin_k_OPTERON,  dmax_k_OPTERON,  dmin_k_OPTERON,
  idamax_k_OPTERON, idamin_k_OPTERON, idmax_k_OPTERON, idmin_k_OPTERON,
  dnrm2_k_OPTERON, dasum_k_OPTERON,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_OPTERON,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_OPTERON, ddot_k_OPTERON,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_OPTERON,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_OPTERON,
  daxpy_k_OPTERON,
  dscal_k_OPTERON, 
  dswap_k_OPTERON,
  dgemv_n_OPTERON,  dgemv_t_OPTERON,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_OPTERON,
  dsymv_L_OPTERON,  dsymv_U_OPTERON,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_OPTERON, dgemm_beta_OPTERON,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_OPTERON, dgemm_itcopy_OPTERON,
#else
  dgemm_oncopy_OPTERON, dgemm_otcopy_OPTERON,
#endif
  dgemm_oncopy_OPTERON, dgemm_otcopy_OPTERON,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_OPTERON,
  dgemm_small_kernel_nn_OPTERON, dgemm_small_kernel_nt_OPTERON, dgemm_small_kernel_tn_OPTERON, dgemm_small_kernel_tt_OPTERON,
  dgemm_small_kernel_b0_nn_OPTERON, dgemm_small_kernel_b0_nt_OPTERON, dgemm_small_kernel_b0_tn_OPTERON, dgemm_small_kernel_b0_tt_OPTERON,
#endif
  dtrsm_kernel_LN_OPTERON, dtrsm_kernel_LT_OPTERON, dtrsm_kernel_RN_OPTERON, dtrsm_kernel_RT_OPTERON,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_OPTERON, dtrsm_iunncopy_OPTERON, dtrsm_iutucopy_OPTERON, dtrsm_iutncopy_OPTERON,
  dtrsm_ilnucopy_OPTERON, dtrsm_ilnncopy_OPTERON, dtrsm_iltucopy_OPTERON, dtrsm_iltncopy_OPTERON,
#else
  dtrsm_ounucopy_OPTERON, dtrsm_ounncopy_OPTERON, dtrsm_outucopy_OPTERON, dtrsm_outncopy_OPTERON,
  dtrsm_olnucopy_OPTERON, dtrsm_olnncopy_OPTERON, dtrsm_oltucopy_OPTERON, dtrsm_oltncopy_OPTERON,
#endif
  dtrsm_ounucopy_OPTERON, dtrsm_ounncopy_OPTERON, dtrsm_outucopy_OPTERON, dtrsm_outncopy_OPTERON,
  dtrsm_olnucopy_OPTERON, dtrsm_olnncopy_OPTERON, dtrsm_oltucopy_OPTERON, dtrsm_oltncopy_OPTERON,
  dtrmm_kernel_RN_OPTERON, dtrmm_kernel_RT_OPTERON, dtrmm_kernel_LN_OPTERON, dtrmm_kernel_LT_OPTERON,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_OPTERON, dtrmm_iunncopy_OPTERON, dtrmm_iutucopy_OPTERON, dtrmm_iutncopy_OPTERON,
  dtrmm_ilnucopy_OPTERON, dtrmm_ilnncopy_OPTERON, dtrmm_iltucopy_OPTERON, dtrmm_iltncopy_OPTERON,
#else
  dtrmm_ounucopy_OPTERON, dtrmm_ounncopy_OPTERON, dtrmm_outucopy_OPTERON, dtrmm_outncopy_OPTERON,
  dtrmm_olnucopy_OPTERON, dtrmm_olnncopy_OPTERON, dtrmm_oltucopy_OPTERON, dtrmm_oltncopy_OPTERON,
#endif
  dtrmm_ounucopy_OPTERON, dtrmm_ounncopy_OPTERON, dtrmm_outucopy_OPTERON, dtrmm_outncopy_OPTERON,
  dtrmm_olnucopy_OPTERON, dtrmm_olnncopy_OPTERON, dtrmm_oltucopy_OPTERON, dtrmm_oltncopy_OPTERON,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_OPTERON, dsymm_iltcopy_OPTERON,
#else
  dsymm_outcopy_OPTERON, dsymm_oltcopy_OPTERON,
#endif
  dsymm_outcopy_OPTERON, dsymm_oltcopy_OPTERON,

#ifndef NO_LAPACK
  dneg_tcopy_OPTERON, dlaswp_ncopy_OPTERON,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_OPTERON,  qamin_k_OPTERON,  qmax_k_OPTERON,  qmin_k_OPTERON,
  iqamax_k_OPTERON, iqamin_k_OPTERON, iqmax_k_OPTERON, iqmin_k_OPTERON,
  qnrm2_k_OPTERON,  qasum_k_OPTERON,  qsum_k_OPTERON, qcopy_k_OPTERON, qdot_k_OPTERON,
  qrot_k_OPTERON,   qaxpy_k_OPTERON,  qscal_k_OPTERON, qswap_k_OPTERON,
  qgemv_n_OPTERON,  qgemv_t_OPTERON,  qger_k_OPTERON,
  qsymv_L_OPTERON,  qsymv_U_OPTERON,

  qgemm_kernel_OPTERON, qgemm_beta_OPTERON,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_OPTERON, qgemm_itcopy_OPTERON,
#else
  qgemm_oncopy_OPTERON, qgemm_otcopy_OPTERON,
#endif
  qgemm_oncopy_OPTERON, qgemm_otcopy_OPTERON,
  qtrsm_kernel_LN_OPTERON, qtrsm_kernel_LT_OPTERON, qtrsm_kernel_RN_OPTERON, qtrsm_kernel_RT_OPTERON,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_OPTERON, qtrsm_iunncopy_OPTERON, qtrsm_iutucopy_OPTERON, qtrsm_iutncopy_OPTERON,
  qtrsm_ilnucopy_OPTERON, qtrsm_ilnncopy_OPTERON, qtrsm_iltucopy_OPTERON, qtrsm_iltncopy_OPTERON,
#else
  qtrsm_ounucopy_OPTERON, qtrsm_ounncopy_OPTERON, qtrsm_outucopy_OPTERON, qtrsm_outncopy_OPTERON,
  qtrsm_olnucopy_OPTERON, qtrsm_olnncopy_OPTERON, qtrsm_oltucopy_OPTERON, qtrsm_oltncopy_OPTERON,
#endif
  qtrsm_ounucopy_OPTERON, qtrsm_ounncopy_OPTERON, qtrsm_outucopy_OPTERON, qtrsm_outncopy_OPTERON,
  qtrsm_olnucopy_OPTERON, qtrsm_olnncopy_OPTERON, qtrsm_oltucopy_OPTERON, qtrsm_oltncopy_OPTERON,
  qtrmm_kernel_RN_OPTERON, qtrmm_kernel_RT_OPTERON, qtrmm_kernel_LN_OPTERON, qtrmm_kernel_LT_OPTERON,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_OPTERON, qtrmm_iunncopy_OPTERON, qtrmm_iutucopy_OPTERON, qtrmm_iutncopy_OPTERON,
  qtrmm_ilnucopy_OPTERON, qtrmm_ilnncopy_OPTERON, qtrmm_iltucopy_OPTERON, qtrmm_iltncopy_OPTERON,
#else
  qtrmm_ounucopy_OPTERON, qtrmm_ounncopy_OPTERON, qtrmm_outucopy_OPTERON, qtrmm_outncopy_OPTERON,
  qtrmm_olnucopy_OPTERON, qtrmm_olnncopy_OPTERON, qtrmm_oltucopy_OPTERON, qtrmm_oltncopy_OPTERON,
#endif
  qtrmm_ounucopy_OPTERON, qtrmm_ounncopy_OPTERON, qtrmm_outucopy_OPTERON, qtrmm_outncopy_OPTERON,
  qtrmm_olnucopy_OPTERON, qtrmm_olnncopy_OPTERON, qtrmm_oltucopy_OPTERON, qtrmm_oltncopy_OPTERON,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_OPTERON, qsymm_iltcopy_OPTERON,
#else
  qsymm_outcopy_OPTERON, qsymm_oltcopy_OPTERON,
#endif
  qsymm_outcopy_OPTERON, qsymm_oltcopy_OPTERON,

#ifndef NO_LAPACK
  qneg_tcopy_OPTERON, qlaswp_ncopy_OPTERON,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_OPTERON, camin_k_OPTERON, icamax_k_OPTERON, icamin_k_OPTERON,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_OPTERON, casum_k_OPTERON, csum_k_OPTERON,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_OPTERON,  cdotu_k_OPTERON, cdotc_k_OPTERON,
#endif
#if (BUILD_COMPLEX)
 csrot_k_OPTERON,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_OPTERON,
  caxpyc_k_OPTERON, 
  cscal_k_OPTERON, 
  cswap_k_OPTERON,

  cgemv_n_OPTERON, cgemv_t_OPTERON, cgemv_r_OPTERON, cgemv_c_OPTERON,
  cgemv_o_OPTERON, cgemv_u_OPTERON, cgemv_s_OPTERON, cgemv_d_OPTERON,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_OPTERON, cgerc_k_OPTERON, cgerv_k_OPTERON, cgerd_k_OPTERON,
  csymv_L_OPTERON, csymv_U_OPTERON,
  chemv_L_OPTERON, chemv_U_OPTERON, chemv_M_OPTERON, chemv_V_OPTERON,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_OPTERON, cgemm_kernel_l_OPTERON, cgemm_kernel_r_OPTERON, cgemm_kernel_b_OPTERON,
  cgemm_beta_OPTERON,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_OPTERON, cgemm_itcopy_OPTERON,
#else
  cgemm_oncopy_OPTERON, cgemm_otcopy_OPTERON,
#endif
  cgemm_oncopy_OPTERON, cgemm_otcopy_OPTERON,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_OPTERON,
  cgemm_small_kernel_nn_OPTERON, cgemm_small_kernel_nt_OPTERON, cgemm_small_kernel_nr_OPTERON, cgemm_small_kernel_nc_OPTERON,
  cgemm_small_kernel_tn_OPTERON, cgemm_small_kernel_tt_OPTERON, cgemm_small_kernel_tr_OPTERON, cgemm_small_kernel_tc_OPTERON,
  cgemm_small_kernel_rn_OPTERON, cgemm_small_kernel_rt_OPTERON, cgemm_small_kernel_rr_OPTERON, cgemm_small_kernel_rc_OPTERON,
  cgemm_small_kernel_cn_OPTERON, cgemm_small_kernel_ct_OPTERON, cgemm_small_kernel_cr_OPTERON, cgemm_small_kernel_cc_OPTERON,
  cgemm_small_kernel_b0_nn_OPTERON, cgemm_small_kernel_b0_nt_OPTERON, cgemm_small_kernel_b0_nr_OPTERON, cgemm_small_kernel_b0_nc_OPTERON,
  cgemm_small_kernel_b0_tn_OPTERON, cgemm_small_kernel_b0_tt_OPTERON, cgemm_small_kernel_b0_tr_OPTERON, cgemm_small_kernel_b0_tc_OPTERON,
  cgemm_small_kernel_b0_rn_OPTERON, cgemm_small_kernel_b0_rt_OPTERON, cgemm_small_kernel_b0_rr_OPTERON, cgemm_small_kernel_b0_rc_OPTERON,
  cgemm_small_kernel_b0_cn_OPTERON, cgemm_small_kernel_b0_ct_OPTERON, cgemm_small_kernel_b0_cr_OPTERON, cgemm_small_kernel_b0_cc_OPTERON,
#endif

  ctrsm_kernel_LN_OPTERON, ctrsm_kernel_LT_OPTERON, ctrsm_kernel_LR_OPTERON, ctrsm_kernel_LC_OPTERON,
  ctrsm_kernel_RN_OPTERON, ctrsm_kernel_RT_OPTERON, ctrsm_kernel_RR_OPTERON, ctrsm_kernel_RC_OPTERON,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_OPTERON,  ctrsm_iunncopy_OPTERON,  ctrsm_iutucopy_OPTERON,  ctrsm_iutncopy_OPTERON,
  ctrsm_ilnucopy_OPTERON,  ctrsm_ilnncopy_OPTERON,  ctrsm_iltucopy_OPTERON,  ctrsm_iltncopy_OPTERON,
#else
  ctrsm_ounucopy_OPTERON,  ctrsm_ounncopy_OPTERON,  ctrsm_outucopy_OPTERON,  ctrsm_outncopy_OPTERON,
  ctrsm_olnucopy_OPTERON,  ctrsm_olnncopy_OPTERON,  ctrsm_oltucopy_OPTERON,  ctrsm_oltncopy_OPTERON,
#endif
  ctrsm_ounucopy_OPTERON,  ctrsm_ounncopy_OPTERON,  ctrsm_outucopy_OPTERON,  ctrsm_outncopy_OPTERON,
  ctrsm_olnucopy_OPTERON,  ctrsm_olnncopy_OPTERON,  ctrsm_oltucopy_OPTERON,  ctrsm_oltncopy_OPTERON,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_OPTERON,  ctrmm_kernel_RT_OPTERON,  ctrmm_kernel_RR_OPTERON,  ctrmm_kernel_RC_OPTERON,
  ctrmm_kernel_LN_OPTERON,  ctrmm_kernel_LT_OPTERON,  ctrmm_kernel_LR_OPTERON,  ctrmm_kernel_LC_OPTERON,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_OPTERON,  ctrmm_iunncopy_OPTERON,  ctrmm_iutucopy_OPTERON,  ctrmm_iutncopy_OPTERON,
  ctrmm_ilnucopy_OPTERON,  ctrmm_ilnncopy_OPTERON,  ctrmm_iltucopy_OPTERON,  ctrmm_iltncopy_OPTERON,
#else
  ctrmm_ounucopy_OPTERON,  ctrmm_ounncopy_OPTERON,  ctrmm_outucopy_OPTERON,  ctrmm_outncopy_OPTERON,
  ctrmm_olnucopy_OPTERON,  ctrmm_olnncopy_OPTERON,  ctrmm_oltucopy_OPTERON,  ctrmm_oltncopy_OPTERON,
#endif
  ctrmm_ounucopy_OPTERON,  ctrmm_ounncopy_OPTERON,  ctrmm_outucopy_OPTERON,  ctrmm_outncopy_OPTERON,
  ctrmm_olnucopy_OPTERON,  ctrmm_olnncopy_OPTERON,  ctrmm_oltucopy_OPTERON,  ctrmm_oltncopy_OPTERON,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_OPTERON,  csymm_iltcopy_OPTERON,
#else
  csymm_outcopy_OPTERON,  csymm_oltcopy_OPTERON,
#endif
  csymm_outcopy_OPTERON,  csymm_oltcopy_OPTERON,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_OPTERON,  chemm_iltcopy_OPTERON,
#else
  chemm_outcopy_OPTERON,  chemm_oltcopy_OPTERON,
#endif
  chemm_outcopy_OPTERON,  chemm_oltcopy_OPTERON,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_OPTERON,

  cgemm3m_incopyb_OPTERON,  cgemm3m_incopyr_OPTERON,
  cgemm3m_incopyi_OPTERON,  cgemm3m_itcopyb_OPTERON,
  cgemm3m_itcopyr_OPTERON,  cgemm3m_itcopyi_OPTERON,
  cgemm3m_oncopyb_OPTERON,  cgemm3m_oncopyr_OPTERON,
  cgemm3m_oncopyi_OPTERON,  cgemm3m_otcopyb_OPTERON,
  cgemm3m_otcopyr_OPTERON,  cgemm3m_otcopyi_OPTERON,

  csymm3m_iucopyb_OPTERON,  csymm3m_ilcopyb_OPTERON,
  csymm3m_iucopyr_OPTERON,  csymm3m_ilcopyr_OPTERON,
  csymm3m_iucopyi_OPTERON,  csymm3m_ilcopyi_OPTERON,
  csymm3m_oucopyb_OPTERON,  csymm3m_olcopyb_OPTERON,
  csymm3m_oucopyr_OPTERON,  csymm3m_olcopyr_OPTERON,
  csymm3m_oucopyi_OPTERON,  csymm3m_olcopyi_OPTERON,

  chemm3m_iucopyb_OPTERON,  chemm3m_ilcopyb_OPTERON,
  chemm3m_iucopyr_OPTERON,  chemm3m_ilcopyr_OPTERON,
  chemm3m_iucopyi_OPTERON,  chemm3m_ilcopyi_OPTERON,

  chemm3m_oucopyb_OPTERON,  chemm3m_olcopyb_OPTERON,
  chemm3m_oucopyr_OPTERON,  chemm3m_olcopyr_OPTERON,
  chemm3m_oucopyi_OPTERON,  chemm3m_olcopyi_OPTERON,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_OPTERON,
  
   claswp_ncopy_OPTERON,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_OPTERON, zamin_k_OPTERON, izamax_k_OPTERON, izamin_k_OPTERON,
  znrm2_k_OPTERON, zasum_k_OPTERON, zsum_k_OPTERON, zcopy_k_OPTERON,
  zdotu_k_OPTERON, zdotc_k_OPTERON, zdrot_k_OPTERON,
  zaxpy_k_OPTERON, zaxpyc_k_OPTERON, zscal_k_OPTERON, zswap_k_OPTERON,

  zgemv_n_OPTERON, zgemv_t_OPTERON, zgemv_r_OPTERON, zgemv_c_OPTERON,
  zgemv_o_OPTERON, zgemv_u_OPTERON, zgemv_s_OPTERON, zgemv_d_OPTERON,
  zgeru_k_OPTERON, zgerc_k_OPTERON, zgerv_k_OPTERON, zgerd_k_OPTERON,
  zsymv_L_OPTERON, zsymv_U_OPTERON,
  zhemv_L_OPTERON, zhemv_U_OPTERON, zhemv_M_OPTERON, zhemv_V_OPTERON,

  zgemm_kernel_n_OPTERON, zgemm_kernel_l_OPTERON, zgemm_kernel_r_OPTERON, zgemm_kernel_b_OPTERON,
  zgemm_beta_OPTERON,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_OPTERON, zgemm_itcopy_OPTERON,
#else
  zgemm_oncopy_OPTERON, zgemm_otcopy_OPTERON,
#endif
  zgemm_oncopy_OPTERON, zgemm_otcopy_OPTERON,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_OPTERON,
  zgemm_small_kernel_nn_OPTERON, zgemm_small_kernel_nt_OPTERON, zgemm_small_kernel_nr_OPTERON, zgemm_small_kernel_nc_OPTERON,
  zgemm_small_kernel_tn_OPTERON, zgemm_small_kernel_tt_OPTERON, zgemm_small_kernel_tr_OPTERON, zgemm_small_kernel_tc_OPTERON,
  zgemm_small_kernel_rn_OPTERON, zgemm_small_kernel_rt_OPTERON, zgemm_small_kernel_rr_OPTERON, zgemm_small_kernel_rc_OPTERON,
  zgemm_small_kernel_cn_OPTERON, zgemm_small_kernel_ct_OPTERON, zgemm_small_kernel_cr_OPTERON, zgemm_small_kernel_cc_OPTERON,
  zgemm_small_kernel_b0_nn_OPTERON, zgemm_small_kernel_b0_nt_OPTERON, zgemm_small_kernel_b0_nr_OPTERON, zgemm_small_kernel_b0_nc_OPTERON,
  zgemm_small_kernel_b0_tn_OPTERON, zgemm_small_kernel_b0_tt_OPTERON, zgemm_small_kernel_b0_tr_OPTERON, zgemm_small_kernel_b0_tc_OPTERON,
  zgemm_small_kernel_b0_rn_OPTERON, zgemm_small_kernel_b0_rt_OPTERON, zgemm_small_kernel_b0_rr_OPTERON, zgemm_small_kernel_b0_rc_OPTERON,
  zgemm_small_kernel_b0_cn_OPTERON, zgemm_small_kernel_b0_ct_OPTERON, zgemm_small_kernel_b0_cr_OPTERON, zgemm_small_kernel_b0_cc_OPTERON,
#endif

  ztrsm_kernel_LN_OPTERON, ztrsm_kernel_LT_OPTERON, ztrsm_kernel_LR_OPTERON, ztrsm_kernel_LC_OPTERON,
  ztrsm_kernel_RN_OPTERON, ztrsm_kernel_RT_OPTERON, ztrsm_kernel_RR_OPTERON, ztrsm_kernel_RC_OPTERON,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_OPTERON,  ztrsm_iunncopy_OPTERON,  ztrsm_iutucopy_OPTERON,  ztrsm_iutncopy_OPTERON,
  ztrsm_ilnucopy_OPTERON,  ztrsm_ilnncopy_OPTERON,  ztrsm_iltucopy_OPTERON,  ztrsm_iltncopy_OPTERON,
#else
  ztrsm_ounucopy_OPTERON,  ztrsm_ounncopy_OPTERON,  ztrsm_outucopy_OPTERON,  ztrsm_outncopy_OPTERON,
  ztrsm_olnucopy_OPTERON,  ztrsm_olnncopy_OPTERON,  ztrsm_oltucopy_OPTERON,  ztrsm_oltncopy_OPTERON,
#endif
  ztrsm_ounucopy_OPTERON,  ztrsm_ounncopy_OPTERON,  ztrsm_outucopy_OPTERON,  ztrsm_outncopy_OPTERON,
  ztrsm_olnucopy_OPTERON,  ztrsm_olnncopy_OPTERON,  ztrsm_oltucopy_OPTERON,  ztrsm_oltncopy_OPTERON,

  ztrmm_kernel_RN_OPTERON,  ztrmm_kernel_RT_OPTERON,  ztrmm_kernel_RR_OPTERON,  ztrmm_kernel_RC_OPTERON,
  ztrmm_kernel_LN_OPTERON,  ztrmm_kernel_LT_OPTERON,  ztrmm_kernel_LR_OPTERON,  ztrmm_kernel_LC_OPTERON,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_OPTERON,  ztrmm_iunncopy_OPTERON,  ztrmm_iutucopy_OPTERON,  ztrmm_iutncopy_OPTERON,
  ztrmm_ilnucopy_OPTERON,  ztrmm_ilnncopy_OPTERON,  ztrmm_iltucopy_OPTERON,  ztrmm_iltncopy_OPTERON,
#else
  ztrmm_ounucopy_OPTERON,  ztrmm_ounncopy_OPTERON,  ztrmm_outucopy_OPTERON,  ztrmm_outncopy_OPTERON,
  ztrmm_olnucopy_OPTERON,  ztrmm_olnncopy_OPTERON,  ztrmm_oltucopy_OPTERON,  ztrmm_oltncopy_OPTERON,
#endif
  ztrmm_ounucopy_OPTERON,  ztrmm_ounncopy_OPTERON,  ztrmm_outucopy_OPTERON,  ztrmm_outncopy_OPTERON,
  ztrmm_olnucopy_OPTERON,  ztrmm_olnncopy_OPTERON,  ztrmm_oltucopy_OPTERON,  ztrmm_oltncopy_OPTERON,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_OPTERON,  zsymm_iltcopy_OPTERON,
#else
  zsymm_outcopy_OPTERON,  zsymm_oltcopy_OPTERON,
#endif
  zsymm_outcopy_OPTERON,  zsymm_oltcopy_OPTERON,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_OPTERON,  zhemm_iltcopy_OPTERON,
#else
  zhemm_outcopy_OPTERON,  zhemm_oltcopy_OPTERON,
#endif
  zhemm_outcopy_OPTERON,  zhemm_oltcopy_OPTERON,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_OPTERON,

  zgemm3m_incopyb_OPTERON,  zgemm3m_incopyr_OPTERON,
  zgemm3m_incopyi_OPTERON,  zgemm3m_itcopyb_OPTERON,
  zgemm3m_itcopyr_OPTERON,  zgemm3m_itcopyi_OPTERON,
  zgemm3m_oncopyb_OPTERON,  zgemm3m_oncopyr_OPTERON,
  zgemm3m_oncopyi_OPTERON,  zgemm3m_otcopyb_OPTERON,
  zgemm3m_otcopyr_OPTERON,  zgemm3m_otcopyi_OPTERON,

  zsymm3m_iucopyb_OPTERON,  zsymm3m_ilcopyb_OPTERON,
  zsymm3m_iucopyr_OPTERON,  zsymm3m_ilcopyr_OPTERON,
  zsymm3m_iucopyi_OPTERON,  zsymm3m_ilcopyi_OPTERON,
  zsymm3m_oucopyb_OPTERON,  zsymm3m_olcopyb_OPTERON,
  zsymm3m_oucopyr_OPTERON,  zsymm3m_olcopyr_OPTERON,
  zsymm3m_oucopyi_OPTERON,  zsymm3m_olcopyi_OPTERON,

  zhemm3m_iucopyb_OPTERON,  zhemm3m_ilcopyb_OPTERON,
  zhemm3m_iucopyr_OPTERON,  zhemm3m_ilcopyr_OPTERON,
  zhemm3m_iucopyi_OPTERON,  zhemm3m_ilcopyi_OPTERON,

  zhemm3m_oucopyb_OPTERON,  zhemm3m_olcopyb_OPTERON,
  zhemm3m_oucopyr_OPTERON,  zhemm3m_olcopyr_OPTERON,
  zhemm3m_oucopyi_OPTERON,  zhemm3m_olcopyi_OPTERON,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_OPTERON, zlaswp_ncopy_OPTERON,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_OPTERON, xamin_k_OPTERON, ixamax_k_OPTERON, ixamin_k_OPTERON,
  xnrm2_k_OPTERON, xasum_k_OPTERON, xsum_k_OPTERON, xcopy_k_OPTERON,
  xdotu_k_OPTERON, xdotc_k_OPTERON, xqrot_k_OPTERON,
  xaxpy_k_OPTERON, xaxpyc_k_OPTERON, xscal_k_OPTERON, xswap_k_OPTERON,

  xgemv_n_OPTERON, xgemv_t_OPTERON, xgemv_r_OPTERON, xgemv_c_OPTERON,
  xgemv_o_OPTERON, xgemv_u_OPTERON, xgemv_s_OPTERON, xgemv_d_OPTERON,
  xgeru_k_OPTERON, xgerc_k_OPTERON, xgerv_k_OPTERON, xgerd_k_OPTERON,
  xsymv_L_OPTERON, xsymv_U_OPTERON,
  xhemv_L_OPTERON, xhemv_U_OPTERON, xhemv_M_OPTERON, xhemv_V_OPTERON,

  xgemm_kernel_n_OPTERON, xgemm_kernel_l_OPTERON, xgemm_kernel_r_OPTERON, xgemm_kernel_b_OPTERON,
  xgemm_beta_OPTERON,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_OPTERON, xgemm_itcopy_OPTERON,
#else
  xgemm_oncopy_OPTERON, xgemm_otcopy_OPTERON,
#endif
  xgemm_oncopy_OPTERON, xgemm_otcopy_OPTERON,

  xtrsm_kernel_LN_OPTERON, xtrsm_kernel_LT_OPTERON, xtrsm_kernel_LR_OPTERON, xtrsm_kernel_LC_OPTERON,
  xtrsm_kernel_RN_OPTERON, xtrsm_kernel_RT_OPTERON, xtrsm_kernel_RR_OPTERON, xtrsm_kernel_RC_OPTERON,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_OPTERON,  xtrsm_iunncopy_OPTERON,  xtrsm_iutucopy_OPTERON,  xtrsm_iutncopy_OPTERON,
  xtrsm_ilnucopy_OPTERON,  xtrsm_ilnncopy_OPTERON,  xtrsm_iltucopy_OPTERON,  xtrsm_iltncopy_OPTERON,
#else
  xtrsm_ounucopy_OPTERON,  xtrsm_ounncopy_OPTERON,  xtrsm_outucopy_OPTERON,  xtrsm_outncopy_OPTERON,
  xtrsm_olnucopy_OPTERON,  xtrsm_olnncopy_OPTERON,  xtrsm_oltucopy_OPTERON,  xtrsm_oltncopy_OPTERON,
#endif
  xtrsm_ounucopy_OPTERON,  xtrsm_ounncopy_OPTERON,  xtrsm_outucopy_OPTERON,  xtrsm_outncopy_OPTERON,
  xtrsm_olnucopy_OPTERON,  xtrsm_olnncopy_OPTERON,  xtrsm_oltucopy_OPTERON,  xtrsm_oltncopy_OPTERON,

  xtrmm_kernel_RN_OPTERON,  xtrmm_kernel_RT_OPTERON,  xtrmm_kernel_RR_OPTERON,  xtrmm_kernel_RC_OPTERON,
  xtrmm_kernel_LN_OPTERON,  xtrmm_kernel_LT_OPTERON,  xtrmm_kernel_LR_OPTERON,  xtrmm_kernel_LC_OPTERON,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_OPTERON,  xtrmm_iunncopy_OPTERON,  xtrmm_iutucopy_OPTERON,  xtrmm_iutncopy_OPTERON,
  xtrmm_ilnucopy_OPTERON,  xtrmm_ilnncopy_OPTERON,  xtrmm_iltucopy_OPTERON,  xtrmm_iltncopy_OPTERON,
#else
  xtrmm_ounucopy_OPTERON,  xtrmm_ounncopy_OPTERON,  xtrmm_outucopy_OPTERON,  xtrmm_outncopy_OPTERON,
  xtrmm_olnucopy_OPTERON,  xtrmm_olnncopy_OPTERON,  xtrmm_oltucopy_OPTERON,  xtrmm_oltncopy_OPTERON,
#endif
  xtrmm_ounucopy_OPTERON,  xtrmm_ounncopy_OPTERON,  xtrmm_outucopy_OPTERON,  xtrmm_outncopy_OPTERON,
  xtrmm_olnucopy_OPTERON,  xtrmm_olnncopy_OPTERON,  xtrmm_oltucopy_OPTERON,  xtrmm_oltncopy_OPTERON,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_OPTERON,  xsymm_iltcopy_OPTERON,
#else
  xsymm_outcopy_OPTERON,  xsymm_oltcopy_OPTERON,
#endif
  xsymm_outcopy_OPTERON,  xsymm_oltcopy_OPTERON,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_OPTERON,  xhemm_iltcopy_OPTERON,
#else
  xhemm_outcopy_OPTERON,  xhemm_oltcopy_OPTERON,
#endif
  xhemm_outcopy_OPTERON,  xhemm_oltcopy_OPTERON,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_OPTERON,

  xgemm3m_incopyb_OPTERON,  xgemm3m_incopyr_OPTERON,
  xgemm3m_incopyi_OPTERON,  xgemm3m_itcopyb_OPTERON,
  xgemm3m_itcopyr_OPTERON,  xgemm3m_itcopyi_OPTERON,
  xgemm3m_oncopyb_OPTERON,  xgemm3m_oncopyr_OPTERON,
  xgemm3m_oncopyi_OPTERON,  xgemm3m_otcopyb_OPTERON,
  xgemm3m_otcopyr_OPTERON,  xgemm3m_otcopyi_OPTERON,

  xsymm3m_iucopyb_OPTERON,  xsymm3m_ilcopyb_OPTERON,
  xsymm3m_iucopyr_OPTERON,  xsymm3m_ilcopyr_OPTERON,
  xsymm3m_iucopyi_OPTERON,  xsymm3m_ilcopyi_OPTERON,
  xsymm3m_oucopyb_OPTERON,  xsymm3m_olcopyb_OPTERON,
  xsymm3m_oucopyr_OPTERON,  xsymm3m_olcopyr_OPTERON,
  xsymm3m_oucopyi_OPTERON,  xsymm3m_olcopyi_OPTERON,

  xhemm3m_iucopyb_OPTERON,  xhemm3m_ilcopyb_OPTERON,
  xhemm3m_iucopyr_OPTERON,  xhemm3m_ilcopyr_OPTERON,
  xhemm3m_iucopyi_OPTERON,  xhemm3m_ilcopyi_OPTERON,

  xhemm3m_oucopyb_OPTERON,  xhemm3m_olcopyb_OPTERON,
  xhemm3m_oucopyr_OPTERON,  xhemm3m_olcopyr_OPTERON,
  xhemm3m_oucopyi_OPTERON,  xhemm3m_olcopyi_OPTERON,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_OPTERON, xlaswp_ncopy_OPTERON,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_OPTERON,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_OPTERON,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_OPTERON,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_OPTERON,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_OPTERON, somatcopy_k_ct_OPTERON, somatcopy_k_rn_OPTERON, somatcopy_k_rt_OPTERON,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_OPTERON, domatcopy_k_ct_OPTERON, domatcopy_k_rn_OPTERON, domatcopy_k_rt_OPTERON,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_OPTERON, comatcopy_k_ct_OPTERON, comatcopy_k_rn_OPTERON, comatcopy_k_rt_OPTERON,
  comatcopy_k_cnc_OPTERON, comatcopy_k_ctc_OPTERON, comatcopy_k_rnc_OPTERON, comatcopy_k_rtc_OPTERON,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_OPTERON, zomatcopy_k_ct_OPTERON, zomatcopy_k_rn_OPTERON, zomatcopy_k_rt_OPTERON,
  zomatcopy_k_cnc_OPTERON, zomatcopy_k_ctc_OPTERON, zomatcopy_k_rnc_OPTERON, zomatcopy_k_rtc_OPTERON,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_OPTERON, simatcopy_k_ct_OPTERON, simatcopy_k_rn_OPTERON, simatcopy_k_rt_OPTERON,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_OPTERON, dimatcopy_k_ct_OPTERON, dimatcopy_k_rn_OPTERON, dimatcopy_k_rt_OPTERON,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_OPTERON, cimatcopy_k_ct_OPTERON, cimatcopy_k_rn_OPTERON, cimatcopy_k_rt_OPTERON,
  cimatcopy_k_cnc_OPTERON, cimatcopy_k_ctc_OPTERON, cimatcopy_k_rnc_OPTERON, cimatcopy_k_rtc_OPTERON,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_OPTERON, zimatcopy_k_ct_OPTERON, zimatcopy_k_rn_OPTERON, zimatcopy_k_rt_OPTERON,
  zimatcopy_k_cnc_OPTERON, zimatcopy_k_ctc_OPTERON, zimatcopy_k_rnc_OPTERON, zimatcopy_k_rtc_OPTERON,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_OPTERON,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_OPTERON,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_OPTERON,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_OPTERON
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
