/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_COPPERMINE;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_COPPERMINE.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_COPPERMINE, sbdtobf16_k_COPPERMINE, sbf16tos_k_COPPERMINE, dbf16tod_k_COPPERMINE,

  samax_k_COPPERMINE,  samin_k_COPPERMINE,  smax_k_COPPERMINE,  smin_k_COPPERMINE,
  isamax_k_COPPERMINE, isamin_k_COPPERMINE, ismax_k_COPPERMINE, ismin_k_COPPERMINE,
  snrm2_k_COPPERMINE,  sasum_k_COPPERMINE, ssum_k_COPPERMINE, scopy_k_COPPERMINE, sbdot_k_COPPERMINE,
  dsdot_k_COPPERMINE,
  srot_k_COPPERMINE,   saxpy_k_COPPERMINE,  sscal_k_COPPERMINE, sswap_k_COPPERMINE,
  sbgemv_n_COPPERMINE, sbgemv_t_COPPERMINE, sger_k_COPPERMINE,
  ssymv_L_COPPERMINE, ssymv_U_COPPERMINE,

  sbgemm_kernel_COPPERMINE, sbgemm_beta_COPPERMINE,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_COPPERMINE, sbgemm_itcopy_COPPERMINE,
#else
  sbgemm_oncopy_COPPERMINE, sbgemm_otcopy_COPPERMINE,
#endif
  sbgemm_oncopy_COPPERMINE, sbgemm_otcopy_COPPERMINE,

  strsm_kernel_LN_COPPERMINE, strsm_kernel_LT_COPPERMINE, strsm_kernel_RN_COPPERMINE, strsm_kernel_RT_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_COPPERMINE, strsm_iunncopy_COPPERMINE, strsm_iutucopy_COPPERMINE, strsm_iutncopy_COPPERMINE,
  strsm_ilnucopy_COPPERMINE, strsm_ilnncopy_COPPERMINE, strsm_iltucopy_COPPERMINE, strsm_iltncopy_COPPERMINE,
#else
  strsm_ounucopy_COPPERMINE, strsm_ounncopy_COPPERMINE, strsm_outucopy_COPPERMINE, strsm_outncopy_COPPERMINE,
  strsm_olnucopy_COPPERMINE, strsm_olnncopy_COPPERMINE, strsm_oltucopy_COPPERMINE, strsm_oltncopy_COPPERMINE,
#endif
  strsm_ounucopy_COPPERMINE, strsm_ounncopy_COPPERMINE, strsm_outucopy_COPPERMINE, strsm_outncopy_COPPERMINE,
  strsm_olnucopy_COPPERMINE, strsm_olnncopy_COPPERMINE, strsm_oltucopy_COPPERMINE, strsm_oltncopy_COPPERMINE,
  strmm_kernel_RN_COPPERMINE, strmm_kernel_RT_COPPERMINE, strmm_kernel_LN_COPPERMINE, strmm_kernel_LT_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_COPPERMINE, strmm_iunncopy_COPPERMINE, strmm_iutucopy_COPPERMINE, strmm_iutncopy_COPPERMINE,
  strmm_ilnucopy_COPPERMINE, strmm_ilnncopy_COPPERMINE, strmm_iltucopy_COPPERMINE, strmm_iltncopy_COPPERMINE,
#else
  strmm_ounucopy_COPPERMINE, strmm_ounncopy_COPPERMINE, strmm_outucopy_COPPERMINE, strmm_outncopy_COPPERMINE,
  strmm_olnucopy_COPPERMINE, strmm_olnncopy_COPPERMINE, strmm_oltucopy_COPPERMINE, strmm_oltncopy_COPPERMINE,
#endif
  strmm_ounucopy_COPPERMINE, strmm_ounncopy_COPPERMINE, strmm_outucopy_COPPERMINE, strmm_outncopy_COPPERMINE,
  strmm_olnucopy_COPPERMINE, strmm_olnncopy_COPPERMINE, strmm_oltucopy_COPPERMINE, strmm_oltncopy_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_COPPERMINE, ssymm_iltcopy_COPPERMINE,
#else
  ssymm_outcopy_COPPERMINE, ssymm_oltcopy_COPPERMINE,
#endif
  ssymm_outcopy_COPPERMINE, ssymm_oltcopy_COPPERMINE,

#ifndef NO_LAPACK
  sneg_tcopy_COPPERMINE, slaswp_ncopy_COPPERMINE,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_COPPERMINE,
  sbgemm_small_kernel_nn_COPPERMINE, sbgemm_small_kernel_nt_COPPERMINE, sbgemm_small_kernel_tn_COPPERMINE, sbgemm_small_kernel_tt_COPPERMINE,
  sbgemm_small_kernel_b0_nn_COPPERMINE, sbgemm_small_kernel_b0_nt_COPPERMINE, sbgemm_small_kernel_b0_tn_COPPERMINE, sbgemm_small_kernel_b0_tt_COPPERMINE,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_COPPERMINE,  samin_k_COPPERMINE,  smax_k_COPPERMINE,  smin_k_COPPERMINE,
  isamax_k_COPPERMINE, isamin_k_COPPERMINE, ismax_k_COPPERMINE, ismin_k_COPPERMINE,
  snrm2_k_COPPERMINE,  sasum_k_COPPERMINE,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_COPPERMINE,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_COPPERMINE, sdot_k_COPPERMINE,
//  dsdot_k_COPPERMINE,
  srot_k_COPPERMINE,   saxpy_k_COPPERMINE,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_COPPERMINE,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_COPPERMINE,
  sgemv_n_COPPERMINE,  sgemv_t_COPPERMINE,
#endif
#if BUILD_SINGLE == 1  
  sger_k_COPPERMINE,
  ssymv_L_COPPERMINE, ssymv_U_COPPERMINE,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_COPPERMINE,
  sgemm_direct_performant_COPPERMINE,	
#endif

  sgemm_kernel_COPPERMINE, sgemm_beta_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_COPPERMINE, sgemm_itcopy_COPPERMINE,
#else
  sgemm_oncopy_COPPERMINE, sgemm_otcopy_COPPERMINE,
#endif
  sgemm_oncopy_COPPERMINE, sgemm_otcopy_COPPERMINE,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_COPPERMINE,
  sgemm_small_kernel_nn_COPPERMINE, sgemm_small_kernel_nt_COPPERMINE, sgemm_small_kernel_tn_COPPERMINE, sgemm_small_kernel_tt_COPPERMINE,
  sgemm_small_kernel_b0_nn_COPPERMINE, sgemm_small_kernel_b0_nt_COPPERMINE, sgemm_small_kernel_b0_tn_COPPERMINE, sgemm_small_kernel_b0_tt_COPPERMINE,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_COPPERMINE, strsm_kernel_LT_COPPERMINE, strsm_kernel_RN_COPPERMINE, strsm_kernel_RT_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_COPPERMINE, strsm_iunncopy_COPPERMINE, strsm_iutucopy_COPPERMINE, strsm_iutncopy_COPPERMINE,
  strsm_ilnucopy_COPPERMINE, strsm_ilnncopy_COPPERMINE, strsm_iltucopy_COPPERMINE, strsm_iltncopy_COPPERMINE,
#else
  strsm_ounucopy_COPPERMINE, strsm_ounncopy_COPPERMINE, strsm_outucopy_COPPERMINE, strsm_outncopy_COPPERMINE,
  strsm_olnucopy_COPPERMINE, strsm_olnncopy_COPPERMINE, strsm_oltucopy_COPPERMINE, strsm_oltncopy_COPPERMINE,
#endif
  strsm_ounucopy_COPPERMINE, strsm_ounncopy_COPPERMINE, strsm_outucopy_COPPERMINE, strsm_outncopy_COPPERMINE,
  strsm_olnucopy_COPPERMINE, strsm_olnncopy_COPPERMINE, strsm_oltucopy_COPPERMINE, strsm_oltncopy_COPPERMINE,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_COPPERMINE, strmm_kernel_RT_COPPERMINE, strmm_kernel_LN_COPPERMINE, strmm_kernel_LT_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_COPPERMINE, strmm_iunncopy_COPPERMINE, strmm_iutucopy_COPPERMINE, strmm_iutncopy_COPPERMINE,
  strmm_ilnucopy_COPPERMINE, strmm_ilnncopy_COPPERMINE, strmm_iltucopy_COPPERMINE, strmm_iltncopy_COPPERMINE,
#else
  strmm_ounucopy_COPPERMINE, strmm_ounncopy_COPPERMINE, strmm_outucopy_COPPERMINE, strmm_outncopy_COPPERMINE,
  strmm_olnucopy_COPPERMINE, strmm_olnncopy_COPPERMINE, strmm_oltucopy_COPPERMINE, strmm_oltncopy_COPPERMINE,
#endif
  strmm_ounucopy_COPPERMINE, strmm_ounncopy_COPPERMINE, strmm_outucopy_COPPERMINE, strmm_outncopy_COPPERMINE,
  strmm_olnucopy_COPPERMINE, strmm_olnncopy_COPPERMINE, strmm_oltucopy_COPPERMINE, strmm_oltncopy_COPPERMINE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_COPPERMINE, ssymm_iltcopy_COPPERMINE,
#else
  ssymm_outcopy_COPPERMINE, ssymm_oltcopy_COPPERMINE,
#endif
  ssymm_outcopy_COPPERMINE, ssymm_oltcopy_COPPERMINE,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_COPPERMINE, slaswp_ncopy_COPPERMINE,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_COPPERMINE,  damin_k_COPPERMINE,  dmax_k_COPPERMINE,  dmin_k_COPPERMINE,
  idamax_k_COPPERMINE, idamin_k_COPPERMINE, idmax_k_COPPERMINE, idmin_k_COPPERMINE,
  dnrm2_k_COPPERMINE, dasum_k_COPPERMINE,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_COPPERMINE,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_COPPERMINE, ddot_k_COPPERMINE,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_COPPERMINE,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_COPPERMINE,
  daxpy_k_COPPERMINE,
  dscal_k_COPPERMINE, 
  dswap_k_COPPERMINE,
  dgemv_n_COPPERMINE,  dgemv_t_COPPERMINE,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_COPPERMINE,
  dsymv_L_COPPERMINE,  dsymv_U_COPPERMINE,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_COPPERMINE, dgemm_beta_COPPERMINE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_COPPERMINE, dgemm_itcopy_COPPERMINE,
#else
  dgemm_oncopy_COPPERMINE, dgemm_otcopy_COPPERMINE,
#endif
  dgemm_oncopy_COPPERMINE, dgemm_otcopy_COPPERMINE,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_COPPERMINE,
  dgemm_small_kernel_nn_COPPERMINE, dgemm_small_kernel_nt_COPPERMINE, dgemm_small_kernel_tn_COPPERMINE, dgemm_small_kernel_tt_COPPERMINE,
  dgemm_small_kernel_b0_nn_COPPERMINE, dgemm_small_kernel_b0_nt_COPPERMINE, dgemm_small_kernel_b0_tn_COPPERMINE, dgemm_small_kernel_b0_tt_COPPERMINE,
#endif
  dtrsm_kernel_LN_COPPERMINE, dtrsm_kernel_LT_COPPERMINE, dtrsm_kernel_RN_COPPERMINE, dtrsm_kernel_RT_COPPERMINE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_COPPERMINE, dtrsm_iunncopy_COPPERMINE, dtrsm_iutucopy_COPPERMINE, dtrsm_iutncopy_COPPERMINE,
  dtrsm_ilnucopy_COPPERMINE, dtrsm_ilnncopy_COPPERMINE, dtrsm_iltucopy_COPPERMINE, dtrsm_iltncopy_COPPERMINE,
#else
  dtrsm_ounucopy_COPPERMINE, dtrsm_ounncopy_COPPERMINE, dtrsm_outucopy_COPPERMINE, dtrsm_outncopy_COPPERMINE,
  dtrsm_olnucopy_COPPERMINE, dtrsm_olnncopy_COPPERMINE, dtrsm_oltucopy_COPPERMINE, dtrsm_oltncopy_COPPERMINE,
#endif
  dtrsm_ounucopy_COPPERMINE, dtrsm_ounncopy_COPPERMINE, dtrsm_outucopy_COPPERMINE, dtrsm_outncopy_COPPERMINE,
  dtrsm_olnucopy_COPPERMINE, dtrsm_olnncopy_COPPERMINE, dtrsm_oltucopy_COPPERMINE, dtrsm_oltncopy_COPPERMINE,
  dtrmm_kernel_RN_COPPERMINE, dtrmm_kernel_RT_COPPERMINE, dtrmm_kernel_LN_COPPERMINE, dtrmm_kernel_LT_COPPERMINE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_COPPERMINE, dtrmm_iunncopy_COPPERMINE, dtrmm_iutucopy_COPPERMINE, dtrmm_iutncopy_COPPERMINE,
  dtrmm_ilnucopy_COPPERMINE, dtrmm_ilnncopy_COPPERMINE, dtrmm_iltucopy_COPPERMINE, dtrmm_iltncopy_COPPERMINE,
#else
  dtrmm_ounucopy_COPPERMINE, dtrmm_ounncopy_COPPERMINE, dtrmm_outucopy_COPPERMINE, dtrmm_outncopy_COPPERMINE,
  dtrmm_olnucopy_COPPERMINE, dtrmm_olnncopy_COPPERMINE, dtrmm_oltucopy_COPPERMINE, dtrmm_oltncopy_COPPERMINE,
#endif
  dtrmm_ounucopy_COPPERMINE, dtrmm_ounncopy_COPPERMINE, dtrmm_outucopy_COPPERMINE, dtrmm_outncopy_COPPERMINE,
  dtrmm_olnucopy_COPPERMINE, dtrmm_olnncopy_COPPERMINE, dtrmm_oltucopy_COPPERMINE, dtrmm_oltncopy_COPPERMINE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_COPPERMINE, dsymm_iltcopy_COPPERMINE,
#else
  dsymm_outcopy_COPPERMINE, dsymm_oltcopy_COPPERMINE,
#endif
  dsymm_outcopy_COPPERMINE, dsymm_oltcopy_COPPERMINE,

#ifndef NO_LAPACK
  dneg_tcopy_COPPERMINE, dlaswp_ncopy_COPPERMINE,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_COPPERMINE,  qamin_k_COPPERMINE,  qmax_k_COPPERMINE,  qmin_k_COPPERMINE,
  iqamax_k_COPPERMINE, iqamin_k_COPPERMINE, iqmax_k_COPPERMINE, iqmin_k_COPPERMINE,
  qnrm2_k_COPPERMINE,  qasum_k_COPPERMINE,  qsum_k_COPPERMINE, qcopy_k_COPPERMINE, qdot_k_COPPERMINE,
  qrot_k_COPPERMINE,   qaxpy_k_COPPERMINE,  qscal_k_COPPERMINE, qswap_k_COPPERMINE,
  qgemv_n_COPPERMINE,  qgemv_t_COPPERMINE,  qger_k_COPPERMINE,
  qsymv_L_COPPERMINE,  qsymv_U_COPPERMINE,

  qgemm_kernel_COPPERMINE, qgemm_beta_COPPERMINE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_COPPERMINE, qgemm_itcopy_COPPERMINE,
#else
  qgemm_oncopy_COPPERMINE, qgemm_otcopy_COPPERMINE,
#endif
  qgemm_oncopy_COPPERMINE, qgemm_otcopy_COPPERMINE,
  qtrsm_kernel_LN_COPPERMINE, qtrsm_kernel_LT_COPPERMINE, qtrsm_kernel_RN_COPPERMINE, qtrsm_kernel_RT_COPPERMINE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_COPPERMINE, qtrsm_iunncopy_COPPERMINE, qtrsm_iutucopy_COPPERMINE, qtrsm_iutncopy_COPPERMINE,
  qtrsm_ilnucopy_COPPERMINE, qtrsm_ilnncopy_COPPERMINE, qtrsm_iltucopy_COPPERMINE, qtrsm_iltncopy_COPPERMINE,
#else
  qtrsm_ounucopy_COPPERMINE, qtrsm_ounncopy_COPPERMINE, qtrsm_outucopy_COPPERMINE, qtrsm_outncopy_COPPERMINE,
  qtrsm_olnucopy_COPPERMINE, qtrsm_olnncopy_COPPERMINE, qtrsm_oltucopy_COPPERMINE, qtrsm_oltncopy_COPPERMINE,
#endif
  qtrsm_ounucopy_COPPERMINE, qtrsm_ounncopy_COPPERMINE, qtrsm_outucopy_COPPERMINE, qtrsm_outncopy_COPPERMINE,
  qtrsm_olnucopy_COPPERMINE, qtrsm_olnncopy_COPPERMINE, qtrsm_oltucopy_COPPERMINE, qtrsm_oltncopy_COPPERMINE,
  qtrmm_kernel_RN_COPPERMINE, qtrmm_kernel_RT_COPPERMINE, qtrmm_kernel_LN_COPPERMINE, qtrmm_kernel_LT_COPPERMINE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_COPPERMINE, qtrmm_iunncopy_COPPERMINE, qtrmm_iutucopy_COPPERMINE, qtrmm_iutncopy_COPPERMINE,
  qtrmm_ilnucopy_COPPERMINE, qtrmm_ilnncopy_COPPERMINE, qtrmm_iltucopy_COPPERMINE, qtrmm_iltncopy_COPPERMINE,
#else
  qtrmm_ounucopy_COPPERMINE, qtrmm_ounncopy_COPPERMINE, qtrmm_outucopy_COPPERMINE, qtrmm_outncopy_COPPERMINE,
  qtrmm_olnucopy_COPPERMINE, qtrmm_olnncopy_COPPERMINE, qtrmm_oltucopy_COPPERMINE, qtrmm_oltncopy_COPPERMINE,
#endif
  qtrmm_ounucopy_COPPERMINE, qtrmm_ounncopy_COPPERMINE, qtrmm_outucopy_COPPERMINE, qtrmm_outncopy_COPPERMINE,
  qtrmm_olnucopy_COPPERMINE, qtrmm_olnncopy_COPPERMINE, qtrmm_oltucopy_COPPERMINE, qtrmm_oltncopy_COPPERMINE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_COPPERMINE, qsymm_iltcopy_COPPERMINE,
#else
  qsymm_outcopy_COPPERMINE, qsymm_oltcopy_COPPERMINE,
#endif
  qsymm_outcopy_COPPERMINE, qsymm_oltcopy_COPPERMINE,

#ifndef NO_LAPACK
  qneg_tcopy_COPPERMINE, qlaswp_ncopy_COPPERMINE,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_COPPERMINE, camin_k_COPPERMINE, icamax_k_COPPERMINE, icamin_k_COPPERMINE,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_COPPERMINE, casum_k_COPPERMINE, csum_k_COPPERMINE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_COPPERMINE,  cdotu_k_COPPERMINE, cdotc_k_COPPERMINE,
#endif
#if (BUILD_COMPLEX)
 csrot_k_COPPERMINE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_COPPERMINE,
  caxpyc_k_COPPERMINE, 
  cscal_k_COPPERMINE, 
  cswap_k_COPPERMINE,

  cgemv_n_COPPERMINE, cgemv_t_COPPERMINE, cgemv_r_COPPERMINE, cgemv_c_COPPERMINE,
  cgemv_o_COPPERMINE, cgemv_u_COPPERMINE, cgemv_s_COPPERMINE, cgemv_d_COPPERMINE,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_COPPERMINE, cgerc_k_COPPERMINE, cgerv_k_COPPERMINE, cgerd_k_COPPERMINE,
  csymv_L_COPPERMINE, csymv_U_COPPERMINE,
  chemv_L_COPPERMINE, chemv_U_COPPERMINE, chemv_M_COPPERMINE, chemv_V_COPPERMINE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_COPPERMINE, cgemm_kernel_l_COPPERMINE, cgemm_kernel_r_COPPERMINE, cgemm_kernel_b_COPPERMINE,
  cgemm_beta_COPPERMINE,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_COPPERMINE, cgemm_itcopy_COPPERMINE,
#else
  cgemm_oncopy_COPPERMINE, cgemm_otcopy_COPPERMINE,
#endif
  cgemm_oncopy_COPPERMINE, cgemm_otcopy_COPPERMINE,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_COPPERMINE,
  cgemm_small_kernel_nn_COPPERMINE, cgemm_small_kernel_nt_COPPERMINE, cgemm_small_kernel_nr_COPPERMINE, cgemm_small_kernel_nc_COPPERMINE,
  cgemm_small_kernel_tn_COPPERMINE, cgemm_small_kernel_tt_COPPERMINE, cgemm_small_kernel_tr_COPPERMINE, cgemm_small_kernel_tc_COPPERMINE,
  cgemm_small_kernel_rn_COPPERMINE, cgemm_small_kernel_rt_COPPERMINE, cgemm_small_kernel_rr_COPPERMINE, cgemm_small_kernel_rc_COPPERMINE,
  cgemm_small_kernel_cn_COPPERMINE, cgemm_small_kernel_ct_COPPERMINE, cgemm_small_kernel_cr_COPPERMINE, cgemm_small_kernel_cc_COPPERMINE,
  cgemm_small_kernel_b0_nn_COPPERMINE, cgemm_small_kernel_b0_nt_COPPERMINE, cgemm_small_kernel_b0_nr_COPPERMINE, cgemm_small_kernel_b0_nc_COPPERMINE,
  cgemm_small_kernel_b0_tn_COPPERMINE, cgemm_small_kernel_b0_tt_COPPERMINE, cgemm_small_kernel_b0_tr_COPPERMINE, cgemm_small_kernel_b0_tc_COPPERMINE,
  cgemm_small_kernel_b0_rn_COPPERMINE, cgemm_small_kernel_b0_rt_COPPERMINE, cgemm_small_kernel_b0_rr_COPPERMINE, cgemm_small_kernel_b0_rc_COPPERMINE,
  cgemm_small_kernel_b0_cn_COPPERMINE, cgemm_small_kernel_b0_ct_COPPERMINE, cgemm_small_kernel_b0_cr_COPPERMINE, cgemm_small_kernel_b0_cc_COPPERMINE,
#endif

  ctrsm_kernel_LN_COPPERMINE, ctrsm_kernel_LT_COPPERMINE, ctrsm_kernel_LR_COPPERMINE, ctrsm_kernel_LC_COPPERMINE,
  ctrsm_kernel_RN_COPPERMINE, ctrsm_kernel_RT_COPPERMINE, ctrsm_kernel_RR_COPPERMINE, ctrsm_kernel_RC_COPPERMINE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_COPPERMINE,  ctrsm_iunncopy_COPPERMINE,  ctrsm_iutucopy_COPPERMINE,  ctrsm_iutncopy_COPPERMINE,
  ctrsm_ilnucopy_COPPERMINE,  ctrsm_ilnncopy_COPPERMINE,  ctrsm_iltucopy_COPPERMINE,  ctrsm_iltncopy_COPPERMINE,
#else
  ctrsm_ounucopy_COPPERMINE,  ctrsm_ounncopy_COPPERMINE,  ctrsm_outucopy_COPPERMINE,  ctrsm_outncopy_COPPERMINE,
  ctrsm_olnucopy_COPPERMINE,  ctrsm_olnncopy_COPPERMINE,  ctrsm_oltucopy_COPPERMINE,  ctrsm_oltncopy_COPPERMINE,
#endif
  ctrsm_ounucopy_COPPERMINE,  ctrsm_ounncopy_COPPERMINE,  ctrsm_outucopy_COPPERMINE,  ctrsm_outncopy_COPPERMINE,
  ctrsm_olnucopy_COPPERMINE,  ctrsm_olnncopy_COPPERMINE,  ctrsm_oltucopy_COPPERMINE,  ctrsm_oltncopy_COPPERMINE,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_COPPERMINE,  ctrmm_kernel_RT_COPPERMINE,  ctrmm_kernel_RR_COPPERMINE,  ctrmm_kernel_RC_COPPERMINE,
  ctrmm_kernel_LN_COPPERMINE,  ctrmm_kernel_LT_COPPERMINE,  ctrmm_kernel_LR_COPPERMINE,  ctrmm_kernel_LC_COPPERMINE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_COPPERMINE,  ctrmm_iunncopy_COPPERMINE,  ctrmm_iutucopy_COPPERMINE,  ctrmm_iutncopy_COPPERMINE,
  ctrmm_ilnucopy_COPPERMINE,  ctrmm_ilnncopy_COPPERMINE,  ctrmm_iltucopy_COPPERMINE,  ctrmm_iltncopy_COPPERMINE,
#else
  ctrmm_ounucopy_COPPERMINE,  ctrmm_ounncopy_COPPERMINE,  ctrmm_outucopy_COPPERMINE,  ctrmm_outncopy_COPPERMINE,
  ctrmm_olnucopy_COPPERMINE,  ctrmm_olnncopy_COPPERMINE,  ctrmm_oltucopy_COPPERMINE,  ctrmm_oltncopy_COPPERMINE,
#endif
  ctrmm_ounucopy_COPPERMINE,  ctrmm_ounncopy_COPPERMINE,  ctrmm_outucopy_COPPERMINE,  ctrmm_outncopy_COPPERMINE,
  ctrmm_olnucopy_COPPERMINE,  ctrmm_olnncopy_COPPERMINE,  ctrmm_oltucopy_COPPERMINE,  ctrmm_oltncopy_COPPERMINE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_COPPERMINE,  csymm_iltcopy_COPPERMINE,
#else
  csymm_outcopy_COPPERMINE,  csymm_oltcopy_COPPERMINE,
#endif
  csymm_outcopy_COPPERMINE,  csymm_oltcopy_COPPERMINE,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_COPPERMINE,  chemm_iltcopy_COPPERMINE,
#else
  chemm_outcopy_COPPERMINE,  chemm_oltcopy_COPPERMINE,
#endif
  chemm_outcopy_COPPERMINE,  chemm_oltcopy_COPPERMINE,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_COPPERMINE,

  cgemm3m_incopyb_COPPERMINE,  cgemm3m_incopyr_COPPERMINE,
  cgemm3m_incopyi_COPPERMINE,  cgemm3m_itcopyb_COPPERMINE,
  cgemm3m_itcopyr_COPPERMINE,  cgemm3m_itcopyi_COPPERMINE,
  cgemm3m_oncopyb_COPPERMINE,  cgemm3m_oncopyr_COPPERMINE,
  cgemm3m_oncopyi_COPPERMINE,  cgemm3m_otcopyb_COPPERMINE,
  cgemm3m_otcopyr_COPPERMINE,  cgemm3m_otcopyi_COPPERMINE,

  csymm3m_iucopyb_COPPERMINE,  csymm3m_ilcopyb_COPPERMINE,
  csymm3m_iucopyr_COPPERMINE,  csymm3m_ilcopyr_COPPERMINE,
  csymm3m_iucopyi_COPPERMINE,  csymm3m_ilcopyi_COPPERMINE,
  csymm3m_oucopyb_COPPERMINE,  csymm3m_olcopyb_COPPERMINE,
  csymm3m_oucopyr_COPPERMINE,  csymm3m_olcopyr_COPPERMINE,
  csymm3m_oucopyi_COPPERMINE,  csymm3m_olcopyi_COPPERMINE,

  chemm3m_iucopyb_COPPERMINE,  chemm3m_ilcopyb_COPPERMINE,
  chemm3m_iucopyr_COPPERMINE,  chemm3m_ilcopyr_COPPERMINE,
  chemm3m_iucopyi_COPPERMINE,  chemm3m_ilcopyi_COPPERMINE,

  chemm3m_oucopyb_COPPERMINE,  chemm3m_olcopyb_COPPERMINE,
  chemm3m_oucopyr_COPPERMINE,  chemm3m_olcopyr_COPPERMINE,
  chemm3m_oucopyi_COPPERMINE,  chemm3m_olcopyi_COPPERMINE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_COPPERMINE,
  
   claswp_ncopy_COPPERMINE,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_COPPERMINE, zamin_k_COPPERMINE, izamax_k_COPPERMINE, izamin_k_COPPERMINE,
  znrm2_k_COPPERMINE, zasum_k_COPPERMINE, zsum_k_COPPERMINE, zcopy_k_COPPERMINE,
  zdotu_k_COPPERMINE, zdotc_k_COPPERMINE, zdrot_k_COPPERMINE,
  zaxpy_k_COPPERMINE, zaxpyc_k_COPPERMINE, zscal_k_COPPERMINE, zswap_k_COPPERMINE,

  zgemv_n_COPPERMINE, zgemv_t_COPPERMINE, zgemv_r_COPPERMINE, zgemv_c_COPPERMINE,
  zgemv_o_COPPERMINE, zgemv_u_COPPERMINE, zgemv_s_COPPERMINE, zgemv_d_COPPERMINE,
  zgeru_k_COPPERMINE, zgerc_k_COPPERMINE, zgerv_k_COPPERMINE, zgerd_k_COPPERMINE,
  zsymv_L_COPPERMINE, zsymv_U_COPPERMINE,
  zhemv_L_COPPERMINE, zhemv_U_COPPERMINE, zhemv_M_COPPERMINE, zhemv_V_COPPERMINE,

  zgemm_kernel_n_COPPERMINE, zgemm_kernel_l_COPPERMINE, zgemm_kernel_r_COPPERMINE, zgemm_kernel_b_COPPERMINE,
  zgemm_beta_COPPERMINE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_COPPERMINE, zgemm_itcopy_COPPERMINE,
#else
  zgemm_oncopy_COPPERMINE, zgemm_otcopy_COPPERMINE,
#endif
  zgemm_oncopy_COPPERMINE, zgemm_otcopy_COPPERMINE,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_COPPERMINE,
  zgemm_small_kernel_nn_COPPERMINE, zgemm_small_kernel_nt_COPPERMINE, zgemm_small_kernel_nr_COPPERMINE, zgemm_small_kernel_nc_COPPERMINE,
  zgemm_small_kernel_tn_COPPERMINE, zgemm_small_kernel_tt_COPPERMINE, zgemm_small_kernel_tr_COPPERMINE, zgemm_small_kernel_tc_COPPERMINE,
  zgemm_small_kernel_rn_COPPERMINE, zgemm_small_kernel_rt_COPPERMINE, zgemm_small_kernel_rr_COPPERMINE, zgemm_small_kernel_rc_COPPERMINE,
  zgemm_small_kernel_cn_COPPERMINE, zgemm_small_kernel_ct_COPPERMINE, zgemm_small_kernel_cr_COPPERMINE, zgemm_small_kernel_cc_COPPERMINE,
  zgemm_small_kernel_b0_nn_COPPERMINE, zgemm_small_kernel_b0_nt_COPPERMINE, zgemm_small_kernel_b0_nr_COPPERMINE, zgemm_small_kernel_b0_nc_COPPERMINE,
  zgemm_small_kernel_b0_tn_COPPERMINE, zgemm_small_kernel_b0_tt_COPPERMINE, zgemm_small_kernel_b0_tr_COPPERMINE, zgemm_small_kernel_b0_tc_COPPERMINE,
  zgemm_small_kernel_b0_rn_COPPERMINE, zgemm_small_kernel_b0_rt_COPPERMINE, zgemm_small_kernel_b0_rr_COPPERMINE, zgemm_small_kernel_b0_rc_COPPERMINE,
  zgemm_small_kernel_b0_cn_COPPERMINE, zgemm_small_kernel_b0_ct_COPPERMINE, zgemm_small_kernel_b0_cr_COPPERMINE, zgemm_small_kernel_b0_cc_COPPERMINE,
#endif

  ztrsm_kernel_LN_COPPERMINE, ztrsm_kernel_LT_COPPERMINE, ztrsm_kernel_LR_COPPERMINE, ztrsm_kernel_LC_COPPERMINE,
  ztrsm_kernel_RN_COPPERMINE, ztrsm_kernel_RT_COPPERMINE, ztrsm_kernel_RR_COPPERMINE, ztrsm_kernel_RC_COPPERMINE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_COPPERMINE,  ztrsm_iunncopy_COPPERMINE,  ztrsm_iutucopy_COPPERMINE,  ztrsm_iutncopy_COPPERMINE,
  ztrsm_ilnucopy_COPPERMINE,  ztrsm_ilnncopy_COPPERMINE,  ztrsm_iltucopy_COPPERMINE,  ztrsm_iltncopy_COPPERMINE,
#else
  ztrsm_ounucopy_COPPERMINE,  ztrsm_ounncopy_COPPERMINE,  ztrsm_outucopy_COPPERMINE,  ztrsm_outncopy_COPPERMINE,
  ztrsm_olnucopy_COPPERMINE,  ztrsm_olnncopy_COPPERMINE,  ztrsm_oltucopy_COPPERMINE,  ztrsm_oltncopy_COPPERMINE,
#endif
  ztrsm_ounucopy_COPPERMINE,  ztrsm_ounncopy_COPPERMINE,  ztrsm_outucopy_COPPERMINE,  ztrsm_outncopy_COPPERMINE,
  ztrsm_olnucopy_COPPERMINE,  ztrsm_olnncopy_COPPERMINE,  ztrsm_oltucopy_COPPERMINE,  ztrsm_oltncopy_COPPERMINE,

  ztrmm_kernel_RN_COPPERMINE,  ztrmm_kernel_RT_COPPERMINE,  ztrmm_kernel_RR_COPPERMINE,  ztrmm_kernel_RC_COPPERMINE,
  ztrmm_kernel_LN_COPPERMINE,  ztrmm_kernel_LT_COPPERMINE,  ztrmm_kernel_LR_COPPERMINE,  ztrmm_kernel_LC_COPPERMINE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_COPPERMINE,  ztrmm_iunncopy_COPPERMINE,  ztrmm_iutucopy_COPPERMINE,  ztrmm_iutncopy_COPPERMINE,
  ztrmm_ilnucopy_COPPERMINE,  ztrmm_ilnncopy_COPPERMINE,  ztrmm_iltucopy_COPPERMINE,  ztrmm_iltncopy_COPPERMINE,
#else
  ztrmm_ounucopy_COPPERMINE,  ztrmm_ounncopy_COPPERMINE,  ztrmm_outucopy_COPPERMINE,  ztrmm_outncopy_COPPERMINE,
  ztrmm_olnucopy_COPPERMINE,  ztrmm_olnncopy_COPPERMINE,  ztrmm_oltucopy_COPPERMINE,  ztrmm_oltncopy_COPPERMINE,
#endif
  ztrmm_ounucopy_COPPERMINE,  ztrmm_ounncopy_COPPERMINE,  ztrmm_outucopy_COPPERMINE,  ztrmm_outncopy_COPPERMINE,
  ztrmm_olnucopy_COPPERMINE,  ztrmm_olnncopy_COPPERMINE,  ztrmm_oltucopy_COPPERMINE,  ztrmm_oltncopy_COPPERMINE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_COPPERMINE,  zsymm_iltcopy_COPPERMINE,
#else
  zsymm_outcopy_COPPERMINE,  zsymm_oltcopy_COPPERMINE,
#endif
  zsymm_outcopy_COPPERMINE,  zsymm_oltcopy_COPPERMINE,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_COPPERMINE,  zhemm_iltcopy_COPPERMINE,
#else
  zhemm_outcopy_COPPERMINE,  zhemm_oltcopy_COPPERMINE,
#endif
  zhemm_outcopy_COPPERMINE,  zhemm_oltcopy_COPPERMINE,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_COPPERMINE,

  zgemm3m_incopyb_COPPERMINE,  zgemm3m_incopyr_COPPERMINE,
  zgemm3m_incopyi_COPPERMINE,  zgemm3m_itcopyb_COPPERMINE,
  zgemm3m_itcopyr_COPPERMINE,  zgemm3m_itcopyi_COPPERMINE,
  zgemm3m_oncopyb_COPPERMINE,  zgemm3m_oncopyr_COPPERMINE,
  zgemm3m_oncopyi_COPPERMINE,  zgemm3m_otcopyb_COPPERMINE,
  zgemm3m_otcopyr_COPPERMINE,  zgemm3m_otcopyi_COPPERMINE,

  zsymm3m_iucopyb_COPPERMINE,  zsymm3m_ilcopyb_COPPERMINE,
  zsymm3m_iucopyr_COPPERMINE,  zsymm3m_ilcopyr_COPPERMINE,
  zsymm3m_iucopyi_COPPERMINE,  zsymm3m_ilcopyi_COPPERMINE,
  zsymm3m_oucopyb_COPPERMINE,  zsymm3m_olcopyb_COPPERMINE,
  zsymm3m_oucopyr_COPPERMINE,  zsymm3m_olcopyr_COPPERMINE,
  zsymm3m_oucopyi_COPPERMINE,  zsymm3m_olcopyi_COPPERMINE,

  zhemm3m_iucopyb_COPPERMINE,  zhemm3m_ilcopyb_COPPERMINE,
  zhemm3m_iucopyr_COPPERMINE,  zhemm3m_ilcopyr_COPPERMINE,
  zhemm3m_iucopyi_COPPERMINE,  zhemm3m_ilcopyi_COPPERMINE,

  zhemm3m_oucopyb_COPPERMINE,  zhemm3m_olcopyb_COPPERMINE,
  zhemm3m_oucopyr_COPPERMINE,  zhemm3m_olcopyr_COPPERMINE,
  zhemm3m_oucopyi_COPPERMINE,  zhemm3m_olcopyi_COPPERMINE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_COPPERMINE, zlaswp_ncopy_COPPERMINE,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_COPPERMINE, xamin_k_COPPERMINE, ixamax_k_COPPERMINE, ixamin_k_COPPERMINE,
  xnrm2_k_COPPERMINE, xasum_k_COPPERMINE, xsum_k_COPPERMINE, xcopy_k_COPPERMINE,
  xdotu_k_COPPERMINE, xdotc_k_COPPERMINE, xqrot_k_COPPERMINE,
  xaxpy_k_COPPERMINE, xaxpyc_k_COPPERMINE, xscal_k_COPPERMINE, xswap_k_COPPERMINE,

  xgemv_n_COPPERMINE, xgemv_t_COPPERMINE, xgemv_r_COPPERMINE, xgemv_c_COPPERMINE,
  xgemv_o_COPPERMINE, xgemv_u_COPPERMINE, xgemv_s_COPPERMINE, xgemv_d_COPPERMINE,
  xgeru_k_COPPERMINE, xgerc_k_COPPERMINE, xgerv_k_COPPERMINE, xgerd_k_COPPERMINE,
  xsymv_L_COPPERMINE, xsymv_U_COPPERMINE,
  xhemv_L_COPPERMINE, xhemv_U_COPPERMINE, xhemv_M_COPPERMINE, xhemv_V_COPPERMINE,

  xgemm_kernel_n_COPPERMINE, xgemm_kernel_l_COPPERMINE, xgemm_kernel_r_COPPERMINE, xgemm_kernel_b_COPPERMINE,
  xgemm_beta_COPPERMINE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_COPPERMINE, xgemm_itcopy_COPPERMINE,
#else
  xgemm_oncopy_COPPERMINE, xgemm_otcopy_COPPERMINE,
#endif
  xgemm_oncopy_COPPERMINE, xgemm_otcopy_COPPERMINE,

  xtrsm_kernel_LN_COPPERMINE, xtrsm_kernel_LT_COPPERMINE, xtrsm_kernel_LR_COPPERMINE, xtrsm_kernel_LC_COPPERMINE,
  xtrsm_kernel_RN_COPPERMINE, xtrsm_kernel_RT_COPPERMINE, xtrsm_kernel_RR_COPPERMINE, xtrsm_kernel_RC_COPPERMINE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_COPPERMINE,  xtrsm_iunncopy_COPPERMINE,  xtrsm_iutucopy_COPPERMINE,  xtrsm_iutncopy_COPPERMINE,
  xtrsm_ilnucopy_COPPERMINE,  xtrsm_ilnncopy_COPPERMINE,  xtrsm_iltucopy_COPPERMINE,  xtrsm_iltncopy_COPPERMINE,
#else
  xtrsm_ounucopy_COPPERMINE,  xtrsm_ounncopy_COPPERMINE,  xtrsm_outucopy_COPPERMINE,  xtrsm_outncopy_COPPERMINE,
  xtrsm_olnucopy_COPPERMINE,  xtrsm_olnncopy_COPPERMINE,  xtrsm_oltucopy_COPPERMINE,  xtrsm_oltncopy_COPPERMINE,
#endif
  xtrsm_ounucopy_COPPERMINE,  xtrsm_ounncopy_COPPERMINE,  xtrsm_outucopy_COPPERMINE,  xtrsm_outncopy_COPPERMINE,
  xtrsm_olnucopy_COPPERMINE,  xtrsm_olnncopy_COPPERMINE,  xtrsm_oltucopy_COPPERMINE,  xtrsm_oltncopy_COPPERMINE,

  xtrmm_kernel_RN_COPPERMINE,  xtrmm_kernel_RT_COPPERMINE,  xtrmm_kernel_RR_COPPERMINE,  xtrmm_kernel_RC_COPPERMINE,
  xtrmm_kernel_LN_COPPERMINE,  xtrmm_kernel_LT_COPPERMINE,  xtrmm_kernel_LR_COPPERMINE,  xtrmm_kernel_LC_COPPERMINE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_COPPERMINE,  xtrmm_iunncopy_COPPERMINE,  xtrmm_iutucopy_COPPERMINE,  xtrmm_iutncopy_COPPERMINE,
  xtrmm_ilnucopy_COPPERMINE,  xtrmm_ilnncopy_COPPERMINE,  xtrmm_iltucopy_COPPERMINE,  xtrmm_iltncopy_COPPERMINE,
#else
  xtrmm_ounucopy_COPPERMINE,  xtrmm_ounncopy_COPPERMINE,  xtrmm_outucopy_COPPERMINE,  xtrmm_outncopy_COPPERMINE,
  xtrmm_olnucopy_COPPERMINE,  xtrmm_olnncopy_COPPERMINE,  xtrmm_oltucopy_COPPERMINE,  xtrmm_oltncopy_COPPERMINE,
#endif
  xtrmm_ounucopy_COPPERMINE,  xtrmm_ounncopy_COPPERMINE,  xtrmm_outucopy_COPPERMINE,  xtrmm_outncopy_COPPERMINE,
  xtrmm_olnucopy_COPPERMINE,  xtrmm_olnncopy_COPPERMINE,  xtrmm_oltucopy_COPPERMINE,  xtrmm_oltncopy_COPPERMINE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_COPPERMINE,  xsymm_iltcopy_COPPERMINE,
#else
  xsymm_outcopy_COPPERMINE,  xsymm_oltcopy_COPPERMINE,
#endif
  xsymm_outcopy_COPPERMINE,  xsymm_oltcopy_COPPERMINE,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_COPPERMINE,  xhemm_iltcopy_COPPERMINE,
#else
  xhemm_outcopy_COPPERMINE,  xhemm_oltcopy_COPPERMINE,
#endif
  xhemm_outcopy_COPPERMINE,  xhemm_oltcopy_COPPERMINE,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_COPPERMINE,

  xgemm3m_incopyb_COPPERMINE,  xgemm3m_incopyr_COPPERMINE,
  xgemm3m_incopyi_COPPERMINE,  xgemm3m_itcopyb_COPPERMINE,
  xgemm3m_itcopyr_COPPERMINE,  xgemm3m_itcopyi_COPPERMINE,
  xgemm3m_oncopyb_COPPERMINE,  xgemm3m_oncopyr_COPPERMINE,
  xgemm3m_oncopyi_COPPERMINE,  xgemm3m_otcopyb_COPPERMINE,
  xgemm3m_otcopyr_COPPERMINE,  xgemm3m_otcopyi_COPPERMINE,

  xsymm3m_iucopyb_COPPERMINE,  xsymm3m_ilcopyb_COPPERMINE,
  xsymm3m_iucopyr_COPPERMINE,  xsymm3m_ilcopyr_COPPERMINE,
  xsymm3m_iucopyi_COPPERMINE,  xsymm3m_ilcopyi_COPPERMINE,
  xsymm3m_oucopyb_COPPERMINE,  xsymm3m_olcopyb_COPPERMINE,
  xsymm3m_oucopyr_COPPERMINE,  xsymm3m_olcopyr_COPPERMINE,
  xsymm3m_oucopyi_COPPERMINE,  xsymm3m_olcopyi_COPPERMINE,

  xhemm3m_iucopyb_COPPERMINE,  xhemm3m_ilcopyb_COPPERMINE,
  xhemm3m_iucopyr_COPPERMINE,  xhemm3m_ilcopyr_COPPERMINE,
  xhemm3m_iucopyi_COPPERMINE,  xhemm3m_ilcopyi_COPPERMINE,

  xhemm3m_oucopyb_COPPERMINE,  xhemm3m_olcopyb_COPPERMINE,
  xhemm3m_oucopyr_COPPERMINE,  xhemm3m_olcopyr_COPPERMINE,
  xhemm3m_oucopyi_COPPERMINE,  xhemm3m_olcopyi_COPPERMINE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_COPPERMINE, xlaswp_ncopy_COPPERMINE,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_COPPERMINE,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_COPPERMINE,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_COPPERMINE,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_COPPERMINE,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_COPPERMINE, somatcopy_k_ct_COPPERMINE, somatcopy_k_rn_COPPERMINE, somatcopy_k_rt_COPPERMINE,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_COPPERMINE, domatcopy_k_ct_COPPERMINE, domatcopy_k_rn_COPPERMINE, domatcopy_k_rt_COPPERMINE,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_COPPERMINE, comatcopy_k_ct_COPPERMINE, comatcopy_k_rn_COPPERMINE, comatcopy_k_rt_COPPERMINE,
  comatcopy_k_cnc_COPPERMINE, comatcopy_k_ctc_COPPERMINE, comatcopy_k_rnc_COPPERMINE, comatcopy_k_rtc_COPPERMINE,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_COPPERMINE, zomatcopy_k_ct_COPPERMINE, zomatcopy_k_rn_COPPERMINE, zomatcopy_k_rt_COPPERMINE,
  zomatcopy_k_cnc_COPPERMINE, zomatcopy_k_ctc_COPPERMINE, zomatcopy_k_rnc_COPPERMINE, zomatcopy_k_rtc_COPPERMINE,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_COPPERMINE, simatcopy_k_ct_COPPERMINE, simatcopy_k_rn_COPPERMINE, simatcopy_k_rt_COPPERMINE,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_COPPERMINE, dimatcopy_k_ct_COPPERMINE, dimatcopy_k_rn_COPPERMINE, dimatcopy_k_rt_COPPERMINE,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_COPPERMINE, cimatcopy_k_ct_COPPERMINE, cimatcopy_k_rn_COPPERMINE, cimatcopy_k_rt_COPPERMINE,
  cimatcopy_k_cnc_COPPERMINE, cimatcopy_k_ctc_COPPERMINE, cimatcopy_k_rnc_COPPERMINE, cimatcopy_k_rtc_COPPERMINE,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_COPPERMINE, zimatcopy_k_ct_COPPERMINE, zimatcopy_k_rn_COPPERMINE, zimatcopy_k_rt_COPPERMINE,
  zimatcopy_k_cnc_COPPERMINE, zimatcopy_k_ctc_COPPERMINE, zimatcopy_k_rnc_COPPERMINE, zimatcopy_k_rtc_COPPERMINE,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_COPPERMINE,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_COPPERMINE,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_COPPERMINE,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_COPPERMINE
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
