#ifndef COST_FCN_H
#define COST_FCN_H

#include <limits>

#include <octave/oct.h>

#include "normal.h"
#include "Base_cost_permute_fcn.h"

class Cost_fcn : public virtual Base_cost_permute_fcn
{
protected:
  //! The cost
  double cost;

public:
  //! Assigns series to NULL and sets cost as large as possible
  Cost_fcn ()
    : cost (std::numeric_limits <double>::max ())
  {
  }

  // "API" functions
  //! Performs a transformation on matrix @c x and assigns its pointer to @c series
  /*!
   * The transformation performed here is to facilitate calculating the cost
   * (either by using cost_full() or cost_update()). The transformation is 
   * performed on matrix @c x, and afterwards @c this->series should point to @c x.
   *
   * @note
   * This method should be called before calling any other method.
   */
  virtual void cost_transform ()
  {
  }

  //! Returns an inverse transformation on @c series
  virtual Matrix cost_inverse () const
  {
    if (this->series != NULL)
      return Matrix (*(this->series));
    else
      return Matrix ();
  }

  //! Calculates the full cost (by design slower than cost_update())
  /*!
      Once the full cost is calculated it is assigned to member cost

      @return the current cost
   */
  virtual double cost_full () = 0;

  //! Calculates an updated cost for modified elements of series
  /*! @param cmax the maximum cost that is acceptable
      @param accept is set to true when the change is acceptable (then the change
                    was performed and the the cost was updated), otherwise false
                    (series and cost are unchanged)

      @return current cost
   */
  virtual double
    cost_update (double cmax, bool &accept) = 0;

  // getters and setters for cost
  double get_cost () const { return cost; }
  void set_cost (double _cost) { this->cost = _cost; }

};

#endif
