; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -mtriple=powerpc64le-unknown-gnu-linux  < %s | FileCheck %s -check-prefix=CHECK

define signext i32 @memcmp8(i32* nocapture readonly %buffer1, i32* nocapture readonly %buffer2) {
; CHECK-LABEL: memcmp8:
; CHECK:       # BB#0:
; CHECK-NEXT:    ldbrx 3, 0, 3
; CHECK-NEXT:    ldbrx 4, 0, 4
; CHECK-NEXT:    li 5, 1
; CHECK-NEXT:    li 12, -1
; CHECK-NEXT:    cmpld 3, 4
; CHECK-NEXT:    isel 3, 12, 5, 0
; CHECK-NEXT:    isel 3, 0, 3, 2
; CHECK-NEXT:    blr
  %t0 = bitcast i32* %buffer1 to i8*
  %t1 = bitcast i32* %buffer2 to i8*
  %call = tail call signext i32 @memcmp(i8* %t0, i8* %t1, i64 8)
  ret i32 %call
}

define signext i32 @memcmp4(i32* nocapture readonly %buffer1, i32* nocapture readonly %buffer2) {
; CHECK-LABEL: memcmp4:
; CHECK:       # BB#0:
; CHECK-NEXT:    lwbrx 3, 0, 3
; CHECK-NEXT:    lwbrx 4, 0, 4
; CHECK-NEXT:    li 5, 1
; CHECK-NEXT:    li 12, -1
; CHECK-NEXT:    cmplw 3, 4
; CHECK-NEXT:    isel 3, 12, 5, 0
; CHECK-NEXT:    isel 3, 0, 3, 2
; CHECK-NEXT:    blr
  %t0 = bitcast i32* %buffer1 to i8*
  %t1 = bitcast i32* %buffer2 to i8*
  %call = tail call signext i32 @memcmp(i8* %t0, i8* %t1, i64 4)
  ret i32 %call
}

define signext i32 @memcmp2(i32* nocapture readonly %buffer1, i32* nocapture readonly %buffer2) {
; CHECK-LABEL: memcmp2:
; CHECK:       # BB#0:
; CHECK-NEXT:    lhbrx 3, 0, 3
; CHECK-NEXT:    lhbrx 4, 0, 4
; CHECK-NEXT:    li 5, 1
; CHECK-NEXT:    li 12, -1
; CHECK-NEXT:    cmplw 3, 4
; CHECK-NEXT:    isel 3, 12, 5, 0
; CHECK-NEXT:    isel 3, 0, 3, 2
; CHECK-NEXT:    blr
  %t0 = bitcast i32* %buffer1 to i8*
  %t1 = bitcast i32* %buffer2 to i8*
  %call = tail call signext i32 @memcmp(i8* %t0, i8* %t1, i64 2)
  ret i32 %call
}

define signext i32 @memcmp1(i32* nocapture readonly %buffer1, i32* nocapture readonly %buffer2) {
; CHECK-LABEL: memcmp1:
; CHECK:       # BB#0:
; CHECK-NEXT:    lbz 3, 0(3)
; CHECK-NEXT:    lbz 4, 0(4)
; CHECK-NEXT:    li 5, 1
; CHECK-NEXT:    li 12, -1
; CHECK-NEXT:    cmplw 3, 4
; CHECK-NEXT:    isel 3, 12, 5, 0
; CHECK-NEXT:    isel 3, 0, 3, 2
; CHECK-NEXT:    blr
  %t0 = bitcast i32* %buffer1 to i8*
  %t1 = bitcast i32* %buffer2 to i8*
  %call = tail call signext i32 @memcmp(i8* %t0, i8* %t1, i64 1) #2
  ret i32 %call
}

declare signext i32 @memcmp(i8*, i8*, i64)
