/*
	$Id: instrum.h,v 1.27 2000/01/03 18:21:13 greglee Exp $

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   instrum.h

   */

typedef struct {
  splen_t
    loop_start, loop_end, data_length;
  uint32
    sample_rate, low_freq, high_freq, root_freq;

  uint8
    root_tune, fine_tune, samplesize;

  uint32
    envelope_rate[7], envelope_offset[7],
    modulation_rate[7], modulation_offset[7];
  FLOAT_T
    volume,
    modEnvToFilterFc, modEnvToPitch, modLfoToFilterFc,
    amp_random, hirand, lorand;
  sample_t *data;
  samplel_t *ldata;
  int32 
    tremolo_sweep_increment, tremolo_phase_increment, 
    lfo_sweep_increment, lfo_phase_increment, lfo_depth, 
    vibrato_sweep_increment;
  uint32
    vibrato_control_ratio,
    cutoff_freq;
  uint8
    reverberation, chorusdepth,
    tremolo_depth, vibrato_depth,
    modes, stereo_mode, trigger;
  uint8
    panning, note_to_use, exclusiveClass;
  int16
    scale_tuning, keyToModEnvHold, keyToModEnvDecay,
    keyToVolEnvHold, keyToVolEnvDecay, resonance;
  uint8
    attenuation, freq_center;
  int32
    freq_scale, vibrato_delay;
  int8
    aps_parameter, sw_up, sw_down, sw_lokey, sw_hikey, sw_last;
} Sample;

/* Bits in modes: */
#define MODES_16BIT	(1<<0)
#define MODES_UNSIGNED	(1<<1)
#define MODES_LOOPING	(1<<2)
#define MODES_PINGPONG	(1<<3)
#define MODES_REVERSE	(1<<4)
#define MODES_SUSTAIN	(1<<5)
#define MODES_ENVELOPE	(1<<6)
#define MODES_FAST_RELEASE	(1<<7)

typedef struct {
  int type;
  int samples;
  Sample *sample;
  int left_samples;
  Sample *left_sample;
  int right_samples;
  Sample *right_sample;
  unsigned char *contents;
} Instrument;

typedef struct _PurgeList {
  sample_t *purge_me;
  struct _PurgeList *next;
} PurgeList;

typedef struct _InstrumentLayer {
  uint8 lo, hi;
  int size;
  int map_size;
  int font_type;
  int sfz_group;
  uint8 *all_layers;
  Instrument *instrument;
  PurgeList *purgelist;
  struct _InstrumentLayer *next;
} InstrumentLayer;

/* font codes */
#define FONT_NORMAL 0
#define FONT_FFF    1
#define FONT_SBK    2
#define FONT_TONESET 3
#define FONT_DRUMSET 4
#define FONT_PRESET 5

struct cfg_type {
	int font_code;
	int num;
	const char *name;
};

#define FONT_GUS    1
#define FONT_SF     2
#define FONT_SFZ    4

/* sfz trigger types */
#define TRIGGER_NONE	0
#define TRIGGER_FIRST	1
#define TRIGGER_LEGATO	2

#define LINKED_SAMPLE 8
#define LEFT_SAMPLE 4
#define RIGHT_SAMPLE 2
#define MONO_SAMPLE 1

typedef struct {
  const char *name;
  InstrumentLayer *layer;
  int font_type, sf_ix, last_used, tuning;
  int note, amp, pan, strip_loop, strip_envelope, strip_tail,
	 gm_num, tpgm, reverb, main_volume, cutoff, sustain;
} ToneBankElement;

/* A hack to delay instrument loading until after reading the
   entire MIDI file. */
#define MAGIC_LOAD_INSTRUMENT ((InstrumentLayer *)(-1))
#define MAXPROG 128
#define MAXSFX 128
#define MAXVAR 17
#define MAXBANK (MAXPROG+MAXVAR+MAXSFX)
/*                 |       |      |
 *                 |       |    mu100,vl
 *                 |     sfx,var1-16
 *                 |     drumsfx
 *               ordinary banks
 */
#define SFXBANK MAXPROG
#define MU100BANK (SFXBANK+MAXVAR)
#define VLBANK (MU100BANK+1)
#define SFXDRUM1 (SFXBANK+0)
#define SFXDRUM2 (SFXBANK+1)
#define TECHNO_KS (SFXBANK+16)
#define TECHNO_HI (SFXBANK+17)
#define TECHNO_LO (SFXBANK+18)
#define SAKURA (SFXBANK+32)
#define SMALL_LATIN (SFXBANK+33)

#define XGDRUM 1

typedef struct {
  const char *name;
  ToneBankElement tone[MAXPROG];
} ToneBank;

extern char *sf_file;
extern ToneBank *tonebank[], *drumset[];

extern InstrumentLayer *default_instrument;
extern int default_program;
extern int antialiasing_allowed;
extern int fast_decay;
extern int free_instruments_afterwards;
extern int cutoff_allowed;
extern int fast_load;

#define SPECIAL_PROGRAM -1

extern int load_missing_instruments(void);
extern void free_instruments(void);
extern void end_soundfont(void);
extern void add_purge (InstrumentLayer *lp, sample_t *data);
extern int free_layer (InstrumentLayer * lp);

extern int32 convert_tremolo_sweep(uint32 sweep);
extern int32 convert_vibrato_sweep(uint32 sweep, uint32 vib_control_ratio);
extern int32 convert_tremolo_rate(uint32 rate);
extern int32 convert_vibrato_rate(uint32 rate);
extern int32 convert_envelope_rate_attack (uint32 rate);
extern int32 convert_envelope_rate (uint32 rate);
extern int32 convert_envelope_offset (uint32 offset);

extern void init_soundfont(const char *fname, int oldbank, int newbank, int level);
extern InstrumentLayer *load_sf_instrument(ToneBank *b, int bank, int tn, int percussion);
extern InstrumentLayer *load_sfz_instrument(ToneBank *b, int bank, int tn, int percussion);
extern int current_tune_number;
extern int max_patch_memory;
extern int current_patch_memory;
extern void free_sfz_data(InstrumentLayer *lp);
