/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (certtool-args.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    /usr/src/ports/gnutls/gnutls-3.6.9-1.i686/src/gnutls-3.6.9/src/certtool-args.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:1:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the certtool author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The certtool program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2019 Free Software Foundation, and others, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  certtool is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  certtool is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the certtool program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_CERTTOOL_ARGS_H_GUARD
#define AUTOOPTS_CERTTOOL_ARGS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172033
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for certtool
 */
typedef enum {
    INDEX_OPT_DEBUG                    =  0,
    INDEX_OPT_VERBOSE                  =  1,
    INDEX_OPT_INFILE                   =  2,
    INDEX_OPT_OUTFILE                  =  3,
    INDEX_OPT_CERTIFICATE_INFO         =  5,
    INDEX_OPT_PUBKEY_INFO              =  6,
    INDEX_OPT_GENERATE_SELF_SIGNED     =  7,
    INDEX_OPT_GENERATE_CERTIFICATE     =  8,
    INDEX_OPT_GENERATE_PROXY           =  9,
    INDEX_OPT_UPDATE_CERTIFICATE       = 10,
    INDEX_OPT_FINGERPRINT              = 11,
    INDEX_OPT_KEY_ID                   = 12,
    INDEX_OPT_CERTIFICATE_PUBKEY       = 13,
    INDEX_OPT_V1                       = 14,
    INDEX_OPT_SIGN_PARAMS              = 15,
    INDEX_OPT_CRQ_INFO                 = 17,
    INDEX_OPT_GENERATE_REQUEST         = 18,
    INDEX_OPT_NO_CRQ_EXTENSIONS        = 19,
    INDEX_OPT_P12_INFO                 = 21,
    INDEX_OPT_P12_NAME                 = 22,
    INDEX_OPT_TO_P12                   = 23,
    INDEX_OPT_KEY_INFO                 = 25,
    INDEX_OPT_P8_INFO                  = 26,
    INDEX_OPT_TO_RSA                   = 27,
    INDEX_OPT_GENERATE_PRIVKEY         = 28,
    INDEX_OPT_KEY_TYPE                 = 29,
    INDEX_OPT_BITS                     = 30,
    INDEX_OPT_CURVE                    = 31,
    INDEX_OPT_SEC_PARAM                = 32,
    INDEX_OPT_TO_P8                    = 33,
    INDEX_OPT_PKCS8                    = 34,
    INDEX_OPT_PROVABLE                 = 35,
    INDEX_OPT_VERIFY_PROVABLE_PRIVKEY  = 36,
    INDEX_OPT_SEED                     = 37,
    INDEX_OPT_CRL_INFO                 = 39,
    INDEX_OPT_GENERATE_CRL             = 40,
    INDEX_OPT_VERIFY_CRL               = 41,
    INDEX_OPT_VERIFY_CHAIN             = 43,
    INDEX_OPT_VERIFY                   = 44,
    INDEX_OPT_VERIFY_HOSTNAME          = 45,
    INDEX_OPT_VERIFY_EMAIL             = 46,
    INDEX_OPT_VERIFY_PURPOSE           = 47,
    INDEX_OPT_VERIFY_ALLOW_BROKEN      = 48,
    INDEX_OPT_P7_GENERATE              = 50,
    INDEX_OPT_P7_SIGN                  = 51,
    INDEX_OPT_P7_DETACHED_SIGN         = 52,
    INDEX_OPT_P7_INCLUDE_CERT          = 53,
    INDEX_OPT_P7_TIME                  = 54,
    INDEX_OPT_P7_SHOW_DATA             = 55,
    INDEX_OPT_P7_INFO                  = 56,
    INDEX_OPT_P7_VERIFY                = 57,
    INDEX_OPT_SMIME_TO_P7              = 58,
    INDEX_OPT_GENERATE_DH_PARAMS       = 60,
    INDEX_OPT_GET_DH_PARAMS            = 61,
    INDEX_OPT_DH_INFO                  = 62,
    INDEX_OPT_LOAD_PRIVKEY             = 63,
    INDEX_OPT_LOAD_PUBKEY              = 64,
    INDEX_OPT_LOAD_REQUEST             = 65,
    INDEX_OPT_LOAD_CERTIFICATE         = 66,
    INDEX_OPT_LOAD_CA_PRIVKEY          = 67,
    INDEX_OPT_LOAD_CA_CERTIFICATE      = 68,
    INDEX_OPT_LOAD_CRL                 = 69,
    INDEX_OPT_LOAD_DATA                = 70,
    INDEX_OPT_PASSWORD                 = 71,
    INDEX_OPT_NULL_PASSWORD            = 72,
    INDEX_OPT_EMPTY_PASSWORD           = 73,
    INDEX_OPT_HEX_NUMBERS              = 74,
    INDEX_OPT_CPRINT                   = 75,
    INDEX_OPT_RSA                      = 76,
    INDEX_OPT_DSA                      = 77,
    INDEX_OPT_ECC                      = 78,
    INDEX_OPT_ECDSA                    = 79,
    INDEX_OPT_HASH                     = 80,
    INDEX_OPT_SALT_SIZE                = 81,
    INDEX_OPT_INDER                    = 82,
    INDEX_OPT_INRAW                    = 83,
    INDEX_OPT_OUTDER                   = 84,
    INDEX_OPT_OUTRAW                   = 85,
    INDEX_OPT_DISABLE_QUICK_RANDOM     = 86,
    INDEX_OPT_TEMPLATE                 = 87,
    INDEX_OPT_STDOUT_INFO              = 88,
    INDEX_OPT_ASK_PASS                 = 89,
    INDEX_OPT_PKCS_CIPHER              = 90,
    INDEX_OPT_PROVIDER                 = 91,
    INDEX_OPT_TEXT                     = 92,
    INDEX_OPT_VERSION                  = 93,
    INDEX_OPT_HELP                     = 94,
    INDEX_OPT_MORE_HELP                = 95
} teOptIndex;
/** count of all options for certtool */
#define OPTION_CT    96
/** certtool version */
#define CERTTOOL_VERSION       "3.6.9"
/** Full certtool version text */
#define CERTTOOL_FULL_VERSION  "certtool 3.6.9"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(DEBUG)
 */
#define         DESC(n) (certtoolOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of certtool exit codes
 */
typedef enum {
    CERTTOOL_EXIT_SUCCESS         = 0,
    CERTTOOL_EXIT_FAILURE         = 1,
    CERTTOOL_EXIT_USAGE_ERROR     = 64,
    CERTTOOL_EXIT_LIBOPTS_FAILURE = 70
}   certtool_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_DEBUG          'd'

#define OPT_VALUE_DEBUG          (DESC(DEBUG).optArg.argInt)
#define VALUE_OPT_VERBOSE        'V'
#define VALUE_OPT_INFILE         0x1001
#define VALUE_OPT_OUTFILE        0x1002
#define VALUE_OPT_CERTIFICATE_INFO 'i'
#define VALUE_OPT_PUBKEY_INFO    0x1003
#define VALUE_OPT_GENERATE_SELF_SIGNED 's'
#define VALUE_OPT_GENERATE_CERTIFICATE 'c'
#define VALUE_OPT_GENERATE_PROXY 0x1004
#define VALUE_OPT_UPDATE_CERTIFICATE 'u'
#define VALUE_OPT_FINGERPRINT    0x1005
#define VALUE_OPT_KEY_ID         0x1006
#define VALUE_OPT_CERTIFICATE_PUBKEY 0x1007
#define VALUE_OPT_V1             0x1008
#define VALUE_OPT_SIGN_PARAMS    0x1009
#define VALUE_OPT_CRQ_INFO       0x100A
#define VALUE_OPT_GENERATE_REQUEST 'q'
#define VALUE_OPT_NO_CRQ_EXTENSIONS 0x100B
#define VALUE_OPT_P12_INFO       0x100C
#define VALUE_OPT_P12_NAME       0x100D
#define VALUE_OPT_TO_P12         0x100E
#define VALUE_OPT_KEY_INFO       'k'
#define VALUE_OPT_P8_INFO        0x100F
#define VALUE_OPT_TO_RSA         0x1010
#define VALUE_OPT_GENERATE_PRIVKEY 'p'
#define VALUE_OPT_KEY_TYPE       0x1011
#define VALUE_OPT_BITS           0x1012

#define OPT_VALUE_BITS           (DESC(BITS).optArg.argInt)
#define VALUE_OPT_CURVE          0x1013
#define VALUE_OPT_SEC_PARAM      0x1014
#define VALUE_OPT_TO_P8          0x1015
#define VALUE_OPT_PKCS8          '8'
#define VALUE_OPT_PROVABLE       0x1016
#define VALUE_OPT_VERIFY_PROVABLE_PRIVKEY 0x1017
#define VALUE_OPT_SEED           0x1018
#define VALUE_OPT_CRL_INFO       'l'
#define VALUE_OPT_GENERATE_CRL   0x1019
#define VALUE_OPT_VERIFY_CRL     0x101A
#define VALUE_OPT_VERIFY_CHAIN   'e'
#define VALUE_OPT_VERIFY         0x101B
#define VALUE_OPT_VERIFY_HOSTNAME 0x101C
#define VALUE_OPT_VERIFY_EMAIL   0x101D
#define VALUE_OPT_VERIFY_PURPOSE 0x101E
#define VALUE_OPT_VERIFY_ALLOW_BROKEN 0x101F
#define VALUE_OPT_P7_GENERATE    0x1020
#define VALUE_OPT_P7_SIGN        0x1021
#define VALUE_OPT_P7_DETACHED_SIGN 0x1022
#define VALUE_OPT_P7_INCLUDE_CERT 0x1023
#define VALUE_OPT_P7_TIME        0x1024
#define VALUE_OPT_P7_SHOW_DATA   0x1025
#define VALUE_OPT_P7_INFO        0x1026
#define VALUE_OPT_P7_VERIFY      0x1027
#define VALUE_OPT_SMIME_TO_P7    0x1028
#define VALUE_OPT_GENERATE_DH_PARAMS 0x1029
#define VALUE_OPT_GET_DH_PARAMS  0x102A
#define VALUE_OPT_DH_INFO        0x102B
#define VALUE_OPT_LOAD_PRIVKEY   0x102C
#define VALUE_OPT_LOAD_PUBKEY    0x102D
#define VALUE_OPT_LOAD_REQUEST   0x102E
#define VALUE_OPT_LOAD_CERTIFICATE 0x102F
#define VALUE_OPT_LOAD_CA_PRIVKEY 0x1030
#define VALUE_OPT_LOAD_CA_CERTIFICATE 0x1031
#define VALUE_OPT_LOAD_CRL       0x1032
#define VALUE_OPT_LOAD_DATA      0x1033
#define VALUE_OPT_PASSWORD       0x1034
#define VALUE_OPT_NULL_PASSWORD  0x1035
#define VALUE_OPT_EMPTY_PASSWORD 0x1036
#define VALUE_OPT_HEX_NUMBERS    0x1037
#define VALUE_OPT_CPRINT         0x1038
#define VALUE_OPT_RSA            0x1039
#define VALUE_OPT_DSA            0x103A
#define VALUE_OPT_ECC            0x103B
#define VALUE_OPT_ECDSA          0x103C
#define VALUE_OPT_HASH           0x103D
#define VALUE_OPT_SALT_SIZE      0x103E

#define OPT_VALUE_SALT_SIZE      (DESC(SALT_SIZE).optArg.argInt)
#define VALUE_OPT_INDER          0x103F
#define VALUE_OPT_INRAW          0x1040
#define VALUE_OPT_OUTDER         0x1041
#define VALUE_OPT_OUTRAW         0x1042
#define VALUE_OPT_DISABLE_QUICK_RANDOM 0x1043
#define VALUE_OPT_TEMPLATE       0x1044
#define VALUE_OPT_STDOUT_INFO    0x1045
#define VALUE_OPT_ASK_PASS       0x1046
#define VALUE_OPT_PKCS_CIPHER    0x1047
#define VALUE_OPT_PROVIDER       0x1048
#define VALUE_OPT_TEXT           0x1049
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'h'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(certtoolOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(certtoolOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                certtoolOptions.curOptIdx = (n); \
                certtoolOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*certtoolOptions.pUsageProc)(&certtoolOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */
#include <gettext.h>


/* * * * * *
 *
 *  Declare the certtool option descriptor.
 */
extern tOptions certtoolOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(certtoolOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(certtoolOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(certtoolOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(certtoolOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */


#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_CERTTOOL_ARGS_H_GUARD */

/* certtool-args.h ends here */
