/* test-case.c generated by valac 0.35.3.10-6b27, the Vala compiler
 * generated from test-case.vala, do not modify */

/* test-case.vala
 *
 * Copyright © 2011 Collabora Ltd.
 * Copyright © 2013 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *      Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *      Simon McVittie <simon.mcvittie@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <errno.h>


#define EDS_TEST_TYPE_TEST_CASE (eds_test_test_case_get_type ())
#define EDS_TEST_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase))
#define EDS_TEST_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCaseClass))
#define EDS_TEST_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_TEST_CASE))
#define EDS_TEST_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_TEST_CASE))
#define EDS_TEST_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCaseClass))

typedef struct _EdsTestTestCase EdsTestTestCase;
typedef struct _EdsTestTestCaseClass EdsTestTestCaseClass;
typedef struct _EdsTestTestCasePrivate EdsTestTestCasePrivate;

#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EdsTestTestCase {
	FolksTestCase parent_instance;
	EdsTestTestCasePrivate * priv;
	EdsTestBackend* eds_backend;
};

struct _EdsTestTestCaseClass {
	FolksTestCaseClass parent_class;
	void (*create_backend) (EdsTestTestCase* self);
	void (*configure_primary_store) (EdsTestTestCase* self);
};

struct _EdsTestTestCasePrivate {
	guint _test_num;
};


static gpointer eds_test_test_case_parent_class = NULL;

GType eds_test_test_case_get_type (void) G_GNUC_CONST;
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_TEST_CASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCasePrivate))
enum  {
	EDS_TEST_TEST_CASE_DUMMY_PROPERTY
};
EdsTestTestCase* eds_test_test_case_new (const gchar* name);
EdsTestTestCase* eds_test_test_case_construct (GType object_type, const gchar* name);
static gchar* eds_test_test_case_real_create_transient_dir (FolksTestCase* base);
static gchar* _eds_test_test_case_get_eds_libexecdir (EdsTestTestCase* self);
static void eds_test_test_case_real_private_bus_up (FolksTestCase* base);
static void eds_test_test_case_real_set_up (FolksTestCase* base);
void eds_test_test_case_create_backend (EdsTestTestCase* self);
void eds_test_test_case_configure_primary_store (EdsTestTestCase* self);
static void eds_test_test_case_real_create_backend (EdsTestTestCase* self);
EdsTestBackend* eds_test_backend_new (const gchar* name);
EdsTestBackend* eds_test_backend_construct (GType object_type, const gchar* name);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default);
static void eds_test_test_case_real_configure_primary_store (EdsTestTestCase* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_test_case_real_tear_down (FolksTestCase* base);
void eds_test_backend_tear_down (EdsTestBackend* self);
static void eds_test_test_case_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


EdsTestTestCase* eds_test_test_case_construct (GType object_type, const gchar* name) {
	EdsTestTestCase * self = NULL;
	const gchar* _tmp0_;
#line 49 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 51 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = name;
#line 51 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) folks_test_case_construct (object_type, _tmp0_);
#line 53 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_BACKENDS_ALLOWED", "eds", TRUE);
#line 54 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", "eds:local://test", TRUE);
#line 49 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	return self;
#line 134 "test-case.c"
}


EdsTestTestCase* eds_test_test_case_new (const gchar* name) {
#line 49 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	return eds_test_test_case_construct (EDS_TEST_TYPE_TEST_CASE, name);
#line 141 "test-case.c"
}


static gchar* eds_test_test_case_real_create_transient_dir (FolksTestCase* base) {
	EdsTestTestCase * self;
	gchar* result = NULL;
	gchar* transient;
	gchar* _tmp0_;
	gchar* config_dir;
	gchar* _tmp1_;
	gint _tmp2_;
#line 58 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 60 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->create_transient_dir (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 60 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	transient = _tmp0_;
#line 63 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = g_strdup_printf ("%s/.config/evolution/sources", transient);
#line 63 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	config_dir = _tmp1_;
#line 65 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = g_mkdir_with_parents (config_dir, 0700);
#line 65 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp2_ != 0) {
#line 167 "test-case.c"
		gint _tmp3_;
		const gchar* _tmp4_;
#line 66 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_ = errno;
#line 66 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = g_strerror (_tmp3_);
#line 66 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_error ("test-case.vala:66: unable to create '%s': %s", config_dir, _tmp4_);
#line 176 "test-case.c"
	}
#line 69 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	result = transient;
#line 69 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (config_dir);
#line 69 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	return result;
#line 184 "test-case.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1226 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1227 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1227 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1228 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1228 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1229 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1229 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 207 "test-case.c"
}


static gchar* _eds_test_test_case_get_eds_libexecdir (EdsTestTestCase* self) {
	gchar* result = NULL;
	gchar* env;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gint exit_status;
	gchar* capture_stdout;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = g_getenv ("FOLKS_TEST_EDS_LIBEXECDIR");
#line 76 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 76 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	env = _tmp1_;
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = env;
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp3_ != NULL) {
#line 235 "test-case.c"
		const gchar* _tmp4_;
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = env;
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
#line 241 "test-case.c"
	} else {
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp2_ = FALSE;
#line 245 "test-case.c"
	}
#line 78 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp2_) {
#line 80 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		result = env;
#line 80 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		return result;
#line 253 "test-case.c"
	}
#line 84 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	exit_status = -1;
#line 85 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	capture_stdout = NULL;
#line 259 "test-case.c"
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp5_ = g_strdup ("pkg-config");
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp6_ = g_strdup ("--variable=libexecdir");
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp7_ = g_strdup ("libedata-book-1.2");
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp8_ = g_new0 (gchar*, 3 + 1);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp8_[0] = _tmp5_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp8_[1] = _tmp6_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp8_[2] = _tmp7_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp9_ = _tmp8_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp9__length1 = 3;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_spawn_sync (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp10_, NULL, &_tmp11_, &_inner_error_);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_g_free0 (capture_stdout);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		capture_stdout = _tmp10_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		exit_status = _tmp11_;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 300 "test-case.c"
			goto __catch7_g_error;
		}
#line 98 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp12_ = exit_status;
#line 98 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_spawn_check_exit_status (_tmp12_, &_inner_error_);
#line 98 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 309 "test-case.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp13_;
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		e1 = _inner_error_;
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_inner_error_ = NULL;
#line 102 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp13_ = e1->message;
#line 102 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_error ("test-case.vala:102: Error getting libexecdir from pkg-config: %s", _tmp13_);
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_g_error_free0 (e1);
#line 328 "test-case.c"
	}
	__finally7:
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_g_free0 (capture_stdout);
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_g_free0 (env);
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		g_clear_error (&_inner_error_);
#line 87 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		return NULL;
#line 343 "test-case.c"
	}
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp14_ = capture_stdout;
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp15_ = string_strip (_tmp14_);
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	result = _tmp15_;
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (capture_stdout);
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (env);
#line 105 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	return result;
#line 357 "test-case.c"
}


static void eds_test_test_case_real_private_bus_up (FolksTestCase* base) {
	EdsTestTestCase * self;
	gchar* libexec;
	gchar* _tmp0_;
#line 116 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	static const gchar* sources_services[] = {"org.gnome.evolution.dataserver.Sources5", "org.gnome.evolution.dataserver.Sources4", "org.gnome.evolution.dataserver.Sources3", "org.gnome.evolution.dataserver.Sources2", "org.gnome.evolution.dataserver.Sources1"};
#line 124 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	static const gchar* address_book_services[] = {"org.gnome.evolution.dataserver.AddressBook9", "org.gnome.evolution.dataserver.AddressBook8", "org.gnome.evolution.dataserver.AddressBook7", "org.gnome.evolution.dataserver.AddressBook6", "org.gnome.evolution.dataserver.AddressBook5"};
#line 369 "test-case.c"
	GError * _inner_error_ = NULL;
#line 108 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 110 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->private_bus_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 113 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = _eds_test_test_case_get_eds_libexecdir (self);
#line 113 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	libexec = _tmp0_;
#line 379 "test-case.c"
	{
		guint i;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		i = (guint) 0;
#line 384 "test-case.c"
		{
			gboolean _tmp1_;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
			_tmp1_ = TRUE;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
			while (TRUE) {
#line 391 "test-case.c"
				guint _tmp3_;
				gchar* service_file_name;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				guint _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* service_file;
				guint _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (!_tmp1_) {
#line 408 "test-case.c"
					guint _tmp2_;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp2_ = i;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					i = _tmp2_ + 1;
#line 414 "test-case.c"
				}
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp1_ = FALSE;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp3_ = i;
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (!(_tmp3_ < ((guint) G_N_ELEMENTS (sources_services)))) {
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					break;
#line 424 "test-case.c"
				}
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp4_ = folks_test_case_get_transient_dir ((FolksTestCase*) self);
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp5_ = _tmp4_;
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp6_ = i;
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp7_ = g_strdup_printf ("evolution-source-registry-%u.service", _tmp6_);
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp8_ = _tmp7_;
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp9_ = g_build_filename (_tmp5_, "dbus-1", "services", _tmp8_, NULL);
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp10_ = _tmp9_;
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (_tmp8_);
#line 136 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				service_file_name = _tmp10_;
#line 139 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp11_ = i;
#line 139 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp12_ = sources_services[_tmp11_];
#line 139 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp13_ = libexec;
#line 139 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp14_ = g_strdup_printf ("[D-BUS Service]\n" "Name=%s\n" "Exec=%s/evolution-source-registry\n", _tmp12_, _tmp13_);
#line 139 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				service_file = _tmp14_;
#line 454 "test-case.c"
				{
					const gchar* _tmp15_;
					const gchar* _tmp16_;
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp15_ = service_file_name;
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp16_ = service_file;
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_file_set_contents (_tmp15_, _tmp16_, (gssize) -1, &_inner_error_);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						if (_inner_error_->domain == G_FILE_ERROR) {
#line 468 "test-case.c"
							goto __catch8_g_file_error;
						}
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file_name);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (libexec);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						g_clear_error (&_inner_error_);
#line 146 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						return;
#line 483 "test-case.c"
					}
				}
				goto __finally8;
				__catch8_g_file_error:
				{
					GError* e2 = NULL;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					e2 = _inner_error_;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_inner_error_ = NULL;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp17_ = service_file_name;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp18_ = e2->message;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_error ("test-case.vala:150: Error creating D-Bus service file ‘%s’: %s", _tmp17_, _tmp18_);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_error_free0 (e2);
#line 504 "test-case.c"
				}
				__finally8:
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file_name);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (libexec);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_clear_error (&_inner_error_);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					return;
#line 521 "test-case.c"
				}
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file);
#line 134 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file_name);
#line 527 "test-case.c"
			}
		}
	}
	{
		guint i;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		i = (guint) 0;
#line 535 "test-case.c"
		{
			gboolean _tmp19_;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
			_tmp19_ = TRUE;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
			while (TRUE) {
#line 542 "test-case.c"
				guint _tmp21_;
				gchar* service_file_name;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				guint _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* service_file;
				guint _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (!_tmp19_) {
#line 559 "test-case.c"
					guint _tmp20_;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp20_ = i;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					i = _tmp20_ + 1;
#line 565 "test-case.c"
				}
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp19_ = FALSE;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp21_ = i;
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (!(_tmp21_ < ((guint) G_N_ELEMENTS (address_book_services)))) {
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					break;
#line 575 "test-case.c"
				}
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp22_ = folks_test_case_get_transient_dir ((FolksTestCase*) self);
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp23_ = _tmp22_;
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp24_ = i;
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp25_ = g_strdup_printf ("evolution-addressbook-factory-%u.service", _tmp24_);
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp26_ = _tmp25_;
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp27_ = g_build_filename (_tmp23_, "dbus-1", "services", _tmp26_, NULL);
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp28_ = _tmp27_;
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (_tmp26_);
#line 158 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				service_file_name = _tmp28_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp29_ = i;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp30_ = address_book_services[_tmp29_];
#line 161 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp31_ = libexec;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_tmp32_ = g_strdup_printf ("[D-BUS Service]\n" "Name=%s\n" "Exec=%s/evolution-addressbook-factory\n", _tmp30_, _tmp31_);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				service_file = _tmp32_;
#line 605 "test-case.c"
				{
					const gchar* _tmp33_;
					const gchar* _tmp34_;
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp33_ = service_file_name;
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp34_ = service_file;
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_file_set_contents (_tmp33_, _tmp34_, (gssize) -1, &_inner_error_);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						if (_inner_error_->domain == G_FILE_ERROR) {
#line 619 "test-case.c"
							goto __catch9_g_file_error;
						}
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file_name);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (libexec);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						g_clear_error (&_inner_error_);
#line 168 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
						return;
#line 634 "test-case.c"
					}
				}
				goto __finally9;
				__catch9_g_file_error:
				{
					GError* e3 = NULL;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					e3 = _inner_error_;
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_inner_error_ = NULL;
#line 172 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp35_ = service_file_name;
#line 172 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_tmp36_ = e3->message;
#line 172 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_error ("test-case.vala:172: Error creating D-Bus service file ‘%s’: %s", _tmp35_, _tmp36_);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_error_free0 (e3);
#line 655 "test-case.c"
				}
				__finally9:
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file_name);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (libexec);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					g_clear_error (&_inner_error_);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
					return;
#line 672 "test-case.c"
				}
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file);
#line 156 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file_name);
#line 678 "test-case.c"
			}
		}
	}
#line 108 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (libexec);
#line 684 "test-case.c"
}


static void eds_test_test_case_real_set_up (FolksTestCase* base) {
	EdsTestTestCase * self;
#line 178 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 180 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->set_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 181 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_create_backend (self);
#line 182 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_configure_primary_store (self);
#line 698 "test-case.c"
}


/**
   * Virtual method to create and set up the EDS backend.
   * Called from set_up(); may be overridden to not create the backend,
   * or to create it but not set it up.
   *
   * Subclasses may chain up, but are not required to so.
   */
static void eds_test_test_case_real_create_backend (EdsTestTestCase* self) {
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	EdsTestBackend* _tmp3_;
	EdsTestBackend* _tmp4_;
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = self->priv->_test_num;
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self->priv->_test_num = _tmp0_ + 1;
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = g_strdup_printf ("test%u", _tmp0_);
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = _tmp1_;
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = eds_test_backend_new (_tmp2_);
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_eds_test_backend_unref0 (self->eds_backend);
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self->eds_backend = _tmp3_;
#line 197 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (_tmp2_);
#line 199 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp4_ = self->eds_backend;
#line 199 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	eds_test_backend_set_up (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, EDS_TEST_TYPE_BACKEND, EdsTestBackend), TRUE);
#line 735 "test-case.c"
}


void eds_test_test_case_create_backend (EdsTestTestCase* self) {
#line 194 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_return_if_fail (self != NULL);
#line 194 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	EDS_TEST_TEST_CASE_GET_CLASS (self)->create_backend (self);
#line 744 "test-case.c"
}


/**
   * Virtual method to configure ``FOLKS_PRIMARY_STORE`` to point to
   * our //eds_backend//.
   *
   * Subclasses may chain up, but are not required to so.
   */
static void eds_test_test_case_real_configure_primary_store (EdsTestTestCase* self) {
	EdsTestBackend* _tmp0_;
	gchar* config_val;
	EdsTestBackend* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 211 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = self->eds_backend;
#line 211 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_vala_assert (_tmp0_ != NULL, "this.eds_backend != null");
#line 212 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = self->eds_backend;
#line 212 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = eds_test_backend_get_address_book_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDS_TEST_TYPE_BACKEND, EdsTestBackend));
#line 212 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = _tmp2_;
#line 212 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp4_ = g_strconcat ("eds:", _tmp3_, NULL);
#line 212 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	config_val = _tmp4_;
#line 213 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", config_val, TRUE);
#line 208 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (config_val);
#line 779 "test-case.c"
}


void eds_test_test_case_configure_primary_store (EdsTestTestCase* self) {
#line 208 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_return_if_fail (self != NULL);
#line 208 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	EDS_TEST_TEST_CASE_GET_CLASS (self)->configure_primary_store (self);
#line 788 "test-case.c"
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 232 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 795 "test-case.c"
}


static void eds_test_test_case_real_tear_down (FolksTestCase* base) {
	EdsTestTestCase * self;
	EdsTestBackend* _tmp0_;
	GMainContext* context;
	GMainContext* _tmp2_;
	GMainContext* _tmp3_;
#line 216 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 218 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = self->eds_backend;
#line 218 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp0_ != NULL) {
#line 811 "test-case.c"
		EdsTestBackend* _tmp1_;
#line 220 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp1_ = self->eds_backend;
#line 220 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		eds_test_backend_tear_down (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDS_TEST_TYPE_BACKEND, EdsTestBackend));
#line 221 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_eds_test_backend_unref0 (self->eds_backend);
#line 221 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		self->eds_backend = NULL;
#line 821 "test-case.c"
	}
#line 224 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_unsetenv ("FOLKS_PRIMARY_STORE");
#line 232 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = g_main_context_default ();
#line 232 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = _g_main_context_ref0 (_tmp2_);
#line 232 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	context = _tmp3_;
#line 233 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	while (TRUE) {
#line 833 "test-case.c"
		GMainContext* _tmp4_;
		gboolean _tmp5_;
#line 233 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = context;
#line 233 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		_tmp5_ = g_main_context_iteration (_tmp4_, FALSE);
#line 233 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
		if (!_tmp5_) {
#line 233 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
			break;
#line 844 "test-case.c"
		}
	}
#line 235 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->tear_down (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 216 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_g_main_context_unref0 (context);
#line 851 "test-case.c"
}


static void eds_test_test_case_class_init (EdsTestTestCaseClass * klass) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_parent_class = g_type_class_peek_parent (klass);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	g_type_class_add_private (klass, sizeof (EdsTestTestCasePrivate));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->create_transient_dir = eds_test_test_case_real_create_transient_dir;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->private_bus_up = eds_test_test_case_real_private_bus_up;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->set_up = eds_test_test_case_real_set_up;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((EdsTestTestCaseClass *) klass)->create_backend = eds_test_test_case_real_create_backend;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((EdsTestTestCaseClass *) klass)->configure_primary_store = eds_test_test_case_real_configure_primary_store;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->tear_down = eds_test_test_case_real_tear_down;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	G_OBJECT_CLASS (klass)->finalize = eds_test_test_case_finalize;
#line 874 "test-case.c"
}


static void eds_test_test_case_instance_init (EdsTestTestCase * self) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self->priv = EDS_TEST_TEST_CASE_GET_PRIVATE (self);
#line 47 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self->eds_backend = NULL;
#line 185 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self->priv->_test_num = (guint) 0;
#line 885 "test-case.c"
}


static void eds_test_test_case_finalize (GObject * obj) {
	EdsTestTestCase * self;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase);
#line 47 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	_eds_test_backend_unref0 (self->eds_backend);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/test-case.vala"
	G_OBJECT_CLASS (eds_test_test_case_parent_class)->finalize (obj);
#line 897 "test-case.c"
}


/**
 * A test case whose private D-Bus session contains the necessary daemons
 * for an Evolution address-book.
 *
 * The EDS daemons are started through D-Bus service activation in
 * {@link TestCase.private_bus_up}, and should automatically exit when the mock
 * D-Bus bus is torn down. All of their configuration and data storage is
 * isolated in a temporary directory which is unique per test run.
 *
 * The EDS daemons are only torn down in {@link TestCase.final_tear_down}, so
 * remain running between test cases in the same test binary. Their state is
 * soft-reset, but some state may be retained between test cases.
 */
GType eds_test_test_case_get_type (void) {
	static volatile gsize eds_test_test_case_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_test_case_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestTestCaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_test_case_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestTestCase), 0, (GInstanceInitFunc) eds_test_test_case_instance_init, NULL };
		GType eds_test_test_case_type_id;
		eds_test_test_case_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "EdsTestTestCase", &g_define_type_info, 0);
		g_once_init_leave (&eds_test_test_case_type_id__volatile, eds_test_test_case_type_id);
	}
	return eds_test_test_case_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



