export CG_InitMarkPolys
code
proc CG_InitMarkPolys 12 12
file "../cg_marks.c"
line 28
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_marks.c -- wall marks
;4:
;5:#include "cg_local.h"
;6:
;7:/*
;8:===================================================================
;9:
;10:MARK POLYS
;11:
;12:===================================================================
;13:*/
;14:
;15:
;16:markPoly_t	cg_activeMarkPolys;			// double linked list
;17:markPoly_t	*cg_freeMarkPolys;			// single linked list
;18:markPoly_t	cg_markPolys[MAX_MARK_POLYS];
;19:static		int	markTotal;
;20:
;21:/*
;22:===================
;23:CG_InitMarkPolys
;24:
;25:This is called at startup and for tournement restarts
;26:===================
;27:*/
;28:void	CG_InitMarkPolys( void ) {
line 31
;29:	int		i;
;30:
;31:	memset( cg_markPolys, 0, sizeof(cg_markPolys) );
ADDRGP4 cg_markPolys
ARGP4
CNSTI4 0
ARGI4
CNSTI4 73728
ARGI4
ADDRGP4 memset
CALLP4
pop
line 33
;32:
;33:	cg_activeMarkPolys.nextMark = &cg_activeMarkPolys;
ADDRGP4 cg_activeMarkPolys+4
ADDRGP4 cg_activeMarkPolys
ASGNP4
line 34
;34:	cg_activeMarkPolys.prevMark = &cg_activeMarkPolys;
ADDRLP4 4
ADDRGP4 cg_activeMarkPolys
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
ASGNP4
line 35
;35:	cg_freeMarkPolys = cg_markPolys;
ADDRGP4 cg_freeMarkPolys
ADDRGP4 cg_markPolys
ASGNP4
line 36
;36:	for ( i = 0 ; i < MAX_MARK_POLYS - 1 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $72
line 37
;37:		cg_markPolys[i].nextMark = &cg_markPolys[i+1];
ADDRLP4 8
CNSTI4 288
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_markPolys+4
ADDP4
ADDRLP4 8
INDIRI4
ADDRGP4 cg_markPolys+288
ADDP4
ASGNP4
line 38
;38:	}
LABELV $73
line 36
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 255
LTI4 $72
line 39
;39:}
LABELV $70
endproc CG_InitMarkPolys 12 12
export CG_FreeMarkPoly
proc CG_FreeMarkPoly 12 4
line 47
;40:
;41:
;42:/*
;43:==================
;44:CG_FreeMarkPoly
;45:==================
;46:*/
;47:void CG_FreeMarkPoly( markPoly_t *le ) {
line 48
;48:	if ( !le->prevMark ) {
ADDRFP4 0
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $79
line 49
;49:		CG_Error( "CG_FreeLocalEntity: not active" );
ADDRGP4 $81
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 50
;50:	}
LABELV $79
line 53
;51:
;52:	// remove from the doubly linked active list
;53:	le->prevMark->nextMark = le->nextMark;
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 4
ASGNI4
ADDRLP4 0
INDIRP4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
ADDRLP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRP4
ASGNP4
line 54
;54:	le->nextMark->prevMark = le->prevMark;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ADDRLP4 8
INDIRP4
INDIRP4
ASGNP4
line 57
;55:
;56:	// the free list is only singly linked
;57:	le->nextMark = cg_freeMarkPolys;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_freeMarkPolys
INDIRP4
ASGNP4
line 58
;58:	cg_freeMarkPolys = le;
ADDRGP4 cg_freeMarkPolys
ADDRFP4 0
INDIRP4
ASGNP4
line 59
;59:}
LABELV $78
endproc CG_FreeMarkPoly 12 4
export CG_AllocMark
proc CG_AllocMark 12 12
line 68
;60:
;61:/*
;62:===================
;63:CG_AllocMark
;64:
;65:Will allways succeed, even if it requires freeing an old active mark
;66:===================
;67:*/
;68:markPoly_t	*CG_AllocMark( void ) {
line 72
;69:	markPoly_t	*le;
;70:	int time;
;71:
;72:	if ( !cg_freeMarkPolys ) {
ADDRGP4 cg_freeMarkPolys
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $83
line 75
;73:		// no free entities, so free the one at the end of the chain
;74:		// remove the oldest active entity
;75:		time = cg_activeMarkPolys.prevMark->time;
ADDRLP4 4
ADDRGP4 cg_activeMarkPolys
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
ADDRGP4 $86
JUMPV
LABELV $85
line 76
;76:		while (cg_activeMarkPolys.prevMark && time == cg_activeMarkPolys.prevMark->time) {
line 77
;77:			CG_FreeMarkPoly( cg_activeMarkPolys.prevMark );
ADDRGP4 cg_activeMarkPolys
INDIRP4
ARGP4
ADDRGP4 CG_FreeMarkPoly
CALLV
pop
line 78
;78:		}
LABELV $86
line 76
ADDRLP4 8
ADDRGP4 cg_activeMarkPolys
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $88
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
EQI4 $85
LABELV $88
line 79
;79:	}
LABELV $83
line 81
;80:
;81:	le = cg_freeMarkPolys;
ADDRLP4 0
ADDRGP4 cg_freeMarkPolys
INDIRP4
ASGNP4
line 82
;82:	cg_freeMarkPolys = cg_freeMarkPolys->nextMark;
ADDRLP4 8
ADDRGP4 cg_freeMarkPolys
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ASGNP4
line 84
;83:
;84:	memset( le, 0, sizeof( *le ) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 288
ARGI4
ADDRGP4 memset
CALLP4
pop
line 87
;85:
;86:	// link into the active list
;87:	le->nextMark = cg_activeMarkPolys.nextMark;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ASGNP4
line 88
;88:	le->prevMark = &cg_activeMarkPolys;
ADDRLP4 0
INDIRP4
ADDRGP4 cg_activeMarkPolys
ASGNP4
line 89
;89:	cg_activeMarkPolys.nextMark->prevMark = le;
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 90
;90:	cg_activeMarkPolys.nextMark = le;
ADDRGP4 cg_activeMarkPolys+4
ADDRLP4 0
INDIRP4
ASGNP4
line 91
;91:	return le;
ADDRLP4 0
INDIRP4
RETP4
LABELV $82
endproc CG_AllocMark 12 12
export CG_ImpactMark
proc CG_ImpactMark 6088 28
line 112
;92:}
;93:
;94:
;95:
;96:/*
;97:=================
;98:CG_ImpactMark
;99:
;100:origin should be a point within a unit of the plane
;101:dir should be the plane normal
;102:
;103:temporary marks will not be stored or randomly oriented, but immediately
;104:passed to the renderer.
;105:=================
;106:*/
;107:#define	MAX_MARK_FRAGMENTS	128
;108:#define	MAX_MARK_POINTS		384
;109:
;110:void CG_ImpactMark( qhandle_t markShader, const vec3_t origin, const vec3_t dir, 
;111:				   float orientation, float red, float green, float blue, float alpha,
;112:				   qboolean alphaFade, float radius, qboolean temporary ) {
line 123
;113:	vec3_t			axis[3];
;114:	float			texCoordScale;
;115:	vec3_t			originalPoints[4];
;116:	byte			colors[4];
;117:	int				i, j;
;118:	int				numFragments;
;119:	markFragment_t	markFragments[MAX_MARK_FRAGMENTS], *mf;
;120:	vec3_t			markPoints[MAX_MARK_POINTS];
;121:	vec3_t			projection;
;122:
;123:	if ( !cg_addMarks.integer ) {
ADDRGP4 cg_addMarks+12
INDIRI4
CNSTI4 0
NEI4 $93
line 124
;124:		return;
ADDRGP4 $92
JUMPV
LABELV $93
line 127
;125:	}
;126:
;127:	if ( radius <= 0 ) {
ADDRFP4 36
INDIRF4
CNSTF4 0
GTF4 $96
line 128
;128:		CG_Error( "CG_ImpactMark called with <= 0 radius" );
ADDRGP4 $98
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 129
;129:	}
LABELV $96
line 136
;130:
;131:	//if ( markTotal >= MAX_MARK_POLYS ) {
;132:	//	return;
;133:	//}
;134:
;135:	// create the texture axis
;136:	VectorNormalize2( dir, axis[0] );
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 VectorNormalize2
CALLF4
pop
line 137
;137:	PerpendicularVector( axis[1], axis[0] );
ADDRLP4 0+12
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 PerpendicularVector
CALLV
pop
line 138
;138:	RotatePointAroundVector( axis[2], axis[0], axis[1], orientation );
ADDRLP4 0+24
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 0+12
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRGP4 RotatePointAroundVector
CALLV
pop
line 139
;139:	CrossProduct( axis[0], axis[2], axis[1] );
ADDRLP4 0
ARGP4
ADDRLP4 0+24
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 141
;140:
;141:	texCoordScale = 0.5 * 1.0 / radius;
ADDRLP4 48
CNSTF4 1056964608
ADDRFP4 36
INDIRF4
DIVF4
ASGNF4
line 144
;142:
;143:	// create the full polygon
;144:	for ( i = 0 ; i < 3 ; i++ ) {
ADDRLP4 44
CNSTI4 0
ASGNI4
LABELV $104
line 145
;145:		originalPoints[0][i] = origin[i] - radius * axis[1][i] - radius * axis[2][i];
ADDRLP4 5752
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5756
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5752
INDIRI4
ADDRLP4 4664
ADDP4
ADDRLP4 5752
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5756
INDIRF4
ADDRLP4 5752
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
SUBF4
ADDRLP4 5756
INDIRF4
ADDRLP4 5752
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
SUBF4
ASGNF4
line 146
;146:		originalPoints[1][i] = origin[i] + radius * axis[1][i] - radius * axis[2][i];
ADDRLP4 5760
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5764
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5760
INDIRI4
ADDRLP4 4664+12
ADDP4
ADDRLP4 5760
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5764
INDIRF4
ADDRLP4 5760
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 5764
INDIRF4
ADDRLP4 5760
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
SUBF4
ASGNF4
line 147
;147:		originalPoints[2][i] = origin[i] + radius * axis[1][i] + radius * axis[2][i];
ADDRLP4 5768
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5772
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5768
INDIRI4
ADDRLP4 4664+24
ADDP4
ADDRLP4 5768
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5772
INDIRF4
ADDRLP4 5768
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
ADDF4
ADDRLP4 5772
INDIRF4
ADDRLP4 5768
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 148
;148:		originalPoints[3][i] = origin[i] - radius * axis[1][i] + radius * axis[2][i];
ADDRLP4 5776
ADDRLP4 44
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 5780
ADDRFP4 36
INDIRF4
ASGNF4
ADDRLP4 5776
INDIRI4
ADDRLP4 4664+36
ADDP4
ADDRLP4 5776
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5776
INDIRI4
ADDRLP4 0+12
ADDP4
INDIRF4
MULF4
SUBF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5776
INDIRI4
ADDRLP4 0+24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 149
;149:	}
LABELV $105
line 144
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 44
INDIRI4
CNSTI4 3
LTI4 $104
line 152
;150:
;151:	// get the fragments
;152:	VectorScale( dir, -20, projection );
ADDRLP4 5752
CNSTF4 3248488448
ASGNF4
ADDRLP4 5756
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 4716
ADDRLP4 5752
INDIRF4
ADDRLP4 5756
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 4716+4
ADDRLP4 5752
INDIRF4
ADDRLP4 5756
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 4716+8
CNSTF4 3248488448
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 153
;153:	numFragments = trap_CM_MarkFragments( 4, (void *)originalPoints,
CNSTI4 4
ARGI4
ADDRLP4 4664
ARGP4
ADDRLP4 4716
ARGP4
CNSTI4 384
ARGI4
ADDRLP4 56
ARGP4
CNSTI4 128
ARGI4
ADDRLP4 4728
ARGP4
ADDRLP4 5760
ADDRGP4 trap_CM_MarkFragments
CALLI4
ASGNI4
ADDRLP4 4712
ADDRLP4 5760
INDIRI4
ASGNI4
line 157
;154:					projection, MAX_MARK_POINTS, markPoints[0],
;155:					MAX_MARK_FRAGMENTS, markFragments );
;156:
;157:	colors[0] = red * 255;
ADDRLP4 5768
CNSTF4 1132396544
ADDRFP4 16
INDIRF4
MULF4
ASGNF4
ADDRLP4 5772
CNSTF4 1325400064
ASGNF4
ADDRLP4 5768
INDIRF4
ADDRLP4 5772
INDIRF4
LTF4 $122
ADDRLP4 5764
ADDRLP4 5768
INDIRF4
ADDRLP4 5772
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $123
JUMPV
LABELV $122
ADDRLP4 5764
ADDRLP4 5768
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $123
ADDRLP4 52
ADDRLP4 5764
INDIRU4
CVUU1 4
ASGNU1
line 158
;158:	colors[1] = green * 255;
ADDRLP4 5780
CNSTF4 1132396544
ADDRFP4 20
INDIRF4
MULF4
ASGNF4
ADDRLP4 5784
CNSTF4 1325400064
ASGNF4
ADDRLP4 5780
INDIRF4
ADDRLP4 5784
INDIRF4
LTF4 $126
ADDRLP4 5776
ADDRLP4 5780
INDIRF4
ADDRLP4 5784
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $127
JUMPV
LABELV $126
ADDRLP4 5776
ADDRLP4 5780
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $127
ADDRLP4 52+1
ADDRLP4 5776
INDIRU4
CVUU1 4
ASGNU1
line 159
;159:	colors[2] = blue * 255;
ADDRLP4 5792
CNSTF4 1132396544
ADDRFP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 5796
CNSTF4 1325400064
ASGNF4
ADDRLP4 5792
INDIRF4
ADDRLP4 5796
INDIRF4
LTF4 $130
ADDRLP4 5788
ADDRLP4 5792
INDIRF4
ADDRLP4 5796
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $131
JUMPV
LABELV $130
ADDRLP4 5788
ADDRLP4 5792
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $131
ADDRLP4 52+2
ADDRLP4 5788
INDIRU4
CVUU1 4
ASGNU1
line 160
;160:	colors[3] = alpha * 255;
ADDRLP4 5804
CNSTF4 1132396544
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 5808
CNSTF4 1325400064
ASGNF4
ADDRLP4 5804
INDIRF4
ADDRLP4 5808
INDIRF4
LTF4 $134
ADDRLP4 5800
ADDRLP4 5804
INDIRF4
ADDRLP4 5808
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $135
JUMPV
LABELV $134
ADDRLP4 5800
ADDRLP4 5804
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $135
ADDRLP4 52+3
ADDRLP4 5800
INDIRU4
CVUU1 4
ASGNU1
line 162
;161:
;162:	for ( i = 0, mf = markFragments ; i < numFragments ; i++, mf++ ) {
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 40
ADDRLP4 4728
ASGNP4
ADDRGP4 $139
JUMPV
LABELV $136
line 169
;163:		polyVert_t	*v;
;164:		polyVert_t	verts[MAX_VERTS_ON_POLY];
;165:		markPoly_t	*mark;
;166:
;167:		// we have an upper limit on the complexity of polygons
;168:		// that we store persistantly
;169:		if ( mf->numPoints > MAX_VERTS_ON_POLY ) {
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 10
LEI4 $140
line 170
;170:			mf->numPoints = MAX_VERTS_ON_POLY;
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 10
ASGNI4
line 171
;171:		}
LABELV $140
line 172
;172:		for ( j = 0, v = verts ; j < mf->numPoints ; j++, v++ ) {
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRLP4 5812
ADDRLP4 5820
ASGNP4
ADDRGP4 $145
JUMPV
LABELV $142
line 175
;173:			vec3_t		delta;
;174:
;175:			VectorCopy( markPoints[mf->firstPoint + j], v->xyz );
ADDRLP4 5812
INDIRP4
CNSTI4 12
ADDRLP4 40
INDIRP4
INDIRI4
ADDRLP4 36
INDIRI4
ADDI4
MULI4
ADDRLP4 56
ADDP4
INDIRB
ASGNB 12
line 177
;176:
;177:			VectorSubtract( v->xyz, origin, delta );
ADDRLP4 6076
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 6060
ADDRLP4 5812
INDIRP4
INDIRF4
ADDRLP4 6076
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 6080
CNSTI4 4
ASGNI4
ADDRLP4 6060+4
ADDRLP4 5812
INDIRP4
ADDRLP4 6080
INDIRI4
ADDP4
INDIRF4
ADDRLP4 6076
INDIRP4
ADDRLP4 6080
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 6084
CNSTI4 8
ASGNI4
ADDRLP4 6060+8
ADDRLP4 5812
INDIRP4
ADDRLP4 6084
INDIRI4
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
ADDRLP4 6084
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 178
;178:			v->st[0] = 0.5 + DotProduct( delta, axis[1] ) * texCoordScale;
ADDRLP4 5812
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 6060
INDIRF4
ADDRLP4 0+12
INDIRF4
MULF4
ADDRLP4 6060+4
INDIRF4
ADDRLP4 0+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 6060+8
INDIRF4
ADDRLP4 0+12+8
INDIRF4
MULF4
ADDF4
ADDRLP4 48
INDIRF4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 179
;179:			v->st[1] = 0.5 + DotProduct( delta, axis[2] ) * texCoordScale;
ADDRLP4 5812
INDIRP4
CNSTI4 16
ADDP4
ADDRLP4 6060
INDIRF4
ADDRLP4 0+24
INDIRF4
MULF4
ADDRLP4 6060+4
INDIRF4
ADDRLP4 0+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 6060+8
INDIRF4
ADDRLP4 0+24+8
INDIRF4
MULF4
ADDF4
ADDRLP4 48
INDIRF4
MULF4
CNSTF4 1056964608
ADDF4
ASGNF4
line 180
;180:			*(int *)v->modulate = *(int *)colors;
ADDRLP4 5812
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 52
INDIRI4
ASGNI4
line 181
;181:		}
LABELV $143
line 172
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 5812
ADDRLP4 5812
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
LABELV $145
ADDRLP4 36
INDIRI4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
LTI4 $142
line 184
;182:
;183:		// if it is a temporary (shadow) mark, add it immediately and forget about it
;184:		if ( temporary ) {
ADDRFP4 40
INDIRI4
CNSTI4 0
EQI4 $162
line 185
;185:			trap_R_AddPolyToScene( markShader, mf->numPoints, verts );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ARGI4
ADDRLP4 5820
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 186
;186:			continue;
ADDRGP4 $137
JUMPV
LABELV $162
line 190
;187:		}
;188:
;189:		// otherwise save it persistantly
;190:		mark = CG_AllocMark();
ADDRLP4 6060
ADDRGP4 CG_AllocMark
CALLP4
ASGNP4
ADDRLP4 5816
ADDRLP4 6060
INDIRP4
ASGNP4
line 191
;191:		mark->time = cg.time;
ADDRLP4 5816
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ASGNI4
line 192
;192:		mark->alphaFade = alphaFade;
ADDRLP4 5816
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 193
;193:		mark->markShader = markShader;
ADDRLP4 5816
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 194
;194:		mark->poly.numVerts = mf->numPoints;
ADDRLP4 5816
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 195
;195:		mark->color[0] = red;
ADDRLP4 5816
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 16
INDIRF4
ASGNF4
line 196
;196:		mark->color[1] = green;
ADDRLP4 5816
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 20
INDIRF4
ASGNF4
line 197
;197:		mark->color[2] = blue;
ADDRLP4 5816
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 24
INDIRF4
ASGNF4
line 198
;198:		mark->color[3] = alpha;
ADDRLP4 5816
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 28
INDIRF4
ASGNF4
line 199
;199:		memcpy( mark->verts, verts, mf->numPoints * sizeof( verts[0] ) );
ADDRLP4 5816
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRLP4 5820
ARGP4
CNSTU4 24
ADDRLP4 40
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CVIU4 4
MULU4
CVUI4 4
ARGI4
ADDRGP4 memcpy
CALLP4
pop
line 200
;200:		markTotal++;
ADDRLP4 6064
ADDRGP4 markTotal
ASGNP4
ADDRLP4 6064
INDIRP4
ADDRLP4 6064
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 201
;201:	}
LABELV $137
line 162
ADDRLP4 44
ADDRLP4 44
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 40
ADDRLP4 40
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
LABELV $139
ADDRLP4 44
INDIRI4
ADDRLP4 4712
INDIRI4
LTI4 $136
line 202
;202:}
LABELV $92
endproc CG_ImpactMark 6088 28
export CG_AddMarks
proc CG_AddMarks 80 12
line 213
;203:
;204:
;205:/*
;206:===============
;207:CG_AddMarks
;208:===============
;209:*/
;210:#define	MARK_TOTAL_TIME		10000
;211:#define	MARK_FADE_TIME		1000
;212:
;213:void CG_AddMarks( void ) {
line 219
;214:	int			j;
;215:	markPoly_t	*mp, *next;
;216:	int			t;
;217:	int			fade;
;218:
;219:	if ( !cg_addMarks.integer ) {
ADDRGP4 cg_addMarks+12
INDIRI4
CNSTI4 0
NEI4 $166
line 220
;220:		return;
ADDRGP4 $165
JUMPV
LABELV $166
line 223
;221:	}
;222:
;223:	mp = cg_activeMarkPolys.nextMark;
ADDRLP4 0
ADDRGP4 cg_activeMarkPolys+4
INDIRP4
ASGNP4
line 224
;224:	for ( ; mp != &cg_activeMarkPolys ; mp = next ) {
ADDRGP4 $173
JUMPV
LABELV $170
line 227
;225:		// grab next now, so if the local entity is freed we
;226:		// still have it
;227:		next = mp->nextMark;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRP4
ASGNP4
line 230
;228:
;229:		// see if it is time to completely remove it
;230:		if ( cg.time > mp->time + MARK_TOTAL_TIME ) {
ADDRGP4 cg+107604
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 10000
ADDI4
LEI4 $174
line 231
;231:			CG_FreeMarkPoly( mp );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 CG_FreeMarkPoly
CALLV
pop
line 232
;232:			continue;
ADDRGP4 $171
JUMPV
LABELV $174
line 236
;233:		}
;234:
;235:		// fade out the energy bursts
;236:		if ( mp->markShader == cgs.media.energyMarkShader ) {
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ADDRGP4 cgs+152340+388
INDIRI4
NEI4 $177
line 238
;237:
;238:			fade = 450 - 450 * ( (cg.time - mp->time ) / 3000.0 );
ADDRLP4 20
CNSTF4 1138819072
ASGNF4
ADDRLP4 8
ADDRLP4 20
INDIRF4
ADDRLP4 20
INDIRF4
ADDRGP4 cg+107604
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1161527296
DIVF4
MULF4
SUBF4
CVFI4 4
ASGNI4
line 239
;239:			if ( fade < 255 ) {
ADDRLP4 8
INDIRI4
CNSTI4 255
GEI4 $182
line 240
;240:				if ( fade < 0 ) {
ADDRLP4 8
INDIRI4
CNSTI4 0
GEI4 $184
line 241
;241:					fade = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 242
;242:				}
LABELV $184
line 243
;243:				if ( mp->verts[0].modulate[0] != 0 ) {
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRU1
CVUI4 1
CNSTI4 0
EQI4 $186
line 244
;244:					for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $191
JUMPV
LABELV $188
line 245
;245:						mp->verts[j].modulate[0] = mp->color[0] * fade;
ADDRLP4 32
CNSTI4 20
ASGNI4
ADDRLP4 36
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 40
CNSTF4 1325400064
ASGNF4
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
LTF4 $193
ADDRLP4 24
ADDRLP4 36
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $194
JUMPV
LABELV $193
ADDRLP4 24
ADDRLP4 36
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $194
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRLP4 24
INDIRU4
CVUU1 4
ASGNU1
line 246
;246:						mp->verts[j].modulate[1] = mp->color[1] * fade;
ADDRLP4 52
CNSTI4 24
ASGNI4
ADDRLP4 56
ADDRLP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 60
CNSTF4 1325400064
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
LTF4 $196
ADDRLP4 44
ADDRLP4 56
INDIRF4
ADDRLP4 60
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $197
JUMPV
LABELV $196
ADDRLP4 44
ADDRLP4 56
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $197
ADDRLP4 52
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 21
ADDP4
ADDRLP4 44
INDIRU4
CVUU1 4
ASGNU1
line 247
;247:						mp->verts[j].modulate[2] = mp->color[2] * fade;
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 76
CNSTF4 1325400064
ASGNF4
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
LTF4 $199
ADDRLP4 64
ADDRLP4 72
INDIRF4
ADDRLP4 76
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $200
JUMPV
LABELV $199
ADDRLP4 64
ADDRLP4 72
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $200
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 22
ADDP4
ADDRLP4 64
INDIRU4
CVUU1 4
ASGNU1
line 248
;248:					}
LABELV $189
line 244
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $191
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $188
line 249
;249:				}
LABELV $186
line 250
;250:			}
LABELV $182
line 251
;251:		}
LABELV $177
line 254
;252:
;253:		// fade all marks out with time
;254:		t = mp->time + MARK_TOTAL_TIME - cg.time;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 10000
ADDI4
ADDRGP4 cg+107604
INDIRI4
SUBI4
ASGNI4
line 255
;255:		if ( t < MARK_FADE_TIME ) {
ADDRLP4 12
INDIRI4
CNSTI4 1000
GEI4 $202
line 256
;256:			fade = 255 * t / MARK_FADE_TIME;
ADDRLP4 8
CNSTI4 255
ADDRLP4 12
INDIRI4
MULI4
CNSTI4 1000
DIVI4
ASGNI4
line 257
;257:			if ( mp->alphaFade ) {
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 0
EQI4 $204
line 258
;258:				for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $209
JUMPV
LABELV $206
line 259
;259:					mp->verts[j].modulate[3] = fade;
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 23
ADDP4
ADDRLP4 8
INDIRI4
CVIU4 4
CVUU1 4
ASGNU1
line 260
;260:				}
LABELV $207
line 258
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $209
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $206
line 261
;261:			} else {
ADDRGP4 $205
JUMPV
LABELV $204
line 262
;262:				for ( j = 0 ; j < mp->poly.numVerts ; j++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $213
JUMPV
LABELV $210
line 263
;263:					mp->verts[j].modulate[0] = mp->color[0] * fade;
ADDRLP4 28
CNSTI4 20
ASGNI4
ADDRLP4 32
ADDRLP4 0
INDIRP4
ADDRLP4 28
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $215
ADDRLP4 20
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $216
JUMPV
LABELV $215
ADDRLP4 20
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $216
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
ADDRLP4 28
INDIRI4
ADDP4
ADDRLP4 20
INDIRU4
CVUU1 4
ASGNU1
line 264
;264:					mp->verts[j].modulate[1] = mp->color[1] * fade;
ADDRLP4 48
CNSTI4 24
ASGNI4
ADDRLP4 52
ADDRLP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 56
CNSTF4 1325400064
ASGNF4
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
LTF4 $218
ADDRLP4 40
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $219
JUMPV
LABELV $218
ADDRLP4 40
ADDRLP4 52
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $219
ADDRLP4 48
INDIRI4
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 21
ADDP4
ADDRLP4 40
INDIRU4
CVUU1 4
ASGNU1
line 265
;265:					mp->verts[j].modulate[2] = mp->color[2] * fade;
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 72
CNSTF4 1325400064
ASGNF4
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
LTF4 $221
ADDRLP4 60
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $222
JUMPV
LABELV $221
ADDRLP4 60
ADDRLP4 68
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $222
CNSTI4 24
ADDRLP4 4
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ADDP4
CNSTI4 22
ADDP4
ADDRLP4 60
INDIRU4
CVUU1 4
ASGNU1
line 266
;266:				}
LABELV $211
line 262
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $213
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
LTI4 $210
line 267
;267:			}
LABELV $205
line 268
;268:		}
LABELV $202
line 271
;269:
;270:
;271:		trap_R_AddPolyToScene( mp->markShader, mp->poly.numVerts, mp->verts );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 272
;272:	}
LABELV $171
line 224
ADDRLP4 0
ADDRLP4 16
INDIRP4
ASGNP4
LABELV $173
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 cg_activeMarkPolys
CVPU4 4
NEU4 $170
line 273
;273:}
LABELV $165
endproc CG_AddMarks 80 12
data
align 4
LABELV shaderAnimNames
address $224
byte 4 0
skip 120
align 4
LABELV shaderAnimCounts
byte 4 23
skip 124
align 4
LABELV shaderAnimSTRatio
byte 4 1065353216
skip 124
export cl_numparticles
align 4
LABELV cl_numparticles
byte 4 1024
export initparticles
align 4
LABELV initparticles
byte 4 0
export CG_ClearParticles
code
proc CG_ClearParticles 28 12
line 377
;274:
;275:// cg_particles.c  
;276:
;277:#define BLOODRED	2
;278:#define EMISIVEFADE	3
;279:#define GREY75		4
;280:
;281:typedef struct particle_s
;282:{
;283:	struct particle_s	*next;
;284:
;285:	float		time;
;286:	float		endtime;
;287:
;288:	vec3_t		org;
;289:	vec3_t		vel;
;290:	vec3_t		accel;
;291:	int			color;
;292:	float		colorvel;
;293:	float		alpha;
;294:	float		alphavel;
;295:	int			type;
;296:	qhandle_t	pshader;
;297:	
;298:	float		height;
;299:	float		width;
;300:				
;301:	float		endheight;
;302:	float		endwidth;
;303:	
;304:	float		start;
;305:	float		end;
;306:
;307:	float		startfade;
;308:	qboolean	rotate;
;309:	int			snum;
;310:	
;311:	qboolean	link;
;312:
;313:	// Ridah
;314:	int			shaderAnim;
;315:	int			roll;
;316:
;317:	int			accumroll;
;318:
;319:} cparticle_t;
;320:
;321:typedef enum
;322:{
;323:	P_NONE,
;324:	P_WEATHER,
;325:	P_FLAT,
;326:	P_SMOKE,
;327:	P_ROTATE,
;328:	P_WEATHER_TURBULENT,
;329:	P_ANIM,	// Ridah
;330:	P_BAT,
;331:	P_BLEED,
;332:	P_FLAT_SCALEUP,
;333:	P_FLAT_SCALEUP_FADE,
;334:	P_WEATHER_FLURRY,
;335:	P_SMOKE_IMPACT,
;336:	P_BUBBLE,
;337:	P_BUBBLE_TURBULENT,
;338:	P_SPRITE
;339:} particle_type_t;
;340:
;341:#define	MAX_SHADER_ANIMS		32
;342:#define	MAX_SHADER_ANIM_FRAMES	64
;343:
;344:static char *shaderAnimNames[MAX_SHADER_ANIMS] = {
;345:	"explode1",
;346:	NULL
;347:};
;348:static qhandle_t shaderAnims[MAX_SHADER_ANIMS][MAX_SHADER_ANIM_FRAMES];
;349:static int	shaderAnimCounts[MAX_SHADER_ANIMS] = {
;350:	23
;351:};
;352:static float	shaderAnimSTRatio[MAX_SHADER_ANIMS] = {
;353:	1.0f
;354:};
;355:static int	numShaderAnims;
;356:// done.
;357:
;358:#define		PARTICLE_GRAVITY	40
;359:#define		MAX_PARTICLES	1024
;360:
;361:cparticle_t	*active_particles, *free_particles;
;362:cparticle_t	particles[MAX_PARTICLES];
;363:int		cl_numparticles = MAX_PARTICLES;
;364:
;365:qboolean		initparticles = qfalse;
;366:vec3_t			pvforward, pvright, pvup;
;367:vec3_t			rforward, rright, rup;
;368:
;369:float			oldtime;
;370:
;371:/*
;372:===============
;373:CL_ClearParticles
;374:===============
;375:*/
;376:void CG_ClearParticles (void)
;377:{
line 380
;378:	int		i;
;379:
;380:	memset( particles, 0, sizeof(particles) );
ADDRGP4 particles
ARGP4
CNSTI4 0
ARGI4
CNSTI4 126976
ARGI4
ADDRGP4 memset
CALLP4
pop
line 382
;381:
;382:	free_particles = &particles[0];
ADDRGP4 free_particles
ADDRGP4 particles
ASGNP4
line 383
;383:	active_particles = NULL;
ADDRGP4 active_particles
CNSTP4 0
ASGNP4
line 385
;384:
;385:	for (i=0 ;i<cl_numparticles ; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $229
JUMPV
LABELV $226
line 386
;386:	{
line 387
;387:		particles[i].next = &particles[i+1];
ADDRLP4 4
CNSTI4 124
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRGP4 particles
ADDP4
ADDRLP4 4
INDIRI4
ADDRGP4 particles+124
ADDP4
ASGNP4
line 388
;388:		particles[i].type = 0;
CNSTI4 124
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 particles+64
ADDP4
CNSTI4 0
ASGNI4
line 389
;389:	}
LABELV $227
line 385
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $229
ADDRLP4 0
INDIRI4
ADDRGP4 cl_numparticles
INDIRI4
LTI4 $226
line 390
;390:	particles[cl_numparticles-1].next = NULL;
CNSTI4 124
ADDRGP4 cl_numparticles
INDIRI4
MULI4
ADDRGP4 particles-124
ADDP4
CNSTP4 0
ASGNP4
line 392
;391:
;392:	oldtime = cg.time;
ADDRGP4 oldtime
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 395
;393:
;394:	// Ridah, init the shaderAnims
;395:	for (i=0; shaderAnimNames[i]; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $237
JUMPV
LABELV $234
line 398
;396:		int j;
;397:
;398:		for (j=0; j<shaderAnimCounts[i]; j++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $241
JUMPV
LABELV $238
line 399
;399:			shaderAnims[i][j] = trap_R_RegisterShader( va("%s%i", shaderAnimNames[i], j+1) );
ADDRGP4 $242
ARGP4
ADDRLP4 12
CNSTI4 2
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 12
INDIRI4
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
ARGP4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ARGI4
ADDRLP4 20
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 12
INDIRI4
LSHI4
ADDRLP4 0
INDIRI4
CNSTI4 8
LSHI4
ADDRGP4 shaderAnims
ADDP4
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 400
;400:		}
LABELV $239
line 398
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $241
ADDRLP4 4
INDIRI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimCounts
ADDP4
INDIRI4
LTI4 $238
line 401
;401:	}
LABELV $235
line 395
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $237
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $234
line 402
;402:	numShaderAnims = i;
ADDRGP4 numShaderAnims
ADDRLP4 0
INDIRI4
ASGNI4
line 405
;403:	// done.
;404:
;405:	initparticles = qtrue;
ADDRGP4 initparticles
CNSTI4 1
ASGNI4
line 406
;406:}
LABELV $225
endproc CG_ClearParticles 28 12
export CG_AddParticleToScene
proc CG_AddParticleToScene 472 16
line 415
;407:
;408:
;409:/*
;410:=====================
;411:CG_AddParticleToScene
;412:=====================
;413:*/
;414:void CG_AddParticleToScene (cparticle_t *p, vec3_t org, float alpha)
;415:{
line 428
;416:
;417:	vec3_t		point;
;418:	polyVert_t	verts[4];
;419:	float		width;
;420:	float		height;
;421:	float		time, time2;
;422:	float		ratio;
;423:	float		invratio;
;424:	vec3_t		color;
;425:	polyVert_t	TRIverts[3];
;426:	vec3_t		rright2, rup2;
;427:
;428:	if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT || p->type == P_WEATHER_FLURRY
ADDRLP4 240
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 240
INDIRI4
CNSTI4 1
EQI4 $249
ADDRLP4 240
INDIRI4
CNSTI4 5
EQI4 $249
ADDRLP4 240
INDIRI4
CNSTI4 11
EQI4 $249
ADDRLP4 240
INDIRI4
CNSTI4 13
EQI4 $249
ADDRLP4 240
INDIRI4
CNSTI4 14
NEI4 $244
LABELV $249
line 430
;429:		|| p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
;430:	{// create a front facing polygon
line 432
;431:			
;432:		if (p->type != P_WEATHER_FLURRY)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 11
EQI4 $250
line 433
;433:		{
line 434
;434:			if (p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
ADDRLP4 244
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 244
INDIRI4
CNSTI4 13
EQI4 $254
ADDRLP4 244
INDIRI4
CNSTI4 14
NEI4 $252
LABELV $254
line 435
;435:			{
line 436
;436:				if (org[2] > p->end)			
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
LEF4 $253
line 437
;437:				{	
line 438
;438:					p->time = cg.time;	
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 439
;439:					VectorCopy (org, p->org); // Ridah, fixes rare snow flakes that flicker on the ground
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 441
;440:									
;441:					p->org[2] = ( p->start + crandom () * 4 );
ADDRLP4 248
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 252
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 252
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 252
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 248
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 444
;442:					
;443:					
;444:					if (p->type == P_BUBBLE_TURBULENT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 14
NEI4 $253
line 445
;445:					{
line 446
;446:						p->vel[0] = crandom() * 4;
ADDRLP4 256
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 256
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 447
;447:						p->vel[1] = crandom() * 4;
ADDRLP4 260
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 260
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 448
;448:					}
line 450
;449:				
;450:				}
line 451
;451:			}
ADDRGP4 $253
JUMPV
LABELV $252
line 453
;452:			else
;453:			{
line 454
;454:				if (org[2] < p->end)			
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
GEF4 $260
line 455
;455:				{	
line 456
;456:					p->time = cg.time;	
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 457
;457:					VectorCopy (org, p->org); // Ridah, fixes rare snow flakes that flicker on the ground
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
ADDRGP4 $264
JUMPV
LABELV $263
line 460
;458:									
;459:					while (p->org[2] < p->end) 
;460:					{
line 461
;461:						p->org[2] += (p->start - p->end); 
ADDRLP4 248
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 252
ADDRLP4 248
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 252
INDIRP4
ADDRLP4 252
INDIRP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
ADDF4
ASGNF4
line 462
;462:					}
LABELV $264
line 459
ADDRLP4 248
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 248
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 248
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
LTF4 $263
line 465
;463:					
;464:					
;465:					if (p->type == P_WEATHER_TURBULENT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 5
NEI4 $266
line 466
;466:					{
line 467
;467:						p->vel[0] = crandom() * 16;
ADDRLP4 252
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 252
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 468
;468:						p->vel[1] = crandom() * 16;
ADDRLP4 256
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 256
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 469
;469:					}
LABELV $266
line 471
;470:				
;471:				}
LABELV $260
line 472
;472:			}
LABELV $253
line 476
;473:			
;474:
;475:			// Rafael snow pvs check
;476:			if (!p->link)
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 0
NEI4 $268
line 477
;477:				return;
ADDRGP4 $243
JUMPV
LABELV $268
line 479
;478:
;479:			p->alpha = 1;
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 480
;480:		}
LABELV $250
line 483
;481:		
;482:		// Ridah, had to do this or MAX_POLYS is being exceeded in village1.bsp
;483:		if (Distance( cg.snap->ps.origin, org ) > 1024) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 244
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 244
INDIRF4
CNSTF4 1149239296
LEF4 $270
line 484
;484:			return;
ADDRGP4 $243
JUMPV
LABELV $270
line 488
;485:		}
;486:		// done.
;487:	
;488:		if (p->type == P_BUBBLE || p->type == P_BUBBLE_TURBULENT)
ADDRLP4 248
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 248
INDIRI4
CNSTI4 13
EQI4 $275
ADDRLP4 248
INDIRI4
CNSTI4 14
NEI4 $273
LABELV $275
line 489
;489:		{
line 490
;490:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 252
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 252
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 252
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 491
;491:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 492
;492:			VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 493
;493:			verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 494
;494:			verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 495
;495:			verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 496
;496:			verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 497
;497:			verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 498
;498:			verts[0].modulate[3] = 255 * p->alpha;	
ADDRLP4 268
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 272
CNSTF4 1325400064
ASGNF4
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
LTF4 $297
ADDRLP4 264
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $298
JUMPV
LABELV $297
ADDRLP4 264
ADDRLP4 268
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $298
ADDRLP4 12+20+3
ADDRLP4 264
INDIRU4
CVUU1 4
ASGNU1
line 500
;499:
;500:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 276
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 280
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 276
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 276
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 501
;501:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 502
;502:			VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 503
;503:			verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 504
;504:			verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 505
;505:			verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 506
;506:			verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 507
;507:			verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 508
;508:			verts[1].modulate[3] = 255 * p->alpha;	
ADDRLP4 292
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 296
CNSTF4 1325400064
ASGNF4
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
LTF4 $327
ADDRLP4 288
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $328
JUMPV
LABELV $327
ADDRLP4 288
ADDRLP4 292
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $328
ADDRLP4 12+24+20+3
ADDRLP4 288
INDIRU4
CVUU1 4
ASGNU1
line 510
;509:
;510:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 300
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 304
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 300
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 300
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 511
;511:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 308
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 512
;512:			VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 513
;513:			verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 514
;514:			verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 515
;515:			verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 516
;516:			verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 517
;517:			verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 518
;518:			verts[2].modulate[3] = 255 * p->alpha;	
ADDRLP4 316
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 320
CNSTF4 1325400064
ASGNF4
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
LTF4 $357
ADDRLP4 312
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $358
JUMPV
LABELV $357
ADDRLP4 312
ADDRLP4 316
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $358
ADDRLP4 12+48+20+3
ADDRLP4 312
INDIRU4
CVUU1 4
ASGNU1
line 520
;519:
;520:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 324
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 328
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 324
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 328
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 324
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 328
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 521
;521:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 332
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 522
;522:			VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 523
;523:			verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 524
;524:			verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 525
;525:			verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 526
;526:			verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 527
;527:			verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 528
;528:			verts[3].modulate[3] = 255 * p->alpha;	
ADDRLP4 340
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 344
CNSTF4 1325400064
ASGNF4
ADDRLP4 340
INDIRF4
ADDRLP4 344
INDIRF4
LTF4 $387
ADDRLP4 336
ADDRLP4 340
INDIRF4
ADDRLP4 344
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $388
JUMPV
LABELV $387
ADDRLP4 336
ADDRLP4 340
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $388
ADDRLP4 12+72+20+3
ADDRLP4 336
INDIRU4
CVUU1 4
ASGNU1
line 529
;529:		}
ADDRGP4 $245
JUMPV
LABELV $273
line 531
;530:		else
;531:		{
line 532
;532:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 252
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 252
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 252
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 256
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 533
;533:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 260
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 534
;534:			VectorCopy( point, TRIverts[0].xyz );
ADDRLP4 108
ADDRLP4 0
INDIRB
ASGNB 12
line 535
;535:			TRIverts[0].st[0] = 1;
ADDRLP4 108+12
CNSTF4 1065353216
ASGNF4
line 536
;536:			TRIverts[0].st[1] = 0;
ADDRLP4 108+12+4
CNSTF4 0
ASGNF4
line 537
;537:			TRIverts[0].modulate[0] = 255;
ADDRLP4 108+20
CNSTU1 255
ASGNU1
line 538
;538:			TRIverts[0].modulate[1] = 255;
ADDRLP4 108+20+1
CNSTU1 255
ASGNU1
line 539
;539:			TRIverts[0].modulate[2] = 255;
ADDRLP4 108+20+2
CNSTU1 255
ASGNU1
line 540
;540:			TRIverts[0].modulate[3] = 255 * p->alpha;	
ADDRLP4 268
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 272
CNSTF4 1325400064
ASGNF4
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
LTF4 $410
ADDRLP4 264
ADDRLP4 268
INDIRF4
ADDRLP4 272
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $411
JUMPV
LABELV $410
ADDRLP4 264
ADDRLP4 268
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $411
ADDRLP4 108+20+3
ADDRLP4 264
INDIRU4
CVUU1 4
ASGNU1
line 542
;541:
;542:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 276
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 280
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 276
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 276
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 280
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 543
;543:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 544
;544:			VectorCopy (point, TRIverts[1].xyz);	
ADDRLP4 108+24
ADDRLP4 0
INDIRB
ASGNB 12
line 545
;545:			TRIverts[1].st[0] = 0;
ADDRLP4 108+24+12
CNSTF4 0
ASGNF4
line 546
;546:			TRIverts[1].st[1] = 0;
ADDRLP4 108+24+12+4
CNSTF4 0
ASGNF4
line 547
;547:			TRIverts[1].modulate[0] = 255;
ADDRLP4 108+24+20
CNSTU1 255
ASGNU1
line 548
;548:			TRIverts[1].modulate[1] = 255;
ADDRLP4 108+24+20+1
CNSTU1 255
ASGNU1
line 549
;549:			TRIverts[1].modulate[2] = 255;
ADDRLP4 108+24+20+2
CNSTU1 255
ASGNU1
line 550
;550:			TRIverts[1].modulate[3] = 255 * p->alpha;	
ADDRLP4 292
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 296
CNSTF4 1325400064
ASGNF4
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
LTF4 $440
ADDRLP4 288
ADDRLP4 292
INDIRF4
ADDRLP4 296
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $441
JUMPV
LABELV $440
ADDRLP4 288
ADDRLP4 292
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $441
ADDRLP4 108+24+20+3
ADDRLP4 288
INDIRU4
CVUU1 4
ASGNU1
line 552
;551:
;552:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 300
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 304
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 300
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 300
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 553
;553:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 308
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 308
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 554
;554:			VectorCopy (point, TRIverts[2].xyz);	
ADDRLP4 108+48
ADDRLP4 0
INDIRB
ASGNB 12
line 555
;555:			TRIverts[2].st[0] = 0;
ADDRLP4 108+48+12
CNSTF4 0
ASGNF4
line 556
;556:			TRIverts[2].st[1] = 1;
ADDRLP4 108+48+12+4
CNSTF4 1065353216
ASGNF4
line 557
;557:			TRIverts[2].modulate[0] = 255;
ADDRLP4 108+48+20
CNSTU1 255
ASGNU1
line 558
;558:			TRIverts[2].modulate[1] = 255;
ADDRLP4 108+48+20+1
CNSTU1 255
ASGNU1
line 559
;559:			TRIverts[2].modulate[2] = 255;
ADDRLP4 108+48+20+2
CNSTU1 255
ASGNU1
line 560
;560:			TRIverts[2].modulate[3] = 255 * p->alpha;	
ADDRLP4 316
CNSTF4 1132396544
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 320
CNSTF4 1325400064
ASGNF4
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
LTF4 $470
ADDRLP4 312
ADDRLP4 316
INDIRF4
ADDRLP4 320
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $471
JUMPV
LABELV $470
ADDRLP4 312
ADDRLP4 316
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $471
ADDRLP4 108+48+20+3
ADDRLP4 312
INDIRU4
CVUU1 4
ASGNU1
line 561
;561:		}
line 563
;562:	
;563:	}
ADDRGP4 $245
JUMPV
LABELV $244
line 564
;564:	else if (p->type == P_SPRITE)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 15
NEI4 $472
line 565
;565:	{
line 569
;566:		vec3_t	rr, ru;
;567:		vec3_t	rotate_ang;
;568:
;569:		VectorSet (color, 1.0, 1.0, 0.5);
ADDRLP4 280
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1056964608
ASGNF4
line 570
;570:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 571
;571:		time2 = p->endtime - p->time;
ADDRLP4 284
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 284
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 284
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 572
;572:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 574
;573:
;574:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 288
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 292
ADDRLP4 288
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 292
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 288
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 292
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 575
;575:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 296
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 300
ADDRLP4 296
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 300
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 296
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 577
;576:
;577:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $477
line 578
;578:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+109044+36
ARGP4
ADDRLP4 268
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 579
;579:			rotate_ang[ROLL] += p->roll;
ADDRLP4 268+8
ADDRLP4 268+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 580
;580:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 268
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 256
ARGP4
ADDRLP4 244
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 581
;581:		}
LABELV $477
line 583
;582:
;583:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $482
line 584
;584:			VectorMA (org, -height, ru, point);	
ADDRLP4 304
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 304
INDIRP4
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 304
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 244+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 585
;585:			VectorMA (point, -width, rr, point);	
ADDRLP4 312
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 256
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 256+4
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 256+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 586
;586:		} else {
ADDRGP4 $483
JUMPV
LABELV $482
line 587
;587:			VectorMA (org, -height, pvup, point);	
ADDRLP4 304
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 304
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 304
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 308
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 588
;588:			VectorMA (point, -width, pvright, point);	
ADDRLP4 312
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 312
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 589
;589:		}
LABELV $483
line 590
;590:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 591
;591:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 592
;592:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 593
;593:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 594
;594:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 595
;595:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 596
;596:		verts[0].modulate[3] = 255;
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 598
;597:
;598:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $514
line 599
;599:			VectorMA (point, 2*height, ru, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 244+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 600
;600:		} else {
ADDRGP4 $515
JUMPV
LABELV $514
line 601
;601:			VectorMA (point, 2*height, pvup, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 602
;602:		}
LABELV $515
line 603
;603:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 604
;604:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 605
;605:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 606
;606:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 607
;607:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 608
;608:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 609
;609:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 611
;610:
;611:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $545
line 612
;612:			VectorMA (point, 2*width, rr, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 256
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 256+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 256+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 613
;613:		} else {
ADDRGP4 $546
JUMPV
LABELV $545
line 614
;614:			VectorMA (point, 2*width, pvright, point);	
ADDRLP4 304
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 615
;615:		}
LABELV $546
line 616
;616:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 617
;617:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 618
;618:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 619
;619:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 620
;620:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 621
;621:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 622
;622:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 624
;623:
;624:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $576
line 625
;625:			VectorMA (point, -2*height, ru, point);	
ADDRLP4 304
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 244
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 244+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 244+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 626
;626:		} else {
ADDRGP4 $577
JUMPV
LABELV $576
line 627
;627:			VectorMA (point, -2*height, pvup, point);	
ADDRLP4 304
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 304
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 628
;628:		}
LABELV $577
line 629
;629:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 630
;630:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 631
;631:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 632
;632:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 633
;633:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 634
;634:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 635
;635:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 636
;636:	}
ADDRGP4 $473
JUMPV
LABELV $472
line 637
;637:	else if (p->type == P_SMOKE || p->type == P_SMOKE_IMPACT)
ADDRLP4 244
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 244
INDIRI4
CNSTI4 3
EQI4 $609
ADDRLP4 244
INDIRI4
CNSTI4 12
NEI4 $607
LABELV $609
line 638
;638:	{// create a front rotating facing polygon
line 640
;639:
;640:		if ( p->type == P_SMOKE_IMPACT && Distance( cg.snap->ps.origin, org ) > 1024) {
ADDRLP4 248
CNSTI4 64
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 248
INDIRI4
ADDP4
INDIRI4
CNSTI4 12
NEI4 $610
ADDRGP4 cg+36
INDIRP4
ADDRLP4 248
INDIRI4
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 252
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 252
INDIRF4
CNSTF4 1149239296
LEF4 $610
line 641
;641:			return;
ADDRGP4 $243
JUMPV
LABELV $610
line 644
;642:		}
;643:
;644:		if (p->color == BLOODRED)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 2
NEI4 $613
line 645
;645:			VectorSet (color, 0.22f, 0.0f, 0.0f);
ADDRLP4 184
CNSTF4 1046562734
ASGNF4
ADDRLP4 184+4
CNSTF4 0
ASGNF4
ADDRLP4 184+8
CNSTF4 0
ASGNF4
ADDRGP4 $614
JUMPV
LABELV $613
line 646
;646:		else if (p->color == GREY75)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 4
NEI4 $617
line 647
;647:		{
line 651
;648:			float	len;
;649:			float	greyit;
;650:			float	val;
;651:			len = Distance (cg.snap->ps.origin, org);
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 268
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 260
ADDRLP4 268
INDIRF4
ASGNF4
line 652
;652:			if (!len)
ADDRLP4 260
INDIRF4
CNSTF4 0
NEF4 $620
line 653
;653:				len = 1;
ADDRLP4 260
CNSTF4 1065353216
ASGNF4
LABELV $620
line 655
;654:
;655:			val = 4096/len;
ADDRLP4 264
CNSTF4 1166016512
ADDRLP4 260
INDIRF4
DIVF4
ASGNF4
line 656
;656:			greyit = 0.25 * val;
ADDRLP4 256
CNSTF4 1048576000
ADDRLP4 264
INDIRF4
MULF4
ASGNF4
line 657
;657:			if (greyit > 0.5)
ADDRLP4 256
INDIRF4
CNSTF4 1056964608
LEF4 $622
line 658
;658:				greyit = 0.5;
ADDRLP4 256
CNSTF4 1056964608
ASGNF4
LABELV $622
line 660
;659:
;660:			VectorSet (color, greyit, greyit, greyit);
ADDRLP4 272
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184+8
ADDRLP4 256
INDIRF4
ASGNF4
line 661
;661:		}
ADDRGP4 $618
JUMPV
LABELV $617
line 663
;662:		else
;663:			VectorSet (color, 1.0, 1.0, 1.0);
ADDRLP4 256
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1065353216
ASGNF4
LABELV $618
LABELV $614
line 665
;664:
;665:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 666
;666:		time2 = p->endtime - p->time;
ADDRLP4 260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 260
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 667
;667:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 669
;668:		
;669:		if (cg.time > p->startfade)
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
LEF4 $629
line 670
;670:		{
line 671
;671:			invratio = 1 - ( (cg.time - p->startfade) / (p->endtime - p->startfade) );
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 268
ADDRLP4 264
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ASGNF4
ADDRLP4 204
CNSTF4 1065353216
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 268
INDIRF4
SUBF4
ADDRLP4 264
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 268
INDIRF4
SUBF4
DIVF4
SUBF4
ASGNF4
line 673
;672:
;673:			if (p->color == EMISIVEFADE)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 3
NEI4 $633
line 674
;674:			{
line 676
;675:				float fval;
;676:				fval = (invratio * invratio);
ADDRLP4 276
ADDRLP4 204
INDIRF4
ASGNF4
ADDRLP4 272
ADDRLP4 276
INDIRF4
ADDRLP4 276
INDIRF4
MULF4
ASGNF4
line 677
;677:				if (fval < 0)
ADDRLP4 272
INDIRF4
CNSTF4 0
GEF4 $635
line 678
;678:					fval = 0;
ADDRLP4 272
CNSTF4 0
ASGNF4
LABELV $635
line 679
;679:				VectorSet (color, fval , fval , fval );
ADDRLP4 280
ADDRLP4 272
INDIRF4
ASGNF4
ADDRLP4 184
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 280
INDIRF4
ASGNF4
ADDRLP4 184+8
ADDRLP4 272
INDIRF4
ASGNF4
line 680
;680:			}
LABELV $633
line 681
;681:			invratio *= p->alpha;
ADDRLP4 204
ADDRLP4 204
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
line 682
;682:		}
ADDRGP4 $630
JUMPV
LABELV $629
line 684
;683:		else 
;684:			invratio = 1 * p->alpha;
ADDRLP4 204
CNSTF4 1065353216
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
MULF4
ASGNF4
LABELV $630
line 686
;685:
;686:		if ( cgs.glconfig.hardwareType == GLHW_RAGEPRO )
ADDRGP4 cgs+20100+11288
INDIRI4
CNSTI4 3
NEI4 $639
line 687
;687:			invratio = 1;
ADDRLP4 204
CNSTF4 1065353216
ASGNF4
LABELV $639
line 689
;688:
;689:		if (invratio > 1)
ADDRLP4 204
INDIRF4
CNSTF4 1065353216
LEF4 $643
line 690
;690:			invratio = 1;
ADDRLP4 204
CNSTF4 1065353216
ASGNF4
LABELV $643
line 692
;691:	
;692:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 264
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 268
ADDRLP4 264
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 268
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 264
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 268
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 693
;693:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 276
ADDRLP4 272
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 276
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 272
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 276
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 695
;694:
;695:		if (p->type != P_SMOKE_IMPACT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 12
EQI4 $645
line 696
;696:		{
line 699
;697:			vec3_t temp;
;698:
;699:			vectoangles (rforward, temp);
ADDRGP4 rforward
ARGP4
ADDRLP4 280
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 700
;700:			p->accumroll += p->roll;
ADDRLP4 292
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 296
ADDRLP4 292
INDIRP4
CNSTI4 120
ADDP4
ASGNP4
ADDRLP4 296
INDIRP4
ADDRLP4 296
INDIRP4
INDIRI4
ADDRLP4 292
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
ADDI4
ASGNI4
line 701
;701:			temp[ROLL] += p->accumroll * 0.1;
ADDRLP4 280+8
ADDRLP4 280+8
INDIRF4
CNSTF4 1036831949
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 702
;702:			AngleVectors ( temp, NULL, rright2, rup2);
ADDRLP4 280
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 208
ARGP4
ADDRLP4 220
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 703
;703:		}
ADDRGP4 $646
JUMPV
LABELV $645
line 705
;704:		else
;705:		{
line 706
;706:			VectorCopy (rright, rright2);
ADDRLP4 208
ADDRGP4 rright
INDIRB
ASGNB 12
line 707
;707:			VectorCopy (rup, rup2);
ADDRLP4 220
ADDRGP4 rup
INDIRB
ASGNB 12
line 708
;708:		}
LABELV $646
line 710
;709:		
;710:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $648
line 711
;711:		{
line 712
;712:			VectorMA (org, -height, rup2, point);	
ADDRLP4 280
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 284
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 280
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 284
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 280
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 284
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 713
;713:			VectorMA (point, -width, rright2, point);	
ADDRLP4 288
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 288
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 288
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 714
;714:		}
ADDRGP4 $649
JUMPV
LABELV $648
line 716
;715:		else
;716:		{
line 717
;717:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 280
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 284
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 280
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 280
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 284
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 718
;718:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 288
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 288
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 288
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 719
;719:		}
LABELV $649
line 720
;720:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 721
;721:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 722
;722:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 723
;723:		verts[0].modulate[0] = 255 * color[0];	
ADDRLP4 284
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 288
CNSTF4 1325400064
ASGNF4
ADDRLP4 284
INDIRF4
ADDRLP4 288
INDIRF4
LTF4 $675
ADDRLP4 280
ADDRLP4 284
INDIRF4
ADDRLP4 288
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $676
JUMPV
LABELV $675
ADDRLP4 280
ADDRLP4 284
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $676
ADDRLP4 12+20
ADDRLP4 280
INDIRU4
CVUU1 4
ASGNU1
line 724
;724:		verts[0].modulate[1] = 255 * color[1];	
ADDRLP4 296
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 300
CNSTF4 1325400064
ASGNF4
ADDRLP4 296
INDIRF4
ADDRLP4 300
INDIRF4
LTF4 $681
ADDRLP4 292
ADDRLP4 296
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $682
JUMPV
LABELV $681
ADDRLP4 292
ADDRLP4 296
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $682
ADDRLP4 12+20+1
ADDRLP4 292
INDIRU4
CVUU1 4
ASGNU1
line 725
;725:		verts[0].modulate[2] = 255 * color[2];	
ADDRLP4 308
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 312
CNSTF4 1325400064
ASGNF4
ADDRLP4 308
INDIRF4
ADDRLP4 312
INDIRF4
LTF4 $687
ADDRLP4 304
ADDRLP4 308
INDIRF4
ADDRLP4 312
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $688
JUMPV
LABELV $687
ADDRLP4 304
ADDRLP4 308
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $688
ADDRLP4 12+20+2
ADDRLP4 304
INDIRU4
CVUU1 4
ASGNU1
line 726
;726:		verts[0].modulate[3] = 255 * invratio;	
ADDRLP4 320
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 324
CNSTF4 1325400064
ASGNF4
ADDRLP4 320
INDIRF4
ADDRLP4 324
INDIRF4
LTF4 $692
ADDRLP4 316
ADDRLP4 320
INDIRF4
ADDRLP4 324
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $693
JUMPV
LABELV $692
ADDRLP4 316
ADDRLP4 320
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $693
ADDRLP4 12+20+3
ADDRLP4 316
INDIRU4
CVUU1 4
ASGNU1
line 728
;727:
;728:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $694
line 729
;729:		{
line 730
;730:			VectorMA (org, -height, rup2, point);	
ADDRLP4 328
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 332
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 328
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 332
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 328
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 332
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 731
;731:			VectorMA (point, width, rright2, point);	
ADDRLP4 336
ADDRLP4 196
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 336
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 336
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
MULF4
ADDF4
ASGNF4
line 732
;732:		}
ADDRGP4 $695
JUMPV
LABELV $694
line 734
;733:		else
;734:		{
line 735
;735:			VectorMA (org, -p->height, pvup, point);	
ADDRLP4 328
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 332
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 328
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 328
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 736
;736:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 336
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 336
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 336
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 737
;737:		}
LABELV $695
line 738
;738:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 739
;739:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 740
;740:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 741
;741:		verts[1].modulate[0] = 255 * color[0];	
ADDRLP4 332
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 336
CNSTF4 1325400064
ASGNF4
ADDRLP4 332
INDIRF4
ADDRLP4 336
INDIRF4
LTF4 $725
ADDRLP4 328
ADDRLP4 332
INDIRF4
ADDRLP4 336
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $726
JUMPV
LABELV $725
ADDRLP4 328
ADDRLP4 332
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $726
ADDRLP4 12+24+20
ADDRLP4 328
INDIRU4
CVUU1 4
ASGNU1
line 742
;742:		verts[1].modulate[1] = 255 * color[1];	
ADDRLP4 344
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 348
CNSTF4 1325400064
ASGNF4
ADDRLP4 344
INDIRF4
ADDRLP4 348
INDIRF4
LTF4 $732
ADDRLP4 340
ADDRLP4 344
INDIRF4
ADDRLP4 348
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $733
JUMPV
LABELV $732
ADDRLP4 340
ADDRLP4 344
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $733
ADDRLP4 12+24+20+1
ADDRLP4 340
INDIRU4
CVUU1 4
ASGNU1
line 743
;743:		verts[1].modulate[2] = 255 * color[2];	
ADDRLP4 356
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 360
CNSTF4 1325400064
ASGNF4
ADDRLP4 356
INDIRF4
ADDRLP4 360
INDIRF4
LTF4 $739
ADDRLP4 352
ADDRLP4 356
INDIRF4
ADDRLP4 360
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $740
JUMPV
LABELV $739
ADDRLP4 352
ADDRLP4 356
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $740
ADDRLP4 12+24+20+2
ADDRLP4 352
INDIRU4
CVUU1 4
ASGNU1
line 744
;744:		verts[1].modulate[3] = 255 * invratio;	
ADDRLP4 368
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 372
CNSTF4 1325400064
ASGNF4
ADDRLP4 368
INDIRF4
ADDRLP4 372
INDIRF4
LTF4 $745
ADDRLP4 364
ADDRLP4 368
INDIRF4
ADDRLP4 372
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $746
JUMPV
LABELV $745
ADDRLP4 364
ADDRLP4 368
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $746
ADDRLP4 12+24+20+3
ADDRLP4 364
INDIRU4
CVUU1 4
ASGNU1
line 746
;745:
;746:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $747
line 747
;747:		{
line 748
;748:			VectorMA (org, height, rup2, point);	
ADDRLP4 376
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 376
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 376
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
line 749
;749:			VectorMA (point, width, rright2, point);	
ADDRLP4 384
ADDRLP4 196
INDIRF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 384
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 384
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
MULF4
ADDF4
ASGNF4
line 750
;750:		}
ADDRGP4 $748
JUMPV
LABELV $747
line 752
;751:		else
;752:		{
line 753
;753:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 376
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 380
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 376
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 380
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 376
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 380
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 754
;754:			VectorMA (point, p->width, pvright, point);	
ADDRLP4 384
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 384
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 384
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 755
;755:		}
LABELV $748
line 756
;756:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 757
;757:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 758
;758:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 759
;759:		verts[2].modulate[0] = 255 * color[0];	
ADDRLP4 380
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 384
CNSTF4 1325400064
ASGNF4
ADDRLP4 380
INDIRF4
ADDRLP4 384
INDIRF4
LTF4 $778
ADDRLP4 376
ADDRLP4 380
INDIRF4
ADDRLP4 384
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $779
JUMPV
LABELV $778
ADDRLP4 376
ADDRLP4 380
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $779
ADDRLP4 12+48+20
ADDRLP4 376
INDIRU4
CVUU1 4
ASGNU1
line 760
;760:		verts[2].modulate[1] = 255 * color[1];	
ADDRLP4 392
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 396
CNSTF4 1325400064
ASGNF4
ADDRLP4 392
INDIRF4
ADDRLP4 396
INDIRF4
LTF4 $785
ADDRLP4 388
ADDRLP4 392
INDIRF4
ADDRLP4 396
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $786
JUMPV
LABELV $785
ADDRLP4 388
ADDRLP4 392
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $786
ADDRLP4 12+48+20+1
ADDRLP4 388
INDIRU4
CVUU1 4
ASGNU1
line 761
;761:		verts[2].modulate[2] = 255 * color[2];	
ADDRLP4 404
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 408
CNSTF4 1325400064
ASGNF4
ADDRLP4 404
INDIRF4
ADDRLP4 408
INDIRF4
LTF4 $792
ADDRLP4 400
ADDRLP4 404
INDIRF4
ADDRLP4 408
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $793
JUMPV
LABELV $792
ADDRLP4 400
ADDRLP4 404
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $793
ADDRLP4 12+48+20+2
ADDRLP4 400
INDIRU4
CVUU1 4
ASGNU1
line 762
;762:		verts[2].modulate[3] = 255 * invratio;	
ADDRLP4 416
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 420
CNSTF4 1325400064
ASGNF4
ADDRLP4 416
INDIRF4
ADDRLP4 420
INDIRF4
LTF4 $798
ADDRLP4 412
ADDRLP4 416
INDIRF4
ADDRLP4 420
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $799
JUMPV
LABELV $798
ADDRLP4 412
ADDRLP4 416
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $799
ADDRLP4 12+48+20+3
ADDRLP4 412
INDIRU4
CVUU1 4
ASGNU1
line 764
;763:
;764:		if (p->rotate)
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRI4
CNSTI4 0
EQI4 $800
line 765
;765:		{
line 766
;766:			VectorMA (org, height, rup2, point);	
ADDRLP4 424
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 424
INDIRP4
INDIRF4
ADDRLP4 220
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 424
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 220+4
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 220+8
INDIRF4
ADDRLP4 180
INDIRF4
MULF4
ADDF4
ASGNF4
line 767
;767:			VectorMA (point, -width, rright2, point);	
ADDRLP4 432
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 208
INDIRF4
ADDRLP4 432
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 208+4
INDIRF4
ADDRLP4 432
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 208+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 768
;768:		}
ADDRGP4 $801
JUMPV
LABELV $800
line 770
;769:		else
;770:		{
line 771
;771:			VectorMA (org, p->height, pvup, point);	
ADDRLP4 424
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 424
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 428
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 424
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 428
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 772
;772:			VectorMA (point, -p->width, pvright, point);	
ADDRLP4 432
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 432
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 432
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 773
;773:		}
LABELV $801
line 774
;774:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 775
;775:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 776
;776:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 777
;777:		verts[3].modulate[0] = 255 * color[0];	
ADDRLP4 428
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 432
CNSTF4 1325400064
ASGNF4
ADDRLP4 428
INDIRF4
ADDRLP4 432
INDIRF4
LTF4 $831
ADDRLP4 424
ADDRLP4 428
INDIRF4
ADDRLP4 432
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $832
JUMPV
LABELV $831
ADDRLP4 424
ADDRLP4 428
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $832
ADDRLP4 12+72+20
ADDRLP4 424
INDIRU4
CVUU1 4
ASGNU1
line 778
;778:		verts[3].modulate[1] = 255 * color[1];	
ADDRLP4 440
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 444
CNSTF4 1325400064
ASGNF4
ADDRLP4 440
INDIRF4
ADDRLP4 444
INDIRF4
LTF4 $838
ADDRLP4 436
ADDRLP4 440
INDIRF4
ADDRLP4 444
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $839
JUMPV
LABELV $838
ADDRLP4 436
ADDRLP4 440
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $839
ADDRLP4 12+72+20+1
ADDRLP4 436
INDIRU4
CVUU1 4
ASGNU1
line 779
;779:		verts[3].modulate[2] = 255 * color[2];	
ADDRLP4 452
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 456
CNSTF4 1325400064
ASGNF4
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
LTF4 $845
ADDRLP4 448
ADDRLP4 452
INDIRF4
ADDRLP4 456
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $846
JUMPV
LABELV $845
ADDRLP4 448
ADDRLP4 452
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $846
ADDRLP4 12+72+20+2
ADDRLP4 448
INDIRU4
CVUU1 4
ASGNU1
line 780
;780:		verts[3].modulate[3] = 255  * invratio;	
ADDRLP4 464
CNSTF4 1132396544
ADDRLP4 204
INDIRF4
MULF4
ASGNF4
ADDRLP4 468
CNSTF4 1325400064
ASGNF4
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
LTF4 $851
ADDRLP4 460
ADDRLP4 464
INDIRF4
ADDRLP4 468
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $852
JUMPV
LABELV $851
ADDRLP4 460
ADDRLP4 464
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $852
ADDRLP4 12+72+20+3
ADDRLP4 460
INDIRU4
CVUU1 4
ASGNU1
line 782
;781:		
;782:	}
ADDRGP4 $608
JUMPV
LABELV $607
line 783
;783:	else if (p->type == P_BLEED)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 8
NEI4 $853
line 784
;784:	{
line 789
;785:		vec3_t	rr, ru;
;786:		vec3_t	rotate_ang;
;787:		float	alpha;
;788:
;789:		alpha = p->alpha;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
ASGNF4
line 791
;790:		
;791:		if ( cgs.glconfig.hardwareType == GLHW_RAGEPRO )
ADDRGP4 cgs+20100+11288
INDIRI4
CNSTI4 3
NEI4 $855
line 792
;792:			alpha = 1;
ADDRLP4 272
CNSTF4 1065353216
ASGNF4
LABELV $855
line 794
;793:
;794:		if (p->roll) 
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $859
line 795
;795:		{
line 796
;796:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+109044+36
ARGP4
ADDRLP4 276
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 797
;797:			rotate_ang[ROLL] += p->roll;
ADDRLP4 276+8
ADDRLP4 276+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 798
;798:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 276
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 248
ARGP4
ADDRLP4 260
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 799
;799:		}
ADDRGP4 $860
JUMPV
LABELV $859
line 801
;800:		else
;801:		{
line 802
;802:			VectorCopy (pvup, ru);
ADDRLP4 260
ADDRGP4 pvup
INDIRB
ASGNB 12
line 803
;803:			VectorCopy (pvright, rr);
ADDRLP4 248
ADDRGP4 pvright
INDIRB
ASGNB 12
line 804
;804:		}
LABELV $860
line 806
;805:
;806:		VectorMA (org, -p->height, ru, point);	
ADDRLP4 288
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 292
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 288
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 292
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 288
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 292
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 807
;807:		VectorMA (point, -p->width, rr, point);	
ADDRLP4 296
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 296
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 296
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 808
;808:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 809
;809:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 810
;810:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 811
;811:		verts[0].modulate[0] = 111;	
ADDRLP4 12+20
CNSTU1 111
ASGNU1
line 812
;812:		verts[0].modulate[1] = 19;	
ADDRLP4 12+20+1
CNSTU1 19
ASGNU1
line 813
;813:		verts[0].modulate[2] = 9;	
ADDRLP4 12+20+2
CNSTU1 9
ASGNU1
line 814
;814:		verts[0].modulate[3] = 255 * alpha;	
ADDRLP4 304
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 308
CNSTF4 1325400064
ASGNF4
ADDRLP4 304
INDIRF4
ADDRLP4 308
INDIRF4
LTF4 $885
ADDRLP4 300
ADDRLP4 304
INDIRF4
ADDRLP4 308
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $886
JUMPV
LABELV $885
ADDRLP4 300
ADDRLP4 304
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $886
ADDRLP4 12+20+3
ADDRLP4 300
INDIRU4
CVUU1 4
ASGNU1
line 816
;815:
;816:		VectorMA (org, -p->height, ru, point);	
ADDRLP4 312
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 316
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 312
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 316
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 312
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 316
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 817
;817:		VectorMA (point, p->width, rr, point);	
ADDRLP4 320
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 818
;818:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 819
;819:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 820
;820:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 821
;821:		verts[1].modulate[0] = 111;	
ADDRLP4 12+24+20
CNSTU1 111
ASGNU1
line 822
;822:		verts[1].modulate[1] = 19;	
ADDRLP4 12+24+20+1
CNSTU1 19
ASGNU1
line 823
;823:		verts[1].modulate[2] = 9;	
ADDRLP4 12+24+20+2
CNSTU1 9
ASGNU1
line 824
;824:		verts[1].modulate[3] = 255 * alpha;	
ADDRLP4 328
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 332
CNSTF4 1325400064
ASGNF4
ADDRLP4 328
INDIRF4
ADDRLP4 332
INDIRF4
LTF4 $915
ADDRLP4 324
ADDRLP4 328
INDIRF4
ADDRLP4 332
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $916
JUMPV
LABELV $915
ADDRLP4 324
ADDRLP4 328
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $916
ADDRLP4 12+24+20+3
ADDRLP4 324
INDIRU4
CVUU1 4
ASGNU1
line 826
;825:
;826:		VectorMA (org, p->height, ru, point);	
ADDRLP4 336
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 340
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 336
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 340
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 336
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 340
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 827
;827:		VectorMA (point, p->width, rr, point);	
ADDRLP4 344
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 344
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 344
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 828
;828:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 829
;829:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 830
;830:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 831
;831:		verts[2].modulate[0] = 111;	
ADDRLP4 12+48+20
CNSTU1 111
ASGNU1
line 832
;832:		verts[2].modulate[1] = 19;	
ADDRLP4 12+48+20+1
CNSTU1 19
ASGNU1
line 833
;833:		verts[2].modulate[2] = 9;	
ADDRLP4 12+48+20+2
CNSTU1 9
ASGNU1
line 834
;834:		verts[2].modulate[3] = 255 * alpha;	
ADDRLP4 352
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 356
CNSTF4 1325400064
ASGNF4
ADDRLP4 352
INDIRF4
ADDRLP4 356
INDIRF4
LTF4 $945
ADDRLP4 348
ADDRLP4 352
INDIRF4
ADDRLP4 356
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $946
JUMPV
LABELV $945
ADDRLP4 348
ADDRLP4 352
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $946
ADDRLP4 12+48+20+3
ADDRLP4 348
INDIRU4
CVUU1 4
ASGNU1
line 836
;835:
;836:		VectorMA (org, p->height, ru, point);	
ADDRLP4 360
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 364
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 360
INDIRP4
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 364
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 360
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 364
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 837
;837:		VectorMA (point, -p->width, rr, point);	
ADDRLP4 368
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 368
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 368
INDIRP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 838
;838:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 839
;839:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 840
;840:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 841
;841:		verts[3].modulate[0] = 111;	
ADDRLP4 12+72+20
CNSTU1 111
ASGNU1
line 842
;842:		verts[3].modulate[1] = 19;	
ADDRLP4 12+72+20+1
CNSTU1 19
ASGNU1
line 843
;843:		verts[3].modulate[2] = 9;	
ADDRLP4 12+72+20+2
CNSTU1 9
ASGNU1
line 844
;844:		verts[3].modulate[3] = 255 * alpha;	
ADDRLP4 376
CNSTF4 1132396544
ADDRLP4 272
INDIRF4
MULF4
ASGNF4
ADDRLP4 380
CNSTF4 1325400064
ASGNF4
ADDRLP4 376
INDIRF4
ADDRLP4 380
INDIRF4
LTF4 $975
ADDRLP4 372
ADDRLP4 376
INDIRF4
ADDRLP4 380
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $976
JUMPV
LABELV $975
ADDRLP4 372
ADDRLP4 376
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $976
ADDRLP4 12+72+20+3
ADDRLP4 372
INDIRU4
CVUU1 4
ASGNU1
line 846
;845:
;846:	}
ADDRGP4 $854
JUMPV
LABELV $853
line 847
;847:	else if (p->type == P_FLAT_SCALEUP)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 9
NEI4 $977
line 848
;848:	{
line 852
;849:		float width, height;
;850:		float sinR, cosR;
;851:
;852:		if (p->color == BLOODRED)
ADDRFP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 2
NEI4 $979
line 853
;853:			VectorSet (color, 1, 1, 1);
ADDRLP4 264
CNSTF4 1065353216
ASGNF4
ADDRLP4 184
ADDRLP4 264
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 264
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1065353216
ASGNF4
ADDRGP4 $980
JUMPV
LABELV $979
line 855
;854:		else
;855:			VectorSet (color, 0.5, 0.5, 0.5);
ADDRLP4 268
CNSTF4 1056964608
ASGNF4
ADDRLP4 184
ADDRLP4 268
INDIRF4
ASGNF4
ADDRLP4 184+4
ADDRLP4 268
INDIRF4
ASGNF4
ADDRLP4 184+8
CNSTF4 1056964608
ASGNF4
LABELV $980
line 857
;856:		
;857:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 858
;858:		time2 = p->endtime - p->time;
ADDRLP4 272
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 272
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 272
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 859
;859:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 861
;860:
;861:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 276
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 280
ADDRLP4 276
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 256
ADDRLP4 280
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 276
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 280
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 862
;862:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 284
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 288
ADDRLP4 284
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 260
ADDRLP4 288
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 284
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 288
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 864
;863:
;864:		if (width > p->endwidth)
ADDRLP4 256
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
LEF4 $986
line 865
;865:			width = p->endwidth;
ADDRLP4 256
ADDRFP4 0
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ASGNF4
LABELV $986
line 867
;866:
;867:		if (height > p->endheight)
ADDRLP4 260
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
LEF4 $988
line 868
;868:			height = p->endheight;
ADDRLP4 260
ADDRFP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ASGNF4
LABELV $988
line 870
;869:
;870:		sinR = height * sin(DEG2RAD(p->roll)) * sqrt(2);
CNSTF4 1078530011
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
MULF4
CNSTF4 1127481344
DIVF4
ARGF4
ADDRLP4 292
ADDRGP4 sin
CALLF4
ASGNF4
CNSTF4 1073741824
ARGF4
ADDRLP4 296
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 248
ADDRLP4 260
INDIRF4
ADDRLP4 292
INDIRF4
MULF4
ADDRLP4 296
INDIRF4
MULF4
ASGNF4
line 871
;871:		cosR = width * cos(DEG2RAD(p->roll)) * sqrt(2);
CNSTF4 1078530011
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
MULF4
CNSTF4 1127481344
DIVF4
ARGF4
ADDRLP4 300
ADDRGP4 cos
CALLF4
ASGNF4
CNSTF4 1073741824
ARGF4
ADDRLP4 304
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRLP4 252
ADDRLP4 256
INDIRF4
ADDRLP4 300
INDIRF4
MULF4
ADDRLP4 304
INDIRF4
MULF4
ASGNF4
line 873
;872:
;873:		VectorCopy (org, verts[0].xyz);	
ADDRLP4 12
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 874
;874:		verts[0].xyz[0] -= sinR;
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 248
INDIRF4
SUBF4
ASGNF4
line 875
;875:		verts[0].xyz[1] -= cosR;
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRLP4 252
INDIRF4
SUBF4
ASGNF4
line 876
;876:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 877
;877:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 878
;878:		verts[0].modulate[0] = 255 * color[0];	
ADDRLP4 312
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 316
CNSTF4 1325400064
ASGNF4
ADDRLP4 312
INDIRF4
ADDRLP4 316
INDIRF4
LTF4 $996
ADDRLP4 308
ADDRLP4 312
INDIRF4
ADDRLP4 316
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $997
JUMPV
LABELV $996
ADDRLP4 308
ADDRLP4 312
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $997
ADDRLP4 12+20
ADDRLP4 308
INDIRU4
CVUU1 4
ASGNU1
line 879
;879:		verts[0].modulate[1] = 255 * color[1];	
ADDRLP4 324
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 328
CNSTF4 1325400064
ASGNF4
ADDRLP4 324
INDIRF4
ADDRLP4 328
INDIRF4
LTF4 $1002
ADDRLP4 320
ADDRLP4 324
INDIRF4
ADDRLP4 328
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1003
JUMPV
LABELV $1002
ADDRLP4 320
ADDRLP4 324
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1003
ADDRLP4 12+20+1
ADDRLP4 320
INDIRU4
CVUU1 4
ASGNU1
line 880
;880:		verts[0].modulate[2] = 255 * color[2];	
ADDRLP4 336
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 340
CNSTF4 1325400064
ASGNF4
ADDRLP4 336
INDIRF4
ADDRLP4 340
INDIRF4
LTF4 $1008
ADDRLP4 332
ADDRLP4 336
INDIRF4
ADDRLP4 340
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1009
JUMPV
LABELV $1008
ADDRLP4 332
ADDRLP4 336
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1009
ADDRLP4 12+20+2
ADDRLP4 332
INDIRU4
CVUU1 4
ASGNU1
line 881
;881:		verts[0].modulate[3] = 255;	
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 883
;882:
;883:		VectorCopy (org, verts[1].xyz);	
ADDRLP4 12+24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 884
;884:		verts[1].xyz[0] -= cosR;	
ADDRLP4 12+24
ADDRLP4 12+24
INDIRF4
ADDRLP4 252
INDIRF4
SUBF4
ASGNF4
line 885
;885:		verts[1].xyz[1] += sinR;	
ADDRLP4 12+24+4
ADDRLP4 12+24+4
INDIRF4
ADDRLP4 248
INDIRF4
ADDF4
ASGNF4
line 886
;886:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 887
;887:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 888
;888:		verts[1].modulate[0] = 255 * color[0];	
ADDRLP4 348
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 352
CNSTF4 1325400064
ASGNF4
ADDRLP4 348
INDIRF4
ADDRLP4 352
INDIRF4
LTF4 $1024
ADDRLP4 344
ADDRLP4 348
INDIRF4
ADDRLP4 352
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1025
JUMPV
LABELV $1024
ADDRLP4 344
ADDRLP4 348
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1025
ADDRLP4 12+24+20
ADDRLP4 344
INDIRU4
CVUU1 4
ASGNU1
line 889
;889:		verts[1].modulate[1] = 255 * color[1];	
ADDRLP4 360
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 364
CNSTF4 1325400064
ASGNF4
ADDRLP4 360
INDIRF4
ADDRLP4 364
INDIRF4
LTF4 $1031
ADDRLP4 356
ADDRLP4 360
INDIRF4
ADDRLP4 364
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1032
JUMPV
LABELV $1031
ADDRLP4 356
ADDRLP4 360
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1032
ADDRLP4 12+24+20+1
ADDRLP4 356
INDIRU4
CVUU1 4
ASGNU1
line 890
;890:		verts[1].modulate[2] = 255 * color[2];	
ADDRLP4 372
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 376
CNSTF4 1325400064
ASGNF4
ADDRLP4 372
INDIRF4
ADDRLP4 376
INDIRF4
LTF4 $1038
ADDRLP4 368
ADDRLP4 372
INDIRF4
ADDRLP4 376
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1039
JUMPV
LABELV $1038
ADDRLP4 368
ADDRLP4 372
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1039
ADDRLP4 12+24+20+2
ADDRLP4 368
INDIRU4
CVUU1 4
ASGNU1
line 891
;891:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 893
;892:
;893:		VectorCopy (org, verts[2].xyz);	
ADDRLP4 12+48
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 894
;894:		verts[2].xyz[0] += sinR;	
ADDRLP4 12+48
ADDRLP4 12+48
INDIRF4
ADDRLP4 248
INDIRF4
ADDF4
ASGNF4
line 895
;895:		verts[2].xyz[1] += cosR;	
ADDRLP4 12+48+4
ADDRLP4 12+48+4
INDIRF4
ADDRLP4 252
INDIRF4
ADDF4
ASGNF4
line 896
;896:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 897
;897:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 898
;898:		verts[2].modulate[0] = 255 * color[0];	
ADDRLP4 384
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 388
CNSTF4 1325400064
ASGNF4
ADDRLP4 384
INDIRF4
ADDRLP4 388
INDIRF4
LTF4 $1055
ADDRLP4 380
ADDRLP4 384
INDIRF4
ADDRLP4 388
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1056
JUMPV
LABELV $1055
ADDRLP4 380
ADDRLP4 384
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1056
ADDRLP4 12+48+20
ADDRLP4 380
INDIRU4
CVUU1 4
ASGNU1
line 899
;899:		verts[2].modulate[1] = 255 * color[1];	
ADDRLP4 396
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 400
CNSTF4 1325400064
ASGNF4
ADDRLP4 396
INDIRF4
ADDRLP4 400
INDIRF4
LTF4 $1062
ADDRLP4 392
ADDRLP4 396
INDIRF4
ADDRLP4 400
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1063
JUMPV
LABELV $1062
ADDRLP4 392
ADDRLP4 396
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1063
ADDRLP4 12+48+20+1
ADDRLP4 392
INDIRU4
CVUU1 4
ASGNU1
line 900
;900:		verts[2].modulate[2] = 255 * color[2];	
ADDRLP4 408
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 412
CNSTF4 1325400064
ASGNF4
ADDRLP4 408
INDIRF4
ADDRLP4 412
INDIRF4
LTF4 $1069
ADDRLP4 404
ADDRLP4 408
INDIRF4
ADDRLP4 412
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1070
JUMPV
LABELV $1069
ADDRLP4 404
ADDRLP4 408
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1070
ADDRLP4 12+48+20+2
ADDRLP4 404
INDIRU4
CVUU1 4
ASGNU1
line 901
;901:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 903
;902:
;903:		VectorCopy (org, verts[3].xyz);	
ADDRLP4 12+72
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 904
;904:		verts[3].xyz[0] += cosR;	
ADDRLP4 12+72
ADDRLP4 12+72
INDIRF4
ADDRLP4 252
INDIRF4
ADDF4
ASGNF4
line 905
;905:		verts[3].xyz[1] -= sinR;	
ADDRLP4 12+72+4
ADDRLP4 12+72+4
INDIRF4
ADDRLP4 248
INDIRF4
SUBF4
ASGNF4
line 906
;906:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 907
;907:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 908
;908:		verts[3].modulate[0] = 255 * color[0];	
ADDRLP4 420
CNSTF4 1132396544
ADDRLP4 184
INDIRF4
MULF4
ASGNF4
ADDRLP4 424
CNSTF4 1325400064
ASGNF4
ADDRLP4 420
INDIRF4
ADDRLP4 424
INDIRF4
LTF4 $1086
ADDRLP4 416
ADDRLP4 420
INDIRF4
ADDRLP4 424
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1087
JUMPV
LABELV $1086
ADDRLP4 416
ADDRLP4 420
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1087
ADDRLP4 12+72+20
ADDRLP4 416
INDIRU4
CVUU1 4
ASGNU1
line 909
;909:		verts[3].modulate[1] = 255 * color[1];	
ADDRLP4 432
CNSTF4 1132396544
ADDRLP4 184+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 436
CNSTF4 1325400064
ASGNF4
ADDRLP4 432
INDIRF4
ADDRLP4 436
INDIRF4
LTF4 $1093
ADDRLP4 428
ADDRLP4 432
INDIRF4
ADDRLP4 436
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1094
JUMPV
LABELV $1093
ADDRLP4 428
ADDRLP4 432
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1094
ADDRLP4 12+72+20+1
ADDRLP4 428
INDIRU4
CVUU1 4
ASGNU1
line 910
;910:		verts[3].modulate[2] = 255 * color[2];	
ADDRLP4 444
CNSTF4 1132396544
ADDRLP4 184+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 448
CNSTF4 1325400064
ASGNF4
ADDRLP4 444
INDIRF4
ADDRLP4 448
INDIRF4
LTF4 $1100
ADDRLP4 440
ADDRLP4 444
INDIRF4
ADDRLP4 448
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $1101
JUMPV
LABELV $1100
ADDRLP4 440
ADDRLP4 444
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $1101
ADDRLP4 12+72+20+2
ADDRLP4 440
INDIRU4
CVUU1 4
ASGNU1
line 911
;911:		verts[3].modulate[3] = 255;		
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 912
;912:	}
ADDRGP4 $978
JUMPV
LABELV $977
line 913
;913:	else if (p->type == P_FLAT)
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1105
line 914
;914:	{
line 916
;915:
;916:		VectorCopy (org, verts[0].xyz);	
ADDRLP4 12
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 917
;917:		verts[0].xyz[0] -= p->height;	
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
SUBF4
ASGNF4
line 918
;918:		verts[0].xyz[1] -= p->width;	
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
SUBF4
ASGNF4
line 919
;919:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 920
;920:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 921
;921:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 922
;922:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 923
;923:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 924
;924:		verts[0].modulate[3] = 255;	
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 926
;925:
;926:		VectorCopy (org, verts[1].xyz);	
ADDRLP4 12+24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 927
;927:		verts[1].xyz[0] -= p->height;	
ADDRLP4 12+24
ADDRLP4 12+24
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
SUBF4
ASGNF4
line 928
;928:		verts[1].xyz[1] += p->width;	
ADDRLP4 12+24+4
ADDRLP4 12+24+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDF4
ASGNF4
line 929
;929:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 930
;930:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 931
;931:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 932
;932:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 933
;933:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 934
;934:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 936
;935:
;936:		VectorCopy (org, verts[2].xyz);	
ADDRLP4 12+48
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 937
;937:		verts[2].xyz[0] += p->height;	
ADDRLP4 12+48
ADDRLP4 12+48
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDF4
ASGNF4
line 938
;938:		verts[2].xyz[1] += p->width;	
ADDRLP4 12+48+4
ADDRLP4 12+48+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ADDF4
ASGNF4
line 939
;939:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 940
;940:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 941
;941:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 942
;942:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 943
;943:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 944
;944:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 946
;945:
;946:		VectorCopy (org, verts[3].xyz);	
ADDRLP4 12+72
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 947
;947:		verts[3].xyz[0] += p->height;	
ADDRLP4 12+72
ADDRLP4 12+72
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDF4
ASGNF4
line 948
;948:		verts[3].xyz[1] -= p->width;	
ADDRLP4 12+72+4
ADDRLP4 12+72+4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
SUBF4
ASGNF4
line 949
;949:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 950
;950:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 951
;951:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 952
;952:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 953
;953:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 954
;954:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 956
;955:
;956:	}
ADDRGP4 $1106
JUMPV
LABELV $1105
line 958
;957:	// Ridah
;958:	else if (p->type == P_ANIM) {
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 6
NEI4 $1178
line 963
;959:		vec3_t	rr, ru;
;960:		vec3_t	rotate_ang;
;961:		int i, j;
;962:
;963:		time = cg.time - p->time;
ADDRLP4 232
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 964
;964:		time2 = p->endtime - p->time;
ADDRLP4 292
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 236
ADDRLP4 292
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 292
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 965
;965:		ratio = time / time2;
ADDRLP4 200
ADDRLP4 232
INDIRF4
ADDRLP4 236
INDIRF4
DIVF4
ASGNF4
line 966
;966:		if (ratio >= 1.0f) {
ADDRLP4 200
INDIRF4
CNSTF4 1065353216
LTF4 $1181
line 967
;967:			ratio = 0.9999f;
ADDRLP4 200
CNSTF4 1065351538
ASGNF4
line 968
;968:		}
LABELV $1181
line 970
;969:
;970:		width = p->width + ( ratio * ( p->endwidth - p->width) );
ADDRLP4 296
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 300
ADDRLP4 296
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
ASGNF4
ADDRLP4 196
ADDRLP4 300
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 296
INDIRP4
CNSTI4 84
ADDP4
INDIRF4
ADDRLP4 300
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 971
;971:		height = p->height + ( ratio * ( p->endheight - p->height) );
ADDRLP4 304
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 308
ADDRLP4 304
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ASGNF4
ADDRLP4 180
ADDRLP4 308
INDIRF4
ADDRLP4 200
INDIRF4
ADDRLP4 304
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ADDRLP4 308
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 974
;972:
;973:		// if we are "inside" this sprite, don't draw
;974:		if (Distance( cg.snap->ps.origin, org ) < width/1.5) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 312
ADDRGP4 Distance
CALLF4
ASGNF4
ADDRLP4 312
INDIRF4
ADDRLP4 196
INDIRF4
CNSTF4 1069547520
DIVF4
GEF4 $1183
line 975
;975:			return;
ADDRGP4 $243
JUMPV
LABELV $1183
line 978
;976:		}
;977:
;978:		i = p->shaderAnim;
ADDRLP4 272
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ASGNI4
line 979
;979:		j = (int)floor(ratio * shaderAnimCounts[p->shaderAnim]);
ADDRLP4 200
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimCounts
ADDP4
INDIRI4
CVIF4 4
MULF4
ARGF4
ADDRLP4 316
ADDRGP4 floor
CALLF4
ASGNF4
ADDRLP4 276
ADDRLP4 316
INDIRF4
CVFI4 4
ASGNI4
line 980
;980:		p->pshader = shaderAnims[i][j];
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 276
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 272
INDIRI4
CNSTI4 8
LSHI4
ADDRGP4 shaderAnims
ADDP4
ADDP4
INDIRI4
ASGNI4
line 982
;981:
;982:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1186
line 983
;983:			vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+109044+36
ARGP4
ADDRLP4 280
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 984
;984:			rotate_ang[ROLL] += p->roll;
ADDRLP4 280+8
ADDRLP4 280+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 985
;985:			AngleVectors ( rotate_ang, NULL, rr, ru);
ADDRLP4 280
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 260
ARGP4
ADDRLP4 248
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 986
;986:		}
LABELV $1186
line 988
;987:
;988:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1191
line 989
;989:			VectorMA (org, -height, ru, point);	
ADDRLP4 320
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 324
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 320
INDIRP4
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 320
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 248+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 990
;990:			VectorMA (point, -width, rr, point);	
ADDRLP4 328
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 260+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 991
;991:		} else {
ADDRGP4 $1192
JUMPV
LABELV $1191
line 992
;992:			VectorMA (org, -height, pvup, point);	
ADDRLP4 320
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 324
ADDRLP4 180
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 320
INDIRP4
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 320
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 324
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRGP4 pvup+8
INDIRF4
ADDRLP4 180
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 993
;993:			VectorMA (point, -width, pvright, point);	
ADDRLP4 328
ADDRLP4 196
INDIRF4
NEGF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 328
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
ADDRLP4 196
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 994
;994:		}
LABELV $1192
line 995
;995:		VectorCopy (point, verts[0].xyz);	
ADDRLP4 12
ADDRLP4 0
INDIRB
ASGNB 12
line 996
;996:		verts[0].st[0] = 0;	
ADDRLP4 12+12
CNSTF4 0
ASGNF4
line 997
;997:		verts[0].st[1] = 0;	
ADDRLP4 12+12+4
CNSTF4 0
ASGNF4
line 998
;998:		verts[0].modulate[0] = 255;	
ADDRLP4 12+20
CNSTU1 255
ASGNU1
line 999
;999:		verts[0].modulate[1] = 255;	
ADDRLP4 12+20+1
CNSTU1 255
ASGNU1
line 1000
;1000:		verts[0].modulate[2] = 255;	
ADDRLP4 12+20+2
CNSTU1 255
ASGNU1
line 1001
;1001:		verts[0].modulate[3] = 255;
ADDRLP4 12+20+3
CNSTU1 255
ASGNU1
line 1003
;1002:
;1003:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1223
line 1004
;1004:			VectorMA (point, 2*height, ru, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1005
;1005:		} else {
ADDRGP4 $1224
JUMPV
LABELV $1223
line 1006
;1006:			VectorMA (point, 2*height, pvup, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1007
;1007:		}
LABELV $1224
line 1008
;1008:		VectorCopy (point, verts[1].xyz);	
ADDRLP4 12+24
ADDRLP4 0
INDIRB
ASGNB 12
line 1009
;1009:		verts[1].st[0] = 0;	
ADDRLP4 12+24+12
CNSTF4 0
ASGNF4
line 1010
;1010:		verts[1].st[1] = 1;	
ADDRLP4 12+24+12+4
CNSTF4 1065353216
ASGNF4
line 1011
;1011:		verts[1].modulate[0] = 255;	
ADDRLP4 12+24+20
CNSTU1 255
ASGNU1
line 1012
;1012:		verts[1].modulate[1] = 255;	
ADDRLP4 12+24+20+1
CNSTU1 255
ASGNU1
line 1013
;1013:		verts[1].modulate[2] = 255;	
ADDRLP4 12+24+20+2
CNSTU1 255
ASGNU1
line 1014
;1014:		verts[1].modulate[3] = 255;	
ADDRLP4 12+24+20+3
CNSTU1 255
ASGNU1
line 1016
;1015:
;1016:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1254
line 1017
;1017:			VectorMA (point, 2*width, rr, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 260
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 260+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 260+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1018
;1018:		} else {
ADDRGP4 $1255
JUMPV
LABELV $1254
line 1019
;1019:			VectorMA (point, 2*width, pvright, point);	
ADDRLP4 320
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvright
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvright+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvright+8
INDIRF4
CNSTF4 1073741824
ADDRLP4 196
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1020
;1020:		}
LABELV $1255
line 1021
;1021:		VectorCopy (point, verts[2].xyz);	
ADDRLP4 12+48
ADDRLP4 0
INDIRB
ASGNB 12
line 1022
;1022:		verts[2].st[0] = 1;	
ADDRLP4 12+48+12
CNSTF4 1065353216
ASGNF4
line 1023
;1023:		verts[2].st[1] = 1;	
ADDRLP4 12+48+12+4
CNSTF4 1065353216
ASGNF4
line 1024
;1024:		verts[2].modulate[0] = 255;	
ADDRLP4 12+48+20
CNSTU1 255
ASGNU1
line 1025
;1025:		verts[2].modulate[1] = 255;	
ADDRLP4 12+48+20+1
CNSTU1 255
ASGNU1
line 1026
;1026:		verts[2].modulate[2] = 255;	
ADDRLP4 12+48+20+2
CNSTU1 255
ASGNU1
line 1027
;1027:		verts[2].modulate[3] = 255;	
ADDRLP4 12+48+20+3
CNSTU1 255
ASGNU1
line 1029
;1028:
;1029:		if (p->roll) {
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1285
line 1030
;1030:			VectorMA (point, -2*height, ru, point);	
ADDRLP4 320
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 248+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 248+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1031
;1031:		} else {
ADDRGP4 $1286
JUMPV
LABELV $1285
line 1032
;1032:			VectorMA (point, -2*height, pvup, point);	
ADDRLP4 320
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 pvup
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 pvup+4
INDIRF4
ADDRLP4 320
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 pvup+8
INDIRF4
CNSTF4 3221225472
ADDRLP4 180
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1033
;1033:		}
LABELV $1286
line 1034
;1034:		VectorCopy (point, verts[3].xyz);	
ADDRLP4 12+72
ADDRLP4 0
INDIRB
ASGNB 12
line 1035
;1035:		verts[3].st[0] = 1;	
ADDRLP4 12+72+12
CNSTF4 1065353216
ASGNF4
line 1036
;1036:		verts[3].st[1] = 0;	
ADDRLP4 12+72+12+4
CNSTF4 0
ASGNF4
line 1037
;1037:		verts[3].modulate[0] = 255;	
ADDRLP4 12+72+20
CNSTU1 255
ASGNU1
line 1038
;1038:		verts[3].modulate[1] = 255;	
ADDRLP4 12+72+20+1
CNSTU1 255
ASGNU1
line 1039
;1039:		verts[3].modulate[2] = 255;	
ADDRLP4 12+72+20+2
CNSTU1 255
ASGNU1
line 1040
;1040:		verts[3].modulate[3] = 255;	
ADDRLP4 12+72+20+3
CNSTU1 255
ASGNU1
line 1041
;1041:	}
LABELV $1178
LABELV $1106
LABELV $978
LABELV $854
LABELV $608
LABELV $473
LABELV $245
line 1044
;1042:	// done.
;1043:	
;1044:	if (!p->pshader) {
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1316
line 1047
;1045:// (SA) temp commented out for DM
;1046://		CG_Printf ("CG_AddParticleToScene type %d p->pshader == ZERO\n", p->type);
;1047:		return;
ADDRGP4 $243
JUMPV
LABELV $1316
line 1050
;1048:	}
;1049:
;1050:	if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT || p->type == P_WEATHER_FLURRY)
ADDRLP4 248
ADDRFP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 248
INDIRI4
CNSTI4 1
EQI4 $1321
ADDRLP4 248
INDIRI4
CNSTI4 5
EQI4 $1321
ADDRLP4 248
INDIRI4
CNSTI4 11
NEI4 $1318
LABELV $1321
line 1051
;1051:		trap_R_AddPolyToScene( p->pshader, 3, TRIverts );
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 108
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
ADDRGP4 $1319
JUMPV
LABELV $1318
line 1053
;1052:	else
;1053:		trap_R_AddPolyToScene( p->pshader, 4, verts );
ADDRFP4 0
INDIRP4
CNSTI4 68
ADDP4
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
LABELV $1319
line 1055
;1054:
;1055:}
LABELV $243
endproc CG_AddParticleToScene 472 16
data
align 4
LABELV roll
byte 4 0
export CG_AddParticles
code
proc CG_AddParticles 96 16
line 1066
;1056:
;1057:// Ridah, made this static so it doesn't interfere with other files
;1058:static float roll = 0.0;
;1059:
;1060:/*
;1061:===============
;1062:CG_AddParticles
;1063:===============
;1064:*/
;1065:void CG_AddParticles (void)
;1066:{
line 1076
;1067:	cparticle_t		*p, *next;
;1068:	float			alpha;
;1069:	float			time, time2;
;1070:	vec3_t			org;
;1071:	int				color;
;1072:	cparticle_t		*active, *tail;
;1073:	int				type;
;1074:	vec3_t			rotate_ang;
;1075:
;1076:	if (!initparticles)
ADDRGP4 initparticles
INDIRI4
CNSTI4 0
NEI4 $1323
line 1077
;1077:		CG_ClearParticles ();
ADDRGP4 CG_ClearParticles
CALLV
pop
LABELV $1323
line 1079
;1078:
;1079:	VectorCopy( cg.refdef.viewaxis[0], pvforward );
ADDRGP4 pvforward
ADDRGP4 cg+109044+36
INDIRB
ASGNB 12
line 1080
;1080:	VectorCopy( cg.refdef.viewaxis[1], pvright );
ADDRGP4 pvright
ADDRGP4 cg+109044+36+12
INDIRB
ASGNB 12
line 1081
;1081:	VectorCopy( cg.refdef.viewaxis[2], pvup );
ADDRGP4 pvup
ADDRGP4 cg+109044+36+24
INDIRB
ASGNB 12
line 1083
;1082:
;1083:	vectoangles( cg.refdef.viewaxis[0], rotate_ang );
ADDRGP4 cg+109044+36
ARGP4
ADDRLP4 48
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1084
;1084:	roll += ((cg.time - oldtime) * 0.1) ;
ADDRLP4 60
ADDRGP4 roll
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
CNSTF4 1036831949
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRGP4 oldtime
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1085
;1085:	rotate_ang[ROLL] += (roll*0.9);
ADDRLP4 48+8
ADDRLP4 48+8
INDIRF4
CNSTF4 1063675494
ADDRGP4 roll
INDIRF4
MULF4
ADDF4
ASGNF4
line 1086
;1086:	AngleVectors ( rotate_ang, rforward, rright, rup);
ADDRLP4 48
ARGP4
ADDRGP4 rforward
ARGP4
ADDRGP4 rright
ARGP4
ADDRGP4 rup
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1088
;1087:	
;1088:	oldtime = cg.time;
ADDRGP4 oldtime
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1090
;1089:
;1090:	active = NULL;
ADDRLP4 44
CNSTP4 0
ASGNP4
line 1091
;1091:	tail = NULL;
ADDRLP4 28
CNSTP4 0
ASGNP4
line 1093
;1092:
;1093:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1341
JUMPV
LABELV $1338
line 1094
;1094:	{
line 1096
;1095:
;1096:		next = p->next;
ADDRLP4 32
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1098
;1097:
;1098:		time = (cg.time - p->time)*0.001;
ADDRLP4 4
CNSTF4 981668463
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 1100
;1099:
;1100:		alpha = p->alpha + time*p->alphavel;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 1101
;1101:		if (alpha <= 0)
ADDRLP4 8
INDIRF4
CNSTF4 0
GTF4 $1343
line 1102
;1102:		{	// faded out
line 1103
;1103:			p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1104
;1104:			free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1105
;1105:			p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1106
;1106:			p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1107
;1107:			p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1108
;1108:			continue;
ADDRGP4 $1339
JUMPV
LABELV $1343
line 1111
;1109:		}
;1110:
;1111:		if (p->type == P_SMOKE || p->type == P_ANIM || p->type == P_BLEED || p->type == P_SMOKE_IMPACT)
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 3
EQI4 $1349
ADDRLP4 68
INDIRI4
CNSTI4 6
EQI4 $1349
ADDRLP4 68
INDIRI4
CNSTI4 8
EQI4 $1349
ADDRLP4 68
INDIRI4
CNSTI4 12
NEI4 $1345
LABELV $1349
line 1112
;1112:		{
line 1113
;1113:			if (cg.time > p->endtime)
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1350
line 1114
;1114:			{
line 1115
;1115:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1116
;1116:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1117
;1117:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1118
;1118:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1119
;1119:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1121
;1120:			
;1121:				continue;
ADDRGP4 $1339
JUMPV
LABELV $1350
line 1124
;1122:			}
;1123:
;1124:		}
LABELV $1345
line 1126
;1125:
;1126:		if (p->type == P_WEATHER_FLURRY)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 11
NEI4 $1353
line 1127
;1127:		{
line 1128
;1128:			if (cg.time > p->endtime)
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1355
line 1129
;1129:			{
line 1130
;1130:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1131
;1131:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1132
;1132:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1133
;1133:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1134
;1134:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1136
;1135:			
;1136:				continue;
ADDRGP4 $1339
JUMPV
LABELV $1355
line 1138
;1137:			}
;1138:		}
LABELV $1353
line 1141
;1139:
;1140:
;1141:		if (p->type == P_FLAT_SCALEUP_FADE)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 10
NEI4 $1358
line 1142
;1142:		{
line 1143
;1143:			if (cg.time > p->endtime)
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
LEF4 $1360
line 1144
;1144:			{
line 1145
;1145:				p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1146
;1146:				free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1147
;1147:				p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1148
;1148:				p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1149
;1149:				p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1150
;1150:				continue;
ADDRGP4 $1339
JUMPV
LABELV $1360
line 1153
;1151:			}
;1152:
;1153:		}
LABELV $1358
line 1155
;1154:
;1155:		if ((p->type == P_BAT || p->type == P_SPRITE) && p->endtime < 0) {
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 7
EQI4 $1365
ADDRLP4 72
INDIRI4
CNSTI4 15
NEI4 $1363
LABELV $1365
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 0
GEF4 $1363
line 1157
;1156:			// temporary sprite
;1157:			CG_AddParticleToScene (p, p->org, alpha);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRGP4 CG_AddParticleToScene
CALLV
pop
line 1158
;1158:			p->next = free_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1159
;1159:			free_particles = p;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1160
;1160:			p->type = 0;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1161
;1161:			p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1162
;1162:			p->alpha = 0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 0
ASGNF4
line 1163
;1163:			continue;
ADDRGP4 $1339
JUMPV
LABELV $1363
line 1166
;1164:		}
;1165:
;1166:		p->next = NULL;
ADDRLP4 0
INDIRP4
CNSTP4 0
ASGNP4
line 1167
;1167:		if (!tail)
ADDRLP4 28
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1366
line 1168
;1168:			active = tail = p;
ADDRLP4 28
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 44
ADDRLP4 0
INDIRP4
ASGNP4
ADDRGP4 $1367
JUMPV
LABELV $1366
line 1170
;1169:		else
;1170:		{
line 1171
;1171:			tail->next = p;
ADDRLP4 28
INDIRP4
ADDRLP4 0
INDIRP4
ASGNP4
line 1172
;1172:			tail = p;
ADDRLP4 28
ADDRLP4 0
INDIRP4
ASGNP4
line 1173
;1173:		}
LABELV $1367
line 1175
;1174:
;1175:		if (alpha > 1.0)
ADDRLP4 8
INDIRF4
CNSTF4 1065353216
LEF4 $1368
line 1176
;1176:			alpha = 1;
ADDRLP4 8
CNSTF4 1065353216
ASGNF4
LABELV $1368
line 1178
;1177:
;1178:		color = p->color;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
ASGNI4
line 1180
;1179:
;1180:		time2 = time*time;
ADDRLP4 12
ADDRLP4 4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1182
;1181:
;1182:		org[0] = p->org[0] + p->vel[0]*time + p->accel[0]*time2;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1183
;1183:		org[1] = p->org[1] + p->vel[1]*time + p->accel[1]*time2;
ADDRLP4 16+4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1184
;1184:		org[2] = p->org[2] + p->vel[2]*time + p->accel[2]*time2;
ADDRLP4 16+8
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1186
;1185:
;1186:		type = p->type;
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
line 1188
;1187:
;1188:		CG_AddParticleToScene (p, org, alpha);
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRGP4 CG_AddParticleToScene
CALLV
pop
line 1189
;1189:	}
LABELV $1339
line 1093
ADDRLP4 0
ADDRLP4 32
INDIRP4
ASGNP4
LABELV $1341
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1338
line 1191
;1190:
;1191:	active_particles = active;
ADDRGP4 active_particles
ADDRLP4 44
INDIRP4
ASGNP4
line 1192
;1192:}
LABELV $1322
endproc CG_AddParticles 96 16
export CG_ParticleSnowFlurry
proc CG_ParticleSnowFlurry 68 4
line 1200
;1193:
;1194:/*
;1195:======================
;1196:CG_AddParticles
;1197:======================
;1198:*/
;1199:void CG_ParticleSnowFlurry (qhandle_t pshader, centity_t *cent)
;1200:{
line 1202
;1201:	cparticle_t	*p;
;1202:	qboolean turb = qtrue;
ADDRLP4 4
CNSTI4 1
ASGNI4
line 1204
;1203:
;1204:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1373
line 1205
;1205:		CG_Printf ("CG_ParticleSnowFlurry pshader == ZERO!\n");
ADDRGP4 $1375
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1373
line 1207
;1206:
;1207:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1376
line 1208
;1208:		return;
ADDRGP4 $1372
JUMPV
LABELV $1376
line 1209
;1209:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1210
;1210:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1211
;1211:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1212
;1212:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1213
;1213:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1214
;1214:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1215
;1215:	p->alpha = 0.90f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1063675494
ASGNF4
line 1216
;1216:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1218
;1217:
;1218:	p->start = cent->currentState.origin2[0];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
ASGNF4
line 1219
;1219:	p->end = cent->currentState.origin2[1];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
ASGNF4
line 1221
;1220:	
;1221:	p->endtime = cg.time + cent->currentState.time;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1222
;1222:	p->startfade = cg.time + cent->currentState.time2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1224
;1223:	
;1224:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1226
;1225:	
;1226:	if (rand()%100 > 90)
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 100
MODI4
CNSTI4 90
LEI4 $1381
line 1227
;1227:	{
line 1228
;1228:		p->height = 32;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 1229
;1229:		p->width = 32;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 1230
;1230:		p->alpha = 0.10f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1036831949
ASGNF4
line 1231
;1231:	}
ADDRGP4 $1382
JUMPV
LABELV $1381
line 1233
;1232:	else
;1233:	{
line 1234
;1234:		p->height = 1;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1065353216
ASGNF4
line 1235
;1235:		p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1236
;1236:	}
LABELV $1382
line 1238
;1237:
;1238:	p->vel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3248488448
ASGNF4
line 1240
;1239:
;1240:	p->type = P_WEATHER_FLURRY;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 11
ASGNI4
line 1242
;1241:	
;1242:	if (turb)
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1383
line 1243
;1243:		p->vel[2] = -10;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3240099840
ASGNF4
LABELV $1383
line 1245
;1244:	
;1245:	VectorCopy(cent->currentState.origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1247
;1246:
;1247:	p->org[0] = p->org[0];
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ASGNF4
line 1248
;1248:	p->org[1] = p->org[1];
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
ASGNF4
line 1249
;1249:	p->org[2] = p->org[2];
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ASGNF4
line 1251
;1250:
;1251:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1253
;1252:	
;1253:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
line 1255
;1254:
;1255:	p->vel[0] += cent->currentState.angles[0] * 32 + (crandom() * 16);
ADDRLP4 40
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
CNSTF4 1107296256
ADDRFP4 4
INDIRP4
CNSTI4 116
ADDP4
INDIRF4
MULF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 40
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1256
;1256:	p->vel[1] += cent->currentState.angles[1] * 32 + (crandom() * 16);
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1107296256
ADDRFP4 4
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
MULF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ADDF4
ASGNF4
line 1257
;1257:	p->vel[2] += cent->currentState.angles[2];
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
ADDF4
ASGNF4
line 1259
;1258:
;1259:	if (turb)
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $1385
line 1260
;1260:	{
line 1261
;1261:		p->accel[0] = crandom () * 16;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1262
;1262:		p->accel[1] = crandom () * 16;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1263
;1263:	}
LABELV $1385
line 1265
;1264:
;1265:}
LABELV $1372
endproc CG_ParticleSnowFlurry 68 4
export CG_ParticleSnow
proc CG_ParticleSnow 56 4
line 1268
;1266:
;1267:void CG_ParticleSnow (qhandle_t pshader, vec3_t origin, vec3_t origin2, int turb, float range, int snum)
;1268:{
line 1271
;1269:	cparticle_t	*p;
;1270:
;1271:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1388
line 1272
;1272:		CG_Printf ("CG_ParticleSnow pshader == ZERO!\n");
ADDRGP4 $1390
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1388
line 1274
;1273:
;1274:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1391
line 1275
;1275:		return;
ADDRGP4 $1387
JUMPV
LABELV $1391
line 1276
;1276:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1277
;1277:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1278
;1278:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1279
;1279:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1280
;1280:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1281
;1281:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1282
;1282:	p->alpha = 0.40f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 1283
;1283:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1284
;1284:	p->start = origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1285
;1285:	p->end = origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1286
;1286:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1287
;1287:	p->height = 1;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1065353216
ASGNF4
line 1288
;1288:	p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1290
;1289:	
;1290:	p->vel[2] = -50;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3259498496
ASGNF4
line 1292
;1291:
;1292:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1394
line 1293
;1293:	{
line 1294
;1294:		p->type = P_WEATHER_TURBULENT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 5
ASGNI4
line 1295
;1295:		p->vel[2] = -50 * 1.3;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3263299584
ASGNF4
line 1296
;1296:	}
ADDRGP4 $1395
JUMPV
LABELV $1394
line 1298
;1297:	else
;1298:	{
line 1299
;1299:		p->type = P_WEATHER;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 1
ASGNI4
line 1300
;1300:	}
LABELV $1395
line 1302
;1301:	
;1302:	VectorCopy(origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1304
;1303:
;1304:	p->org[0] = p->org[0] + ( crandom() * range);
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1305
;1305:	p->org[1] = p->org[1] + ( crandom() * range);
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1306
;1306:	p->org[2] = p->org[2] + ( crandom() * (p->start - p->end)); 
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 20
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1308
;1307:
;1308:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 36
INDIRF4
ASGNF4
line 1310
;1309:	
;1310:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 44
INDIRF4
ASGNF4
line 1312
;1311:
;1312:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1396
line 1313
;1313:	{
line 1314
;1314:		p->vel[0] = crandom() * 16;
ADDRLP4 48
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 48
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1315
;1315:		p->vel[1] = crandom() * 16;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1316
;1316:	}
LABELV $1396
line 1319
;1317:
;1318:	// Rafael snow pvs check
;1319:	p->snum = snum;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 20
INDIRI4
ASGNI4
line 1320
;1320:	p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
line 1322
;1321:
;1322:}
LABELV $1387
endproc CG_ParticleSnow 56 4
export CG_ParticleBubble
proc CG_ParticleBubble 68 4
line 1325
;1323:
;1324:void CG_ParticleBubble (qhandle_t pshader, vec3_t origin, vec3_t origin2, int turb, float range, int snum)
;1325:{
line 1329
;1326:	cparticle_t	*p;
;1327:	float		randsize;
;1328:
;1329:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1399
line 1330
;1330:		CG_Printf ("CG_ParticleSnow pshader == ZERO!\n");
ADDRGP4 $1390
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1399
line 1332
;1331:
;1332:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1401
line 1333
;1333:		return;
ADDRGP4 $1398
JUMPV
LABELV $1401
line 1334
;1334:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1335
;1335:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1336
;1336:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1337
;1337:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1338
;1338:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1339
;1339:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1340
;1340:	p->alpha = 0.40f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 1341
;1341:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1342
;1342:	p->start = origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1343
;1343:	p->end = origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1344
;1344:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1346
;1345:	
;1346:	randsize = 1 + (crandom() * 0.5);
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
CNSTF4 1056964608
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 1348
;1347:	
;1348:	p->height = randsize;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 1349
;1349:	p->width = randsize;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 4
INDIRF4
ASGNF4
line 1351
;1350:	
;1351:	p->vel[2] = 50 + ( crandom() * 10 );
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1112014848
ADDF4
ASGNF4
line 1353
;1352:
;1353:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1404
line 1354
;1354:	{
line 1355
;1355:		p->type = P_BUBBLE_TURBULENT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 14
ASGNI4
line 1356
;1356:		p->vel[2] = 50 * 1.3;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1115815936
ASGNF4
line 1357
;1357:	}
ADDRGP4 $1405
JUMPV
LABELV $1404
line 1359
;1358:	else
;1359:	{
line 1360
;1360:		p->type = P_BUBBLE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 13
ASGNI4
line 1361
;1361:	}
LABELV $1405
line 1363
;1362:	
;1363:	VectorCopy(origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1365
;1364:
;1365:	p->org[0] = p->org[0] + ( crandom() * range);
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 16
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1366
;1366:	p->org[1] = p->org[1] + ( crandom() * range);
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 1367
;1367:	p->org[2] = p->org[2] + ( crandom() * (p->start - p->end)); 
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1369
;1368:
;1369:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 48
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 48
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 48
INDIRF4
ASGNF4
line 1371
;1370:	
;1371:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
line 1373
;1372:
;1373:	if (turb)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1406
line 1374
;1374:	{
line 1375
;1375:		p->vel[0] = crandom() * 4;
ADDRLP4 60
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 60
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1376
;1376:		p->vel[1] = crandom() * 4;
ADDRLP4 64
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 64
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 1377
;1377:	}
LABELV $1406
line 1380
;1378:
;1379:	// Rafael snow pvs check
;1380:	p->snum = snum;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 20
INDIRI4
ASGNI4
line 1381
;1381:	p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
line 1383
;1382:
;1383:}
LABELV $1398
endproc CG_ParticleBubble 68 4
export CG_ParticleSmoke
proc CG_ParticleSmoke 28 4
line 1386
;1384:
;1385:void CG_ParticleSmoke (qhandle_t pshader, centity_t *cent)
;1386:{
line 1392
;1387:
;1388:	// using cent->density = enttime
;1389:	//		 cent->frame = startfade
;1390:	cparticle_t	*p;
;1391:
;1392:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1409
line 1393
;1393:		CG_Printf ("CG_ParticleSmoke == ZERO!\n");
ADDRGP4 $1411
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1409
line 1395
;1394:
;1395:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1412
line 1396
;1396:		return;
ADDRGP4 $1408
JUMPV
LABELV $1412
line 1397
;1397:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1398
;1398:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1399
;1399:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1400
;1400:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1401
;1401:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1403
;1402:	
;1403:	p->endtime = cg.time + cent->currentState.time;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1404
;1404:	p->startfade = cg.time + cent->currentState.time2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1406
;1405:	
;1406:	p->color = 0;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 0
ASGNI4
line 1407
;1407:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1408
;1408:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1409
;1409:	p->start = cent->currentState.origin[2];
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ASGNF4
line 1410
;1410:	p->end = cent->currentState.origin2[2];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ASGNF4
line 1411
;1411:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1412
;1412:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1413
;1413:	p->height = 8;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ASGNF4
line 1414
;1414:	p->width = 8;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ASGNF4
line 1415
;1415:	p->endheight = 32;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1107296256
ASGNF4
line 1416
;1416:	p->endwidth = 32;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1107296256
ASGNF4
line 1417
;1417:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1419
;1418:	
;1419:	VectorCopy(cent->currentState.origin, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1421
;1420:
;1421:	p->vel[0] = p->vel[1] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
line 1422
;1422:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 16
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
line 1424
;1423:
;1424:	p->vel[2] = 5;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1084227584
ASGNF4
line 1426
;1425:
;1426:	if (cent->currentState.frame == 1)// reverse gravity	
ADDRFP4 4
INDIRP4
CNSTI4 172
ADDP4
INDIRI4
CNSTI4 1
NEI4 $1417
line 1427
;1427:		p->vel[2] *= -1;
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTF4 3212836864
ADDRLP4 20
INDIRP4
INDIRF4
MULF4
ASGNF4
LABELV $1417
line 1429
;1428:
;1429:	p->roll = 8 + (crandom() * 4);
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1090519040
ADDF4
CVFI4 4
ASGNI4
line 1430
;1430:}
LABELV $1408
endproc CG_ParticleSmoke 28 4
export CG_ParticleBulletDebris
proc CG_ParticleBulletDebris 16 0
line 1434
;1431:
;1432:
;1433:void CG_ParticleBulletDebris (vec3_t org, vec3_t vel, int duration)
;1434:{
line 1438
;1435:
;1436:	cparticle_t	*p;
;1437:
;1438:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1420
line 1439
;1439:		return;
ADDRGP4 $1419
JUMPV
LABELV $1420
line 1440
;1440:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1441
;1441:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1442
;1442:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1443
;1443:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1444
;1444:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1446
;1445:	
;1446:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1447
;1447:	p->startfade = cg.time + duration/2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
DIVI4
ADDI4
CVIF4 4
ASGNF4
line 1449
;1448:	
;1449:	p->color = EMISIVEFADE;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 3
ASGNI4
line 1450
;1450:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1451
;1451:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1453
;1452:
;1453:	p->height = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1056964608
ASGNF4
line 1454
;1454:	p->width = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1056964608
ASGNF4
line 1455
;1455:	p->endheight = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1056964608
ASGNF4
line 1456
;1456:	p->endwidth = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1056964608
ASGNF4
line 1458
;1457:
;1458:	p->pshader = cgs.media.tracerShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+152340+220
INDIRI4
ASGNI4
line 1460
;1459:
;1460:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1462
;1461:	
;1462:	VectorCopy(org, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 1464
;1463:
;1464:	p->vel[0] = vel[0];
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ASGNF4
line 1465
;1465:	p->vel[1] = vel[1];
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 1466
;1466:	p->vel[2] = vel[2];
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1467
;1467:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 8
INDIRF4
ASGNF4
line 1469
;1468:
;1469:	p->accel[2] = -60;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3262119936
ASGNF4
line 1470
;1470:	p->vel[2] += -20;
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 3248488448
ADDF4
ASGNF4
line 1472
;1471:	
;1472:}
LABELV $1419
endproc CG_ParticleBulletDebris 16 0
export CG_ParticleExplosion
proc CG_ParticleExplosion 16 8
line 1481
;1473:
;1474:/*
;1475:======================
;1476:CG_ParticleExplosion
;1477:======================
;1478:*/
;1479:
;1480:void CG_ParticleExplosion (char *animStr, vec3_t origin, vec3_t vel, int duration, int sizeStart, int sizeEnd)
;1481:{
line 1485
;1482:	cparticle_t	*p;
;1483:	int anim;
;1484:
;1485:	if (animStr < (char *)10)
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 10
GEU4 $1428
line 1486
;1486:		CG_Error( "CG_ParticleExplosion: animStr is probably an index rather than a string" );
ADDRGP4 $1430
ARGP4
ADDRGP4 CG_Error
CALLV
pop
LABELV $1428
line 1489
;1487:
;1488:	// find the animation string
;1489:	for (anim=0; shaderAnimNames[anim]; anim++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1434
JUMPV
LABELV $1431
line 1490
;1490:		if (!Q_stricmp( animStr, shaderAnimNames[anim] ))
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $1435
line 1491
;1491:			break;
ADDRGP4 $1433
JUMPV
LABELV $1435
line 1492
;1492:	}
LABELV $1432
line 1489
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1434
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1431
LABELV $1433
line 1493
;1493:	if (!shaderAnimNames[anim]) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimNames
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1437
line 1494
;1494:		CG_Error("CG_ParticleExplosion: unknown animation string: %s\n", animStr);
ADDRGP4 $1439
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 1495
;1495:		return;
ADDRGP4 $1427
JUMPV
LABELV $1437
line 1498
;1496:	}
;1497:
;1498:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1440
line 1499
;1499:		return;
ADDRGP4 $1427
JUMPV
LABELV $1440
line 1500
;1500:	p = free_particles;
ADDRLP4 4
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1501
;1501:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 4
INDIRP4
INDIRP4
ASGNP4
line 1502
;1502:	p->next = active_particles;
ADDRLP4 4
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1503
;1503:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 4
INDIRP4
ASGNP4
line 1504
;1504:	p->time = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1505
;1505:	p->alpha = 0.5;
ADDRLP4 4
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1056964608
ASGNF4
line 1506
;1506:	p->alphavel = 0;
ADDRLP4 4
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1508
;1507:
;1508:	if (duration < 0) {
ADDRFP4 12
INDIRI4
CNSTI4 0
GEI4 $1443
line 1509
;1509:		duration *= -1;
ADDRFP4 12
CNSTI4 -1
ADDRFP4 12
INDIRI4
MULI4
ASGNI4
line 1510
;1510:		p->roll = 0;
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1511
;1511:	} else {
ADDRGP4 $1444
JUMPV
LABELV $1443
line 1512
;1512:		p->roll = crandom()*179;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1127415808
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CVFI4 4
ASGNI4
line 1513
;1513:	}
LABELV $1444
line 1515
;1514:
;1515:	p->shaderAnim = anim;
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 1517
;1516:
;1517:	p->width = sizeStart;
ADDRLP4 4
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 16
INDIRI4
CVIF4 4
ASGNF4
line 1518
;1518:	p->height = sizeStart*shaderAnimSTRatio[anim];	// for sprites that are stretch in either direction
ADDRLP4 4
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 16
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimSTRatio
ADDP4
INDIRF4
MULF4
ASGNF4
line 1520
;1519:
;1520:	p->endheight = sizeEnd;
ADDRLP4 4
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 20
INDIRI4
CVIF4 4
ASGNF4
line 1521
;1521:	p->endwidth = sizeEnd*shaderAnimSTRatio[anim];
ADDRLP4 4
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 20
INDIRI4
CVIF4 4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 shaderAnimSTRatio
ADDP4
INDIRF4
MULF4
ASGNF4
line 1523
;1522:
;1523:	p->endtime = cg.time + duration;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1525
;1524:
;1525:	p->type = P_ANIM;
ADDRLP4 4
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 6
ASGNI4
line 1527
;1526:
;1527:	VectorCopy( origin, p->org );
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1528
;1528:	VectorCopy( vel, p->vel );
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 8
INDIRP4
INDIRB
ASGNB 12
line 1529
;1529:	VectorClear( p->accel );
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 12
INDIRF4
ASGNF4
line 1531
;1530:
;1531:}
LABELV $1427
endproc CG_ParticleExplosion 16 8
export CG_AddParticleShrapnel
proc CG_AddParticleShrapnel 0 0
line 1535
;1532:
;1533:// Rafael Shrapnel
;1534:void CG_AddParticleShrapnel (localEntity_t *le)
;1535:{
line 1536
;1536:	return;
LABELV $1446
endproc CG_AddParticleShrapnel 0 0
export CG_NewParticleArea
proc CG_NewParticleArea 92 24
line 1541
;1537:}
;1538:// done.
;1539:
;1540:int CG_NewParticleArea (int num)
;1541:{
line 1548
;1542:	// const char *str;
;1543:	char *str;
;1544:	char *token;
;1545:	int type;
;1546:	vec3_t origin, origin2;
;1547:	int		i;
;1548:	float range = 0;
ADDRLP4 40
CNSTF4 0
ASGNF4
line 1553
;1549:	int turb;
;1550:	int	numparticles;
;1551:	int	snum;
;1552:	
;1553:	str = (char *) CG_ConfigString (num);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 56
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 56
INDIRP4
ASGNP4
line 1554
;1554:	if (!str[0])
ADDRLP4 8
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $1448
line 1555
;1555:		return (0);
CNSTI4 0
RETI4
ADDRGP4 $1447
JUMPV
LABELV $1448
line 1558
;1556:	
;1557:	// returns type 128 64 or 32
;1558:	token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 60
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 60
INDIRP4
ASGNP4
line 1559
;1559:	type = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 64
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 36
ADDRLP4 64
INDIRI4
ASGNI4
line 1561
;1560:	
;1561:	if (type == 1)
ADDRLP4 36
INDIRI4
CNSTI4 1
NEI4 $1450
line 1562
;1562:		range = 128;
ADDRLP4 40
CNSTF4 1124073472
ASGNF4
ADDRGP4 $1451
JUMPV
LABELV $1450
line 1563
;1563:	else if (type == 2)
ADDRLP4 36
INDIRI4
CNSTI4 2
NEI4 $1452
line 1564
;1564:		range = 64;
ADDRLP4 40
CNSTF4 1115684864
ASGNF4
ADDRGP4 $1453
JUMPV
LABELV $1452
line 1565
;1565:	else if (type == 3)
ADDRLP4 36
INDIRI4
CNSTI4 3
NEI4 $1454
line 1566
;1566:		range = 32;
ADDRLP4 40
CNSTF4 1107296256
ASGNF4
ADDRGP4 $1455
JUMPV
LABELV $1454
line 1567
;1567:	else if (type == 0)
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $1456
line 1568
;1568:		range = 256;
ADDRLP4 40
CNSTF4 1132462080
ASGNF4
ADDRGP4 $1457
JUMPV
LABELV $1456
line 1569
;1569:	else if (type == 4)
ADDRLP4 36
INDIRI4
CNSTI4 4
NEI4 $1458
line 1570
;1570:		range = 8;
ADDRLP4 40
CNSTF4 1090519040
ASGNF4
ADDRGP4 $1459
JUMPV
LABELV $1458
line 1571
;1571:	else if (type == 5)
ADDRLP4 36
INDIRI4
CNSTI4 5
NEI4 $1460
line 1572
;1572:		range = 16;
ADDRLP4 40
CNSTF4 1098907648
ASGNF4
ADDRGP4 $1461
JUMPV
LABELV $1460
line 1573
;1573:	else if (type == 6)
ADDRLP4 36
INDIRI4
CNSTI4 6
NEI4 $1462
line 1574
;1574:		range = 32;
ADDRLP4 40
CNSTF4 1107296256
ASGNF4
ADDRGP4 $1463
JUMPV
LABELV $1462
line 1575
;1575:	else if (type == 7)
ADDRLP4 36
INDIRI4
CNSTI4 7
NEI4 $1464
line 1576
;1576:		range = 64;
ADDRLP4 40
CNSTF4 1115684864
ASGNF4
LABELV $1464
LABELV $1463
LABELV $1461
LABELV $1459
LABELV $1457
LABELV $1455
LABELV $1453
LABELV $1451
line 1579
;1577:
;1578:
;1579:	for (i=0; i<3; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1466
line 1580
;1580:	{
line 1581
;1581:		token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1582
;1582:		origin[i] = atof (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 1583
;1583:	}
LABELV $1467
line 1579
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1466
line 1585
;1584:
;1585:	for (i=0; i<3; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1470
line 1586
;1586:	{
line 1587
;1587:		token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1588
;1588:		origin2[i] = atof (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atof
CALLF4
ASGNF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 24
ADDP4
ADDRLP4 72
INDIRF4
ASGNF4
line 1589
;1589:	}
LABELV $1471
line 1585
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1470
line 1591
;1590:		
;1591:	token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 68
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 68
INDIRP4
ASGNP4
line 1592
;1592:	numparticles = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 72
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 48
ADDRLP4 72
INDIRI4
ASGNI4
line 1594
;1593:	
;1594:	token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 76
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 76
INDIRP4
ASGNP4
line 1595
;1595:	turb = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 80
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 44
ADDRLP4 80
INDIRI4
ASGNI4
line 1597
;1596:
;1597:	token = COM_Parse (&str);
ADDRLP4 8
ARGP4
ADDRLP4 84
ADDRGP4 COM_Parse
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 84
INDIRP4
ASGNP4
line 1598
;1598:	snum = atoi (token);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 88
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 52
ADDRLP4 88
INDIRI4
ASGNI4
line 1600
;1599:	
;1600:	for (i=0; i<numparticles; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $1477
JUMPV
LABELV $1474
line 1601
;1601:	{
line 1602
;1602:		if (type >= 4)
ADDRLP4 36
INDIRI4
CNSTI4 4
LTI4 $1478
line 1603
;1603:			CG_ParticleBubble (cgs.media.waterBubbleShader, origin, origin2, turb, range, snum);
ADDRGP4 cgs+152340+292
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 CG_ParticleBubble
CALLV
pop
ADDRGP4 $1479
JUMPV
LABELV $1478
line 1605
;1604:		else
;1605:			CG_ParticleSnow (cgs.media.waterBubbleShader, origin, origin2, turb, range, snum);
ADDRGP4 cgs+152340+292
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRLP4 24
ARGP4
ADDRLP4 44
INDIRI4
ARGI4
ADDRLP4 40
INDIRF4
ARGF4
ADDRLP4 52
INDIRI4
ARGI4
ADDRGP4 CG_ParticleSnow
CALLV
pop
LABELV $1479
line 1606
;1606:	}
LABELV $1475
line 1600
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1477
ADDRLP4 0
INDIRI4
ADDRLP4 48
INDIRI4
LTI4 $1474
line 1608
;1607:
;1608:	return (1);
CNSTI4 1
RETI4
LABELV $1447
endproc CG_NewParticleArea 92 24
export CG_SnowLink
proc CG_SnowLink 16 0
line 1612
;1609:}
;1610:
;1611:void	CG_SnowLink (centity_t *cent, qboolean particleOn)
;1612:{
line 1616
;1613:	cparticle_t		*p, *next;
;1614:	int id;
;1615:
;1616:	id = cent->currentState.frame;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 172
ADDP4
INDIRI4
ASGNI4
line 1618
;1617:
;1618:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1488
JUMPV
LABELV $1485
line 1619
;1619:	{
line 1620
;1620:		next = p->next;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1622
;1621:		
;1622:		if (p->type == P_WEATHER || p->type == P_WEATHER_TURBULENT)
ADDRLP4 12
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 1
EQI4 $1491
ADDRLP4 12
INDIRI4
CNSTI4 5
NEI4 $1489
LABELV $1491
line 1623
;1623:		{
line 1624
;1624:			if (p->snum == id)
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $1492
line 1625
;1625:			{
line 1626
;1626:				if (particleOn)
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $1494
line 1627
;1627:					p->link = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 1
ASGNI4
ADDRGP4 $1495
JUMPV
LABELV $1494
line 1629
;1628:				else
;1629:					p->link = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
CNSTI4 0
ASGNI4
LABELV $1495
line 1630
;1630:			}
LABELV $1492
line 1631
;1631:		}
LABELV $1489
line 1633
;1632:
;1633:	}
LABELV $1486
line 1618
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
LABELV $1488
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1485
line 1634
;1634:}
LABELV $1484
endproc CG_SnowLink 16 0
export CG_ParticleImpactSmokePuff
proc CG_ParticleImpactSmokePuff 24 4
line 1637
;1635:
;1636:void CG_ParticleImpactSmokePuff (qhandle_t pshader, vec3_t origin)
;1637:{
line 1640
;1638:	cparticle_t	*p;
;1639:
;1640:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1497
line 1641
;1641:		CG_Printf ("CG_ParticleImpactSmokePuff pshader == ZERO!\n");
ADDRGP4 $1499
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1497
line 1643
;1642:
;1643:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1500
line 1644
;1644:		return;
ADDRGP4 $1496
JUMPV
LABELV $1500
line 1645
;1645:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1646
;1646:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1647
;1647:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1648
;1648:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1649
;1649:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1650
;1650:	p->alpha = 0.25;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1048576000
ASGNF4
line 1651
;1651:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1652
;1652:	p->roll = crandom()*179;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTF4 1127415808
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CVFI4 4
ASGNI4
line 1654
;1653:
;1654:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1656
;1655:
;1656:	p->endtime = cg.time + 1000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 1000
ADDI4
CVIF4 4
ASGNF4
line 1657
;1657:	p->startfade = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
line 1659
;1658:
;1659:	p->width = rand()%4 + 8;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRLP4 8
INDIRI4
CNSTI4 4
MODI4
CNSTI4 8
ADDI4
CVIF4 4
ASGNF4
line 1660
;1660:	p->height = rand()%4 + 8;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRLP4 12
INDIRI4
CNSTI4 4
MODI4
CNSTI4 8
ADDI4
CVIF4 4
ASGNF4
line 1662
;1661:
;1662:	p->endheight = p->height *2;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1073741824
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
MULF4
ASGNF4
line 1663
;1663:	p->endwidth = p->width * 2;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1073741824
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
INDIRF4
MULF4
ASGNF4
line 1665
;1664:
;1665:	p->endtime = cg.time + 500;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 500
ADDI4
CVIF4 4
ASGNF4
line 1667
;1666:
;1667:	p->type = P_SMOKE_IMPACT;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 12
ASGNI4
line 1669
;1668:
;1669:	VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1670
;1670:	VectorSet(p->vel, 0, 0, 20);
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1101004800
ASGNF4
line 1671
;1671:	VectorSet(p->accel, 0, 0, 20);
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1101004800
ASGNF4
line 1673
;1672:
;1673:	p->rotate = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 1
ASGNI4
line 1674
;1674:}
LABELV $1496
endproc CG_ParticleImpactSmokePuff 24 4
export CG_Particle_Bleed
proc CG_Particle_Bleed 24 4
line 1677
;1675:
;1676:void CG_Particle_Bleed (qhandle_t pshader, vec3_t start, vec3_t dir, int fleshEntityNum, int duration)
;1677:{
line 1680
;1678:	cparticle_t	*p;
;1679:
;1680:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1507
line 1681
;1681:		CG_Printf ("CG_Particle_Bleed pshader == ZERO!\n");
ADDRGP4 $1509
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1507
line 1683
;1682:
;1683:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1510
line 1684
;1684:		return;
ADDRGP4 $1506
JUMPV
LABELV $1510
line 1685
;1685:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1686
;1686:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1687
;1687:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1688
;1688:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1689
;1689:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1690
;1690:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1691
;1691:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1692
;1692:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1694
;1693:
;1694:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1696
;1695:
;1696:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 16
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 1698
;1697:	
;1698:	if (fleshEntityNum)
ADDRFP4 12
INDIRI4
CNSTI4 0
EQI4 $1514
line 1699
;1699:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
ADDRGP4 $1515
JUMPV
LABELV $1514
line 1701
;1700:	else
;1701:		p->startfade = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
LABELV $1515
line 1703
;1702:
;1703:	p->width = 4;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1082130432
ASGNF4
line 1704
;1704:	p->height = 4;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1082130432
ASGNF4
line 1706
;1705:
;1706:	p->endheight = 4+rand()%3;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 4
INDIRI4
CNSTI4 3
MODI4
CNSTI4 4
ADDI4
CVIF4 4
ASGNF4
line 1707
;1707:	p->endwidth = p->endheight;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
INDIRF4
ASGNF4
line 1709
;1708:
;1709:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1711
;1710:
;1711:	VectorCopy( start, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1712
;1712:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1713
;1713:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1714
;1714:	p->vel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3248488448
ASGNF4
line 1715
;1715:	VectorClear( p->accel );
ADDRLP4 16
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 16
INDIRF4
ASGNF4
line 1717
;1716:
;1717:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1719
;1718:
;1719:	p->roll = rand()%179;
ADDRLP4 20
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 20
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1721
;1720:	
;1721:	p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 1722
;1722:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1724
;1723:
;1724:}
LABELV $1506
endproc CG_Particle_Bleed 24 4
export CG_Particle_OilParticle
proc CG_Particle_OilParticle 36 4
line 1727
;1725:
;1726:void CG_Particle_OilParticle (qhandle_t pshader, centity_t *cent)
;1727:{
line 1734
;1728:	cparticle_t	*p;
;1729:
;1730:	int			time;
;1731:	int			time2;
;1732:	float		ratio;
;1733:
;1734:	float	duration = 1500;
ADDRLP4 16
CNSTF4 1153138688
ASGNF4
line 1736
;1735:
;1736:	time = cg.time;
ADDRLP4 8
ADDRGP4 cg+107604
INDIRI4
ASGNI4
line 1737
;1737:	time2 = cg.time + cent->currentState.time;
ADDRLP4 12
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDI4
ASGNI4
line 1739
;1738:
;1739:	ratio =(float)1 - ((float)time / (float)time2);
ADDRLP4 4
CNSTF4 1065353216
ADDRLP4 8
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRI4
CVIF4 4
DIVF4
SUBF4
ASGNF4
line 1741
;1740:
;1741:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1521
line 1742
;1742:		CG_Printf ("CG_Particle_OilParticle == ZERO!\n");
ADDRGP4 $1523
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1521
line 1744
;1743:
;1744:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1524
line 1745
;1745:		return;
ADDRGP4 $1518
JUMPV
LABELV $1524
line 1746
;1746:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1747
;1747:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1748
;1748:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1749
;1749:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1750
;1750:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1751
;1751:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1752
;1752:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1753
;1753:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1755
;1754:
;1755:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1757
;1756:
;1757:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRLP4 16
INDIRF4
ADDF4
ASGNF4
line 1759
;1758:	
;1759:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1761
;1760:
;1761:	p->width = 1;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1065353216
ASGNF4
line 1762
;1762:	p->height = 3;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1077936128
ASGNF4
line 1764
;1763:
;1764:	p->endheight = 3;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1077936128
ASGNF4
line 1765
;1765:	p->endwidth = 1;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1065353216
ASGNF4
line 1767
;1766:
;1767:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 1769
;1768:
;1769:	VectorCopy(cent->currentState.origin, p->org );	
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1771
;1770:	
;1771:	p->vel[0] = (cent->currentState.origin2[0] * (16 * ratio));
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRF4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
MULF4
ASGNF4
line 1772
;1772:	p->vel[1] = (cent->currentState.origin2[1] * (16 * ratio));
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 108
ADDP4
INDIRF4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
MULF4
ASGNF4
line 1773
;1773:	p->vel[2] = (cent->currentState.origin2[2]);
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRF4
ASGNF4
line 1775
;1774:
;1775:	p->snum = 1.0f;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTI4 1
ASGNI4
line 1777
;1776:
;1777:	VectorClear( p->accel );
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1779
;1778:
;1779:	p->accel[2] = -20;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3248488448
ASGNF4
line 1781
;1780:
;1781:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1783
;1782:
;1783:	p->roll = rand()%179;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 32
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1785
;1784:	
;1785:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1787
;1786:
;1787:}
LABELV $1518
endproc CG_Particle_OilParticle 36 4
export CG_Particle_OilSlick
proc CG_Particle_OilSlick 36 4
line 1791
;1788:
;1789:
;1790:void CG_Particle_OilSlick (qhandle_t pshader, centity_t *cent)
;1791:{
line 1794
;1792:	cparticle_t	*p;
;1793:	
;1794:  	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1529
line 1795
;1795:		CG_Printf ("CG_Particle_OilSlick == ZERO!\n");
ADDRGP4 $1531
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1529
line 1797
;1796:
;1797:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1532
line 1798
;1798:		return;
ADDRGP4 $1528
JUMPV
LABELV $1532
line 1799
;1799:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1800
;1800:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1801
;1801:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1802
;1802:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1803
;1803:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1805
;1804:	
;1805:	if (cent->currentState.angles2[2])
ADDRFP4 4
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
CNSTF4 0
EQF4 $1535
line 1806
;1806:		p->endtime = cg.time + cent->currentState.angles2[2];
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ADDRFP4 4
INDIRP4
CNSTI4 136
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRGP4 $1536
JUMPV
LABELV $1535
line 1808
;1807:	else
;1808:		p->endtime = cg.time + 60000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 60000
ADDI4
CVIF4 4
ASGNF4
LABELV $1536
line 1810
;1809:
;1810:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1812
;1811:
;1812:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1813
;1813:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1814
;1814:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1816
;1815:
;1816:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1818
;1817:
;1818:	if (cent->currentState.angles2[0] || cent->currentState.angles2[1])
ADDRLP4 8
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
CNSTF4 0
ASGNF4
ADDRLP4 8
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
NEF4 $1541
ADDRLP4 8
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ADDRLP4 12
INDIRF4
EQF4 $1539
LABELV $1541
line 1819
;1819:	{
line 1820
;1820:		p->width = cent->currentState.angles2[0];
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ASGNF4
line 1821
;1821:		p->height = cent->currentState.angles2[0];
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
ASGNF4
line 1823
;1822:
;1823:		p->endheight = cent->currentState.angles2[1];
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ASGNF4
line 1824
;1824:		p->endwidth = cent->currentState.angles2[1];
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
ASGNF4
line 1825
;1825:	}
ADDRGP4 $1540
JUMPV
LABELV $1539
line 1827
;1826:	else
;1827:	{
line 1828
;1828:		p->width = 8;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ASGNF4
line 1829
;1829:		p->height = 8;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ASGNF4
line 1831
;1830:
;1831:		p->endheight = 16;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ASGNF4
line 1832
;1832:		p->endwidth = 16;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ASGNF4
line 1833
;1833:	}
LABELV $1540
line 1835
;1834:
;1835:	p->type = P_FLAT_SCALEUP;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 9
ASGNI4
line 1837
;1836:
;1837:	p->snum = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTI4 1
ASGNI4
line 1839
;1838:
;1839:	VectorCopy(cent->currentState.origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 1841
;1840:	
;1841:	p->org[2]+= 0.55 + (crandom() * 0.5);
ADDRLP4 16
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1056964608
CNSTF4 1073741824
ADDRLP4 16
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1057803469
ADDF4
ADDF4
ASGNF4
line 1843
;1842:
;1843:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1844
;1844:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1845
;1845:	p->vel[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 0
ASGNF4
line 1846
;1846:	VectorClear( p->accel );
ADDRLP4 28
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 28
INDIRF4
ASGNF4
line 1848
;1847:
;1848:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1850
;1849:
;1850:	p->roll = rand()%179;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 32
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1852
;1851:	
;1852:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1854
;1853:
;1854:}
LABELV $1528
endproc CG_Particle_OilSlick 36 4
export CG_OilSlickRemove
proc CG_OilSlickRemove 16 4
line 1857
;1855:
;1856:void CG_OilSlickRemove (centity_t *cent)
;1857:{
line 1861
;1858:	cparticle_t		*p, *next;
;1859:	int				id;
;1860:
;1861:	id = 1.0f;
ADDRLP4 8
CNSTI4 1
ASGNI4
line 1863
;1862:
;1863:	if (!id)
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $1543
line 1864
;1864:		CG_Printf ("CG_OilSlickRevove NULL id\n");
ADDRGP4 $1545
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1543
line 1866
;1865:
;1866:	for (p=active_particles ; p ; p=next)
ADDRLP4 0
ADDRGP4 active_particles
INDIRP4
ASGNP4
ADDRGP4 $1549
JUMPV
LABELV $1546
line 1867
;1867:	{
line 1868
;1868:		next = p->next;
ADDRLP4 4
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1870
;1869:		
;1870:		if (p->type == P_FLAT_SCALEUP)
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
INDIRI4
CNSTI4 9
NEI4 $1550
line 1871
;1871:		{
line 1872
;1872:			if (p->snum == id)
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRI4
ADDRLP4 8
INDIRI4
NEI4 $1552
line 1873
;1873:			{
line 1874
;1874:				p->endtime = cg.time + 100;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
ASGNF4
line 1875
;1875:				p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1876
;1876:				p->type = P_FLAT_SCALEUP_FADE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 10
ASGNI4
line 1878
;1877:
;1878:			}
LABELV $1552
line 1879
;1879:		}
LABELV $1550
line 1881
;1880:
;1881:	}
LABELV $1547
line 1866
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
LABELV $1549
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1546
line 1882
;1882:}
LABELV $1542
endproc CG_OilSlickRemove 16 4
export ValidBloodPool
proc ValidBloodPool 196 28
line 1885
;1883:
;1884:qboolean ValidBloodPool (vec3_t start)
;1885:{
line 1896
;1886:#define EXTRUDE_DIST	0.5
;1887:
;1888:	vec3_t	angles;
;1889:	vec3_t	right, up;
;1890:	vec3_t	this_pos, x_pos, center_pos, end_pos;
;1891:	float	x, y;
;1892:	float	fwidth, fheight;
;1893:	trace_t	trace;
;1894:	vec3_t	normal;
;1895:
;1896:	fwidth = 16;
ADDRLP4 152
CNSTF4 1098907648
ASGNF4
line 1897
;1897:	fheight = 16;
ADDRLP4 120
CNSTF4 1098907648
ASGNF4
line 1899
;1898:
;1899:	VectorSet (normal, 0, 0, 1);
ADDRLP4 168
CNSTF4 0
ASGNF4
ADDRLP4 96
ADDRLP4 168
INDIRF4
ASGNF4
ADDRLP4 96+4
ADDRLP4 168
INDIRF4
ASGNF4
ADDRLP4 96+8
CNSTF4 1065353216
ASGNF4
line 1901
;1900:
;1901:	vectoangles (normal, angles);
ADDRLP4 96
ARGP4
ADDRLP4 156
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1902
;1902:	AngleVectors (angles, NULL, right, up);
ADDRLP4 156
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 140
ARGP4
ADDRLP4 108
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 1904
;1903:
;1904:	VectorMA (start, EXTRUDE_DIST, normal, center_pos);
ADDRLP4 172
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 176
CNSTF4 1056964608
ASGNF4
ADDRLP4 128
ADDRLP4 172
INDIRP4
INDIRF4
ADDRLP4 176
INDIRF4
ADDRLP4 96
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 128+4
ADDRLP4 172
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 176
INDIRF4
ADDRLP4 96+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 128+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1056964608
ADDRLP4 96+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1906
;1905:
;1906:	for (x= -fwidth/2; x<fwidth; x+= fwidth)
ADDRLP4 124
ADDRLP4 152
INDIRF4
NEGF4
CNSTF4 1073741824
DIVF4
ASGNF4
ADDRGP4 $1565
JUMPV
LABELV $1562
line 1907
;1907:	{
line 1908
;1908:		VectorMA (center_pos, x, right, x_pos);
ADDRLP4 84
ADDRLP4 128
INDIRF4
ADDRLP4 140
INDIRF4
ADDRLP4 124
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 84+4
ADDRLP4 128+4
INDIRF4
ADDRLP4 140+4
INDIRF4
ADDRLP4 124
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 84+8
ADDRLP4 128+8
INDIRF4
ADDRLP4 140+8
INDIRF4
ADDRLP4 124
INDIRF4
MULF4
ADDF4
ASGNF4
line 1910
;1909:
;1910:		for (y= -fheight/2; y<fheight; y+= fheight)
ADDRLP4 12
ADDRLP4 120
INDIRF4
NEGF4
CNSTF4 1073741824
DIVF4
ASGNF4
ADDRGP4 $1575
JUMPV
LABELV $1572
line 1911
;1911:		{
line 1912
;1912:			VectorMA (x_pos, y, up, this_pos);
ADDRLP4 0
ADDRLP4 84
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 84+4
INDIRF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 84+8
INDIRF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 1913
;1913:			VectorMA (this_pos, -EXTRUDE_DIST*2, normal, end_pos);
ADDRLP4 188
CNSTF4 3212836864
ASGNF4
ADDRLP4 16
ADDRLP4 0
INDIRF4
ADDRLP4 188
INDIRF4
ADDRLP4 96
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 188
INDIRF4
ADDRLP4 96+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 16+8
ADDRLP4 0+8
INDIRF4
CNSTF4 3212836864
ADDRLP4 96+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1915
;1914:			
;1915:			CG_Trace (&trace, this_pos, NULL, NULL, end_pos, -1, CONTENTS_SOLID);
ADDRLP4 28
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 192
CNSTP4 0
ASGNP4
ADDRLP4 192
INDIRP4
ARGP4
ADDRLP4 192
INDIRP4
ARGP4
ADDRLP4 16
ARGP4
CNSTI4 -1
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 1918
;1916:
;1917:			
;1918:			if (trace.entityNum < (MAX_ENTITIES - 1)) // may only land on world
ADDRLP4 28+52
INDIRI4
CNSTI4 1022
GEI4 $1588
line 1919
;1919:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $1555
JUMPV
LABELV $1588
line 1921
;1920:
;1921:			if (!(!trace.startsolid && trace.fraction < 1))
ADDRLP4 28+4
INDIRI4
CNSTI4 0
NEI4 $1595
ADDRLP4 28+8
INDIRF4
CNSTF4 1065353216
LTF4 $1591
LABELV $1595
line 1922
;1922:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $1555
JUMPV
LABELV $1591
line 1924
;1923:		
;1924:		}
LABELV $1573
line 1910
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 120
INDIRF4
ADDF4
ASGNF4
LABELV $1575
ADDRLP4 12
INDIRF4
ADDRLP4 120
INDIRF4
LTF4 $1572
line 1925
;1925:	}
LABELV $1563
line 1906
ADDRLP4 124
ADDRLP4 124
INDIRF4
ADDRLP4 152
INDIRF4
ADDF4
ASGNF4
LABELV $1565
ADDRLP4 124
INDIRF4
ADDRLP4 152
INDIRF4
LTF4 $1562
line 1927
;1926:
;1927:	return qtrue;
CNSTI4 1
RETI4
LABELV $1555
endproc ValidBloodPool 196 28
export CG_BloodPool
proc CG_BloodPool 48 4
line 1931
;1928:}
;1929:
;1930:void CG_BloodPool (localEntity_t *le, qhandle_t pshader, trace_t *tr)
;1931:{	
line 1937
;1932:	cparticle_t	*p;
;1933:	qboolean	legit;
;1934:	vec3_t		start;
;1935:	float		rndSize;
;1936:	
;1937:	if (!pshader)
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $1597
line 1938
;1938:		CG_Printf ("CG_BloodPool pshader == ZERO!\n");
ADDRGP4 $1599
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1597
line 1940
;1939:
;1940:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1600
line 1941
;1941:		return;
ADDRGP4 $1596
JUMPV
LABELV $1600
line 1943
;1942:	
;1943:	VectorCopy (tr->endpos, start);
ADDRLP4 8
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
INDIRB
ASGNB 12
line 1944
;1944:	legit = ValidBloodPool (start);
ADDRLP4 8
ARGP4
ADDRLP4 24
ADDRGP4 ValidBloodPool
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 24
INDIRI4
ASGNI4
line 1946
;1945:
;1946:	if (!legit) 
ADDRLP4 20
INDIRI4
CNSTI4 0
NEI4 $1602
line 1947
;1947:		return;
ADDRGP4 $1596
JUMPV
LABELV $1602
line 1949
;1948:
;1949:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 1950
;1950:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 1951
;1951:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 1952
;1952:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 1953
;1953:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 1955
;1954:	
;1955:	p->endtime = cg.time + 3000;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 3000
ADDI4
CVIF4 4
ASGNF4
line 1956
;1956:	p->startfade = p->endtime;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 1958
;1957:
;1958:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 1959
;1959:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 1960
;1960:	p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 1962
;1961:
;1962:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 4
INDIRI4
ASGNI4
line 1964
;1963:
;1964:	rndSize = 0.4 + random()*0.6;
ADDRLP4 32
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
CNSTF4 1058642330
ADDRLP4 32
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1053609165
ADDF4
ASGNF4
line 1966
;1965:
;1966:	p->width = 8*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1090519040
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1967
;1967:	p->height = 8*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1090519040
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1969
;1968:
;1969:	p->endheight = 16*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1970
;1970:	p->endwidth = 16*rndSize;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 1972
;1971:	
;1972:	p->type = P_FLAT_SCALEUP;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 9
ASGNI4
line 1974
;1973:
;1974:	VectorCopy(start, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 8
INDIRB
ASGNB 12
line 1976
;1975:	
;1976:	p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 1977
;1977:	p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 1978
;1978:	p->vel[2] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 0
ASGNF4
line 1979
;1979:	VectorClear( p->accel );
ADDRLP4 40
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 40
INDIRF4
ASGNF4
line 1981
;1980:
;1981:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 1983
;1982:
;1983:	p->roll = rand()%179;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 44
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 1985
;1984:	
;1985:	p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 1987
;1986:	
;1987:	p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 1988
;1988:}
LABELV $1596
endproc CG_BloodPool 48 4
export CG_ParticleBloodCloud
proc CG_ParticleBloodCloud 84 16
line 1994
;1989:
;1990:#define NORMALSIZE	16
;1991:#define LARGESIZE	32
;1992:
;1993:void CG_ParticleBloodCloud (centity_t *cent, vec3_t origin, vec3_t dir)
;1994:{
line 2003
;1995:	float	length;
;1996:	float	dist;
;1997:	float	crittersize;
;1998:	vec3_t	angles, forward;
;1999:	vec3_t	point;
;2000:	cparticle_t	*p;
;2001:	int		i;
;2002:	
;2003:	dist = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
line 2005
;2004:
;2005:	length = VectorLength (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 56
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 40
ADDRLP4 56
INDIRF4
ASGNF4
line 2006
;2006:	vectoangles (dir, angles);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2007
;2007:	AngleVectors (angles, forward, NULL, NULL);
ADDRLP4 44
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 60
CNSTP4 0
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2009
;2008:
;2009:	crittersize = LARGESIZE;
ADDRLP4 16
CNSTF4 1107296256
ASGNF4
line 2011
;2010:
;2011:	if (length)
ADDRLP4 40
INDIRF4
CNSTF4 0
EQF4 $1607
line 2012
;2012:		dist = length / crittersize;
ADDRLP4 36
ADDRLP4 40
INDIRF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
LABELV $1607
line 2014
;2013:
;2014:	if (dist < 1)
ADDRLP4 36
INDIRF4
CNSTF4 1065353216
GEF4 $1609
line 2015
;2015:		dist = 1;
ADDRLP4 36
CNSTF4 1065353216
ASGNF4
LABELV $1609
line 2017
;2016:
;2017:	VectorCopy (origin, point);
ADDRLP4 4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2019
;2018:
;2019:	for (i=0; i<dist; i++)
ADDRLP4 32
CNSTI4 0
ASGNI4
ADDRGP4 $1614
JUMPV
LABELV $1611
line 2020
;2020:	{
line 2021
;2021:		VectorMA (point, crittersize, forward, point);	
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 20+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 20+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2023
;2022:		
;2023:		if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1621
line 2024
;2024:			return;
ADDRGP4 $1606
JUMPV
LABELV $1621
line 2026
;2025:
;2026:		p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2027
;2027:		free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2028
;2028:		p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2029
;2029:		active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2031
;2030:
;2031:		p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2032
;2032:		p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 2033
;2033:		p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2034
;2034:		p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 2036
;2035:
;2036:		p->pshader = cgs.media.smokePuffShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+152340+276
INDIRI4
ASGNI4
line 2038
;2037:
;2038:		p->endtime = cg.time + 350 + (crandom() * 100);
ADDRLP4 68
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 350
ADDI4
CVIF4 4
CNSTF4 1120403456
CNSTF4 1073741824
ADDRLP4 68
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2040
;2039:		
;2040:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2042
;2041:		
;2042:		p->width = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 2043
;2043:		p->height = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 2044
;2044:		p->endheight = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1107296256
ASGNF4
line 2045
;2045:		p->endwidth = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1107296256
ASGNF4
line 2047
;2046:
;2047:		p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2049
;2048:
;2049:		VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2051
;2050:		
;2051:		p->vel[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 0
ASGNF4
line 2052
;2052:		p->vel[1] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 0
ASGNF4
line 2053
;2053:		p->vel[2] = -1;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 3212836864
ASGNF4
line 2055
;2054:		
;2055:		VectorClear( p->accel );
ADDRLP4 76
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 76
INDIRF4
ASGNF4
line 2057
;2056:
;2057:		p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2059
;2058:
;2059:		p->roll = rand()%179;
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 80
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2061
;2060:		
;2061:		p->color = BLOODRED;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 2
ASGNI4
line 2063
;2062:		
;2063:		p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 2065
;2064:		
;2065:	}
LABELV $1612
line 2019
ADDRLP4 32
ADDRLP4 32
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1614
ADDRLP4 32
INDIRI4
CVIF4 4
ADDRLP4 36
INDIRF4
LTF4 $1611
line 2068
;2066:
;2067:	
;2068:}
LABELV $1606
endproc CG_ParticleBloodCloud 84 16
export CG_ParticleSparks
proc CG_ParticleSparks 60 0
line 2071
;2069:
;2070:void CG_ParticleSparks (vec3_t org, vec3_t vel, int duration, float x, float y, float speed)
;2071:{
line 2074
;2072:	cparticle_t	*p;
;2073:
;2074:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1629
line 2075
;2075:		return;
ADDRGP4 $1628
JUMPV
LABELV $1629
line 2076
;2076:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2077
;2077:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2078
;2078:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2079
;2079:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2080
;2080:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2082
;2081:	
;2082:	p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 2083
;2083:	p->startfade = cg.time + duration/2;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
DIVI4
ADDI4
CVIF4 4
ASGNF4
line 2085
;2084:	
;2085:	p->color = EMISIVEFADE;
ADDRLP4 0
INDIRP4
CNSTI4 48
ADDP4
CNSTI4 3
ASGNI4
line 2086
;2086:	p->alpha = 0.4f;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1053609165
ASGNF4
line 2087
;2087:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2089
;2088:
;2089:	p->height = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1056964608
ASGNF4
line 2090
;2090:	p->width = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1056964608
ASGNF4
line 2091
;2091:	p->endheight = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1056964608
ASGNF4
line 2092
;2092:	p->endwidth = 0.5;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1056964608
ASGNF4
line 2094
;2093:
;2094:	p->pshader = cgs.media.tracerShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+152340+220
INDIRI4
ASGNI4
line 2096
;2095:
;2096:	p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2098
;2097:	
;2098:	VectorCopy(org, p->org);
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 2100
;2099:
;2100:	p->org[0] += (crandom() * x);
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 4
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 2101
;2101:	p->org[1] += (crandom() * y);
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRFP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2103
;2102:
;2103:	p->vel[0] = vel[0];
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 4
INDIRP4
INDIRF4
ASGNF4
line 2104
;2104:	p->vel[1] = vel[1];
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ASGNF4
line 2105
;2105:	p->vel[2] = vel[2];
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
line 2107
;2106:
;2107:	p->accel[0] = p->accel[1] = p->accel[2] = 0;
ADDRLP4 24
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 24
INDIRF4
ASGNF4
line 2109
;2108:
;2109:	p->vel[0] += (crandom() * 4);
ADDRLP4 28
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 28
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2110
;2110:	p->vel[1] += (crandom() * 4);
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRF4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 36
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 2111
;2111:	p->vel[2] += (20 + (crandom() * 10)) * speed;	
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 48
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
CNSTF4 1092616192
CNSTF4 1073741824
ADDRLP4 44
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1101004800
ADDF4
ADDRFP4 20
INDIRF4
MULF4
ADDF4
ASGNF4
line 2113
;2112:
;2113:	p->accel[0] = crandom () * 4;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 52
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2114
;2114:	p->accel[1] = crandom () * 4;
ADDRLP4 56
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1082130432
CNSTF4 1073741824
ADDRLP4 56
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2116
;2115:	
;2116:}
LABELV $1628
endproc CG_ParticleSparks 60 0
export CG_ParticleDust
proc CG_ParticleDust 120 16
line 2119
;2117:
;2118:void CG_ParticleDust (centity_t *cent, vec3_t origin, vec3_t dir)
;2119:{
line 2128
;2120:	float	length;
;2121:	float	dist;
;2122:	float	crittersize;
;2123:	vec3_t	angles, forward;
;2124:	vec3_t	point;
;2125:	cparticle_t	*p;
;2126:	int		i;
;2127:	
;2128:	dist = 0;
ADDRLP4 40
CNSTF4 0
ASGNF4
line 2130
;2129:
;2130:	VectorNegate (dir, dir);
ADDRLP4 56
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 60
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
NEGF4
ASGNF4
ADDRLP4 64
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
NEGF4
ASGNF4
line 2131
;2131:	length = VectorLength (dir);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 32
ADDRLP4 68
INDIRF4
ASGNF4
line 2132
;2132:	vectoangles (dir, angles);
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 44
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 2133
;2133:	AngleVectors (angles, forward, NULL, NULL);
ADDRLP4 44
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 72
CNSTP4 0
ASGNP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRLP4 72
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2135
;2134:
;2135:	crittersize = LARGESIZE;
ADDRLP4 16
CNSTF4 1107296256
ASGNF4
line 2137
;2136:
;2137:	if (length)
ADDRLP4 32
INDIRF4
CNSTF4 0
EQF4 $1637
line 2138
;2138:		dist = length / crittersize;
ADDRLP4 40
ADDRLP4 32
INDIRF4
ADDRLP4 16
INDIRF4
DIVF4
ASGNF4
LABELV $1637
line 2140
;2139:
;2140:	if (dist < 1)
ADDRLP4 40
INDIRF4
CNSTF4 1065353216
GEF4 $1639
line 2141
;2141:		dist = 1;
ADDRLP4 40
CNSTF4 1065353216
ASGNF4
LABELV $1639
line 2143
;2142:
;2143:	VectorCopy (origin, point);
ADDRLP4 4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2145
;2144:
;2145:	for (i=0; i<dist; i++)
ADDRLP4 36
CNSTI4 0
ASGNI4
ADDRGP4 $1644
JUMPV
LABELV $1641
line 2146
;2146:	{
line 2147
;2147:		VectorMA (point, crittersize, forward, point);	
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 4+4
INDIRF4
ADDRLP4 20+4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
ADDRLP4 20+8
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ADDF4
ASGNF4
line 2149
;2148:				
;2149:		if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1651
line 2150
;2150:			return;
ADDRGP4 $1636
JUMPV
LABELV $1651
line 2152
;2151:
;2152:		p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2153
;2153:		free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2154
;2154:		p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2155
;2155:		active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2157
;2156:
;2157:		p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2158
;2158:		p->alpha = 5.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1084227584
ASGNF4
line 2159
;2159:		p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2160
;2160:		p->roll = 0;
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
CNSTI4 0
ASGNI4
line 2162
;2161:
;2162:		p->pshader = cgs.media.smokePuffShader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRGP4 cgs+152340+276
INDIRI4
ASGNI4
line 2165
;2163:
;2164:		// RF, stay around for long enough to expand and dissipate naturally
;2165:		if (length)
ADDRLP4 32
INDIRF4
CNSTF4 0
EQF4 $1656
line 2166
;2166:			p->endtime = cg.time + 4500 + (crandom() * 3500);
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 4500
ADDI4
CVIF4 4
CNSTF4 1163575296
CNSTF4 1073741824
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRGP4 $1657
JUMPV
LABELV $1656
line 2168
;2167:		else
;2168:			p->endtime = cg.time + 750 + (crandom() * 500);
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
CNSTI4 750
ADDI4
CVIF4 4
CNSTF4 1140457472
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
LABELV $1657
line 2170
;2169:		
;2170:		p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2172
;2171:		
;2172:		p->width = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
CNSTF4 1107296256
ASGNF4
line 2173
;2173:		p->height = LARGESIZE;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
CNSTF4 1107296256
ASGNF4
line 2176
;2174:
;2175:		// RF, expand while falling
;2176:		p->endheight = LARGESIZE*3.0;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1119879168
ASGNF4
line 2177
;2177:		p->endwidth = LARGESIZE*3.0;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1119879168
ASGNF4
line 2179
;2178:
;2179:		if (!length)
ADDRLP4 32
INDIRF4
CNSTF4 0
NEF4 $1661
line 2180
;2180:		{
line 2181
;2181:			p->width *= 0.2f;
ADDRLP4 88
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
CNSTF4 1045220557
ADDRLP4 88
INDIRP4
INDIRF4
MULF4
ASGNF4
line 2182
;2182:			p->height *= 0.2f;
ADDRLP4 92
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
CNSTF4 1045220557
ADDRLP4 92
INDIRP4
INDIRF4
MULF4
ASGNF4
line 2184
;2183:
;2184:			p->endheight = NORMALSIZE;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1098907648
ASGNF4
line 2185
;2185:			p->endwidth = NORMALSIZE;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1098907648
ASGNF4
line 2186
;2186:		}
LABELV $1661
line 2188
;2187:
;2188:		p->type = P_SMOKE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 3
ASGNI4
line 2190
;2189:
;2190:		VectorCopy( point, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 2192
;2191:		
;2192:		p->vel[0] = crandom()*6;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
CNSTF4 1086324736
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2193
;2193:		p->vel[1] = crandom()*6;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1086324736
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2194
;2194:		p->vel[2] = random()*20;
ADDRLP4 96
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTF4 1101004800
ADDRLP4 96
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ASGNF4
line 2197
;2195:
;2196:		// RF, add some gravity/randomness
;2197:		p->accel[0] = crandom()*3;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1077936128
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2198
;2198:		p->accel[1] = crandom()*3;
ADDRLP4 104
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1077936128
CNSTF4 1073741824
ADDRLP4 104
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 2199
;2199:		p->accel[2] = -PARTICLE_GRAVITY*0.4;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 3246391296
ASGNF4
line 2201
;2200:
;2201:		VectorClear( p->accel );
ADDRLP4 112
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 112
INDIRF4
ASGNF4
line 2203
;2202:
;2203:		p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2205
;2204:
;2205:		p->roll = rand()%179;
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 116
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2207
;2206:		
;2207:		p->alpha = 0.75;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1061158912
ASGNF4
line 2209
;2208:		
;2209:	}
LABELV $1642
line 2145
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $1644
ADDRLP4 36
INDIRI4
CVIF4 4
ADDRLP4 40
INDIRF4
LTF4 $1641
line 2212
;2210:
;2211:	
;2212:}
LABELV $1636
endproc CG_ParticleDust 120 16
export CG_ParticleMisc
proc CG_ParticleMisc 8 4
line 2215
;2213:
;2214:void CG_ParticleMisc (qhandle_t pshader, vec3_t origin, int size, int duration, float alpha)
;2215:{
line 2218
;2216:	cparticle_t	*p;
;2217:
;2218:	if (!pshader)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1664
line 2219
;2219:		CG_Printf ("CG_ParticleImpactSmokePuff pshader == ZERO!\n");
ADDRGP4 $1499
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
LABELV $1664
line 2221
;2220:
;2221:	if (!free_particles)
ADDRGP4 free_particles
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1666
line 2222
;2222:		return;
ADDRGP4 $1663
JUMPV
LABELV $1666
line 2224
;2223:
;2224:	p = free_particles;
ADDRLP4 0
ADDRGP4 free_particles
INDIRP4
ASGNP4
line 2225
;2225:	free_particles = p->next;
ADDRGP4 free_particles
ADDRLP4 0
INDIRP4
INDIRP4
ASGNP4
line 2226
;2226:	p->next = active_particles;
ADDRLP4 0
INDIRP4
ADDRGP4 active_particles
INDIRP4
ASGNP4
line 2227
;2227:	active_particles = p;
ADDRGP4 active_particles
ADDRLP4 0
INDIRP4
ASGNP4
line 2228
;2228:	p->time = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2229
;2229:	p->alpha = 1.0;
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1065353216
ASGNF4
line 2230
;2230:	p->alphavel = 0;
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 0
ASGNF4
line 2231
;2231:	p->roll = rand()%179;
ADDRLP4 4
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 4
INDIRI4
CNSTI4 179
MODI4
ASGNI4
line 2233
;2232:
;2233:	p->pshader = pshader;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 2235
;2234:
;2235:	if (duration > 0)
ADDRFP4 12
INDIRI4
CNSTI4 0
LEI4 $1669
line 2236
;2236:		p->endtime = cg.time + duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRGP4 cg+107604
INDIRI4
ADDRFP4 12
INDIRI4
ADDI4
CVIF4 4
ASGNF4
ADDRGP4 $1670
JUMPV
LABELV $1669
line 2238
;2237:	else
;2238:		p->endtime = duration;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 12
INDIRI4
CVIF4 4
ASGNF4
LABELV $1670
line 2240
;2239:
;2240:	p->startfade = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
ADDRGP4 cg+107604
INDIRI4
CVIF4 4
ASGNF4
line 2242
;2241:
;2242:	p->width = size;
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2243
;2243:	p->height = size;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2245
;2244:
;2245:	p->endheight = size;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2246
;2246:	p->endwidth = size;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 2248
;2247:
;2248:	p->type = P_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 15
ASGNI4
line 2250
;2249:
;2250:	VectorCopy( origin, p->org );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 2252
;2251:
;2252:	p->rotate = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
CNSTI4 0
ASGNI4
line 2253
;2253:}
LABELV $1663
endproc CG_ParticleMisc 8 4
bss
export oldtime
align 4
LABELV oldtime
skip 4
export rup
align 4
LABELV rup
skip 12
export rright
align 4
LABELV rright
skip 12
export rforward
align 4
LABELV rforward
skip 12
export pvup
align 4
LABELV pvup
skip 12
export pvright
align 4
LABELV pvright
skip 12
export pvforward
align 4
LABELV pvforward
skip 12
export particles
align 4
LABELV particles
skip 126976
export free_particles
align 4
LABELV free_particles
skip 4
export active_particles
align 4
LABELV active_particles
skip 4
align 4
LABELV numShaderAnims
skip 4
align 4
LABELV shaderAnims
skip 8192
align 4
LABELV markTotal
skip 4
export cg_freeMarkPolys
align 4
LABELV cg_freeMarkPolys
skip 4
export cg_activeMarkPolys
align 4
LABELV cg_activeMarkPolys
skip 288
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_R_RegisterFont
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_R_RemapShader
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_MakeExplosion
import CG_Bleed
import CG_BigExplode
import CG_GibPlayer
import CG_ScorePlum
import CG_SpawnEffect
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_OutOfAmmoChange
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_GrappleTrail
import CG_RailTrail
import CG_Bullet
import CG_ShotgunFire
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawString
import CG_DrawPic
import CG_FillRect
import CG_AdjustFrom640
import CG_DrawActiveFrame
import CG_AddBufferedSound
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_BuildSpectatorString
import CG_GetSelectedScore
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_trueLightning
import cg_oldPlasma
import cg_oldRocket
import cg_oldRail
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawAttacker
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPerson
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_brassTime
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_railTrailTime
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_gibs
import cg_shadows
import cg_swingSpeed
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
export cg_markPolys
align 4
LABELV cg_markPolys
skip 73728
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import bg_numItems
import bg_itemlist
import Pmove
import PM_UpdateViewAngles
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import PerpendicularVector
import AngleVectors
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $1599
byte 1 67
byte 1 71
byte 1 95
byte 1 66
byte 1 108
byte 1 111
byte 1 111
byte 1 100
byte 1 80
byte 1 111
byte 1 111
byte 1 108
byte 1 32
byte 1 112
byte 1 115
byte 1 104
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1545
byte 1 67
byte 1 71
byte 1 95
byte 1 79
byte 1 105
byte 1 108
byte 1 83
byte 1 108
byte 1 105
byte 1 99
byte 1 107
byte 1 82
byte 1 101
byte 1 118
byte 1 111
byte 1 118
byte 1 101
byte 1 32
byte 1 78
byte 1 85
byte 1 76
byte 1 76
byte 1 32
byte 1 105
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $1531
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 95
byte 1 79
byte 1 105
byte 1 108
byte 1 83
byte 1 108
byte 1 105
byte 1 99
byte 1 107
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1523
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 95
byte 1 79
byte 1 105
byte 1 108
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1509
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 95
byte 1 66
byte 1 108
byte 1 101
byte 1 101
byte 1 100
byte 1 32
byte 1 112
byte 1 115
byte 1 104
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1499
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 73
byte 1 109
byte 1 112
byte 1 97
byte 1 99
byte 1 116
byte 1 83
byte 1 109
byte 1 111
byte 1 107
byte 1 101
byte 1 80
byte 1 117
byte 1 102
byte 1 102
byte 1 32
byte 1 112
byte 1 115
byte 1 104
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1439
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 117
byte 1 110
byte 1 107
byte 1 110
byte 1 111
byte 1 119
byte 1 110
byte 1 32
byte 1 97
byte 1 110
byte 1 105
byte 1 109
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 32
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $1430
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 97
byte 1 110
byte 1 105
byte 1 109
byte 1 83
byte 1 116
byte 1 114
byte 1 32
byte 1 105
byte 1 115
byte 1 32
byte 1 112
byte 1 114
byte 1 111
byte 1 98
byte 1 97
byte 1 98
byte 1 108
byte 1 121
byte 1 32
byte 1 97
byte 1 110
byte 1 32
byte 1 105
byte 1 110
byte 1 100
byte 1 101
byte 1 120
byte 1 32
byte 1 114
byte 1 97
byte 1 116
byte 1 104
byte 1 101
byte 1 114
byte 1 32
byte 1 116
byte 1 104
byte 1 97
byte 1 110
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 116
byte 1 114
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $1411
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 109
byte 1 111
byte 1 107
byte 1 101
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1390
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 110
byte 1 111
byte 1 119
byte 1 32
byte 1 112
byte 1 115
byte 1 104
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $1375
byte 1 67
byte 1 71
byte 1 95
byte 1 80
byte 1 97
byte 1 114
byte 1 116
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 110
byte 1 111
byte 1 119
byte 1 70
byte 1 108
byte 1 117
byte 1 114
byte 1 114
byte 1 121
byte 1 32
byte 1 112
byte 1 115
byte 1 104
byte 1 97
byte 1 100
byte 1 101
byte 1 114
byte 1 32
byte 1 61
byte 1 61
byte 1 32
byte 1 90
byte 1 69
byte 1 82
byte 1 79
byte 1 33
byte 1 10
byte 1 0
align 1
LABELV $242
byte 1 37
byte 1 115
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $224
byte 1 101
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 100
byte 1 101
byte 1 49
byte 1 0
align 1
LABELV $98
byte 1 67
byte 1 71
byte 1 95
byte 1 73
byte 1 109
byte 1 112
byte 1 97
byte 1 99
byte 1 116
byte 1 77
byte 1 97
byte 1 114
byte 1 107
byte 1 32
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 60
byte 1 61
byte 1 32
byte 1 48
byte 1 32
byte 1 114
byte 1 97
byte 1 100
byte 1 105
byte 1 117
byte 1 115
byte 1 0
align 1
LABELV $81
byte 1 67
byte 1 71
byte 1 95
byte 1 70
byte 1 114
byte 1 101
byte 1 101
byte 1 76
byte 1 111
byte 1 99
byte 1 97
byte 1 108
byte 1 69
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 58
byte 1 32
byte 1 110
byte 1 111
byte 1 116
byte 1 32
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 101
byte 1 0
