#!/bin/bash

DIR=$1
FILES=$(find $DIR/locale -type f -name 'pointlinux-installer.po')

for FILE in $FILES; do
  echo $FILE
  NEWFILE=$(echo $FILE | sed 's/.po$/.mo/g')
  msgfmt $FILE -o $NEWFILE
  if [ -e $NEWFILE ]; then
    rm -rf $FILE
  else
    echo "Error converting!"
    exit 1
  fi
done

cp -r $DIR/pointlinux-installer/* $DIR/debian/pointlinux-installer
cp -r $DIR/locale $DIR/debian/pointlinux-installer/usr/share
