#!/bin/bash

DIR=$1

mkdir -p $DIR/usr/share/icons
cd $DIR/usr/share/icons

if ! wget -c https://faenza-icon-theme.googlecode.com/files/faenza-icon-theme_1.3.zip; then
  echo "Could not download package"
  exit 1
fi

unzip faenza-icon-theme_1.3.zip

rm faenza-icon-theme_1.3.zip

shopt -s extglob
rm !(Faenza.tar.gz|Faenza-Dark.tar.gz)

for FILE in $(ls .); do
  tar -zxvf $FILE
done

rm *.tar.gz

mv Faenza PointLinux-Faenza
mv Faenza-Dark PointLinux-Faenza-Dark
sed -i 's/Name=Faenza/Name=Point Linux Faenza/g' PointLinux-Faenza/index.theme
sed -i 's/Faenza/Faenza\nExample=distributor-logo/g' PointLinux-Faenza/index.theme
sed -i 's/Name=Faenza/Name=Point Linux Faenza/g' PointLinux-Faenza-Dark/index.theme
sed -i 's/Inherits=Faenza/Inherits=PointLinux-Faenza/g' PointLinux-Faenza-Dark/index.theme

for FILE in *-logo*.* start-here*.* gnome-main-menu.* novell-button.*; do
  find . -name $FILE -print0 | xargs -0 rm
done

find . -type f -exec chmod 644 '{}' \;
#delete broken links
find . -type l ! -exec test -e {} \; -exec rm {} \;
#delete empty dirs
find . -type d -depth -empty -delete

LN="ln -sf"
for SIZE in 16 22 24 32 48 64 96 scalable; do
  cd $DIR/usr/share/icons/PointLinux-Faenza/places/$SIZE
  if [ $SIZE = "scalable" ]; then
    cp $DIR/icons/start-here.svg .
    cp $DIR/icons/distributor-logo.svg .
    EXT=svg
  else
    #convert -resize $SIZE -format PNG24 -background transparent $DIR/icons/start-here.svg start-here.png
    convert -resize $SIZE -format PNG24 -background transparent $DIR/icons/distributor-logo.svg distributor-logo.png
    EXT=png
  fi
  $LN distributor-logo.$EXT gnome-main-menu.$EXT
  $LN distributor-logo.$EXT novell-button.$EXT

  cd $DIR/usr/share/icons/PointLinux-Faenza/apps/$SIZE
  $LN gnome-network-properties.$EXT mate-network-properties.$EXT
  $LN gnome-power-manager.$EXT mate-power-statistics.$EXT
  $LN ../../devices/$SIZE/battery.$EXT mate-power-manager.$EXT
  $LN menu-editor.$EXT mozo.$EXT
  $LN file-roller.$EXT engrampa.$EXT
  $LN eog.$EXT eom.$EXT
  $LN gnome-display-properties.$EXT mate-preferences-desktop-display.$EXT
  $LN ../../categories/$SIZE/preferences-desktop.$EXT mateconf-editor.$EXT
  $LN ../../categories/$SIZE/preferences-desktop.$EXT mate-session-properties.$EXT
  $LN gtk-info.$EXT mate-notification-properties.$EXT
  $LN evince.$EXT atril.$EXT
  $LN openjdk-6.$EXT javaws.$EXT
  $LN gtk-info.$EXT hook-notifier.$EXT
  $LN baobab.$EXT mate-disk-usage-analyzer.$EXT
done

cp -r $DIR/usr $DIR/debian/pointlinux-faenza-icon-theme
