/*****************************************************************************
 * interface.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#ifndef _INTERFACE_H_
#define _INTERFACE_H_

#include "friends.h"

extern GtkWidget *bd_tree;

extern GtkWidget *bimdiag_window;
extern GtkWidget *bimdiag_radio1;
extern GtkWidget *bimdiag_radio2;
extern GtkWidget *bimdiag_radio3;
extern GtkWidget *bimdiag_entry1;
extern GtkWidget *bimdiag_entry2;
extern GtkWidget *bimdiag_check1;
extern GtkWidget *bimdiag_check2;
extern GtkWidget *bimdiag_check3;
extern GtkWidget *bimdiag_check4;
extern GtkWidget *bimdiag_size_radio1;
extern GtkWidget *bimdiag_size_radio2;
extern GtkWidget *bimdiag_size_radio3;
extern GtkWidget *bimdiag_image1;
extern GtkWidget *bimdiag_image2;
extern GtkWidget *login_credentials;

extern GtkWidget *chatroom_user_pane;
extern GtkWidget *emotes_pane;
extern GtkWidget *chatroom_input_pane;
extern GtkWidget *add_to_favorites_menuitem;
extern GtkWidget *conf_invite1;
extern GtkWidget *conf_invite2;
extern GtkWidget *conf_invite3;
extern GtkWidget *conf_invite4;
extern GtkWidget *conf_leave1;
extern GtkWidget *conf_leave2;
extern GtkWidget *conf_invite6;  /* trayicon.c */
extern GtkWidget *conf_invite7;  /* trayicon.c */
extern char *bimage_browsed_file;

extern GtkWidget *create_bimage_select_window(GtkWidget *parent);

extern GtkWidget *create_window1 (void);
extern GtkWidget *create_user_menu (GtkWidget *parent);
extern GtkWidget *create_login_window (void);
extern GtkWidget *create_profile_window(GtkWidget *parent);
extern GtkWidget *create_alias_menu(GtkWidget *parent);
extern GtkWidget *create_alias_window(GtkWidget *parent);
extern GtkWidget *create_find_window(void);
extern int find_tab_posn(char *tab_name);

extern GtkWidget *create_buddy_list_tab();
extern GtkWidget *create_budlist_popup_menu(GtkWidget *parent);
extern GtkWidget *create_budgrp_popup_menu(GtkWidget *parent);

extern GtkWidget* create_stealth_window(GtkWidget *parent, char *who);
extern GtkWidget *get_pixmapped_button(char *button_label, const gchar *stock_id);

/* added PhrozenSmoke: common dialogs */
extern void show_ok_dialog(char *mymsg);
extern void show_ok_dialog_p(GtkWidget *parent, char *mymsg);
extern gboolean on_close_bimage_select_window(GtkWidget *widget, gpointer user_data);

extern GtkWidget *show_confirm_dialog(char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel);
extern GtkWidget *show_confirm_dialog_config_p(GtkWidget *parent, char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel, int with_callback);
extern GtkWidget *show_input_dialog(GtkWidget *parent, char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel);
extern GtkWidget *create_list_dialog(GtkWidget *parent, char *wintitle, char *header, char *ldefault, GList *comblist, int editable, const char *stock_id);

typedef enum {SAVE, OPEN} SAVE_OPEN;
char *gyachi_file_browser(GtkWidget *parent, const char *full_path_filename, SAVE_OPEN mode);
void select_file_to_send(GtkWidget *parent, char *filename, char *user_for_file);

void show_credentials_box(GtkWidget *window, GdkPixbuf *imbuf);
extern GtkWidget *create_yremove_window(GtkWidget *parent);
extern GtkWidget *create_yprivacy_window(GtkWidget *parent);

GtkWidget *get_smiley_button(char *filename, int allow_fail);
void show_smiley_window_chat(GtkWidget *button, gpointer user_data);
void show_smiley_window_pm(GtkWidget *button, gpointer user_data);

extern int num_dialogs_too_fast;
extern GHashTable *buddy_status;
extern int dialogs_opening_too_fast();
extern void reset_buddy_groups();

extern void refresh_buddy_clist();
extern void update_buddy_clist(char *buddy_name);

extern GtkWidget *get_stocki_button(const gchar *stock_id, char *tip, GtkIconSize size);
extern gboolean on_close_ok_dialog(GtkWidget *widget, gpointer user_data);
extern gboolean on_close_ok_dialogw(GtkWidget *widget, GdkEvent *event, gpointer user_data);

extern void show_mail_stat(char *mailcount);

#endif

