/*****************************************************************************
 * gyache-libnotify.c, Plugin to use libnotify for displaying
 * notifications.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007, Gregory D Hosler (ghosler ['at'] users.sourceforge.net)
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#include <string.h>
#include <libnotify/notification.h>
#include <libnotify/notify.h>

#include "plugin_api.h"
#include "trayicon.h"
#include "notify.h"

#include "theme_support.h"

#include "gy_config.h"


int libnotify_init();
void gyachi_libnotify(char *mytitle, char *mymsg, const char *stock_id, int timeout);

PLUGIN_INFO plugin_info = {
	.type = PLUGIN_GENERIC, 
	.module_name = "GyachI-libNotify",
	.description = "A plugin to use the libnotify api to post notifications, using the notifier", 
	.version     = "0.1", 
	.date        = "18/12/2007",
	.credits     = "Gregory D Hosler [ghosler ('at') users.sourceforge.net]",
	.sys_req     = "libnotify",
	.init        = libnotify_init};


int libnotify_init() {
	int rv;

	rv = notify_init("Gyachi");
	if (!rv) return 0;
	set_notify_callback(gyachi_libnotify);
	return 1;
}


void gyachi_libnotify(char *mytitle, char *mymsg, const char *stock_id, int timeout)
{
	NotifyNotification* my_popup;
	GtkWidget *win;
	GdkPixbuf *icon_pixbuf;
	GError *my_error;
	int rv;

	/* ugly hack, borrowed from gaim... */
	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_widget_realize(win);

	my_popup=notify_notification_new_with_status_icon(mytitle, mymsg, NULL, popup_attach_systray?systray_get_status_icon():NULL);
	if (stock_id) {
		icon_pixbuf = gtk_widget_render_icon(win, stock_id, (strcmp(stock_id, GYACHI_MAIL) == 0) ? GYACHI_ICON_SIZE_MAIL: GTK_ICON_SIZE_LARGE_TOOLBAR, "gvwindow");
		if (icon_pixbuf) {
			notify_notification_set_icon_from_pixbuf(my_popup, icon_pixbuf);
		}
		g_object_unref(icon_pixbuf);
	}
	notify_notification_set_timeout(my_popup, timeout);
	my_error = 0;
	rv = notify_notification_show(my_popup, &my_error);
	g_object_unref(G_OBJECT(my_popup));
	gtk_widget_destroy(win);
}
