# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains endpoints and data types for user management.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        common,
        team_common,
        team_policies,
        users_common,
    )
except (ImportError, SystemError, ValueError):
    import common
    import team_common
    import team_policies
    import users_common

class Account(bb.Struct):
    """
    The amount of detail revealed about an account depends on the user being
    queried and the user making the query.

    :ivar users.Account.account_id: The user's unique Dropbox ID.
    :ivar users.Account.name: Details of a user's name.
    :ivar users.Account.email: The user's e-mail address. Do not rely on this
        without checking the ``email_verified`` field. Even then, it's possible
        that the user has since lost access to their e-mail.
    :ivar users.Account.email_verified: Whether the user has verified their
        e-mail address.
    :ivar users.Account.profile_photo_url: URL for the photo representing the
        user, if one is set.
    :ivar users.Account.disabled: Whether the user has been disabled.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
        '_name_value',
        '_name_present',
        '_email_value',
        '_email_present',
        '_email_verified_value',
        '_email_verified_present',
        '_profile_photo_url_value',
        '_profile_photo_url_present',
        '_disabled_value',
        '_disabled_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None,
                 name=None,
                 email=None,
                 email_verified=None,
                 disabled=None,
                 profile_photo_url=None):
        self._account_id_value = None
        self._account_id_present = False
        self._name_value = None
        self._name_present = False
        self._email_value = None
        self._email_present = False
        self._email_verified_value = None
        self._email_verified_present = False
        self._profile_photo_url_value = None
        self._profile_photo_url_present = False
        self._disabled_value = None
        self._disabled_present = False
        if account_id is not None:
            self.account_id = account_id
        if name is not None:
            self.name = name
        if email is not None:
            self.email = email
        if email_verified is not None:
            self.email_verified = email_verified
        if profile_photo_url is not None:
            self.profile_photo_url = profile_photo_url
        if disabled is not None:
            self.disabled = disabled

    @property
    def account_id(self):
        """
        The user's unique Dropbox ID.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            raise AttributeError("missing required field 'account_id'")

    @account_id.setter
    def account_id(self, val):
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def name(self):
        """
        Details of a user's name.

        :rtype: Name
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        self._name_validator.validate_type_only(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    @property
    def email(self):
        """
        The user's e-mail address. Do not rely on this without checking the
        ``email_verified`` field. Even then, it's possible that the user has
        since lost access to their e-mail.

        :rtype: str
        """
        if self._email_present:
            return self._email_value
        else:
            raise AttributeError("missing required field 'email'")

    @email.setter
    def email(self, val):
        val = self._email_validator.validate(val)
        self._email_value = val
        self._email_present = True

    @email.deleter
    def email(self):
        self._email_value = None
        self._email_present = False

    @property
    def email_verified(self):
        """
        Whether the user has verified their e-mail address.

        :rtype: bool
        """
        if self._email_verified_present:
            return self._email_verified_value
        else:
            raise AttributeError("missing required field 'email_verified'")

    @email_verified.setter
    def email_verified(self, val):
        val = self._email_verified_validator.validate(val)
        self._email_verified_value = val
        self._email_verified_present = True

    @email_verified.deleter
    def email_verified(self):
        self._email_verified_value = None
        self._email_verified_present = False

    @property
    def profile_photo_url(self):
        """
        URL for the photo representing the user, if one is set.

        :rtype: str
        """
        if self._profile_photo_url_present:
            return self._profile_photo_url_value
        else:
            return None

    @profile_photo_url.setter
    def profile_photo_url(self, val):
        if val is None:
            del self.profile_photo_url
            return
        val = self._profile_photo_url_validator.validate(val)
        self._profile_photo_url_value = val
        self._profile_photo_url_present = True

    @profile_photo_url.deleter
    def profile_photo_url(self):
        self._profile_photo_url_value = None
        self._profile_photo_url_present = False

    @property
    def disabled(self):
        """
        Whether the user has been disabled.

        :rtype: bool
        """
        if self._disabled_present:
            return self._disabled_value
        else:
            raise AttributeError("missing required field 'disabled'")

    @disabled.setter
    def disabled(self, val):
        val = self._disabled_validator.validate(val)
        self._disabled_value = val
        self._disabled_present = True

    @disabled.deleter
    def disabled(self):
        self._disabled_value = None
        self._disabled_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(Account, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'Account(account_id={!r}, name={!r}, email={!r}, email_verified={!r}, disabled={!r}, profile_photo_url={!r})'.format(
            self._account_id_value,
            self._name_value,
            self._email_value,
            self._email_verified_value,
            self._disabled_value,
            self._profile_photo_url_value,
        )

Account_validator = bv.Struct(Account)

class BasicAccount(Account):
    """
    Basic information about any account.

    :ivar users.BasicAccount.is_teammate: Whether this user is a teammate of the
        current user. If this account is the current user's account, then this
        will be ``True``.
    :ivar users.BasicAccount.team_member_id: The user's unique team member id.
        This field will only be present if the user is part of a team and
        ``is_teammate`` is ``True``.
    """

    __slots__ = [
        '_is_teammate_value',
        '_is_teammate_present',
        '_team_member_id_value',
        '_team_member_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None,
                 name=None,
                 email=None,
                 email_verified=None,
                 disabled=None,
                 is_teammate=None,
                 profile_photo_url=None,
                 team_member_id=None):
        super(BasicAccount, self).__init__(account_id,
                                           name,
                                           email,
                                           email_verified,
                                           disabled,
                                           profile_photo_url)
        self._is_teammate_value = None
        self._is_teammate_present = False
        self._team_member_id_value = None
        self._team_member_id_present = False
        if is_teammate is not None:
            self.is_teammate = is_teammate
        if team_member_id is not None:
            self.team_member_id = team_member_id

    @property
    def is_teammate(self):
        """
        Whether this user is a teammate of the current user. If this account is
        the current user's account, then this will be ``True``.

        :rtype: bool
        """
        if self._is_teammate_present:
            return self._is_teammate_value
        else:
            raise AttributeError("missing required field 'is_teammate'")

    @is_teammate.setter
    def is_teammate(self, val):
        val = self._is_teammate_validator.validate(val)
        self._is_teammate_value = val
        self._is_teammate_present = True

    @is_teammate.deleter
    def is_teammate(self):
        self._is_teammate_value = None
        self._is_teammate_present = False

    @property
    def team_member_id(self):
        """
        The user's unique team member id. This field will only be present if the
        user is part of a team and ``is_teammate`` is ``True``.

        :rtype: str
        """
        if self._team_member_id_present:
            return self._team_member_id_value
        else:
            return None

    @team_member_id.setter
    def team_member_id(self, val):
        if val is None:
            del self.team_member_id
            return
        val = self._team_member_id_validator.validate(val)
        self._team_member_id_value = val
        self._team_member_id_present = True

    @team_member_id.deleter
    def team_member_id(self):
        self._team_member_id_value = None
        self._team_member_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(BasicAccount, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'BasicAccount(account_id={!r}, name={!r}, email={!r}, email_verified={!r}, disabled={!r}, is_teammate={!r}, profile_photo_url={!r}, team_member_id={!r})'.format(
            self._account_id_value,
            self._name_value,
            self._email_value,
            self._email_verified_value,
            self._disabled_value,
            self._is_teammate_value,
            self._profile_photo_url_value,
            self._team_member_id_value,
        )

BasicAccount_validator = bv.Struct(BasicAccount)

class FileLockingValue(bb.Union):
    """
    The value for ``UserFeature.file_locking``.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar bool users.FileLockingValue.enabled: When this value is True, the user
        can lock files in shared directories. When the value is False the user
        can unlock the files they have locked or request to unlock files locked
        by others.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def enabled(cls, val):
        """
        Create an instance of this class set to the ``enabled`` tag with value
        ``val``.

        :param bool val:
        :rtype: FileLockingValue
        """
        return cls('enabled', val)

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_enabled(self):
        """
        When this value is True, the user can lock files in shared directories.
        When the value is False the user can unlock the files they have locked
        or request to unlock files locked by others.

        Only call this if :meth:`is_enabled` is true.

        :rtype: bool
        """
        if not self.is_enabled():
            raise AttributeError("tag 'enabled' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(FileLockingValue, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'FileLockingValue(%r, %r)' % (self._tag, self._value)

FileLockingValue_validator = bv.Union(FileLockingValue)

class FullAccount(Account):
    """
    Detailed information about the current user's account.

    :ivar users.FullAccount.country: The user's two-letter country code, if
        available. Country codes are based on `ISO 3166-1
        <http://en.wikipedia.org/wiki/ISO_3166-1>`_.
    :ivar users.FullAccount.locale: The language that the user specified. Locale
        tags will be `IETF language tags
        <http://en.wikipedia.org/wiki/IETF_language_tag>`_.
    :ivar users.FullAccount.referral_link: The user's `referral link
        <https://www.dropbox.com/referrals>`_.
    :ivar users.FullAccount.team: If this account is a member of a team,
        information about that team.
    :ivar users.FullAccount.team_member_id: This account's unique team member
        id. This field will only be present if ``team`` is present.
    :ivar users.FullAccount.is_paired: Whether the user has a personal and work
        account. If the current account is personal, then ``team`` will always
        be None, but ``is_paired`` will indicate if a work account is linked.
    :ivar users.FullAccount.account_type: What type of account this user has.
    :ivar users.FullAccount.root_info: The root info for this account.
    """

    __slots__ = [
        '_country_value',
        '_country_present',
        '_locale_value',
        '_locale_present',
        '_referral_link_value',
        '_referral_link_present',
        '_team_value',
        '_team_present',
        '_team_member_id_value',
        '_team_member_id_present',
        '_is_paired_value',
        '_is_paired_present',
        '_account_type_value',
        '_account_type_present',
        '_root_info_value',
        '_root_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None,
                 name=None,
                 email=None,
                 email_verified=None,
                 disabled=None,
                 locale=None,
                 referral_link=None,
                 is_paired=None,
                 account_type=None,
                 root_info=None,
                 profile_photo_url=None,
                 country=None,
                 team=None,
                 team_member_id=None):
        super(FullAccount, self).__init__(account_id,
                                          name,
                                          email,
                                          email_verified,
                                          disabled,
                                          profile_photo_url)
        self._country_value = None
        self._country_present = False
        self._locale_value = None
        self._locale_present = False
        self._referral_link_value = None
        self._referral_link_present = False
        self._team_value = None
        self._team_present = False
        self._team_member_id_value = None
        self._team_member_id_present = False
        self._is_paired_value = None
        self._is_paired_present = False
        self._account_type_value = None
        self._account_type_present = False
        self._root_info_value = None
        self._root_info_present = False
        if country is not None:
            self.country = country
        if locale is not None:
            self.locale = locale
        if referral_link is not None:
            self.referral_link = referral_link
        if team is not None:
            self.team = team
        if team_member_id is not None:
            self.team_member_id = team_member_id
        if is_paired is not None:
            self.is_paired = is_paired
        if account_type is not None:
            self.account_type = account_type
        if root_info is not None:
            self.root_info = root_info

    @property
    def country(self):
        """
        The user's two-letter country code, if available. Country codes are
        based on `ISO 3166-1 <http://en.wikipedia.org/wiki/ISO_3166-1>`_.

        :rtype: str
        """
        if self._country_present:
            return self._country_value
        else:
            return None

    @country.setter
    def country(self, val):
        if val is None:
            del self.country
            return
        val = self._country_validator.validate(val)
        self._country_value = val
        self._country_present = True

    @country.deleter
    def country(self):
        self._country_value = None
        self._country_present = False

    @property
    def locale(self):
        """
        The language that the user specified. Locale tags will be `IETF language
        tags <http://en.wikipedia.org/wiki/IETF_language_tag>`_.

        :rtype: str
        """
        if self._locale_present:
            return self._locale_value
        else:
            raise AttributeError("missing required field 'locale'")

    @locale.setter
    def locale(self, val):
        val = self._locale_validator.validate(val)
        self._locale_value = val
        self._locale_present = True

    @locale.deleter
    def locale(self):
        self._locale_value = None
        self._locale_present = False

    @property
    def referral_link(self):
        """
        The user's `referral link <https://www.dropbox.com/referrals>`_.

        :rtype: str
        """
        if self._referral_link_present:
            return self._referral_link_value
        else:
            raise AttributeError("missing required field 'referral_link'")

    @referral_link.setter
    def referral_link(self, val):
        val = self._referral_link_validator.validate(val)
        self._referral_link_value = val
        self._referral_link_present = True

    @referral_link.deleter
    def referral_link(self):
        self._referral_link_value = None
        self._referral_link_present = False

    @property
    def team(self):
        """
        If this account is a member of a team, information about that team.

        :rtype: FullTeam
        """
        if self._team_present:
            return self._team_value
        else:
            return None

    @team.setter
    def team(self, val):
        if val is None:
            del self.team
            return
        self._team_validator.validate_type_only(val)
        self._team_value = val
        self._team_present = True

    @team.deleter
    def team(self):
        self._team_value = None
        self._team_present = False

    @property
    def team_member_id(self):
        """
        This account's unique team member id. This field will only be present if
        ``team`` is present.

        :rtype: str
        """
        if self._team_member_id_present:
            return self._team_member_id_value
        else:
            return None

    @team_member_id.setter
    def team_member_id(self, val):
        if val is None:
            del self.team_member_id
            return
        val = self._team_member_id_validator.validate(val)
        self._team_member_id_value = val
        self._team_member_id_present = True

    @team_member_id.deleter
    def team_member_id(self):
        self._team_member_id_value = None
        self._team_member_id_present = False

    @property
    def is_paired(self):
        """
        Whether the user has a personal and work account. If the current account
        is personal, then ``team`` will always be None, but ``is_paired`` will
        indicate if a work account is linked.

        :rtype: bool
        """
        if self._is_paired_present:
            return self._is_paired_value
        else:
            raise AttributeError("missing required field 'is_paired'")

    @is_paired.setter
    def is_paired(self, val):
        val = self._is_paired_validator.validate(val)
        self._is_paired_value = val
        self._is_paired_present = True

    @is_paired.deleter
    def is_paired(self):
        self._is_paired_value = None
        self._is_paired_present = False

    @property
    def account_type(self):
        """
        What type of account this user has.

        :rtype: users_common.AccountType
        """
        if self._account_type_present:
            return self._account_type_value
        else:
            raise AttributeError("missing required field 'account_type'")

    @account_type.setter
    def account_type(self, val):
        self._account_type_validator.validate_type_only(val)
        self._account_type_value = val
        self._account_type_present = True

    @account_type.deleter
    def account_type(self):
        self._account_type_value = None
        self._account_type_present = False

    @property
    def root_info(self):
        """
        The root info for this account.

        :rtype: common.RootInfo
        """
        if self._root_info_present:
            return self._root_info_value
        else:
            raise AttributeError("missing required field 'root_info'")

    @root_info.setter
    def root_info(self, val):
        self._root_info_validator.validate_type_only(val)
        self._root_info_value = val
        self._root_info_present = True

    @root_info.deleter
    def root_info(self):
        self._root_info_value = None
        self._root_info_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(FullAccount, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'FullAccount(account_id={!r}, name={!r}, email={!r}, email_verified={!r}, disabled={!r}, locale={!r}, referral_link={!r}, is_paired={!r}, account_type={!r}, root_info={!r}, profile_photo_url={!r}, country={!r}, team={!r}, team_member_id={!r})'.format(
            self._account_id_value,
            self._name_value,
            self._email_value,
            self._email_verified_value,
            self._disabled_value,
            self._locale_value,
            self._referral_link_value,
            self._is_paired_value,
            self._account_type_value,
            self._root_info_value,
            self._profile_photo_url_value,
            self._country_value,
            self._team_value,
            self._team_member_id_value,
        )

FullAccount_validator = bv.Struct(FullAccount)

class Team(bb.Struct):
    """
    Information about a team.

    :ivar users.Team.id: The team's unique ID.
    :ivar users.Team.name: The name of the team.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_name_value',
        '_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 name=None):
        self._id_value = None
        self._id_present = False
        self._name_value = None
        self._name_present = False
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name

    @property
    def id(self):
        """
        The team's unique ID.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def name(self):
        """
        The name of the team.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(Team, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'Team(id={!r}, name={!r})'.format(
            self._id_value,
            self._name_value,
        )

Team_validator = bv.Struct(Team)

class FullTeam(Team):
    """
    Detailed information about a team.

    :ivar users.FullTeam.sharing_policies: Team policies governing sharing.
    :ivar users.FullTeam.office_addin_policy: Team policy governing the use of
        the Office Add-In.
    """

    __slots__ = [
        '_sharing_policies_value',
        '_sharing_policies_present',
        '_office_addin_policy_value',
        '_office_addin_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 name=None,
                 sharing_policies=None,
                 office_addin_policy=None):
        super(FullTeam, self).__init__(id,
                                       name)
        self._sharing_policies_value = None
        self._sharing_policies_present = False
        self._office_addin_policy_value = None
        self._office_addin_policy_present = False
        if sharing_policies is not None:
            self.sharing_policies = sharing_policies
        if office_addin_policy is not None:
            self.office_addin_policy = office_addin_policy

    @property
    def sharing_policies(self):
        """
        Team policies governing sharing.

        :rtype: team_policies.TeamSharingPolicies
        """
        if self._sharing_policies_present:
            return self._sharing_policies_value
        else:
            raise AttributeError("missing required field 'sharing_policies'")

    @sharing_policies.setter
    def sharing_policies(self, val):
        self._sharing_policies_validator.validate_type_only(val)
        self._sharing_policies_value = val
        self._sharing_policies_present = True

    @sharing_policies.deleter
    def sharing_policies(self):
        self._sharing_policies_value = None
        self._sharing_policies_present = False

    @property
    def office_addin_policy(self):
        """
        Team policy governing the use of the Office Add-In.

        :rtype: team_policies.OfficeAddInPolicy
        """
        if self._office_addin_policy_present:
            return self._office_addin_policy_value
        else:
            raise AttributeError("missing required field 'office_addin_policy'")

    @office_addin_policy.setter
    def office_addin_policy(self, val):
        self._office_addin_policy_validator.validate_type_only(val)
        self._office_addin_policy_value = val
        self._office_addin_policy_present = True

    @office_addin_policy.deleter
    def office_addin_policy(self):
        self._office_addin_policy_value = None
        self._office_addin_policy_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(FullTeam, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'FullTeam(id={!r}, name={!r}, sharing_policies={!r}, office_addin_policy={!r})'.format(
            self._id_value,
            self._name_value,
            self._sharing_policies_value,
            self._office_addin_policy_value,
        )

FullTeam_validator = bv.Struct(FullTeam)

class GetAccountArg(bb.Struct):
    """
    :ivar users.GetAccountArg.account_id: A user's account identifier.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_id=None):
        self._account_id_value = None
        self._account_id_present = False
        if account_id is not None:
            self.account_id = account_id

    @property
    def account_id(self):
        """
        A user's account identifier.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            raise AttributeError("missing required field 'account_id'")

    @account_id.setter
    def account_id(self, val):
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetAccountArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetAccountArg(account_id={!r})'.format(
            self._account_id_value,
        )

GetAccountArg_validator = bv.Struct(GetAccountArg)

class GetAccountBatchArg(bb.Struct):
    """
    :ivar users.GetAccountBatchArg.account_ids: List of user account
        identifiers.  Should not contain any duplicate account IDs.
    """

    __slots__ = [
        '_account_ids_value',
        '_account_ids_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 account_ids=None):
        self._account_ids_value = None
        self._account_ids_present = False
        if account_ids is not None:
            self.account_ids = account_ids

    @property
    def account_ids(self):
        """
        List of user account identifiers.  Should not contain any duplicate
        account IDs.

        :rtype: list of [str]
        """
        if self._account_ids_present:
            return self._account_ids_value
        else:
            raise AttributeError("missing required field 'account_ids'")

    @account_ids.setter
    def account_ids(self, val):
        val = self._account_ids_validator.validate(val)
        self._account_ids_value = val
        self._account_ids_present = True

    @account_ids.deleter
    def account_ids(self):
        self._account_ids_value = None
        self._account_ids_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetAccountBatchArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetAccountBatchArg(account_ids={!r})'.format(
            self._account_ids_value,
        )

GetAccountBatchArg_validator = bv.Struct(GetAccountBatchArg)

class GetAccountBatchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str users.GetAccountBatchError.no_account: The value is an account ID
        specified in :field:`GetAccountBatchArg.account_ids` that does not
        exist.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def no_account(cls, val):
        """
        Create an instance of this class set to the ``no_account`` tag with
        value ``val``.

        :param str val:
        :rtype: GetAccountBatchError
        """
        return cls('no_account', val)

    def is_no_account(self):
        """
        Check if the union tag is ``no_account``.

        :rtype: bool
        """
        return self._tag == 'no_account'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_no_account(self):
        """
        The value is an account ID specified in
        ``GetAccountBatchArg.account_ids`` that does not exist.

        Only call this if :meth:`is_no_account` is true.

        :rtype: str
        """
        if not self.is_no_account():
            raise AttributeError("tag 'no_account' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetAccountBatchError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetAccountBatchError(%r, %r)' % (self._tag, self._value)

GetAccountBatchError_validator = bv.Union(GetAccountBatchError)

class GetAccountError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar users.GetAccountError.no_account: The specified
        ``GetAccountArg.account_id`` does not exist.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_account = None
    # Attribute is overwritten below the class definition
    other = None

    def is_no_account(self):
        """
        Check if the union tag is ``no_account``.

        :rtype: bool
        """
        return self._tag == 'no_account'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetAccountError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetAccountError(%r, %r)' % (self._tag, self._value)

GetAccountError_validator = bv.Union(GetAccountError)

class IndividualSpaceAllocation(bb.Struct):
    """
    :ivar users.IndividualSpaceAllocation.allocated: The total space allocated
        to the user's account (bytes).
    """

    __slots__ = [
        '_allocated_value',
        '_allocated_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 allocated=None):
        self._allocated_value = None
        self._allocated_present = False
        if allocated is not None:
            self.allocated = allocated

    @property
    def allocated(self):
        """
        The total space allocated to the user's account (bytes).

        :rtype: int
        """
        if self._allocated_present:
            return self._allocated_value
        else:
            raise AttributeError("missing required field 'allocated'")

    @allocated.setter
    def allocated(self, val):
        val = self._allocated_validator.validate(val)
        self._allocated_value = val
        self._allocated_present = True

    @allocated.deleter
    def allocated(self):
        self._allocated_value = None
        self._allocated_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(IndividualSpaceAllocation, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'IndividualSpaceAllocation(allocated={!r})'.format(
            self._allocated_value,
        )

IndividualSpaceAllocation_validator = bv.Struct(IndividualSpaceAllocation)

class Name(bb.Struct):
    """
    Representations for a person's name to assist with internationalization.

    :ivar users.Name.given_name: Also known as a first name.
    :ivar users.Name.surname: Also known as a last name or family name.
    :ivar users.Name.familiar_name: Locale-dependent name. In the US, a person's
        familiar name is their ``given_name``, but elsewhere, it could be any
        combination of a person's ``given_name`` and ``surname``.
    :ivar users.Name.display_name: A name that can be used directly to represent
        the name of a user's Dropbox account.
    :ivar users.Name.abbreviated_name: An abbreviated form of the person's name.
        Their initials in most locales.
    """

    __slots__ = [
        '_given_name_value',
        '_given_name_present',
        '_surname_value',
        '_surname_present',
        '_familiar_name_value',
        '_familiar_name_present',
        '_display_name_value',
        '_display_name_present',
        '_abbreviated_name_value',
        '_abbreviated_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 given_name=None,
                 surname=None,
                 familiar_name=None,
                 display_name=None,
                 abbreviated_name=None):
        self._given_name_value = None
        self._given_name_present = False
        self._surname_value = None
        self._surname_present = False
        self._familiar_name_value = None
        self._familiar_name_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._abbreviated_name_value = None
        self._abbreviated_name_present = False
        if given_name is not None:
            self.given_name = given_name
        if surname is not None:
            self.surname = surname
        if familiar_name is not None:
            self.familiar_name = familiar_name
        if display_name is not None:
            self.display_name = display_name
        if abbreviated_name is not None:
            self.abbreviated_name = abbreviated_name

    @property
    def given_name(self):
        """
        Also known as a first name.

        :rtype: str
        """
        if self._given_name_present:
            return self._given_name_value
        else:
            raise AttributeError("missing required field 'given_name'")

    @given_name.setter
    def given_name(self, val):
        val = self._given_name_validator.validate(val)
        self._given_name_value = val
        self._given_name_present = True

    @given_name.deleter
    def given_name(self):
        self._given_name_value = None
        self._given_name_present = False

    @property
    def surname(self):
        """
        Also known as a last name or family name.

        :rtype: str
        """
        if self._surname_present:
            return self._surname_value
        else:
            raise AttributeError("missing required field 'surname'")

    @surname.setter
    def surname(self, val):
        val = self._surname_validator.validate(val)
        self._surname_value = val
        self._surname_present = True

    @surname.deleter
    def surname(self):
        self._surname_value = None
        self._surname_present = False

    @property
    def familiar_name(self):
        """
        Locale-dependent name. In the US, a person's familiar name is their
        ``given_name``, but elsewhere, it could be any combination of a person's
        ``given_name`` and ``surname``.

        :rtype: str
        """
        if self._familiar_name_present:
            return self._familiar_name_value
        else:
            raise AttributeError("missing required field 'familiar_name'")

    @familiar_name.setter
    def familiar_name(self, val):
        val = self._familiar_name_validator.validate(val)
        self._familiar_name_value = val
        self._familiar_name_present = True

    @familiar_name.deleter
    def familiar_name(self):
        self._familiar_name_value = None
        self._familiar_name_present = False

    @property
    def display_name(self):
        """
        A name that can be used directly to represent the name of a user's
        Dropbox account.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def abbreviated_name(self):
        """
        An abbreviated form of the person's name. Their initials in most
        locales.

        :rtype: str
        """
        if self._abbreviated_name_present:
            return self._abbreviated_name_value
        else:
            raise AttributeError("missing required field 'abbreviated_name'")

    @abbreviated_name.setter
    def abbreviated_name(self, val):
        val = self._abbreviated_name_validator.validate(val)
        self._abbreviated_name_value = val
        self._abbreviated_name_present = True

    @abbreviated_name.deleter
    def abbreviated_name(self):
        self._abbreviated_name_value = None
        self._abbreviated_name_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(Name, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'Name(given_name={!r}, surname={!r}, familiar_name={!r}, display_name={!r}, abbreviated_name={!r})'.format(
            self._given_name_value,
            self._surname_value,
            self._familiar_name_value,
            self._display_name_value,
            self._abbreviated_name_value,
        )

Name_validator = bv.Struct(Name)

class PaperAsFilesValue(bb.Union):
    """
    The value for ``UserFeature.paper_as_files``.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar bool users.PaperAsFilesValue.enabled: When this value is true, the
        user's Paper docs are accessible in Dropbox with the .paper extension
        and must be accessed via the /files endpoints.  When this value is
        false, the user's Paper docs are stored separate from Dropbox files and
        folders and should be accessed via the /paper endpoints.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def enabled(cls, val):
        """
        Create an instance of this class set to the ``enabled`` tag with value
        ``val``.

        :param bool val:
        :rtype: PaperAsFilesValue
        """
        return cls('enabled', val)

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_enabled(self):
        """
        When this value is true, the user's Paper docs are accessible in Dropbox
        with the .paper extension and must be accessed via the /files endpoints.
        When this value is false, the user's Paper docs are stored separate from
        Dropbox files and folders and should be accessed via the /paper
        endpoints.

        Only call this if :meth:`is_enabled` is true.

        :rtype: bool
        """
        if not self.is_enabled():
            raise AttributeError("tag 'enabled' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(PaperAsFilesValue, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'PaperAsFilesValue(%r, %r)' % (self._tag, self._value)

PaperAsFilesValue_validator = bv.Union(PaperAsFilesValue)

class SpaceAllocation(bb.Union):
    """
    Space is allocated differently based on the type of account.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar IndividualSpaceAllocation SpaceAllocation.individual: The user's space
        allocation applies only to their individual account.
    :ivar TeamSpaceAllocation SpaceAllocation.team: The user shares space with
        other members of their team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def individual(cls, val):
        """
        Create an instance of this class set to the ``individual`` tag with
        value ``val``.

        :param IndividualSpaceAllocation val:
        :rtype: SpaceAllocation
        """
        return cls('individual', val)

    @classmethod
    def team(cls, val):
        """
        Create an instance of this class set to the ``team`` tag with value
        ``val``.

        :param TeamSpaceAllocation val:
        :rtype: SpaceAllocation
        """
        return cls('team', val)

    def is_individual(self):
        """
        Check if the union tag is ``individual``.

        :rtype: bool
        """
        return self._tag == 'individual'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_individual(self):
        """
        The user's space allocation applies only to their individual account.

        Only call this if :meth:`is_individual` is true.

        :rtype: IndividualSpaceAllocation
        """
        if not self.is_individual():
            raise AttributeError("tag 'individual' not set")
        return self._value

    def get_team(self):
        """
        The user shares space with other members of their team.

        Only call this if :meth:`is_team` is true.

        :rtype: TeamSpaceAllocation
        """
        if not self.is_team():
            raise AttributeError("tag 'team' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SpaceAllocation, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'SpaceAllocation(%r, %r)' % (self._tag, self._value)

SpaceAllocation_validator = bv.Union(SpaceAllocation)

class SpaceUsage(bb.Struct):
    """
    Information about a user's space usage and quota.

    :ivar users.SpaceUsage.used: The user's total space usage (bytes).
    :ivar users.SpaceUsage.allocation: The user's space allocation.
    """

    __slots__ = [
        '_used_value',
        '_used_present',
        '_allocation_value',
        '_allocation_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 used=None,
                 allocation=None):
        self._used_value = None
        self._used_present = False
        self._allocation_value = None
        self._allocation_present = False
        if used is not None:
            self.used = used
        if allocation is not None:
            self.allocation = allocation

    @property
    def used(self):
        """
        The user's total space usage (bytes).

        :rtype: int
        """
        if self._used_present:
            return self._used_value
        else:
            raise AttributeError("missing required field 'used'")

    @used.setter
    def used(self, val):
        val = self._used_validator.validate(val)
        self._used_value = val
        self._used_present = True

    @used.deleter
    def used(self):
        self._used_value = None
        self._used_present = False

    @property
    def allocation(self):
        """
        The user's space allocation.

        :rtype: SpaceAllocation
        """
        if self._allocation_present:
            return self._allocation_value
        else:
            raise AttributeError("missing required field 'allocation'")

    @allocation.setter
    def allocation(self, val):
        self._allocation_validator.validate_type_only(val)
        self._allocation_value = val
        self._allocation_present = True

    @allocation.deleter
    def allocation(self):
        self._allocation_value = None
        self._allocation_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SpaceUsage, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'SpaceUsage(used={!r}, allocation={!r})'.format(
            self._used_value,
            self._allocation_value,
        )

SpaceUsage_validator = bv.Struct(SpaceUsage)

class TeamSpaceAllocation(bb.Struct):
    """
    :ivar users.TeamSpaceAllocation.used: The total space currently used by the
        user's team (bytes).
    :ivar users.TeamSpaceAllocation.allocated: The total space allocated to the
        user's team (bytes).
    :ivar users.TeamSpaceAllocation.user_within_team_space_allocated: The total
        space allocated to the user within its team allocated space (0 means
        that no restriction is imposed on the user's quota within its team).
    :ivar users.TeamSpaceAllocation.user_within_team_space_limit_type: The type
        of the space limit imposed on the team member (off, alert_only,
        stop_sync).
    :ivar users.TeamSpaceAllocation.user_within_team_space_used_cached: An
        accurate cached calculation of a team member's total space usage
        (bytes).
    """

    __slots__ = [
        '_used_value',
        '_used_present',
        '_allocated_value',
        '_allocated_present',
        '_user_within_team_space_allocated_value',
        '_user_within_team_space_allocated_present',
        '_user_within_team_space_limit_type_value',
        '_user_within_team_space_limit_type_present',
        '_user_within_team_space_used_cached_value',
        '_user_within_team_space_used_cached_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 used=None,
                 allocated=None,
                 user_within_team_space_allocated=None,
                 user_within_team_space_limit_type=None,
                 user_within_team_space_used_cached=None):
        self._used_value = None
        self._used_present = False
        self._allocated_value = None
        self._allocated_present = False
        self._user_within_team_space_allocated_value = None
        self._user_within_team_space_allocated_present = False
        self._user_within_team_space_limit_type_value = None
        self._user_within_team_space_limit_type_present = False
        self._user_within_team_space_used_cached_value = None
        self._user_within_team_space_used_cached_present = False
        if used is not None:
            self.used = used
        if allocated is not None:
            self.allocated = allocated
        if user_within_team_space_allocated is not None:
            self.user_within_team_space_allocated = user_within_team_space_allocated
        if user_within_team_space_limit_type is not None:
            self.user_within_team_space_limit_type = user_within_team_space_limit_type
        if user_within_team_space_used_cached is not None:
            self.user_within_team_space_used_cached = user_within_team_space_used_cached

    @property
    def used(self):
        """
        The total space currently used by the user's team (bytes).

        :rtype: int
        """
        if self._used_present:
            return self._used_value
        else:
            raise AttributeError("missing required field 'used'")

    @used.setter
    def used(self, val):
        val = self._used_validator.validate(val)
        self._used_value = val
        self._used_present = True

    @used.deleter
    def used(self):
        self._used_value = None
        self._used_present = False

    @property
    def allocated(self):
        """
        The total space allocated to the user's team (bytes).

        :rtype: int
        """
        if self._allocated_present:
            return self._allocated_value
        else:
            raise AttributeError("missing required field 'allocated'")

    @allocated.setter
    def allocated(self, val):
        val = self._allocated_validator.validate(val)
        self._allocated_value = val
        self._allocated_present = True

    @allocated.deleter
    def allocated(self):
        self._allocated_value = None
        self._allocated_present = False

    @property
    def user_within_team_space_allocated(self):
        """
        The total space allocated to the user within its team allocated space (0
        means that no restriction is imposed on the user's quota within its
        team).

        :rtype: int
        """
        if self._user_within_team_space_allocated_present:
            return self._user_within_team_space_allocated_value
        else:
            raise AttributeError("missing required field 'user_within_team_space_allocated'")

    @user_within_team_space_allocated.setter
    def user_within_team_space_allocated(self, val):
        val = self._user_within_team_space_allocated_validator.validate(val)
        self._user_within_team_space_allocated_value = val
        self._user_within_team_space_allocated_present = True

    @user_within_team_space_allocated.deleter
    def user_within_team_space_allocated(self):
        self._user_within_team_space_allocated_value = None
        self._user_within_team_space_allocated_present = False

    @property
    def user_within_team_space_limit_type(self):
        """
        The type of the space limit imposed on the team member (off, alert_only,
        stop_sync).

        :rtype: team_common.MemberSpaceLimitType
        """
        if self._user_within_team_space_limit_type_present:
            return self._user_within_team_space_limit_type_value
        else:
            raise AttributeError("missing required field 'user_within_team_space_limit_type'")

    @user_within_team_space_limit_type.setter
    def user_within_team_space_limit_type(self, val):
        self._user_within_team_space_limit_type_validator.validate_type_only(val)
        self._user_within_team_space_limit_type_value = val
        self._user_within_team_space_limit_type_present = True

    @user_within_team_space_limit_type.deleter
    def user_within_team_space_limit_type(self):
        self._user_within_team_space_limit_type_value = None
        self._user_within_team_space_limit_type_present = False

    @property
    def user_within_team_space_used_cached(self):
        """
        An accurate cached calculation of a team member's total space usage
        (bytes).

        :rtype: int
        """
        if self._user_within_team_space_used_cached_present:
            return self._user_within_team_space_used_cached_value
        else:
            raise AttributeError("missing required field 'user_within_team_space_used_cached'")

    @user_within_team_space_used_cached.setter
    def user_within_team_space_used_cached(self, val):
        val = self._user_within_team_space_used_cached_validator.validate(val)
        self._user_within_team_space_used_cached_value = val
        self._user_within_team_space_used_cached_present = True

    @user_within_team_space_used_cached.deleter
    def user_within_team_space_used_cached(self):
        self._user_within_team_space_used_cached_value = None
        self._user_within_team_space_used_cached_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(TeamSpaceAllocation, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'TeamSpaceAllocation(used={!r}, allocated={!r}, user_within_team_space_allocated={!r}, user_within_team_space_limit_type={!r}, user_within_team_space_used_cached={!r})'.format(
            self._used_value,
            self._allocated_value,
            self._user_within_team_space_allocated_value,
            self._user_within_team_space_limit_type_value,
            self._user_within_team_space_used_cached_value,
        )

TeamSpaceAllocation_validator = bv.Struct(TeamSpaceAllocation)

class UserFeature(bb.Union):
    """
    A set of features that a Dropbox User account may have configured.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar users.UserFeature.paper_as_files: This feature contains information
        about how the user's Paper files are stored.
    :ivar users.UserFeature.file_locking: This feature allows users to lock
        files in order to restrict other users from editing them.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    paper_as_files = None
    # Attribute is overwritten below the class definition
    file_locking = None
    # Attribute is overwritten below the class definition
    other = None

    def is_paper_as_files(self):
        """
        Check if the union tag is ``paper_as_files``.

        :rtype: bool
        """
        return self._tag == 'paper_as_files'

    def is_file_locking(self):
        """
        Check if the union tag is ``file_locking``.

        :rtype: bool
        """
        return self._tag == 'file_locking'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserFeature, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserFeature(%r, %r)' % (self._tag, self._value)

UserFeature_validator = bv.Union(UserFeature)

class UserFeatureValue(bb.Union):
    """
    Values that correspond to entries in :class:`UserFeature`.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def paper_as_files(cls, val):
        """
        Create an instance of this class set to the ``paper_as_files`` tag with
        value ``val``.

        :param PaperAsFilesValue val:
        :rtype: UserFeatureValue
        """
        return cls('paper_as_files', val)

    @classmethod
    def file_locking(cls, val):
        """
        Create an instance of this class set to the ``file_locking`` tag with
        value ``val``.

        :param FileLockingValue val:
        :rtype: UserFeatureValue
        """
        return cls('file_locking', val)

    def is_paper_as_files(self):
        """
        Check if the union tag is ``paper_as_files``.

        :rtype: bool
        """
        return self._tag == 'paper_as_files'

    def is_file_locking(self):
        """
        Check if the union tag is ``file_locking``.

        :rtype: bool
        """
        return self._tag == 'file_locking'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_paper_as_files(self):
        """
        Only call this if :meth:`is_paper_as_files` is true.

        :rtype: PaperAsFilesValue
        """
        if not self.is_paper_as_files():
            raise AttributeError("tag 'paper_as_files' not set")
        return self._value

    def get_file_locking(self):
        """
        Only call this if :meth:`is_file_locking` is true.

        :rtype: FileLockingValue
        """
        if not self.is_file_locking():
            raise AttributeError("tag 'file_locking' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserFeatureValue, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserFeatureValue(%r, %r)' % (self._tag, self._value)

UserFeatureValue_validator = bv.Union(UserFeatureValue)

class UserFeaturesGetValuesBatchArg(bb.Struct):
    """
    :ivar users.UserFeaturesGetValuesBatchArg.features: A list of features in
        :class:`UserFeature`. If the list is empty, this route will return
        :class:`UserFeaturesGetValuesBatchError`.
    """

    __slots__ = [
        '_features_value',
        '_features_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 features=None):
        self._features_value = None
        self._features_present = False
        if features is not None:
            self.features = features

    @property
    def features(self):
        """
        A list of features in :class:`UserFeature`. If the list is empty, this
        route will return :class:`UserFeaturesGetValuesBatchError`.

        :rtype: list of [UserFeature]
        """
        if self._features_present:
            return self._features_value
        else:
            raise AttributeError("missing required field 'features'")

    @features.setter
    def features(self, val):
        val = self._features_validator.validate(val)
        self._features_value = val
        self._features_present = True

    @features.deleter
    def features(self):
        self._features_value = None
        self._features_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserFeaturesGetValuesBatchArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserFeaturesGetValuesBatchArg(features={!r})'.format(
            self._features_value,
        )

UserFeaturesGetValuesBatchArg_validator = bv.Struct(UserFeaturesGetValuesBatchArg)

class UserFeaturesGetValuesBatchError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar users.UserFeaturesGetValuesBatchError.empty_features_list: At least
        one :class:`UserFeature` must be included in the
        :class:`UserFeaturesGetValuesBatchArg`.features list.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    empty_features_list = None
    # Attribute is overwritten below the class definition
    other = None

    def is_empty_features_list(self):
        """
        Check if the union tag is ``empty_features_list``.

        :rtype: bool
        """
        return self._tag == 'empty_features_list'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserFeaturesGetValuesBatchError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserFeaturesGetValuesBatchError(%r, %r)' % (self._tag, self._value)

UserFeaturesGetValuesBatchError_validator = bv.Union(UserFeaturesGetValuesBatchError)

class UserFeaturesGetValuesBatchResult(bb.Struct):

    __slots__ = [
        '_values_value',
        '_values_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 values=None):
        self._values_value = None
        self._values_present = False
        if values is not None:
            self.values = values

    @property
    def values(self):
        """
        :rtype: list of [UserFeatureValue]
        """
        if self._values_present:
            return self._values_value
        else:
            raise AttributeError("missing required field 'values'")

    @values.setter
    def values(self, val):
        val = self._values_validator.validate(val)
        self._values_value = val
        self._values_present = True

    @values.deleter
    def values(self):
        self._values_value = None
        self._values_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserFeaturesGetValuesBatchResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserFeaturesGetValuesBatchResult(values={!r})'.format(
            self._values_value,
        )

UserFeaturesGetValuesBatchResult_validator = bv.Struct(UserFeaturesGetValuesBatchResult)

GetAccountBatchResult_validator = bv.List(BasicAccount_validator)
Account._account_id_validator = users_common.AccountId_validator
Account._name_validator = Name_validator
Account._email_validator = bv.String()
Account._email_verified_validator = bv.Boolean()
Account._profile_photo_url_validator = bv.Nullable(bv.String())
Account._disabled_validator = bv.Boolean()
Account._all_field_names_ = set([
    'account_id',
    'name',
    'email',
    'email_verified',
    'profile_photo_url',
    'disabled',
])
Account._all_fields_ = [
    ('account_id', Account._account_id_validator),
    ('name', Account._name_validator),
    ('email', Account._email_validator),
    ('email_verified', Account._email_verified_validator),
    ('profile_photo_url', Account._profile_photo_url_validator),
    ('disabled', Account._disabled_validator),
]

BasicAccount._is_teammate_validator = bv.Boolean()
BasicAccount._team_member_id_validator = bv.Nullable(bv.String())
BasicAccount._all_field_names_ = Account._all_field_names_.union(set([
    'is_teammate',
    'team_member_id',
]))
BasicAccount._all_fields_ = Account._all_fields_ + [
    ('is_teammate', BasicAccount._is_teammate_validator),
    ('team_member_id', BasicAccount._team_member_id_validator),
]

FileLockingValue._enabled_validator = bv.Boolean()
FileLockingValue._other_validator = bv.Void()
FileLockingValue._tagmap = {
    'enabled': FileLockingValue._enabled_validator,
    'other': FileLockingValue._other_validator,
}

FileLockingValue.other = FileLockingValue('other')

FullAccount._country_validator = bv.Nullable(bv.String(min_length=2, max_length=2))
FullAccount._locale_validator = bv.String(min_length=2)
FullAccount._referral_link_validator = bv.String()
FullAccount._team_validator = bv.Nullable(FullTeam_validator)
FullAccount._team_member_id_validator = bv.Nullable(bv.String())
FullAccount._is_paired_validator = bv.Boolean()
FullAccount._account_type_validator = users_common.AccountType_validator
FullAccount._root_info_validator = common.RootInfo_validator
FullAccount._all_field_names_ = Account._all_field_names_.union(set([
    'country',
    'locale',
    'referral_link',
    'team',
    'team_member_id',
    'is_paired',
    'account_type',
    'root_info',
]))
FullAccount._all_fields_ = Account._all_fields_ + [
    ('country', FullAccount._country_validator),
    ('locale', FullAccount._locale_validator),
    ('referral_link', FullAccount._referral_link_validator),
    ('team', FullAccount._team_validator),
    ('team_member_id', FullAccount._team_member_id_validator),
    ('is_paired', FullAccount._is_paired_validator),
    ('account_type', FullAccount._account_type_validator),
    ('root_info', FullAccount._root_info_validator),
]

Team._id_validator = bv.String()
Team._name_validator = bv.String()
Team._all_field_names_ = set([
    'id',
    'name',
])
Team._all_fields_ = [
    ('id', Team._id_validator),
    ('name', Team._name_validator),
]

FullTeam._sharing_policies_validator = team_policies.TeamSharingPolicies_validator
FullTeam._office_addin_policy_validator = team_policies.OfficeAddInPolicy_validator
FullTeam._all_field_names_ = Team._all_field_names_.union(set([
    'sharing_policies',
    'office_addin_policy',
]))
FullTeam._all_fields_ = Team._all_fields_ + [
    ('sharing_policies', FullTeam._sharing_policies_validator),
    ('office_addin_policy', FullTeam._office_addin_policy_validator),
]

GetAccountArg._account_id_validator = users_common.AccountId_validator
GetAccountArg._all_field_names_ = set(['account_id'])
GetAccountArg._all_fields_ = [('account_id', GetAccountArg._account_id_validator)]

GetAccountBatchArg._account_ids_validator = bv.List(users_common.AccountId_validator, min_items=1)
GetAccountBatchArg._all_field_names_ = set(['account_ids'])
GetAccountBatchArg._all_fields_ = [('account_ids', GetAccountBatchArg._account_ids_validator)]

GetAccountBatchError._no_account_validator = users_common.AccountId_validator
GetAccountBatchError._other_validator = bv.Void()
GetAccountBatchError._tagmap = {
    'no_account': GetAccountBatchError._no_account_validator,
    'other': GetAccountBatchError._other_validator,
}

GetAccountBatchError.other = GetAccountBatchError('other')

GetAccountError._no_account_validator = bv.Void()
GetAccountError._other_validator = bv.Void()
GetAccountError._tagmap = {
    'no_account': GetAccountError._no_account_validator,
    'other': GetAccountError._other_validator,
}

GetAccountError.no_account = GetAccountError('no_account')
GetAccountError.other = GetAccountError('other')

IndividualSpaceAllocation._allocated_validator = bv.UInt64()
IndividualSpaceAllocation._all_field_names_ = set(['allocated'])
IndividualSpaceAllocation._all_fields_ = [('allocated', IndividualSpaceAllocation._allocated_validator)]

Name._given_name_validator = bv.String()
Name._surname_validator = bv.String()
Name._familiar_name_validator = bv.String()
Name._display_name_validator = bv.String()
Name._abbreviated_name_validator = bv.String()
Name._all_field_names_ = set([
    'given_name',
    'surname',
    'familiar_name',
    'display_name',
    'abbreviated_name',
])
Name._all_fields_ = [
    ('given_name', Name._given_name_validator),
    ('surname', Name._surname_validator),
    ('familiar_name', Name._familiar_name_validator),
    ('display_name', Name._display_name_validator),
    ('abbreviated_name', Name._abbreviated_name_validator),
]

PaperAsFilesValue._enabled_validator = bv.Boolean()
PaperAsFilesValue._other_validator = bv.Void()
PaperAsFilesValue._tagmap = {
    'enabled': PaperAsFilesValue._enabled_validator,
    'other': PaperAsFilesValue._other_validator,
}

PaperAsFilesValue.other = PaperAsFilesValue('other')

SpaceAllocation._individual_validator = IndividualSpaceAllocation_validator
SpaceAllocation._team_validator = TeamSpaceAllocation_validator
SpaceAllocation._other_validator = bv.Void()
SpaceAllocation._tagmap = {
    'individual': SpaceAllocation._individual_validator,
    'team': SpaceAllocation._team_validator,
    'other': SpaceAllocation._other_validator,
}

SpaceAllocation.other = SpaceAllocation('other')

SpaceUsage._used_validator = bv.UInt64()
SpaceUsage._allocation_validator = SpaceAllocation_validator
SpaceUsage._all_field_names_ = set([
    'used',
    'allocation',
])
SpaceUsage._all_fields_ = [
    ('used', SpaceUsage._used_validator),
    ('allocation', SpaceUsage._allocation_validator),
]

TeamSpaceAllocation._used_validator = bv.UInt64()
TeamSpaceAllocation._allocated_validator = bv.UInt64()
TeamSpaceAllocation._user_within_team_space_allocated_validator = bv.UInt64()
TeamSpaceAllocation._user_within_team_space_limit_type_validator = team_common.MemberSpaceLimitType_validator
TeamSpaceAllocation._user_within_team_space_used_cached_validator = bv.UInt64()
TeamSpaceAllocation._all_field_names_ = set([
    'used',
    'allocated',
    'user_within_team_space_allocated',
    'user_within_team_space_limit_type',
    'user_within_team_space_used_cached',
])
TeamSpaceAllocation._all_fields_ = [
    ('used', TeamSpaceAllocation._used_validator),
    ('allocated', TeamSpaceAllocation._allocated_validator),
    ('user_within_team_space_allocated', TeamSpaceAllocation._user_within_team_space_allocated_validator),
    ('user_within_team_space_limit_type', TeamSpaceAllocation._user_within_team_space_limit_type_validator),
    ('user_within_team_space_used_cached', TeamSpaceAllocation._user_within_team_space_used_cached_validator),
]

UserFeature._paper_as_files_validator = bv.Void()
UserFeature._file_locking_validator = bv.Void()
UserFeature._other_validator = bv.Void()
UserFeature._tagmap = {
    'paper_as_files': UserFeature._paper_as_files_validator,
    'file_locking': UserFeature._file_locking_validator,
    'other': UserFeature._other_validator,
}

UserFeature.paper_as_files = UserFeature('paper_as_files')
UserFeature.file_locking = UserFeature('file_locking')
UserFeature.other = UserFeature('other')

UserFeatureValue._paper_as_files_validator = PaperAsFilesValue_validator
UserFeatureValue._file_locking_validator = FileLockingValue_validator
UserFeatureValue._other_validator = bv.Void()
UserFeatureValue._tagmap = {
    'paper_as_files': UserFeatureValue._paper_as_files_validator,
    'file_locking': UserFeatureValue._file_locking_validator,
    'other': UserFeatureValue._other_validator,
}

UserFeatureValue.other = UserFeatureValue('other')

UserFeaturesGetValuesBatchArg._features_validator = bv.List(UserFeature_validator)
UserFeaturesGetValuesBatchArg._all_field_names_ = set(['features'])
UserFeaturesGetValuesBatchArg._all_fields_ = [('features', UserFeaturesGetValuesBatchArg._features_validator)]

UserFeaturesGetValuesBatchError._empty_features_list_validator = bv.Void()
UserFeaturesGetValuesBatchError._other_validator = bv.Void()
UserFeaturesGetValuesBatchError._tagmap = {
    'empty_features_list': UserFeaturesGetValuesBatchError._empty_features_list_validator,
    'other': UserFeaturesGetValuesBatchError._other_validator,
}

UserFeaturesGetValuesBatchError.empty_features_list = UserFeaturesGetValuesBatchError('empty_features_list')
UserFeaturesGetValuesBatchError.other = UserFeaturesGetValuesBatchError('other')

UserFeaturesGetValuesBatchResult._values_validator = bv.List(UserFeatureValue_validator)
UserFeaturesGetValuesBatchResult._all_field_names_ = set(['values'])
UserFeaturesGetValuesBatchResult._all_fields_ = [('values', UserFeaturesGetValuesBatchResult._values_validator)]

features_get_values = bb.Route(
    'features/get_values',
    1,
    False,
    UserFeaturesGetValuesBatchArg_validator,
    UserFeaturesGetValuesBatchResult_validator,
    UserFeaturesGetValuesBatchError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_account = bb.Route(
    'get_account',
    1,
    False,
    GetAccountArg_validator,
    BasicAccount_validator,
    GetAccountError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_account_batch = bb.Route(
    'get_account_batch',
    1,
    False,
    GetAccountBatchArg_validator,
    GetAccountBatchResult_validator,
    GetAccountBatchError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get_current_account = bb.Route(
    'get_current_account',
    1,
    False,
    bv.Void(),
    FullAccount_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
get_space_usage = bb.Route(
    'get_space_usage',
    1,
    False,
    bv.Void(),
    SpaceUsage_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'features/get_values': features_get_values,
    'get_account': get_account,
    'get_account_batch': get_account_batch,
    'get_current_account': get_current_account,
    'get_space_usage': get_space_usage,
}

