#!/bin/bash

# (C) Michael Weinberger 2008

# Version 2

PACKAGENAME=tikiwiki-1.9.10.1
#PACKAGENAME=tikiwiki-1.10.0b1


MIRROR_1="http://downloads.sourceforge.net/tikiwiki"
MIRROR_2="http://www.mirrorservice.org/sites/download.sourceforge.net/pub/sourceforge/t/ti/tikiwiki"


MIRROR=$MIRROR_2


# Downloading the tarball
TARBALL=$PACKAGENAME.tar.gz
test ! -f $TARBALL && echo "--- Downloading the tarball ---" && wget $MIRROR/$TARBALL


# Unpacking the tarball
echo
echo "--- Unpacking the tarball $TARBALL ---"
if [ -d  /opt/tikiwiki ] ; then
	echo "WARNING: Existing installation found!"
	echo -n "Enter 'proceed' to overwrite or press Enter to continue: "
	read IN
else
	IN="proceed"
fi
if [ "$IN" == 'proceed' ] ; then
	rm -rf /opt/$PACKAGENAME /opt/tikiwiki
	tar -C /opt/ -xzf $TARBALL || exit -1
	mv /opt/$PACKAGENAME /opt/tikiwiki
	patch -p0  < tiki-login.php.patch
	echo "OK"
else
	echo "Skipped."
fi

# Bad URL fixes
patch -p0 -N < tiki-login.php.patch

# Setting ownership and permissions
echo
echo "--- Setting ownership and permissions"
chown -R www.www /opt/tikiwiki
chmod -R o-rwx /opt/tikiwiki
echo "OK"


# Creating the database
echo
echo "--- Creating the database ---"
test ! -f tiki-db-password && ps auxww|md5sum|sed -e 's/ .*$//' > tiki-db-password
DBPW=`cat tiki-db-password`
echo "create database if not exists tiki" | mysql
echo "REVOKE ALL PRIVILEGES ON * . * FROM 'tikiadmin'@'localhost'" | mysql 2>&1 &> /dev/null
echo "grant SELECT, INSERT, UPDATE, DELETE, CREATE, DROP, INDEX, ALTER, CREATE TEMPORARY TABLES  on tiki.* to tikiadmin@localhost identified by '$DBPW'" | mysql
echo "FLUSH PRIVILEGES" | mysql
echo "MySQL tikiadmin password is stored in file tiki-db-password"
echo "OK"

### PHP settings
UploadMaxFilesize=100M
PostMaxSize=120M
MemoryLimit=64M
MaxExecutionTime=120
echo
echo "--- PHP settings: UploadMaxFilesize=$UploadMaxFilesize"
echo "--- PHP settings: PostMaxSize=$PostMaxSize"
echo "--- PHP settings: MemoryLimit=$MemoryLimit"
echo "--- PHP settings: MaxExecutionTime=$MaxExecutionTime"
config setprop php UploadMaxFilesize $UploadMaxFilesize
config setprop php PostMaxSize $PostMaxSize
config setprop php MemoryLimit $MemoryLimit
config setprop php MaxExecutionTime $MaxExecutionTime
/sbin/e-smith/expand-template /etc/php.ini
service httpd-e-smith restart
echo "OK"


### Installing httpd.conf custom template
mkdir -p /etc/e-smith/templates-custom/etc/httpd/conf/httpd.conf/
cat <<HERE > /etc/e-smith/templates-custom/etc/httpd/conf/httpd.conf/86TikiWikiAlias

# tikiwiki
Alias /tikiwiki /opt/tikiwiki
<Directory /opt/tikiwiki>
    SSLRequireSSL
    Options -Indexes
    AllowOverride All
    order allow,deny
    allow from all
    AddType application/x-httpd-php .php 
    php_flag  magic_quotes_gpc  off
    php_flag  track_vars        on
</Directory>

HERE

mkdir -p /etc/e-smith/templates-custom/etc/httpd/conf/httpd.conf/VirtualHosts
cat <<HERE > /etc/e-smith/templates-custom/etc/httpd/conf/httpd.conf/VirtualHosts/30tikiwikiRewriteRule
{
    \$haveSSL = (exists \${modSSL}{status} and \${modSSL}{status} eq "enabled") ?  'yes' : 'no';

    if ((\$port eq "80") && (\$haveSSL eq 'yes'))
        {
            \$OUT .= "    RewriteRule ^/tikiwiki(/.*|\\$)    https://%{HTTP_HOST}/tikiwiki\\\$1 [L,R]\n";
        }
}
HERE

expand-template /etc/httpd/conf/httpd.conf
service httpd-e-smith restart
echo "OK"


### Setting MySQL max_allowed_packet
max_allowed_packet=30M
echo
echo "--- Setting MySQL max_allowed_packet=$max_allowed_packet ---"
mkdir -p /etc/e-smith/templates-custom/etc/my.cnf/
echo "set-variable = max_allowed_packet=$max_allowed_packet" > /etc/e-smith/templates-custom/etc/my.cnf/010max_allowed_packet
expand-template /etc/my.cnf
service mysqld restart
sleep 1
echo "OK"


### Setup TikiWiki
cat <<HERE > /opt/tikiwiki/db/local.php
<?php
\$db_tiki='mysql';
\$dbversion_tiki='1.9';
\$host_tiki='localhost';
\$user_tiki='tikiadmin';
\$pass_tiki='$DBPW';
\$dbs_tiki='tiki';
?>
HERE
chown www.www /opt/tikiwiki/db/local.php
chmod o-rwx /opt/tikiwiki/db/local.php

# Initializing database
if [ ! -f /opt/tikiwiki/db/local.php ] ; then
	echo
	echo "--- Initializing database ---"
	sleep 1
	mysql -A tiki < /opt/tikiwiki/db/tiki-1.9-mysql.sql
	sleep 1
	#mysql -A tiki < /opt/tikiwiki/db/profiles/default-inserts.sql
	mysql -A tiki < /opt/tikiwiki/db/profiles/basicEnabled.prf
	sleep 1
	mysql -A tiki < /opt/tikiwiki/db/tiki-secdb_1.9_mysql.sql
	sleep 1

	echo "UPDATE tiki_preferences SET value='y' WHERE name='feature_detect_language'" | mysql -A tiki
	echo "UPDATE tiki_preferences SET value='n' WHERE name='allowRegister'" | mysql -A tiki
	echo "UPDATE tiki_preferences SET value='n' WHERE name='feature_bot_bar_icons'" | mysql -A tiki
	echo "UPDATE tiki_preferences SET value='default.css' WHERE name='style'" | mysql -A tiki
	echo "UPDATE tiki_preferences SET value='/tikiwiki' WHERE name='http_prefix' OR name='https_prefix'" | mysql -A tiki
	echo "DELETE FROM users_grouppermissions WHERE groupName='Anonymous'"| mysql -A tiki

fi

