#!/bin/bash
COMPANY=$1
test -z $1 && exit
if [ -f $COMPANY"_ca_cert.crt" ] ; then
echo "Root certificate $COMPANY"_ca_cert.crt" already exists."
exit
fi

mkdir -p private
openssl req -x509 -extensions v3_ca  -out $COMPANY"_ca_cert.crt" -newkey rsa:1024 -keyout private/$COMPANY"_ca_priv_key.pem" -days 9125 -config openssl.cnf

openssl x509 -in $COMPANY"_ca_cert.crt" -inform PEM -outform DER -out $COMPANY"_ca_cert_der.crt"
