#!/bin/bash
test -z $1 && exit
test -z $2 && exit

COMPANY=$2
if [ ! -f $COMPANY"_ca_cert.crt" ] ; then
echo "Error: Root Certificate '$COMPANY"_ca_cert.crt"' not found."
exit;
fi

if [ ! -f private/$COMPANY"_ca_priv_key.pem" ] ; then
echo "Error: Private Root Key 'private/$COMPANY"_ca_priv_key.pem"' not found."
exit;
fi

BASE=`echo $1|sed -e 's/\.csr$//'`
CSR="$BASE.csr"
CRT="$BASE.crt"

if [ ! -f $CSR ] ; then
echo "Error: Certificate Request file '$CSR' not found."
exit;
fi


openssl x509 -req -in $CSR -CA $COMPANY"_ca_cert.crt"  -CAkey private/$COMPANY"_ca_priv_key.pem" -CAcreateserial -out $CRT -days 3650

