#!/bin/ash

# Version 02
# Michael Weinberger 2008 <mweinber@neddix.de>

logger -s "Running Affa setup..."

# enable ssh service
sed -ie 's/^#\(ssh.*\)/\1/' /etc/inetd.conf 
# reload inetd configuration
kill -HUP `ps | grep inetd | sed -e 's/ .*//'`

# install rsync 3.0.4 statically linked
cp -a /bootbank/bexi/rsync-static /bin/rsync

# root home dir for storing public keys
mkdir -p /bootbank/bexi/root/.ssh
touch /bootbank/bexi/root/.ssh/authorized_keys
touch /bootbank/bexi/root/.ssh/known_hosts

# link .ssh dir to non-volatile USB location
mkdir -p /root
ln -fs /bootbank/bexi/root/.ssh /root/

# set new home dir for user root
sed -ie 's#^\(root:.*\)\(:/:\)\(.*\)#\1:/root:\3#' /etc/passwd 

# add execution of this script to rc.local
grep -v "#BEXI$" < /etc/rc.local > /etc/rc.local.affa; mv -f /etc/rc.local.affa /etc/rc.local
echo "test -f /bootbank/bexi/affa-setup.sh && /bootbank/bexi/affa-setup.sh #BEXI" >> /etc/rc.local
echo "test ! -d /root && sed -ie 's#^\(root:.*\)\(:/root:\)\(.*\)#\1:/:\3#' /etc/passwd  #BEXI" >> /etc/rc.local
