%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde ElasticSearch client
Name: Horde_ElasticSearch
Version: 1.0.4
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_ElasticSearch-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_ElasticSearch
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Http >= 2.0.0
Requires: Horde_Http < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Lightweight API for ElasticSearch (http://www.elasticsearch.org/).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_ElasticSearch.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_ElasticSearch.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_ElasticSearch >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_ElasticSearch/*
%{peardir}/*
%{xmldir}/Horde_ElasticSearch.xml

%changelog
* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.4-1
- Updated to 1.0.4

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

