%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Mail Library
Name: Horde_Mail
Version: 2.6.5
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Mail-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Mail
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Stream_Filter >= 2.0.0
Requires: Horde_Stream_Filter < 3.0.0alpha1
Requires: Horde_Idna >= 1.0.0
Requires: Horde_Idna < 2.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Provides interfaces for sending e-mail messages and parsing e-mail
addresses.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Mail.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Mail.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Mail >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Mail/*
%{peardir}/*
%{xmldir}/Horde_Mail.xml

%changelog
* Sat Mar 2 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.5-1  
- Updated to 2.6.5

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.4-1  
- Updated to 2.6.4

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.3-1  
- Updated to 2.6.3

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.2-1  
- Updated to 2.6.2

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.0-1  
- Updated to 2.6.0

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1  
- Updated to 2.5.1

* Tue Nov 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.0-1  
- Updated to 2.5.0

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1  
- Updated to 2.4.0

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1  
- Updated to 2.3.0

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1  
- Updated to 2.2.0

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.6-1  
- Updated to 2.1.6

* Wed Feb 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.5-1
- Updated to 2.1.5

* Wed Oct 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1
- Updated to 2.1.2

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1
- Updated to 2.1.1

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1
- Updated to 2.06

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1  
- Initial release for SME Server
- Original build from pear make-rpm-spec

