%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Browser API
Name: Horde_Browser
Version: 2.0.16
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Browser-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Browser
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
The Horde_Browser class provides an API for getting information about the
current user's browser and its capabilities.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Browser.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Browser.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Browser >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Browser/*
%{peardir}/*
%{xmldir}/Horde_Browser.xml

%changelog
* Wed Jan 16 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.16-1
- Updated to 2.0.16

* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.15-1
- Updated to 2.0.15

* Mon Jul 31 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.14-1
- Updated to 2.0.14

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.13-1
- Updated to 2.0.13

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.12-1
- Updated to 2.0.12

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.11-1
- Updated to 2.0.11

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.10-1
- Updated to 2.0.10

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.9-1
- Updated to 2.0.9

* Wed Nov 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.8-1
- Updated to 2.0.8

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.7-1
- Updated to 2.0.7

* Wed Mar 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1
- Updated to 2.0.6

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Updated to 2.0.5

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Updated to 2.0.4

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec


