# $Id: e-smith-imp.spec,v 1.1 2013/02/14 16:15:34 slords Exp $

Summary: e-smith specific IMP configuration and templates.
%define name e-smith-imp
Name: %{name}
%define version 5.7.0
%define release 3
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch1: e-smith-imp-5.7.0_sme10_smtpd_db_update.patch
Patch2: e-smith-imp-5.7.0_spam_learning.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: horde >= 5
Requires: imp-h5 >= 6
Requires: e-smith-base >= 4.15.1
Requires: e-smith-apache >= 1.1.0-18
Requires: e-smith-lib >= 1.15.1-16
Requires: e-smith-ingo
Requires: php
Requires: php-ldap
Requires: php-mysql
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no
Obsoletes: dcb-e-smith-imp
Obsoletes: smeserver-imp-menuarray
Requires: php-pear(HTTP_Request)
Obsoletes: smeserver-dimp
Obsoletes: smeserver-mimp

%changelog
* Mon Mar 27 2017 John H. Bennett III <bennettj@johnbennettservices.com> 5.7.0-3
- Patch to enable spam reporting in horde, now that the tell option has been enabled in
  SME 9.2, so that I can get rid of the custom-template I have been using.

* Mon Jun 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> 5.7.0-2
- Patch to update 120IMAPServers template file because of db migration from smtpd to qpsmtpd.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 5.7.0-1
- Re-rolled and incremented version number so that it won't conflict with horde 3 rpms currently in SME 10.

* Sun Jan 3 2016 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-22
- Patch to change default imap subscription setting to disabled.  This makes it easier when using
  shared or public folders.  Will only be changed for users that have never logged into Horde webmail.
  For those that have, to change go to preferences/mail/show advanced preferences/
  folder display/uncheck Use IMAP mailbox subscriptions

* Fri Jan 1 2016 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-21
- Patch to enable shared mailboxes.  smeserver-dovecot-extras rpm must be installed and configured.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-20
- Partial implementation of [SME: 6465] to enable message logging and to implement 
  max_recipients and max_timelimit restrictions.  This is a two-step process.
  Step 1, enable message logging - config setprop horde LogMessages enabled ; signal-event email-update
  Step 2, configure horde permissions.  Administration, Permissions, All Permissions, Mail, Add, Mail(Plus sign), 
  Maximum Number of Recipients per Message, add value, update.  Mail (Plus sign), Mail,
  Maximum Number of Recipients per Time Period, add value, update.  Don't forget to add all permissions to Mail
  for All Authenticated Users.  If you don't, users won't be able to see the mail link in webmail.
  You can also add different values to individual users using the full user@domain.com syntax, or
  a group using the group name created in the horde administration panel.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-19
- Patch to include additional apache ACL directory restrictions

* Mon Sep 14 2015 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-18
- Patch to remove ldap logic so that ldap auth will really work if ldap auth is enabled.

* Sun Feb 22 2015 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-17
- Patch to add all the html compose buttons when composing mail using html format.

* Sat Nov 29 2014 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-16
- Patch to imp which enables report as spam and innocent buttons.
- This would need further modifications for the distro as it requires a change
  to /var/service/spamd/run to add -l parameter after spamd, razor registration,
  spamassassin/local.cf, and razor-agent.conf config changes.

* Fri Sep 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-15
- Patch to imp conf.php for 6.2.3 complliance

* Fri Sep 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-14
- Patch to imp conf.php for 6.2.2 compliance
- Changed PHP keylength to default to 2048

* Sat Jul 12 2014 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-13
- Patch to imp mime_drivers.local.php for 6.2 compatibility.

* Mon Jun 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-12
- Patch to imp conf.php for 6.2 compliance

* Thu Dec 26 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-11
- Patch to correct link attachment regression config in conf.php.  
  Want to acually send the attachments, not link to them from local server.

* Thu Dec 26 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-10
- Patch to add quota info to imp menu if a quota is set.

* Wed Jul 17 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-9
- Patch that bring imp conf.php up to imp 6.1.1 specs

* Wed Jun 05 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-8
- Updated spec file to require horde >= 6 and imp-h5 >=6

* Thu Mar 28 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-7
- Patch that removes no longer needed imp.sql in horde/smeserver directory

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-6
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-5
- Update file id and other misc. settings in conf.php so config shows up to date.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-4
- Update imp backends.local.php template to change imap to use port 143 and notls [SME: 7682]


* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-3
- Update imp prefs.local.php template to display attachment icon by default

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-2
- Update imp mime_drivers.local.php template to fix limitinlinesize for text in message

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-1
- Update imp templates to reflect changes in imp 5.0.20

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 5.5.0-0
- Roll new stream for horde5 components and above under sme9

* Wed Feb 13 2013 Shad L. Lords <slords@mail.com> 5.4.0-1.sme
- Roll new stream for sme9

* Tue Dec 21 2010 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-10
- Patch to enable LDAP auth for horde webmail 

* Wed May 5 2010 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-9
- Updated templates to reflect changes in imp 4.3.7 

* Sun Feb 14 2010 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-8
- Patch to template imp's mime_drivers.php file so some settings can be customized [SME: 5224]
- config setprop horde Limitinlinesize  <--default is 1048576
- config setprop horde inlineHTML true|false <--default is true
- config setprop horde inlineImages true|false <--default is true

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-7
- Updated templates to reflect changes in imp 4.3.6 [SME: 5776]

* Tue Oct 13 2009 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-6  
- Updated templates to reflect changes in imp 4.3.5 [SME: 5510]

* Sat Jun 20 2009 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-5
- Updated templates to reflect changes in imp 4.3.4 [SME: 5371]

* Wed Jan 07 2009 Gavin Weight <gweight@gmail.com> 5.2.0-4
- Updated spec file to require php-pear(HTTP_Request) and remove obsolete
  php-pear-HTTP-Request line. [SME: 4928]

* Wed Dec 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-3
- Updated spec file to require php-pear-HTTP-Request to accomodate HTML composition [SME: 4821]

* Sat Dec 06 2008 John H. Bennett III <bennettj@johnbennettservices.com> 5.2.0-2       
- Updated templates to reflect changes in imp 4.3 [SME: 4832]

* Tue Oct 7 2008 Shad L. Lords <slords@mail.com> 5.2.0-1.sme
- Roll new stream to separate sme7/sme8 trees [SME: 4633]

* Mon Jun 23 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2-1
- Initial build
- Jump in package name to reflect new version of imp

%description
This package adds necessary templates and configuration items
so that IMP 6.x will work properly on SME Server

%prep
%setup

%patch1 -p1
%patch2 -p1

%build
mkdir -p root/home/httpd/html/horde/imp/SSLonly
 
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
