%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Alarm Libraries
Name: Horde_Alarm
Version: 2.2.10
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Alarm-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Alarm
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
An interface to deal with reminders, alarms and notifications through a
standardized API. The following notification methods are currently
available: standard Horde notifications, popups, emails.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Alarm.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Alarm.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Alarm >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Alarm/*
%{peardir}/*
%{xmldir}/Horde_Alarm.xml

%changelog
* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.10-1  
- Updated to 2.2.10

* Wed May 5 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.9-1  
- Updated to 2.2.9

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.8-1  
- Updated to 2.2.8

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.7-1  
- Updated to 2.2.7

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.6-1  
- Updated to 2.2.6

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.5-1  
- Updated to 2.2.5

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.4-1  
- Updated to 2.2.4

* Thu Nov 06 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.3-1  
- Updated to 2.2.3

* Sat Oct 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.2-1  
- Updated to 2.2.2

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1  
- Updated to 2.2.1

* Thu Apr 03 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1  
- Updated to 2.2.0

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Thu Oct 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Updated to 2.0.5

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
