%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Weather Provider
Name: Horde_Service_Weather
Version: 2.5.5
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Service_Weather-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Service_Weather
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Http >= 2.0.0
Requires: Horde_Http < 3.0.0alpha1
Requires: Horde_Url >= 2.0.0
Requires: Horde_Url < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Set of classes that provide an abstraction to various online weather
service providers. Includes drivers for WeatherUnderground,
WorldWeatherOnline, and Google Weather.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Service_Weather.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Service_Weather.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Service_Weather >/dev/null || :
fi

%files
/usr/bin/horde-service-weather-metar-database
%defattr(-,root,root)
%doc %{pear_hordedir}
#%doc docs/Horde_Service_Weather/*
%{peardir}/*
%{xmldir}/Horde_Service_Weather.xml


%changelog
* Sat Dec 5 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.5-1  
- Updated to 2.5.5

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.4-1  
- Updated to 2.5.4

* Sun Dec 11 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.3-1  
- Updated to 2.5.3

* Mon Nov 14 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.2-1  
- Updated to 2.5.2

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1  
- Updated to 2.4.0

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.4-1  
- Updated to 2.3.4

* Wed Mar 16 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.3-1  
- Updated to 2.3.3

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.2-1  
- Updated to 2.3.2

* Mon Jan 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.1-1  
- Updated to 2.3.1

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1  
- Updated to 2.3.0

* Fri Sep 4 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1  
- Updated to 2.2.0

* Sat Mar 7 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.6-1  
- Updated to 2.1.5

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.5-1  
- Updated to 2.1.5

* Sat Oct 11 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.4-1  
- Updated to 2.1.4

* Tue Jul 1 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1  
- Updated to 2.1.3

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1  
- Updated to 2.1.1

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1  
- Updated to 2.1.0

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
