%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Caching API
Name: Horde_Cache
Version: 2.5.5
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Cache-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Cache
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Compress_Fast >= 1.0.0
Requires: Horde_Compress_Fast < 2.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_HashTable >= 1.0.0
Requires: Horde_HashTable  < 2.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
A simple, functional caching API, with the option to store the cached data
on the filesystem, in one of the PHP opcode cache systems (APC,
eAcclerator, XCache, or Zend Performance Suite's content cache), memcached,
or an SQL table.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Cache.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Cache.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Cache >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Cache/*
%{peardir}/*
%{xmldir}/Horde_Cache.xml

%changelog
* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.5-1  
- Updated to 2.5.5

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.4-1  
- Updated to 2.5.4

* Mon Feb 22 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.3-1  
- Updated to 2.5.3

* Mon Jan 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1  
- Updated to 2.5.1

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.0-1  
- Updated to 2.5.0

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.2-1  
- Updated to 2.4.2

* Wed Feb 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.1-1
- Updatde to 2.4.1

* Thu Oct 10 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- Updated to 2.3.0

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1
- Update to 2.2.1

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Initial release for SME Server
- Original build from pear make-rpm-spec


