# $Id: smeserver-nag.spec,v 1.1 2010/07/08 15:01:16 slords Exp $
# Authority: mrjhb3
# Name: John H. Bennett III

Summary: SME Server specific Nag configuration and templates.
%define name smeserver-nag
Name: %{name}
%define version 2.3
%define release 13
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch0: smeserver-nag_3_upgrade.patch
Patch1: smeserver-nag_Nag_Convert_Datatree-to-SQL.patch
Patch2: smeserver-nag_4_conf_php.patch
Patch3: smeserver-nag_convert-datatree-shares-to-sql.patch
Patch4: smeserver-nag_4_conf_menu_apps_php.patch
Patch5: smeserver-nag_migrate_db_hide.patch
Patch6: smeserver-nag_http_directive.patch
Patch7: smeserver-nag_99Nag_Datatree_to_SQL_typo_fix.patch
Patch8: smeserver-nag_task_sharing.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: e-smith-base >= 4.15.1
Requires: e-smith-apache >= 1.1.0-18
Requires: e-smith-lib >= 1.15.1-16
Requires: imp-h5 >= 6
Requires: nag-h5 >= 4
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no
Obsoletes: dcb-e-smith-nag
Obsoletes: smeserver-nag-menuarray

%changelog
* Wed Nov 21 2018 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-13
- add Obsoletes: smeserver-nag-menuarray [SME: 10488] 

* Tue May 9 2017 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-12
- Patch to fix unable to share tasks.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-11
- Patch to correct typo in 99Nag_Datatree_to_SQL file.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-10
- Patch to include additional apache ACL directory restrictions

* Wed Mar 26 2014 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-9
- Patch to send the majority of the output from horde table migration to /dev/null.
  Some log noise errors will still be seen depending on what tables are present from
  previous versions.

* Fri May 31 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-8
- Updated spec file to require imp-h5 >= 6 and nag-h5 >= 4

* Wed Apr 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-7
- Remark out requires until proper RPM's are built.

* Tue Nov 27 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-6
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sun Nov 25 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-5  
- Update to latest nag-convert-datatree-shares-to-sql script for automated 
  SME Server install.

* Sat Nov 24 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-4
 -Update file id in conf.php so config shows up to date.

* Thu Aug 2 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-3
- Add SME Server modified script to migrate Nag Datatree to SQL backend so that
  upgrades will migrate data to new DB structure

* Mon Apr 30 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-2
- Update Nag templates to reflect changes in Nag 3.0.7

* Mon Apr 30 2012 John H. Bennett III <bennettj@johnbennettservices.com> 2.3-1
-  Re-rolled for Nag 3.0.x

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-7
- Updated templates to reflect Nag 2.3.5

* Mon Dec 28 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-6          
- Updated templates to reflect Nag 2.3.4

* Sat Oct 10 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-5
- Updated templates to reflect Nag 2.3.3

* Wed Jun 17 2009 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-4
- Updated templates to reflect Nag 2.3.2

* Tue Sep 30 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-3
- Patch to add forgotten changes from nag upgrade sql script

* Mon Sep 29 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-2
- Updated templates to reflect Nag 2.3

* Tue Jun 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-1    
- Initial production build
- Jump in package name to reflect new version of Nag 2.2

* Sat May 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 0.2-1
- Updated to include changes in Nag 2.2 RC3
- Re-rolled tarball 

* Sun Apr 6 2008 John H. Bennett III <bennettj@johnbennettservices.com> 0.1-1
- Initial build
- Jump in package name to reflect new version of Nag

%description
This package adds necessary templates and configuration items
so that Nag will work properly on SME Server

%prep
%setup

%patch0 -p1 
%patch1 -p1 
%patch2 -p1 
%patch3 -p1 
%patch4 -p1 
%patch5 -p1 
%patch6 -p1 
%patch7 -p1 
%patch8 -p1 

%build
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
