%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde SMTP Client
Name: Horde_Smtp
Version: 1.9.6
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Smtp-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Smtp
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Provides interfaces for connecting to a SMTP (RFC 5321) server to send
e-mail messages..

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Smtp.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Smtp.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Smtp >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Smtp/*
%{peardir}/*
%{xmldir}/Horde_Smtp.xml


%changelog
* Fri Nov 20 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.6-1  
- Updated to 1.9.6

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.5-1  
- Updated to 1.9.5

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.4-1  
- Updated to 1.9.4

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.3-1  
- Updated to 1.9.3

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.2-1  
- Updated to 1.9.2

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.1-1  
- Updated to 1.9.1

* Tue Mar 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.9.0-1  
- Updated to 1.9.0

* Sat Jan 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.8.0-1  
- Updated to 1.8.0

* Tue Nov 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.7.0-1  
- Updated to 1.7.0

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.6.0-1  
- Updated to 1.6.0
	
* Sat Jun 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.5.2-1  
- Updated to 1.5.2

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.5.0-1  
- Updated to 1.5.0

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.1-1  
- Updated to 1.4.1

* Wed Feb 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.4.0-1
- Updated to 1.4.0

* Thu Nov 22 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.1-1
- Updated to 1.3.1

* Wed Oct 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.3.0-1
- Updated to 1.3.0

* Mon Sep 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.2.3-1
- Initial release for SME Server                
- Original build from pear make-rpm-spec

