%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Preferences API
Name: Horde_Prefs
Version: 2.9.0
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Prefs-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Prefs
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}   

%description
The Horde_Prefs package provides a common abstracted interface into the
various preferences storage mediums. It also includes all of the functions
for retrieving, storing, and checking preference values.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Prefs.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Prefs.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Prefs >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Prefs/*
%{peardir}/*
%{xmldir}/Horde_Prefs.xml
%{_bindir}/horde-prefs

%changelog
* Sun Nov 12 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.0-1
- Updated to 2.9.0

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.8.1-1
- Updated to 2.8.1

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.8.0-1
- Updated to 2.8.0

* Wed Mar 16 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.6-1
- Updated to 2.7.6

* Mon Jan 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.5-1
- Updated to 2.7.5

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.4-1
- Updated to 2.7.4

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.3-1
- Updated to 2.7.3

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.2-1
- Updated to 2.7.2

* Sat Jan 3 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.1-1
- Updated to 2.7.1

* Wed Sep 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.0-1
- Updated to 2.7.0

* Tue May 13 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.0-1
- Updated to 2.6.0

* Mon Nov 11 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.2-1
- Updated to 2.5.2

* Mon Oct 28 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1
- Updated to 2.5.1

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.0-1
- Updated to 2.5.0

- Initial release for SME Server
- Original build from pear make-rpm-spec

