%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Image API
Name: Horde_Image
Version: 2.6.1
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Image-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Image
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
An Image utility API, with backends for:
* GD
* GIF
* PNG
* SVG
* SWF
* ImageMagick convert command line tool
* Imagick Extension

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s
%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Image.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Image.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Image >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Image/*
%{peardir}/*
%{xmldir}/Horde_Image.xml


%changelog
* Wed Mar 25 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.1-1
- Updated to 2.6.1

* Wed Jan 16 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.0-1
- Updated to 2.6.0

* Sun Jun 24 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.3-1
- Updated to 2.5.3

* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.2-1
- Updated to 2.5.2

* Mon Jun 26 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1
- Updated to 2.5.1

* Sat Apr 15 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.1-1
- Updated to 2.4.1

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1
- Updated to 2.4.0

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.6-1
- Updated to 2.3.6

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.5-1
- Updated to 2.3.5

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.4-1
- Updated to 2.3.4

* Mon Sep 7 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.3-1
- Updated to 2.3.3

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.2-1
- Updated to 2.3.2

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.1-1
- Updated to 2.3.1

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- Updated to 2.3.0

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Updated to 2.2.0

* Sat Jun 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.8-1
- Updated to 2.0.8

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1  
- Updated to 2.0.6

* Mon Jul 15 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Updated to 2.0.5

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
