%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Cryptography API
Name: Horde_Crypt
Version: 2.7.12
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Crypt-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Crypt
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Stream_Filter >= 2.0.0
Requires: Horde_Stream_Filter < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
The Horde_Crypt package class provides an API for various cryptographic
systems.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Crypt.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Crypt.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Crypt >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Crypt/*
%{peardir}/*
%{xmldir}/Horde_Crypt.xml

%changelog
* Sun Sep 30 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.12-1  
- Updated to 2.7.12

* Sun Nov 12 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.11-1  
- Updated to 2.7.11

* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.10-1  
- Updated to 2.7.10

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.9-1  
- Updated to 2.7.9

* Wed May 5 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.8-1  
- Updated to 2.7.8

* Mon Apr 3 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.6-1  
- Updated to 2.7.6

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.5-1  
- Updated to 2.7.5

* Sat Dec 3 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.4-1  
- Updated to 2.7.4

* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.3-1  
- Updated to 2.7.3

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.0-1  
- Updated to 2.7.0

* Mon Aug 24 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.1-1  
- Updated to 2.6.1

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.0-1  
- Updated to 2.6.0

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.3-1  
- Updated to 2.5.3

* Sat Jan 3 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.2-1  
- Updated to 2.5.2

* Wed Nov 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.1-1  
- Updated to 2.5.1

* Tue Jul 1 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.5.0-1  
- Updated to 2.5.0

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.3-1  
- Updated to 2.4.3

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.2-1  
- Updated to 2.4.2

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.1-1
- Updated to 2.4.1

* Tue Nov 19 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1
- Updated to 2.4.0

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.2-1
- Updated to 2.2.2

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Initial release for SME Server
- Original build from pear make-rpm-spec


