# $Id: e-smith-turba.spec,v 1.1 2013/02/14 16:17:11 slords Exp $

Summary: e-smith module to configure Turba 1.0
%define name e-smith-turba
Name: %{name}
%define version 3.7.0
%define release 3
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch1: e-smith-turba-3.7.0_backends.local.php.patch
Patch2: e-smith-turba-3.7.0_turba_sync.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildRequires: e-smith-devtools
BuildArchitectures: noarch
Requires: e-smith-base, e-smith-lib, e-smith >= 4.1
Requires: imp-h5 >= 6
Requires: turba-h5 >= 4
AutoReqProv: no
Obsoletes: dcb-e-smith-turba
Obsoletes: smeserver-turba-menuarray

%changelog
* Sun Nov 24 2019 John H. Bennett III <bennettj@johnbennettservices.com> 3.7.0-3
- Patch to fix email syning to mobile devices.

* Thu Mar 16 2017 John H. Bennett III <bennettj@johnbennettservices.com> 3.7.0-2
- Patch to add more email fields to turba for better synchronization with ActiveSync per horde devs.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 3.7.0-1
- Re-rolled and incremented version number so that it won't conflict with horde 3 rpms currently in SME 10.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-13
- Patch to fix typo in 99Turba_Datatree_to_SQ file.

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-12
- Patch to include additional apache ACL directory restrictions

* Mon Nov 11 2014 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-11
- Patch to add the ability to import vcard contacts that have multiple email addresses

* Thu Jul 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-10
- Patch to turba to add the ability to create additional MySQL ojbects that are 
  used, but no longer created by the default install.

* Mon Jun 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-9
- Patch to turba conf.php for 4.2 compatibility.

* Wed Mar 26 2014 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-8
- Patch to send the majority of the output from horde table migration to /dev/null.
  Some log noise errors will still be seen depending on what tables are present from
  previous versions.

* Wed Jun 05 2013  John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-7
- Updated spec file to require imp-h5 >=6 and turba-h5 >=4

* Fri Apr 26 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-6
- Change patch0 name and fixed typo in patch

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-5
- Re-add patch after new stream created
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-4
- Re-add patch after new stream created
- Update to latest turba-convert-datatree-shares-to-sql script for automated 
  SME Server install.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-3
- Re-add patch after new stream created
- Update file id in conf.php so config shows up to date.

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-2
- Re-add patch after new stream created
- Add SME Server modified script to migrate Turba Datatree to SQL backend so that
  upgrades will migrate data to new DB structure

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-1
- Re-add patch after new stream created
- Update turba templates to reflect changes in turba 3.0.13

* Sat Mar 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 3.5.0-0
- Roll new stream for horde5 components and above under sme9

* Wed Feb 13 2013 Shad L. Lords <slords@mail.com> 3.4.0-1
- Roll new stream for sme9

* Fri Nov 12 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-17
- Fix bug in refactored code used to set ldap base dn. [SME: 2939]

* Fri Nov 12 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-16
- Refactored code used to set ldap base dn.  Thanks Shad Lords [SME: 2939]

* Sun Aug 1 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-15
- Update to remove turbaContact info that SME is not using [SME: 5942]

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-14
- Patch that adds the ability to have a local LDAP Group Address book.  [SME: 5944]

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-13
- Patch to template attributes.php to add ability to have multiple email values
  for a contact.  Separate entries with a comma and a space [SME: 5943]

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-12
- Update to freebusy info in sources.php [SME 5942]

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-11
- Update to fix turbatype error when using turba LDAP address search [SME: 5772]

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-10
- Update LDAP for changed scope [SME: 2939]

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-9
- Updated template files to reflect changes in Turba 2.3.3 [SME: 5778]
- Remove previous patch.  Will add new partial patch for bug 2939

* Sat Feb 13 2010 Stephen Noble <support@dungog.net> 3.2.0-8
- Update LDAP for changed schema [SME: 2939]

* Tue Oct 13 2009 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-7   
- Updated template files to reflect changes in Turba 2.3.2 [SME: 5512]

* Wed Apr 8 2009 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-6
- Remove redundant 49turba_migrate_contacts template fragments [SME: 5148]

* Sun Jan 4 2009 Jonathan Martens <smeserver-contribs@snetram.nl> 3.2.0-5
- Fix date in previous changelog entry [SME: 4910]

* Sun Jan 4 2009 Jonathan Martens <smeserver-contribs@snetram.nl> 3.2.0-4
- Fix turba.sql patch to prevent creating a .orig file [SME: 4910]

* Fri Jan 2 2009 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-3       
- Updated template files to reflect changes in Turba 2.3.1

* Sat Dec 06 2008 John H. Bennett III <bennettj@johnbennettservices.com> 3.2.0-2       
- Updated template files to reflect changes in Turba 2.3 [SME: 4833]

* Tue Oct 7 2008 Shad L. Lords <slords@mail.com> 3.2.0-1.sme
- Roll new stream to separate sme7/sme8 trees [SME: 4633]

* Fri Jul 11 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-3
- Patch to fix 49turba_migrate_contacts to not run on post-install

* Fri Jun 20 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-2
- Upgrade patch for Turba 2.2.1

* Sat Jun 7 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-1    
- Initial production build

* Sat May 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-02
- Updated to include changes in Turba 2.2 RC4
- Re-rolled tarball

* Fri Apr 11 2008 John H. Bennett III <bennettj@johnbennettservices.com> 2.2-01
- Initial build
- Jump in package name to reflect new version of turba

%description
This package adds necessary templates and configuration items
so that Turba will work properly on SME Server

%prep
%setup

%patch1 -p1
%patch2 -p1

%build
perl createlinks


%install
rm -rf $RPM_BUILD_ROOT
(cd root   ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
rm -f %{name}-%{version}-filelist
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)

