%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name XML_Parser2

Summary: XML parsing class based on PHP's bundled expat
Name: php-pear-XML-Parser2
Version: 0.1.0
Release: 2%{?dist}
License: BSD License
Group: Development/Libraries
Source0: http://pear.php.net/get/XML_Parser2-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/XML_Parser2

BuildRequires:  php-pear(PEAR) >= 1.4.7
Requires: php-pear(PEAR) >= 1.4.0b1
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::PEAR
#Requires: PEAR::PEAR >= 1.4.0b1

BuildArch: noarch

%description
This is an XML parser based on PHPs built-in xml extension.
It supports two basic modes of operation: "func" and "event".  In "func"
mode, it will look for a function named after each element (xmltag_ELEMENT
for start tags and xmltag_ELEMENT_ for end tags), and in "event" mode it
uses a set of generic callbacks.

Since version 1.2.0 there's a new XML_Parser_Simple class that makes
parsing of most XML documents easier, by automatically providing a stack
for the elements.
Furthermore its now possible to split the parser from the handler object,
so you do not have to extend XML_Parser anymore in order to parse a
document with it.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/XML_Parser2.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/XML_Parser2.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/XML_Parser2 >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/XML_Parser2/*
%{peardir}/*
%{xmldir}/XML_Parser2.xml

%changelog
* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 0.1.0-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 0.1.0-1
- Original from pear-make-rpm-spec.

