%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name PEAR_Command_Packaging

Summary: make-rpm-spec command for managing RPM .spec files for PEAR packages
Name: php-pear-PEAR-Command-Packaging
Version: 0.3.0
Release: 2%{?dist}
License: PHP License 3.01
Group: Development/Libraries
Source0: http://pear.php.net/get/PEAR_Command_Packaging-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/PEAR_Command_Packaging

BuildRequires:  php-pear(PEAR) >= 1.7.0
Requires: php-pear(PEAR) >= 1.4.3
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::PEAR >= 1.4.3

BuildArch: noarch

%description
This command is an improved implementation of the standard 'makerpm'
command,
  and contains several enhancements that make it far more flexible. Similar

  functions for other external packaging mechanisms may be added at a later
date.

  Enhanced features over the original PEAR "makerpm" command include:
  
  - Ability to define a release on the command line
  - Allows more advanced customisation of the generated package name
  - Allows virtual Provides/Requires that differ in format from the package
name
    format 
  - tries to intelligently distinguish between PEAR and PECL when
generating 
    packages

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/PEAR_Command_Packaging.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/PEAR_Command_Packaging.xml

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/PEAR_Command_Packaging
fi

%files
%defattr(-,root,root)
%doc docs/PEAR_Command_Packaging/*
%{peardir}/*
%{xmldir}/PEAR_Command_Packaging.xml

%changelog
* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 0.3.0-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 0.3.0-1
- Original from pear-make-rpm-spec.
