%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde Database Libraries
Name: Horde_Db
Version: 2.4.0
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Db-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Db
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
BuildRequires: php-channel(pear.horde.org)
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Horde database/SQL abstraction layer

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Db.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Db.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Db >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Db/*
%{peardir}/*
%{xmldir}/Horde_Db.xml
%{_bindir}/horde-db-migrate-component

%changelog
* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.0-1  
- Updated to 2.4.0

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.4-1  
- Updated to 2.3.4

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.3-1  
- Updated to 2.3.3

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.2-1  
- Updated to 2.3.2

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.1-1  
- Updated to 2.3.1

* Wed Nov 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1  
- Updated to 2.3.0

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.3-1  
- Updated to 2.2.3

* Wed Nov 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.2-1  
- Updated to 2.2.2

* Sat Oct 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.5-1  
- Updated to 2.1.5

* Tue Oct 02 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.4-1  
- Updated to 2.1.4

* Sat Jun 28 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1  
- Updated to 2.1.3

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1  
- Updated to 2.1.2

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1  
- Updated to 2.1.1

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1
- Updated to 2.1.0

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Updated to 2.0.4

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

