%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde_SyncMl provides an API for processing SyncML requests
Name: Horde_SyncMl
Version: 2.0.7
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_SyncMl-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_SyncMl
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Date >= 2.0.0
Requires: Horde_Date < 3.0.0alpha1
Requires: Horde_Icalendar >= 2.0.0
Requires: Horde_Icalendar < 3.0.0alpha1
Requires: Horde_Log >= 2.0.0
Requires: Horde_Log < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_Xml_Wbxml >= 2.0.0
Requires: Horde_Xml_Wbxml < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Classes for implementing a SyncML server.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_SyncMl.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_SyncMl.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_SyncMl >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_SyncMl/*
%{peardir}/*
%{xmldir}/Horde_SyncMl.xml

%changelog
* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.7-1
- Update to 2.0.7

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1
- Update to 2.0.6

* Thu Dec 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Update to 2.0.5

* Fri Jul 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.4-1
- Update to 2.0.4

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
