%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde MIME Viewer Library
Name: Horde_Mime_Viewer
Version: 2.2.2
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Mime_Viewer-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Mime_Viewer
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Browser >= 2.0.0
Requires: Horde_Browser < 3.0.0alpha1
Requires: Horde_Compress >= 2.0.0
Requires: Horde_Compress < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Text_Filter >= 2.0.0
Requires: Horde_Text_Filter < 3.0.0alpha1
Requires: Horde_Text_Flowed >= 2.0.0
Requires: Horde_Text_Flowed < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Provides rendering drivers for MIME data.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Mime_Viewer.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Mime_Viewer.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Mime_Viewer >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc %{pear_hordedir}
#%doc docs/Horde_Mime_Viewer/*
%{peardir}/*
%{xmldir}/Horde_Mime_Viewer.xml

%changelog
* Sun Sep 10 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.2-1  
- Updated to 2.2.2

* Tue Sep 6 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.1-1  
- Updated to 2.2.1

* Tue Aug 8 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1  
- Updated to 2.2.0

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.3-1  
- Updated to 2.1.3

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.2-1  
- Updated to 2.1.2

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.1-1  
- Updated to 2.1.1

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.1.0-1  
- Updated to 2.1.0

* Wed Nov 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.8-1  
- Updated to 2.0.8

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.7-1  
- Updated to 2.0.7

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.6-1  
- Updated to 2.0.6

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.5-1
- Initial release for SME Server
- Original build from pear make-rpm-spec

