%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde IMAP Client
Name: Horde_Imap_Client
Version: 2.30.1
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Imap_Client-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Imap_Client
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Mime >= 2.0.0
Requires: Horde_Mime < 3.0.0alpha1
Requires: Horde_Stream >= 1.0.0
Requires: Horde_Stream < 2.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Interface to access IMAP4rev1 (RFC 3501) mail servers. Also supports
connections to POP3 (STD 53/RFC 1939).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Imap_Client.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Imap_Client.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Imap_Client >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Imap_Client/*
%{peardir}/*
%{xmldir}/Horde_Imap_Client.xml

%changelog
* Mon Nov 11 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.30.1-1
- Update to 2.30.1

* Tue Oct 8 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.30.0-1
- Update to 2.30.0

* Wed Sep 18 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.18-1
- Update to 2.29.18

* Sat Mar 2 2019 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.17-1
- Update to 2.29.17

* Sun Jun 24 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.16-1
- Update to 2.29.16

* Sun Sep 10 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.15-1
- Update to 2.29.15

* Tue Aug 1 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.14-1
- Update to 2.29.14

* Sat Jun 24 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.13-1
- Update to 2.29.13

* Sun Dec 18 2016 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.12-1
- Update to 2.29.12

* Sat Dec 3 2016 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.11-1
- Update to 2.29.11

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.9-1
- Update to 2.29.9

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.8-1
- Update to 2.29.8

* Thu Jun 2 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.7-1
- Update to 2.29.7

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.6-1
- Update to 2.29.6

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.5-1
- Update to 2.29.5

* Wed Nov 25 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.4-1
- Update to 2.29.4

* Mon Sep 7 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.3-1
- Update to 2.29.3

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.1-1
- Update to 2.29.1

* Thu Jun 18 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.29.0-1
- Update to 2.29.0

* Tue May 12 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.28.1-1
- Update to 2.28.1

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.28.0-1
- Update to 2.28.0

* Tue Mar 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.27.0-1
- Update to 2.27.0

* Wed Feb 04 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.26.1-1
- Update to 2.26.1

* Thu Dec 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.25.6-1
- Update to 2.25.6

* Tue Nov 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.25.5-1
- Update to 2.25.5

* Fri Oct 17 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.25.2-1
- Update to 2.25.2

* Sat Sep 20 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.25.1-1
- Update to 2.25.1

* Wed Sep 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.25.0-1
- Update to 2.25.0

* Tue Aug 12 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.24.2-1
- Update to 2.24.2

* Wed Jul 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.23.2-1
- Update to 2.23.2

* Wed Jun 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.23.1-1
- Update to 2.23.1

* Tue Jun 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.22.0-1
- Update to 2.22.0

* Wed May 21 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.20.0-1
- Update to 2.20.0

* Thu Apr 3 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.19.2-1  
- Update to 2.19.2

* Sun Mar 16 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.19.1-1
- Update to 2.19.1

* Tue Mar 11 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.19.0-1
- Update to 2.19.0

* Sat Jan 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.17.1-1
- Update to 2.17.1

* Sat Nov 2 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.16.0-1
- Update to 2.16.0

* Sun Oct 12 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.15.5-1
- Update to 2.15.5

* Fri Jul 26 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.12.0-1
- Update to 2.12

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.11.2-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
