%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name HTTP_WebDAV_Server      

Summary: WebDAV Server Baseclass
Name: php-pear-HTTP_WebDAV_Server
Version: 1.0.0RC8
Release: 2
License: New BSD License
Group: Development/Libraries
Source0: http://pear.php.net/get/HTTP_WebDAV_Server-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/HTTP_WebDAV_Server

BuildRequires:  php-pear(PEAR) >= 1.4.7
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7

BuildArch: noarch

%description
RFC2518 compliant helper class for WebDAV server implementation.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/HTTP_WebDAV_Server.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/HTTP_WebDAV_Server.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/HTTP_WebDAV_Server >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/HTTP_WebDAV_Server/*
%{peardir}/*
%{xmldir}/HTTP_WebDAV_Server.xml

%changelog
* Mon Jun 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.0RC8-2
- updated spec file requires section, and left original info remarked.

* Mon Jun 24 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.0RC8-1
- Original build from pear-make-rpm-spec.
