%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name Log

Summary: PEAR: Logging Framework
Name: php-pear-Log
Version: 1.13.2
Release: 1%{?dist}
License: MIT License
Group: Development/Libraries
Source0: http://pear.php.net/get/Log-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/Log
BuildRequires:  php-pear(PEAR) >= 1.4.7
Provides:       php-pear(%{pear_name}) = %{version}

BuildArch: noarch

%description
The Log package provides an abstracted logging framework.  It includes
output handlers for log files, databases, syslog, email, Firebug, and the
console.  It also provides composite and subject-observer logging
mechanisms.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Log.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Log.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/Log >/dev/null || :
fi

%files
%defattr(-,root,root)
%doc docs/Log/*
%{peardir}/*
%{xmldir}/Log.xml

%changelog
* Sat Jul 4 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 1.13.2-1
- Updated to 1.13.2

* Mon Apr 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.13.1-1
- Updated to 1.13.1

* Mon Jun 15 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 1.12.9-1
- Updated to 1.12.9

* Tue Jul 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.12.8-1
- Build from SME Server 9.  Remi SRC files kept failing test section for some reason
- Original from pear-make-rpm-spec.
