%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde MIME Library
Name: Horde_Mime
Version: 2.11.1
Release: 1%{?dist}
License: LGPL-2.1
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Mime-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Mime
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Mail >= 2.0.0
Requires: Horde_Mail < 3.0.0alpha1
Requires: Horde_Stream_Filter >= 2.0.0
Requires: Horde_Stream_Filter < 3.0.0alpha1
Requires: Horde_Support >= 2.1.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Text_Flowed >= 2.0.0
Requires: Horde_Text_Flowed < 3.0.0alpha1
Requires: Horde_Translation >= 2.0.0
Requires: Horde_Translation < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

Provides:       %{name} = %{version}

%description
Provides methods for dealing with Multipurpose Internet Mail Extensions
(MIME) features (RFC 2045/2046/2047).

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Mime.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Mime.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Mime >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Mime/*
%{peardir}/*
%{xmldir}/Horde_Mime.xml

%changelog
* Tue Oct 20 2020 John H. Bennett III <bennettj@johnbennettservices.com> - 2.11.1-1
- Update to 2.11.1

* Wed Jan 17 2018 John H. Bennett III <bennettj@johnbennettservices.com> - 2.11.0-1
- Update to 2.11.0

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 2.10.3-1
- Update to 2.10.3

* Wed Nov 9 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.10.2-1
- Update to 2.10.2

* Mon Sep 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.10.1-1
- Update to 2.10.1

* Wed Jul 27 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.10.0-1
- Update to 2.10.0

* Thu Jun 2 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.5-1
- Update to 2.9.5

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.4-1
- Update to 2.9.4

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.3-1
- Update to 2.9.3

* Fri Sep 4 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.2-1
- Update to 2.9.2

* Wed Jun 6  2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.1-1
- Update to 2.9.1

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.9.0-1
- Update to 2.9.0

* Thu Apr 16 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.8.1-1
- Update to 2.8.1

* Tue Mar 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.8.0-1
- Update to 2.8.0

* Tue Jan 20 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 2.7.0-1
- Update to 2.7.0

* Tue Dec 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.6.0-1
- Update to 2.6.0

* Wed Aug 27 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.5-1
- Update to 2.4.5

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.4-1
- Update to 2.4.4

* Wed Jul 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.3-1
- Update to 2.4.3

* Wed Jun 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.2-1
- Update to 2.4.2

* Sun May 25 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.4.1-1
- Update to 2.4.1

* Tue Apr 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.2-1
- Update to 2.3.2

* Tue Mar 11 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.3.0-1
- Update to 2.3.0

* Wed Feb 19 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.9-1
- Update to 2.2.9

* Fri Nov 22 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.8-1
- Update to 2.2.8

* Mon Oct 7 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.7-1
- Update to 2.2.7

* Fri Aug 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.5-1
- Update to 2.2.5

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.2.0-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
