%define peardir %(pear config-get php_dir 2> /dev/null || echo %{_datadir}/pear)
%define xmldir  /var/lib/pear
%global pear_name File_Fstab

Summary: Read and write fstab files
Name: php-pear-File-Fstab
Version: 2.0.3
Release: 2%{?dist}
License: PHP License v3.0
Group: Development/Libraries
Source0: http://pear.php.net/get/File_Fstab-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.php.net/package/File_Fstab

BuildRequires:  php-pear(PEAR) >= 1.4.7
Requires: php-pear(PEAR) >= 1.4.0b1
Provides:       php-pear(%{pear_name}) = %{version}

#BuildRequires: PEAR::PEAR >= 1.4.7
#Requires: PEAR::PEAR
#Requires: PEAR::PEAR >= 1.4.0b1

BuildArch: noarch

%description
File_Fstab is an easy-to-use package which can read & write UNIX fstab
files. It presents a pleasant object-oriented interface to the fstab.
Features:
* Supports blockdev, label, and UUID specification of mount device.
* Extendable to parse non-standard fstab formats by defining a new Entry
class for that format.
* Easily examine and set mount options for an entry.
* Stable, functional interface.
* Fully documented with PHPDoc.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=/docs \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock



# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/File_Fstab.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/File_Fstab.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.php.net/File_Fstab >/dev/null || :
fi

%files
%defattr(-,root,root)

%{peardir}/*
%{xmldir}/File_Fstab.xml

%changelog
* Mon May 6 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-2
- updated spec file requires section, and left original info remarked.

* Sun May 5 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 2.0.3-1
- Original from pear-make-rpm-spec.
