%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: Horde library for WebDAV, CalDAV, CardDAV
Name: Horde_Dav
Version: 1.1.4
Release: 1%{?dist}
License: BSD-2-Clause
Group: Development/Libraries
Source0: http://pear.horde.org/get/Horde_Dav-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/Horde_Dav
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: Horde_Auth >= 2.0.0
Requires: Horde_Auth < 3.0.0alpha1
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Stream >= 1.2.0
Requires: Horde_Stream < 2.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0
Requires: php-channel(pear.horde.org)
BuildArch: noarch

%description
This package contains all Horde-specific wrapper classes for the Sabre DAV
library.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/Horde_Dav.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/Horde_Dav.xml  >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/Horde_Dav >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/Horde_Dav/*
%{peardir}/*
%{xmldir}/Horde_Dav.xml

%changelog
* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.4-1
- Updated to 1.1.4

* Tue Apr 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.3-1
- Updated to 1.1.3

* Thu Dec 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.2-1
- Updated to 1.1.2

* Wed Oct 29 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.1-1
- Updated to 1.1.1

* Tue Oct 02 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.1.0-1
- Updated to 1.1.0

* Mon Jun 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.7-1
- Updated to 1.0.7

* Wed Mar 5 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.4-1
- Updated to 1.0.4

* Tue Nov 12 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.3-1
- Updated to 1.0.3

* Wed Jul 17 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.2-1
- Updated to 1.0.2

* Mon Jun 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 1.0.0-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
