%{!?__pear: %{expand: %%global __pear %{_bindir}/pear}}
%global pear_name XML_Serializer

Name:           php-pear-XML-Serializer
Version:        0.21.0
Release:        1%{?dist}
Summary:        Swiss-army knife for reading and writing XML files

Group:          Development/Libraries
License:        BSD
URL:            http://pear.php.net/package/XML_Serializer
Source0:        http://pear.php.net/get/%{pear_name}-%{version}.tgz
#Source2:        xml2changelog

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  php-pear >= 1:1.4.9-1.2
# for tests
###BuildRequires:  php-pear(pear.phpunit.de/PHPUnit)
BuildRequires:  php-pear(XML_Util) >= 1.1.1
BuildRequires:  php-pear(XML_Parser) >= 1.2.6
Requires:       php-xml

Requires:       php-pear(PEAR) 
Requires:       php-pear(XML_Util) >= 1.1.1
Requires:       php-pear(XML_Parser) >= 1.2.6
Requires:       php-xml
Requires(post): %{__pear}
Requires(postun): %{__pear}
Provides:       php-pear(%{pear_name}) = %{version}

%description
XML_Serializer serializes complex data structures like arrays or object as
XML documents. This class helps you generating any XML document you require
without the need for DOM.


%prep
%setup -q -c
###%{_bindir}/php -n %{SOURCE2} package.xml | tee CHANGELOG | head -n 10

# Create a "localized" php.ini to avoid build warning
cp /etc/php.ini .
echo "date.timezone=UTC" >>php.ini

cd %{pear_name}-%{version}
# package.xml is V2
mv ../package.xml %{name}.xml


%build
cd %{pear_name}-%{version}
# Empty build section, most likely nothing required.


%install
rm -rf $RPM_BUILD_ROOT docdir
cd %{pear_name}-%{version}
PHPRC=../php.ini %{__pear} install --nodeps --packagingroot $RPM_BUILD_ROOT %{name}.xml

# Move documentation
###mkdir -p docdir
###mv $RPM_BUILD_ROOT%{pear_docdir}/%{pear_name} ../docdir
###mv $RPM_BUILD_ROOT%{pear_datadir}/%{pear_name}/doc/* ../docdir


# Clean up unnecessary files
rm -rf $RPM_BUILD_ROOT%{pear_phpdir}/.??*

# Install XML package description
mkdir -p $RPM_BUILD_ROOT%{pear_xmldir}
install -pm 644 %{name}.xml $RPM_BUILD_ROOT%{pear_xmldir}


%clean
rm -rf $RPM_BUILD_ROOT


%check
cd %{pear_name}-%{version}/tests
###phpunit \
###   -d date.timezone=UTC \
###   -d include_path=%{pear_phpdir}:$RPM_BUILD_ROOT%{pear_phpdir} \
###   AllTests


%post
%{__pear} install --nodeps --soft --force --register-only \
    %{pear_xmldir}/%{name}.xml >/dev/null || :


%postun
if [ $1 -eq 0 ] ; then
    %{__pear} uninstall --nodeps --ignore-errors --register-only \
        %{pear_name} >/dev/null || :
fi


%files
%defattr(-,root,root,-)
###%doc CHANGELOG docdir/*
%doc /usr/share/pear/doc/XML_Serializer/*
%{pear_xmldir}/%{name}.xml
%{pear_phpdir}/XML/*
%{pear_testdir}/%{pear_name}


%changelog
* Sun Dec 17 2017 John H. Bennett III <bennettj@johnbennettservices.com> 0.21.0-1
- update to 0.21.0

* Tue Oct 26 2010 Remi Collet <Fedora@FamilleCollet.com> - 0.20.2-1
- Version 0.20.2 (beta) - API 0.20.0 (beta) - QA release
- add generated Changelog
- run phpunit test suite in %%check

* Mon Aug 23 2010 Remi Collet <Fedora@FamilleCollet.com> - 0.20.0-2
- clean define
- set date.timezone during build
- use version in "Requires".

* Sun Jan 24 2010 Remi Collet <Fedora@FamilleCollet.com> 0.20.0-1
- update to 0.20.0
- License is BSD (since 0.19.0)
- rename XML_Serializer.xml to php-pear-XML-Serializer.xml
- add tests
- add %%check (documentation only)

* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.18.0-6
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Thu Feb 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.18.0-5
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Thu Aug 28 2008 Tom "spot" Callaway <tcallawa@redhat.com> 0.18.0-4
- fix license tag

* Sun Jan 14 2007 Christopher Stone <chris.stone@gmail.com> 0.18.0-3
- Add license to %%files

* Mon Oct 16 2006 Christopher Stone <chris.stone@gmail.com> 0.18.0-2
- Move the todo file in %%{pear_datadir} into %%doc

* Sat Oct 14 2006 Christopher Stone <chris.stone@gmail.com> 0.18.0-1
- Initial release
