# $Id: e-smith-horde.spec,v 1.22 2010/05/11 04:07:35 mrjhb3 Exp $

Summary: e-smith specific Horde configuration and templates.
%define name e-smith-horde
Name: %{name}
%define version 4.8.0
%define release 8
Version: %{version}
Release: %{release}%{?dist}
License: GPL
Group: Networking/Daemons
Source: %{name}-%{version}.tar.gz
Patch1: e-smith-horde-4.8.0_renumber_database_creation.order.patch
Patch2: e-smith-horde-4.8.0_horde_5_2_13_conf.php.patch
Patch3: e-smith-horde-4.8.0_horde_5_2_14_conf.php.patch
Patch4: e-smith-horde-4.8.0_horde_php_pear_fix.patch
Patch5: e-smith-horde-4.8.0_autodiscover_json.patch
Patch6: e-smith-horde-4.8.0_horde_5_2_22_conf.php.patch
Patch7: e-smith-horde-4.8.0_horde_5_2_23_hash.patch
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-buildroot
BuildArchitectures: noarch
Requires: e-smith-base >= 4.9.44, horde >= 5.0, mysql
Requires: e-smith-lib >= 1.15.1-16
Requires: enscript
Requires: php-domxml
Requires: php-gd
Requires: php-mbstring
Requires: wv
Requires: xlhtml
Requires: php-pear
Obsoletes: php-devel <= 5.3.3-14
Obsoletes: autoconf <= 2.59 
Obsoletes: automake <= 1.9.6
Obsoletes: imake <= 1.0.2   
Obsoletes: libXdmcp <= 1.0.1
Obsoletes: pear-date
Obsoletes: pear-db
Obsoletes: pear-file
Obsoletes: pear-log
Obsoletes: pear-mail
Obsoletes: pear-mail_mime
Requires: php-pear(Date)
Requires: php-pear(File)
Requires: php-pear(HTTP)
Requires: php-pear(Log)
Requires: php-pear(Services_Weather)
BuildRequires: e-smith-devtools >= 1.13.1-03
AutoReqProv: no
Obsoletes: dcb-e-smith-horde
Obsoletes: smeserver-horde-menuarray
Obsoletes: smeserver-trean < 0.1-8

%changelog
* Sun Jun 15 2020 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-8
- Beginning with horde 5.2.3, the Horde project is moving away from using $ID to using $Hash to
- verify componenta are up to date.  $Hash is the sha1sum of the specific components conf.xml file

* Thu Apr 23 2020 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-7
- Patch to conf.php for horde 5.2.22 compliance

* Fri Dec 6 2019 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-6
- Patch to add support version 2 Autodiscovery (autodiscover.json)

* Sun Jul 7 2019 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-5
- Patch to fix errors when running horde5 with SCL and php versions higher than what the base ships with.

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-4
- Patch to conf.php for horde 5.2.14 compliance

* Sat Mar 4 2017 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-3
- Patch to conf.php for horde 5.2.13 compliance

* Sun Jun 12 2016 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-2
- Patch to renumber the datbase creation steps, so the DB will be created without errors.

* Sun Jun 5 2016 John H. Bennett III <bennettj@johnbennettservices.com> 4.8.0-1
- Re-rolled and incremented version number so that it won't conflict with horde 3 rpms currently in SME 10.

* Tue Feb 16 2016 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-30
- Patch to change hook logic for $vdomain. [SME:9249]

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-29
- Patch to conf.php for horde 5.2.9 compliance

* Wed Dec 30 2015 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-28
- Patch to include additional apache ACL directory restrictions

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-27
- Patch to conf.php for horde 5.2.8 compliance

* Wed Jun 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-26
- Patch to switch to using built in horde program to remove user data from DB if enabled

* Mon Dec 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-25
- Patch to enable per device logging to /tmp
  To enable - config setprop horde DeviceLog enabled

* Tue Dec 9 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-24
- Patch to conf.php for horde 5.2.3 compliance

* Thu Nov 27 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-23
- Patch to SME server compatible horde remove user script to bring inline with 
  current horde code.

* Thu Nov 20 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-22
- Patch to re-enable case insensitive logins.

* Mon Sep 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-21
- Re-add ldap auth capability and fix template errors.  Can't test on SME 9 as it 
  doesn't support LDAP auth.  Settings match what I had done on SME 8, so hopefully 
  no re-work is needed if/when SME Server supports LDAP auth.

* Mon Sep 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-20
- Patch that sets default horde left menu to 250 pixels so all items are displayed.

* Wed Aug 6 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-19
- Patch that adds DB variable to either use cookies or not.  Setups that don't
  have a domain configured need to set to disabled for horde 5.x to work.
- config setprop horde Cookies disabled ; signal-event email-update

* Mon Jun 30 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-18
- Patch to conf.php for horde 5.2 compliance

* Wed Mar 26 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-17
- Patch to send the majority of the output from horde table migration to /dev/null.  
  Some log noise errors will still be seen depending on what tables are present from
  previous versions.

* Sat Feb 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-16
- Patch to change default mysql charset to latin1.  There is a bug with utf-8,
  http://bugs.mysql.com/bug.php?id=4541, that is being hit that prevents one of
  horde's tables from being upgraded.  This might funk some things up, so need 
  to test thoroughly and see.

* Sat Feb 22 2014 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-15
- Patch to change to use mysqli per horde devs and clean up unneeded template code

* Tue Jan 28 2014 Ian Wells <esmith@wellsi.com> 4.6.0-14
- Replace last change with a default value for horde access [SME: 7351]
- Ensure initialisation of variables in webmail-only-local-network by Stephane de Labrusse [SME: 7351]

* Fri Dec 20 2013 Ian Wells <esmith@wellsi.com> 4.6.0-13
- Update of allow webmail-only-local-network by Stephane de Labrusse [SME: 7351]
- Whitespace patch for 85HordeAccess

* Tue Dec 10 2013 Chris Burnat <devlist@burnat.com> 4.6.0-12
- Allow webmail-only-local-network by Stephane de Labrusse [SME: 7351]

* Thu Nov 7 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-11
- patch to correct admin user output.

* Thu Nov 7 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-10
- add ability to remove horde user specifc data from horde mysql DB for SME Server.  
- To enable - config setprop horde RemoveUsers enabled ; signal-event email-update [SME:4402]

* Wed Oct 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-9
- Patch to horde conf.php to bring it up to 5.1.5 compliance

* Mon Sep 9 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-8
- Patch to add entries for Ansel to horde conf.php.  Doesn't hurt anything if it's not installed.

* Mon Sep 9 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-7
- Patch to clean up code in horde conf.php template

* Mon Sep 9 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-6
- Patch to add db variable to enable/disable Activesync support.  Forgot to add originally.
- config setprop horde ActiveSync enabled|disabled

* Tue Sep 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-5
- Patch that enables horde static CSS, JS, and theme caching to the local file system
  that speeds up system responses.

* Tue Sep 3 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-4
- Patch to horde conf.php to bring it up to 5.1.4 compliance

* Fri Jun 07 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-3
- Patch to horde conf.php to bring it up to current level 5.0.5, so that configuration status
  shows application is up to date. 
- changed path for aspell to /usr/bin/hunspell so spell checking works since aspell is no
  longer included in the base SME Server distro

* Fri May 31 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-2
- Change spec file to require horde >=5
- Obsolete el5 version of packages required by requires [SME: 7273]
- Obsolete el5 version of packages required by php-devel [SME: 7273]
- Obsolete el5 version of php-devel [SME: 7273]

* Thu May 23 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.6.0-1
- Roll new stream for horde5 on sme9 so that updates will install properly.

* Sat Jan 19 2013 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-8
- Patch to template for horde directory directive in httpd.conf so that Nag tasks will save properly.

* Sun Dec 2 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-7
- Initial attempt at making proper template changes for working with ActiveSync.
  testing needed.
- To enable -  config setprop horde Activesync enabled ; signal-event email-update

* Tue Nov 27 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-6
- Patch that enables LDAP auth, when enabled, for horde5 with SME8

* Tue Nov 27 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-5
- Update to remove 120MenuSettings and conf.menu.apps.php file as they aren't used
  with horde 5.x.

* Sat Nov 24 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-4
- Update file id and other misc. settings in conf.php so config shows up to date.

* Mon Apr 23 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-3
- Fix mysql.init files.

* Mon Apr 23 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-2
- Update horde templates to reflect changes in Horde 4.0.14

* Sat Apr 14 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.3.0-1
- Re-rolled for Horde 4.0.x.

* Sat Mar 10 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-20
- Upgrade horde templates to reflect changes in Horde 3.3.13

* Sun Mar 10 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-19
- Add ability to authenticate via ldap if it's enabled 

* Sun Mar 10 2012 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-18
- Add ability to define additional Horde webmail admins. config setprop horde Admins <userid> 
- Admin will always be present 

* Fri Dec 23 2011 Jonathan Martens <smeserver-conbtribs@snetram.nl> 4.2.0-17
- Remove original file that is also templated [SME: 6666]

* Mon Jul 04 2011 Charlie Brady <charlie_brady@mitel.com> 4.2.0-16
- Remove php-pecl(Fileinfo) dependency. [SME: 6436]

* Sun Jan 2 2011 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-15
- Add option to verify from address in webmail if setting up additional identities [SME:6469]

* Sat Nov 06 2010 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-14
- Upgrade horde templates to reflect changes in Horde 3.3.10 [SME: 6348]

* Mon May 10 2010 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-13
- Upgrade horde templates to reflect changes in Horde 3.3.8 [SME: 5938]

* Sun Feb 14 2010 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-12
- Patch to change horde's templated mime_drivers.php file so some additional
  settings can be customized [SME: 5224]
- config setprop horde inlineMSWord true|false <-- default is false
- config setprop horde inlineMSExcel true|false <-- default is false
- config setprop horde inlineMSPowerpoint true|false <-- default is false
- config setprop horde inlineWordperfect true|false <-- default is false
- config setprop horde inlineAudio true|false <-- default is true

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-11
- Patch to make sure username is always saved in lowercase to horde db's [SME:5775]

* Sat Feb 13 2010 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-10
- Upgrade horde templates to reflect changes in Horde 3.3.6 [SME: 5774]

* Tue Oct 13 2009 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-9
- Really apply patch from previous attempt [SME: 5509]

* Tue Oct 13 2009 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-8  
- Upgrade horde templates to reflect changes in Horde 3.3.5 [SME: 5509]   

* Sat Jun 20 2009 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-7
- Upgrade to horde templates to reflect changes in Horde 3.3.4 [SME: 5372]

* Thu Dec 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-6
- Updated spec file to remove requires and obsoletes of php-pear-HTTP-Request
  information moved to e-smith-imp for both sme7 and sme8 [SME: 4821]

* Sun Dec 21 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-5
- Update to Spec file to obsolete smeserver-trean < 0.1-8  [SME: 4860]

* Sat Dec 20 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-4
- Patch to conf.php template to set a blank cookie domain so that FQDN and non-FQDN
- access to webmail will work. Remove klutz template from registry.php [SME: 4787]

* Sat Dec 06 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-3
- Upgrade to horde templates to reflect changes in Horde 3.3.2

* Sat Dec 06 2008 John H. Bennett III <bennettj@johnbennettservices.com> 4.2.0-2       
- Upgrade to horde templates to reflect changes in Horde 3.3  [SME: 4831]

* Tue Oct 7 2008 Shad L. Lords <slords@mail.com> 4.2.0-1.sme
- Roll new stream to separate sme7/sme8 trees [SME: 4633]

* Tue Jun 24 2008 John H. Bennett III <bennettj@johnbennettservices.com> 3.2-2
- Upgrade patch for Horde 3.2.1 [SME: 4532]

* Mon Jun 2 2008 John H. Bennett III <bennettj@johnbennettservices.com> 3.2-1
- Initial production build
- Jump in package name to reflect new version of horde

%description
This package adds necessary templates and configuration items
so that Horde will work properly on SME Server

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
for i in post-install post-upgrade
do
    mkdir -p root/etc/e-smith/events/$i
done
perl createlinks

%install
rm -rf $RPM_BUILD_ROOT
(cd root ; find . -depth -print | cpio -dump $RPM_BUILD_ROOT)
/sbin/e-smith/genfilelist $RPM_BUILD_ROOT > %{name}-%{version}-filelist
echo "%doc COPYING"          >> %{name}-%{version}-filelist

%clean 
rm -rf $RPM_BUILD_ROOT

%pre
%preun
%post
rm -rf /home/httpd/html/horde/dimp
rm -rf /home/httpd/html/horde/mimp
rm -rf /home/httpd/html/horde/conf.menu.apps.php

%postun

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
