%define peardir /usr/share/pear
%define xmldir  /var/lib/pear

Summary: PEAR: A web based notes manager
Name: mnemo-h5
Version: 4.2.14
Release: 1%{?dist}
License: ASL
Group: Development/Libraries
Source0: http://pear.horde.org/get/mnemo-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
URL: http://pear.horde.org/package/mnemo
BuildRequires:       php-pear(PEAR) >= 1.4.7
BuildRequires: php-channel(pear.horde.org)
Requires: Horde_Role >= 1.0.0
Requires: content >= 2.0.3
Requires: content < 3.0.0alpha1
Requires: horde >= 5.0.0
Requires: horde < 6.0.0alpha1
Requires: Horde_Auth >= 2.0.0
Requires: Horde_Auth < 3.0.0alpha1
Requires: Horde_Core >= 2.0.0
Requires: Horde_Core < 3.0.0alpha1
Requires: Horde_Data >= 2.0.0
Requires: Horde_Data < 3.0.0alpha1
Requires: Horde_Exception >= 2.0.0
Requires: Horde_Exception < 3.0.0alpha1
Requires: Horde_Form >= 2.0.0
Requires: Horde_Form < 3.0.0alpha1
Requires: Horde_Group >= 2.0.0
Requires: Horde_Group < 3.0.0alpha1
Requires: Horde_History >= 2.0.0
Requires: Horde_History < 3.0.0alpha1
Requires: Horde_Icalendar >= 2.0.0
Requires: Horde_Icalendar < 3.0.0alpha1
Requires: Horde_Injector >= 2.0.0
Requires: Horde_Injector < 3.0.0alpha1
Requires: Horde_Perms >= 2.0.0
Requires: Horde_Perms < 3.0.0alpha1
Requires: Horde_Prefs >= 2.0.0
Requires: Horde_Prefs < 3.0.0alpha1
Requires: Horde_Share >= 2.0.0
Requires: Horde_Share < 3.0.0alpha1
Requires: Horde_Support >= 2.0.0
Requires: Horde_Support < 3.0.0alpha1
Requires: Horde_Text_Filter >= 2.0.0
Requires: Horde_Text_Filter < 3.0.0alpha1
Requires: Horde_Util >= 2.0.0
Requires: Horde_Util < 3.0.0alpha1
Requires: php-pear(PEAR) >= 1.7.0           
Requires: php-channel(pear.horde.org)  
Obsoletes: mnemo-h3   
BuildArch: noarch

Provides:       %{name} = %{version}

%description
The Mnemo Note Manager is the Horde notes/memos application. It allows
users to keep web-based notes and freeform text. Notes may be shared with
other users via shared notepads. It requires the Horde Application
Framework and an SQL database or Kolab server for backend storage.

%prep
%setup -c -T
pear -v -c pearrc \
        -d php_dir=%{peardir} \
        -d doc_dir=%{pear_docdir} \
        -d bin_dir=%{_bindir} \
        -d data_dir=%{peardir}/data \
        -d test_dir=%{peardir}/tests \
        -d ext_dir=%{_libdir} \
        -d horde_dir=%{pear_hordedir} \
        -s

%build

%install
rm -rf %{buildroot}
pear -c pearrc install --nodeps --packagingroot %{buildroot} %{SOURCE0}
        
# Clean up unnecessary files
rm pearrc
rm %{buildroot}/%{peardir}/.filemap
rm %{buildroot}/%{peardir}/.lock
rm -rf %{buildroot}/%{peardir}/.registry
rm -rf %{buildroot}%{peardir}/.channels
rm %{buildroot}%{peardir}/.depdb
rm %{buildroot}%{peardir}/.depdblock

#mv %{buildroot}/docs .


# Install XML package description
mkdir -p %{buildroot}%{xmldir}
tar -xzf %{SOURCE0} package.xml
cp -p package.xml %{buildroot}%{xmldir}/mnemo.xml

%clean
rm -rf %{buildroot}

%post
pear install --nodeps --soft --force --register-only %{xmldir}/mnemo.xml >/dev/null || :

%postun
if [ "$1" -eq "0" ]; then
    pear uninstall --nodeps --ignore-errors --register-only pear.horde.org/mnemo >/dev/null || :
fi

%files
%defattr(-,root,root)
#%doc docs/mnemo/*
%doc %{pear_hordedir}
%{peardir}/*
%{xmldir}/mnemo.xml
%{_bindir}/mnemo-convert-datatree-shares-to-sql
%{_bindir}/mnemo-convert-sql-shares-to-sqlng
%{_bindir}/mnemo-convert-to-utf8
%{_bindir}/mnemo-import-text-note

%changelog
* Wed Sep 20 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.14-1
- Updated to mnemo 4.2.14

* Tue Mar 21 2017 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.13-1
- Updated to mnemo 4.2.13

* Sun Dec 18 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.12-1
- Updated to mnemo 4.2.12

* Tue Jul 26 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.11-1
- Updated to mnemo 4.2.11

* Wed Mar 23 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.10-1
- Updated to mnemo 4.2.10

* Sun Feb 7 2016 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.9-1
- Updated to mnemo 4.2.9

* Fri Oct 23 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.8-1
- Updated to mnemo 4.2.8

* Sat Aug 1 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.7-1
- Updated to mnemo 4.2.7

* Sat May 2 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.6-1
- Updated to mnemo 4.2.6

* Tue Feb 10 2015 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.5-1
- Updated to mnemo 4.2.5

* Thu Dec 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.3-1
- Updated to mnemo 4.2.3

* Wed Oct 29 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.2-1
- Updated to mnemo 4.2.2

* Mon Aug 4 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.1-1
- Updated to mnemo 4.2.1

* Tue Jul 8 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.2.0-1
- Updated to mnemo 4.2.0

* Mon Mar 10 2014 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.3-1
- Updated to mnemo 4.1.3

* Wed Oct 30 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.2-1
- Updated to mnemo 4.1.2

* Tue Jul 16 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.1.1-1
- Updated to mnemo 4.1.1

* Tue Jun 4 2013 John H. Bennett III <bennettj@johnbennettservices.com> - 4.0.3-1
- Initial release for SME Server
- Original build from pear make-rpm-spec
